/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.structure;

import java.awt.Component;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.util.Vector;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.DataNode;
import oracle.dmt.dataminer.navigator.PhysicalDataNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.wflownodes.DataProfileNavNode;
import oracle.dmt.dataminer.teditor.structure.ColumnDataRow;
import oracle.dmt.dataminer.teditor.structure.StructureLrb;
import oracle.dmt.dataminer.teditor.structure.StructureViewTableModel;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class StructureViewState {
    private Context _context;
    private String _connectionName;
    private StructureViewTableModel _tableModel;
    private Node _node;
    private String _cacheTableName;
    private String _cacheSchemaName;
    private boolean _loadFromNode = true;

    public StructureViewState(Context context) {
        assert (context != null) : "Context cannot be passed into constructore as a null.";
        this._context = context;
        this.initTable();
    }

    public StructureViewState(Context context, boolean bl) {
        assert (context != null) : "Context cannot be passed into constructore as a null.";
        this._context = context;
        this._loadFromNode = bl;
        if (this._loadFromNode) {
            this.initTable();
        }
    }

    public StructureViewState(String string, String string2, String string3) {
        this._context = null;
        this._loadFromNode = false;
        this._connectionName = string;
        this._cacheTableName = string3;
        this._cacheSchemaName = string2;
    }

    public StructureViewTableModel getTableModel() {
        return this._tableModel;
    }

    private void initTable() {
        this._node = this._context.getNode();
        assert (this._node != null) : "Tree Node is not null";
        assert (this._node instanceof DataNode) : "Node is not of type DataNode";
        PhysicalDataNode physicalDataNode = null;
        if (this._node instanceof DataNode) {
            DataNode dataNode = (DataNode)this._node;
            this._cacheTableName = dataNode.getCacheTableName();
            this._cacheSchemaName = dataNode.getCacheSchemaName();
            if ((this._cacheTableName == null || this._cacheTableName.length() == 0) && this._node instanceof PhysicalDataNode) {
                physicalDataNode = (PhysicalDataNode)this._node.getData();
                this._cacheTableName = physicalDataNode.getTableName();
                this._cacheSchemaName = physicalDataNode.getUserName();
            }
        }
    }

    public String getSchema() {
        return this._cacheSchemaName;
    }

    public String getName() {
        return this._cacheTableName;
    }

    public void setTableName(String string, String string2) {
        this._cacheSchemaName = string;
        this._cacheTableName = string2;
    }

    public StructureViewTableModel getFilteredRows(String string, int n) throws Exception {
        return this._tableModel.getFilteredRows(string, n);
    }

    public void load() throws Exception {
        if (this._node == null) {
            this.reload();
            return;
        }
        DataNode dataNode = (DataNode)this._node;
        this._cacheTableName = dataNode.getCacheTableName();
        this._cacheSchemaName = dataNode.getCacheSchemaName();
        if (this._cacheTableName == null || this._cacheTableName.length() == 0) {
            Object object = this._node.getData();
            if (object instanceof DataProfileNavNode) {
                String string = ((DataProfileNavNode)object).getStatsTableName();
                this.reloadStatsTable(string);
            } else {
                this.getMetaData();
            }
        } else {
            this.reload();
        }
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
    }

    public void reload() throws Exception {
        Connection connection = null;
        String string = " SELECT COLUMN_NAME,\n  DATA_TYPE        ,\n  DATA_LENGTH      ,\n  DATA_PRECISION   ,\n  DATA_SCALE ,\n  COLUMN_ID \n   FROM all_tab_columns\n  WHERE TABLE_NAME = ? AND \n  OWNER = ? \n ORDER BY COLUMN_ID ASC";
        SQLHelper sQLHelper = new SQLHelper();
        Vector<ColumnDataRow> vector = new Vector<ColumnDataRow>();
        try {
            connection = this._context != null ? Connections.getUniqueConnection(this._context) : this.getConnectionUsingConnectionName();
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.pstmt.setString(1, this._cacheTableName);
            sQLHelper.pstmt.setString(2, this._cacheSchemaName);
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.pstmt.execute();
            ColumnDataRow columnDataRow = null;
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                String string2 = sQLHelper.rs.getString("COLUMN_NAME");
                String string3 = sQLHelper.rs.getString("DATA_TYPE");
                Integer n = new Integer(sQLHelper.rs.getInt("DATA_LENGTH"));
                Integer n2 = new Integer(sQLHelper.rs.getInt("DATA_PRECISION"));
                Integer n3 = new Integer(sQLHelper.rs.getInt("DATA_SCALE"));
                Integer n4 = new Integer(sQLHelper.rs.getInt("COLUMN_ID"));
                columnDataRow = new ColumnDataRow(string2, string3, n, n2, n3, n4);
                vector.add(columnDataRow);
            }
            this._tableModel = new StructureViewTableModel(vector);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
            if (connection != null) {
                connection.close();
            }
        }
    }

    public void reloadStatsTable(String string) throws Exception {
        Connection connection = null;
        String string2 = " SELECT COLUMN_NAME,\n  DATA_TYPE        ,\n  DATA_LENGTH      ,\n  DATA_PRECISION   ,\n  DATA_SCALE ,\n  COLUMN_ID \n   FROM user_tab_columns\n  WHERE TABLE_NAME = ? \n ORDER BY COLUMN_ID ASC";
        SQLHelper sQLHelper = new SQLHelper();
        Vector<ColumnDataRow> vector = new Vector<ColumnDataRow>();
        try {
            connection = this._context != null ? Connections.getUniqueConnection(this._context) : this.getConnectionUsingConnectionName();
            sQLHelper.pstmt = connection.prepareStatement(string2);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.pstmt.execute();
            ColumnDataRow columnDataRow = null;
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString("COLUMN_NAME");
                String string4 = sQLHelper.rs.getString("DATA_TYPE");
                Integer n = new Integer(sQLHelper.rs.getInt("DATA_LENGTH"));
                Integer n2 = new Integer(sQLHelper.rs.getInt("DATA_PRECISION"));
                Integer n3 = new Integer(sQLHelper.rs.getInt("DATA_SCALE"));
                Integer n4 = new Integer(sQLHelper.rs.getInt("COLUMN_ID"));
                columnDataRow = new ColumnDataRow(string3, string4, n, n2, n3, n4);
                vector.add(columnDataRow);
            }
            this._tableModel = new StructureViewTableModel(vector);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
            if (connection != null) {
                connection.close();
            }
        }
    }

    private Connection getConnectionUsingConnectionName() {
        DatabaseConnections databaseConnections = DatabaseConnections.getInstance();
        Connection connection = null;
        try {
            connection = databaseConnections.getUniqueConnection(this._connectionName);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_TITLE"), (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_MESG"), null);
        }
        return connection;
    }

    private String getStackedSQL() {
        DataNode dataNode = (DataNode)this._node;
        WorkflowNode workflowNode = (WorkflowNode)dataNode.getParent().getAncestor(WorkflowNode.class);
        WorkflowModel workflowModel = workflowNode.getWorkflowModel();
        if (workflowModel == null) {
            return null;
        }
        DataNodeType dataNodeType = (DataNodeType)dataNode.getRepositoryData();
        AbstractDataNode abstractDataNode = (AbstractDataNode)workflowModel.findNodeByMetadataId(dataNodeType.getId());
        if (abstractDataNode == null) {
            return null;
        }
        return abstractDataNode.getStackedSQL(workflowModel);
    }

    private void getMetaData() throws Exception {
        Connection connection = null;
        Vector<ColumnDataRow> vector = new Vector<ColumnDataRow>();
        String string = this.getStackedSQL();
        if (string == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("SELECT * FROM ( ");
        stringBuilder.append(string);
        stringBuilder.append(")");
        try {
            connection = this._context != null ? Connections.getUniqueConnection(this._context) : this.getConnectionUsingConnectionName();
            ConnectionFolder.setConnectionAlterSessionFixes(connection);
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"ODMR_OBJECT_NAMES", (Connection)connection);
            ArrayDescriptor arrayDescriptor2 = ArrayDescriptor.createDescriptor((String)"ODMR_OBJECT_IDS", (Connection)connection);
            ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)new String[0]);
            ARRAY aRRAY2 = new ARRAY(arrayDescriptor2, connection, (Object)new String[0]);
            ARRAY aRRAY3 = new ARRAY(arrayDescriptor2, connection, (Object)new String[0]);
            ARRAY aRRAY4 = new ARRAY(arrayDescriptor2, connection, (Object)new String[0]);
            ARRAY aRRAY5 = new ARRAY(arrayDescriptor2, connection, (Object)new String[0]);
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{call ODMR_UTIL.DESCRIBE_SQL_EXPRESSION(?,?,?,?,?,?)}");
            oracleCallableStatement.setCharacterStream(1, (Reader)new StringReader(stringBuilder.toString()), stringBuilder.length());
            oracleCallableStatement.setArray(2, (Array)aRRAY);
            oracleCallableStatement.setArray(3, (Array)aRRAY2);
            oracleCallableStatement.setArray(4, (Array)aRRAY3);
            oracleCallableStatement.setArray(5, (Array)aRRAY4);
            oracleCallableStatement.setArray(6, (Array)aRRAY5);
            oracleCallableStatement.registerOutParameter(2, 2003, "ODMR_OBJECT_NAMES");
            oracleCallableStatement.registerOutParameter(3, 2003, "ODMR_OBJECT_NAMES");
            oracleCallableStatement.registerOutParameter(4, 2003, "ODMR_OBJECT_IDS");
            oracleCallableStatement.registerOutParameter(5, 2003, "ODMR_OBJECT_IDS");
            oracleCallableStatement.registerOutParameter(6, 2003, "ODMR_OBJECT_IDS");
            oracleCallableStatement.execute();
            ARRAY aRRAY6 = oracleCallableStatement.getARRAY(2);
            String[] stringArray = (String[])aRRAY6.getArray();
            ARRAY aRRAY7 = oracleCallableStatement.getARRAY(3);
            String[] stringArray2 = (String[])aRRAY7.getArray();
            ARRAY aRRAY8 = oracleCallableStatement.getARRAY(4);
            BigDecimal[] bigDecimalArray = (BigDecimal[])aRRAY8.getArray();
            ARRAY aRRAY9 = oracleCallableStatement.getARRAY(5);
            BigDecimal[] bigDecimalArray2 = (BigDecimal[])aRRAY9.getArray();
            ARRAY aRRAY10 = oracleCallableStatement.getARRAY(6);
            BigDecimal[] bigDecimalArray3 = (BigDecimal[])aRRAY10.getArray();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = stringArray2[i];
                int n = bigDecimalArray[i].intValue();
                int n2 = bigDecimalArray2[i].intValue();
                int n3 = bigDecimalArray3[i].intValue();
                ColumnDataRow columnDataRow = new ColumnDataRow(string2, string3, n, n2, n3, null);
                vector.add(columnDataRow);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        this._tableModel = new StructureViewTableModel(vector);
    }
}

