/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.sql;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.navigator.DataNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.teditor.sql.SQLEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.SwingWorker;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.TextComponentSearchSupport;

public class SQLViewerPanel
extends DataMinerViewGUI {
    private String _sql;
    private SearchField _jFilterCtl = new SearchField();
    private JTextPane _jSQLTextArea = new JTextPane();
    private Component _findPane;
    TextComponentSearchSupport _textSearchComponent;
    private ComponentWithTitlebar<JComponent> _jComponentWithToolbar;

    public SQLViewerPanel(Editor editor, Context context) {
        super(editor, context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jComponentWithToolbar = new ComponentWithTitlebar();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this._jComponentWithToolbar, -1, 380, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this._jComponentWithToolbar, -1, 278, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this._sql = SQLEditorLrb.get("SQL_VIEWER_EDITOR_LOADING");
        this._textSearchComponent = new TextComponentSearchSupport((JTextComponent)this._jSQLTextArea);
        this._jSQLTextArea.setText(this._sql);
        JScrollPane jScrollPane = new JScrollPane(this._jSQLTextArea);
        this._jComponentWithToolbar.setComponent((JComponent)jScrollPane);
        this._jComponentWithToolbar.setLabel(new JLabel(SQLEditorLrb.get("SQL_VIEWER_TEXT_AREA_TITLE")));
        ControlBar controlBar = new ControlBar();
        this._findPane = this.createFindPane();
        controlBar.add(this._findPane);
        this._jComponentWithToolbar.setControlBar(controlBar);
        this._jFilterCtl.setStyle(SearchField.Style.FIND);
        this._jFilterCtl.setPrompt(SQLEditorLrb.get("SQL_VIEWER_FIND"));
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                SearchEvent.Direction direction = searchEvent.getDirection();
                String string = searchEvent.getSearchText();
                SQLViewerPanel.this._textSearchComponent.search(direction, string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        this.setLoading(true);
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    protected Component createFindPane() {
        Box box = new Box(2);
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._jFilterCtl);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 200);
        Dimension dimension3 = this.derive(dimension, 120);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    public HelpInfo getHelpInfo() {
        String string = "dm_datasourceviewer_sql";
        return new HelpInfo(string);
    }

    private String getStackedSQL() {
        DataNode dataNode = (DataNode)this.getContext().getNode();
        WorkflowNode workflowNode = (WorkflowNode)dataNode.getParent().getAncestor(WorkflowNode.class);
        WorkflowModel workflowModel = workflowNode.getWorkflowModel();
        if (workflowModel == null) {
            return null;
        }
        DataNodeType dataNodeType = (DataNodeType)dataNode.getRepositoryData();
        AbstractDataNode abstractDataNode = (AbstractDataNode)workflowModel.findNodeByMetadataId(dataNodeType.getId());
        if (abstractDataNode == null) {
            return null;
        }
        return abstractDataNode.getStackedSQL(workflowModel, true);
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        String sql = null;

        public LoadUI(boolean bl) {
        }

        public LoadUI() {
        }

        public Object construct() {
            try {
                this.sql = SQLViewerPanel.this.getStackedSQL();
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return this.sql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    SQLViewerPanel.this._sql = this.sql;
                    SQLViewerPanel.this._jSQLTextArea.setEditable(false);
                    SQLViewerPanel.this._jSQLTextArea.setText(SQLViewerPanel.this._sql);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SQLViewerPanel.this._jSQLTextArea.setCaretPosition(SQLViewerPanel.this._jSQLTextArea.getDocument().getLength());
                            SQLViewerPanel.this._jSQLTextArea.moveCaretPosition(0);
                            SQLViewerPanel.this._jSQLTextArea.select(0, 0);
                        }
                    });
                    SQLViewerPanel.this.setLoaded(true);
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)SQLEditorLrb.get("SQL_VIEWER_FAILURE_TITLE"), (String)SQLEditorLrb.get("SQL_VIEWER_FAILURE_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), null, (String)SQLEditorLrb.get("SQL_VIEWER_FAILURE_TITLE"), (String)SQLEditorLrb.get("SQL_VIEWER_FAILURE_TITLE"));
                }
            }
            catch (Exception exception) {
            }
            finally {
                SQLViewerPanel.this.setLoading(false);
            }
        }
    }
}

