/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.sql.Clob;
import java.sql.Connection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.accessibility.AccessibleContext;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.teditor.data.ODMrDataTypesUtil;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModel;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class ODMrCopyableResultSetTableAdapter {
    protected final JTable _table;
    protected String _nullValue = "(null)";

    public ODMrCopyableResultSetTableAdapter(JTable jTable) {
        this._table = jTable;
    }

    public void setNullString(String string) {
        this._nullValue = string;
    }

    public String getNullString() {
        return this._nullValue;
    }

    public boolean canCopy() {
        return ODMrCopyableResultSetTableAdapter.isSelectionSizeOk(this._table.getSelectedRowCount(), this._table.getSelectedRows()) && (this._table.getRowSelectionAllowed() || ODMrCopyableResultSetTableAdapter.isSelectionSizeOk(this._table.getSelectedColumnCount(), this._table.getSelectedColumns()));
    }

    public boolean canCut() {
        return false;
    }

    public boolean canPaste() {
        return false;
    }

    public boolean copyToClipboard() {
        return this.copyToClipboard(false, false);
    }

    public boolean copyToClipboard(boolean bl) {
        return this.copyToClipboard(bl, false);
    }

    public boolean copyToClipboard(boolean bl, boolean bl2) {
        int n = this._table.getSelectedRowCount();
        int[] nArray = this._table.getSelectedRows();
        int n2 = this._table.getColumnCount();
        Connection connection = null;
        StringBuilder stringBuilder = new StringBuilder(n * n2 * 10);
        if (this._table.getModel() instanceof ODMrResultSetTableModel) {
            connection = ((ODMrResultSetTableModel)this._table.getModel()).getConnection();
            if (bl2 && nArray.length > 0) {
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    if (!this._table.isCellSelected(nArray[0], i)) continue;
                    String string = this.sanitizeStringForCopy(((ODMrResultSetTableModel)this._table.getModel()).getRawColumnName(i));
                    if (n3 != 0 && n3 <= n2 - 1) {
                        stringBuilder.append("\t");
                    }
                    stringBuilder.append(string);
                    ++n3;
                }
                if (nArray.length == 1 && stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
            }
            for (Object object : (StringSelection)nArray) {
                if (nArray.length > 1 && stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                int n4 = 0;
                for (int i = 0; i < n2; ++i) {
                    String string;
                    if (!this._table.isCellSelected((int)object, i)) continue;
                    if (n4 != 0 && n4 <= n2 - 1) {
                        stringBuilder.append("\t");
                    }
                    ++n4;
                    Object object2 = this._table.getValueAt((int)object, i);
                    if (object2 instanceof JLabel) {
                        AccessibleContext accessibleContext;
                        JLabel jLabel = (JLabel)object2;
                        string = jLabel.getText();
                        if (!(string != null && string.length() != 0 || (string = (accessibleContext = jLabel.getAccessibleContext()).getAccessibleName()) != null && string.length() != 0)) {
                            string = accessibleContext.getAccessibleDescription();
                        }
                    } else {
                        string = connection != null ? (object2 != null ? ODMrDataTypesUtil.stringValue(object2, connection) : this._nullValue) : (object2 != null ? this.getValue(object2) : this._nullValue);
                    }
                    stringBuilder.append(this.sanitizeStringForCopy(string));
                }
            }
        }
        StringSelection stringSelection = new StringSelection(stringBuilder.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        ClipboardStack.pushCurrentClipboard();
        clipboard.setContents(stringSelection, stringSelection);
        if (bl) {
            this._table.repaint();
        }
        return true;
    }

    public void pasteToJTable() {
    }

    public static boolean isSelectionSizeOk(int n, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        int n2 = nArray[nArray.length - 1] - nArray[0];
        return n - 1 == n2 && n == nArray.length;
    }

    protected static int[] _getColumnList(JTable jTable) {
        if (jTable == null) {
            return new int[0];
        }
        int n = jTable.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    protected String getValue(Object object) {
        TableModel tableModel = this._table.getModel();
        ODMrResultSetTableModel oDMrResultSetTableModel = null;
        String string = this._nullValue;
        if (tableModel instanceof ODMrResultSetTableModel) {
            oDMrResultSetTableModel = (ODMrResultSetTableModel)tableModel;
        }
        try {
            string = object instanceof Clob ? ((Clob)object).getSubString(1L, (int)((Clob)object).length()) : (object instanceof OPAQUE ? ((OPAQUE)object).getSQLTypeName().trim() : (object instanceof TIMESTAMPTZ && oDMrResultSetTableModel != null ? ((TIMESTAMPTZ)object).stringValue(oDMrResultSetTableModel.getConnection()) : (object instanceof TIMESTAMPLTZ && oDMrResultSetTableModel != null ? ((TIMESTAMPLTZ)object).stringValue(oDMrResultSetTableModel.getConnection()) : (object instanceof Datum ? ((Datum)object).stringValue() : object.toString()))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private String sanitizeStringForCopy(String string) {
        String string2 = "\r\n|[\r\n\u2028\u2029\u0085]|\t";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return "\"" + string + "\"";
        }
        return string;
    }
}

