/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.ai;

import java.awt.Component;
import java.sql.Connection;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.table.TableColumn;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.NiceTableWithToolbar;
import oracle.dmt.dataminer.controls.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.wflownodes.ColumnFilterNavNode;
import oracle.dmt.dataminer.teditor.ai.DialogsLrb;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterResultType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.ide.util.SwingWorker;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class AIViewerPanel
extends DataMinerViewGUI {
    private AttrsTableModelEx _models;
    private NiceTableWithToolbar _tableWithToolbar;
    private Map<String, Statistics> _statisticLookupMap = new TreeMap<String, Statistics>();
    private Map<String, String> _attrTypeLookupMap = new HashMap<String, String>();
    private String[] _columnNamesEx = new String[]{DialogsLrb.get("AI_EDITOR_TABLE_COL_NAME"), DialogsLrb.get("AI_EDITOR_TABLE_COL_TYPE"), DialogsLrb.get("AI_EDITOR_TABLE_COL_RANK"), DialogsLrb.get("AI_EDITOR_TABLE_COL_IMPORTANCE")};
    private int[] _columnWidthsEx = new int[]{180, 80, 50, 80};
    private static final int ATTRIBUTE = 0;
    private static final int DATA_TYPE = 1;
    private static final int RANK = 2;
    private static final int IMPORTANCE = 3;
    private static final int COLUMN_COUNT = 4;
    private ComponentWithTitlebar<JComponent> componentWithTitlebar1;
    private JLabel jTargetColumnLabel;
    private JLabel jTargetLabel;

    public AIViewerPanel(Editor editor, Context context) throws Exception {
        super(editor, context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("AI_EDITOR_TARGET_LABEL"), this.jTargetLabel);
        UIResourceHelper.setComponentText(hashMap);
    }

    @Override
    public void initUI() {
        this._models = new AttrsTableModelEx();
        ControlBar controlBar = new ControlBar();
        this._tableWithToolbar = new NiceTableWithToolbar(this.componentWithTitlebar1, controlBar, this._columnNamesEx, this._models);
        this._tableWithToolbar.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("AI_EDITOR_TABLE_TITLE")));
        TableColumn tableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(new NumberCellRenderer());
        tableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(3);
        Preferences preferences = Preferences.getPreferences();
        ModelViewerPreferenceSettings modelViewerPreferenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)preferences);
        NumberFormat numberFormat = NumericFormat.getInstance(true, modelViewerPreferenceSettings.getPercentagePrecisionLevel(), 0, 0);
        numberFormat.setMaximumFractionDigits(modelViewerPreferenceSettings.getPercentagePrecisionLevel());
        numberFormat.setMinimumIntegerDigits(1);
        tableColumn.setCellRenderer(new HistogramBarRenderer(1L, true, numberFormat));
        this._tableWithToolbar.getNiceTable().setAutoResizeMode(0);
        this._tableWithToolbar.getNiceTable().setColumnSelectorAvailable(true);
        this._tableWithToolbar.getNiceTable().setShowToolTips(true);
        this._tableWithToolbar.getNiceTable().setUpdateSelectionOnSort(true);
        this._tableWithToolbar.getNiceTable().setRowSelectionAllowed(true);
        this._tableWithToolbar.getNiceTable().setSortColumn(2, true);
        int n = 0;
        for (int n2 : this._columnWidthsEx) {
            this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    public HelpInfo getHelpInfo() {
        String string = "ai_viewer_help";
        return new HelpInfo(string);
    }

    private void initComponents() {
        this.jTargetLabel = new JLabel();
        this.jTargetColumnLabel = new JLabel();
        this.componentWithTitlebar1 = new ComponentWithTitlebar();
        this.jTargetLabel.setText("Target:");
        this.jTargetLabel.setName("jTargetLabel");
        this.jTargetColumnLabel.setText("Target Column");
        this.jTargetColumnLabel.setName("jTargetColumnLabel");
        this.componentWithTitlebar1.setName("componentWithTitlebar1");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.componentWithTitlebar1, -1, 380, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTargetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetColumnLabel, -2, 213, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLabel).addComponent(this.jTargetColumnLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.componentWithTitlebar1, -1, 258, Short.MAX_VALUE).addContainerGap()));
    }

    private class AttrsTableModelEx
    extends GenericBaseTableModel {
        Map<String, Statistics> _statisticLookupMap;

        public int getRowCount() {
            return this._statisticLookupMap != null ? this._statisticLookupMap.size() : 1;
        }

        public AttrsTableModelEx() {
            this(null);
        }

        public AttrsTableModelEx(Map<String, Statistics> map) {
            this._statisticLookupMap = map;
            this.setColumnIdentifiers(AIViewerPanel.this._columnNamesEx);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(4);
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return object.getClass();
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            if (this._statisticLookupMap == null) {
                return "Loading...";
            }
            Object[] objectArray = this._statisticLookupMap.keySet().toArray();
            Object object = null;
            if (objectArray.length > 0) {
                Statistics statistics = this._statisticLookupMap.get(objectArray[n]);
                switch (n2) {
                    case 0: {
                        object = objectArray[n];
                        break;
                    }
                    case 1: {
                        object = statistics.getType();
                        break;
                    }
                    case 2: {
                        if (statistics == null) break;
                        object = statistics.getRank();
                        break;
                    }
                    case 3: {
                        if (statistics == null) break;
                        object = statistics.getImportance();
                        break;
                    }
                }
            }
            return object;
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadResults(ColumnFilterNodeType columnFilterNodeType) throws Exception {
            Connection connection = null;
            try {
                Object object2;
                for (Object object2 : columnFilterNodeType.getColumnFilterAttributes().getAttribute()) {
                    AIViewerPanel.this._attrTypeLookupMap.put(object2.getName(), object2.getDataType());
                }
                ColumnFilterResultType columnFilterResultType = columnFilterNodeType.getColumnFilterResults();
                object2 = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute().getName();
                if (columnFilterResultType != null) {
                    AIViewerPanel.this._statisticLookupMap.clear();
                    connection = Connections.getUniqueConnection(AIViewerPanel.this._context);
                    SQLHelper sQLHelper = new SQLHelper();
                    String string = columnFilterResultType.getAttrImportanceOutput();
                    if (string != null) {
                        String string2 = "SELECT ATTRIBUTE_NAME, IMPORTANCE_VALUE, RANK FROM " + string + " WHERE ATTRIBUTE_NAME != :1 ORDER BY RANK";
                        sQLHelper.pstmt = connection.prepareStatement(string2);
                        sQLHelper.pstmt.setString(1, (String)object2);
                        sQLHelper.pstmt.setFetchSize(100);
                        sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                        String string3 = null;
                        Integer n = null;
                        Double d = null;
                        while (sQLHelper.rs.next()) {
                            string3 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                            n = sQLHelper.rs.getInt("RANK");
                            d = sQLHelper.rs.getDouble("IMPORTANCE_VALUE");
                            Statistics statistics = new Statistics();
                            statistics.setType((String)AIViewerPanel.this._attrTypeLookupMap.get(string3));
                            statistics.setRank(n);
                            statistics.setImportance(d);
                            AIViewerPanel.this._statisticLookupMap.put(string3, statistics);
                        }
                        sQLHelper.close();
                    }
                }
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public Object construct() {
            try {
                Node node = AIViewerPanel.this._context.getNode();
                if (node instanceof ColumnFilterNavNode) {
                    ColumnFilterNavNode columnFilterNavNode = (ColumnFilterNavNode)node;
                    ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNavNode.getRepositoryData();
                    this.loadResults(columnFilterNodeType);
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            block6: {
                try {
                    if (this._success && this._ex == null) {
                        AIViewerPanel.this._models = new AttrsTableModelEx(AIViewerPanel.this._statisticLookupMap);
                        AIViewerPanel.this._tableWithToolbar.resetNiceTableModel(AIViewerPanel.this._models);
                        Node node = AIViewerPanel.this._context.getNode();
                        if (node instanceof ColumnFilterNavNode) {
                            ColumnFilterNavNode columnFilterNavNode = (ColumnFilterNavNode)node;
                            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNavNode.getRepositoryData();
                            AIViewerPanel.this.jTargetColumnLabel.setText(columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute().getName());
                            AIViewerPanel.this._tableWithToolbar.getNiceTable().setSortColumn(2, true);
                        }
                        break block6;
                    }
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("AI_EDITOR_ERROR_MESG"), null);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("AI_EDITOR_ERROR_MESG"), null);
                }
            }
        }
    }

    private class Statistics {
        String _type;
        Integer _rank;
        Double _importance;

        public Statistics() {
            this(null, null, null);
        }

        public Statistics(String string, Integer n, Double d) {
            this._type = string;
            this._rank = n;
            this._importance = d;
        }

        public void setRank(Integer n) {
            this._rank = n;
        }

        public Integer getRank() {
            return this._rank;
        }

        public void setImportance(Double d) {
            this._importance = d;
        }

        public Double getImportance() {
            return this._importance;
        }

        public void setType(String string) {
            this._type = string;
        }

        public String getType() {
            return this._type;
        }
    }
}

