/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dataminer.generated.server.DmRule;
import oracle.dmt.dataminer.server.model.PredicateRowData;
import oracle.dmt.dataminer.server.model.RuleContentOption;

public class RuleRowData {
    private Integer _rule_id;
    private Vector<PredicateRowData> _antecedent;
    private Vector<PredicateRowData> _consequent;
    private Double _rule_support;
    private Double _rule_confidence;
    private Double _rule_lift;
    private Double _antecedent_support;
    private Double _consequent_support;
    private Integer _number_of_items;
    private static final String BROWSER_NEXT_LINE = "<BR>";
    private static final String AND_CONSTANT = "AND";

    public RuleRowData() {
        this._rule_id = 0;
        this._rule_support = new Double(0.0);
        this._rule_confidence = new Double(0.0);
        this._rule_lift = new Double(0.0);
        this._antecedent_support = new Double(0.0);
        this._consequent_support = new Double(0.0);
        this._number_of_items = 0;
        this._antecedent = new Vector();
        this._consequent = new Vector();
    }

    public RuleRowData(Integer n) {
        this._rule_id = n;
        this._rule_support = new Double(0.0);
        this._rule_confidence = new Double(0.0);
        this._rule_lift = new Double(0.0);
        this._antecedent_support = new Double(0.0);
        this._consequent_support = new Double(0.0);
        this._number_of_items = 0;
        this._antecedent = new Vector();
        this._consequent = new Vector();
    }

    public RuleRowData(Integer n, Double d, Double d2, Double d3, Double d4, Double d5, Integer n2, Vector<PredicateRowData> vector, Vector<PredicateRowData> vector2) {
        this._rule_id = n;
        this._rule_support = d;
        this._rule_confidence = d2;
        this._rule_lift = d3;
        this._antecedent_support = d4;
        this._consequent_support = d5;
        this._number_of_items = n2;
        this._antecedent = vector;
        this._consequent = vector2;
    }

    public RuleRowData(DmRule dmRule) throws Exception {
        this._rule_id = dmRule.getRuleId() != null ? new Integer(dmRule.getRuleId()) : null;
        this._rule_support = dmRule.getRuleSupport() != null ? new Double(dmRule.getRuleSupport().doubleValue()) : null;
        this._rule_confidence = dmRule.getRuleConfidence() != null ? new Double(dmRule.getRuleConfidence().doubleValue()) : null;
        this._rule_lift = dmRule.getRuleLift() != null ? new Double(dmRule.getRuleLift().doubleValue()) : null;
        this._antecedent_support = dmRule.getAntecedentSupport() != null ? new Double(dmRule.getAntecedentSupport().doubleValue()) : null;
        this._consequent_support = dmRule.getConsequentSupport() != null ? new Double(dmRule.getConsequentSupport().doubleValue()) : null;
        this._number_of_items = dmRule.getNumberOfItems() != null ? new Integer(dmRule.getNumberOfItems()) : null;
        this._number_of_items = dmRule.getNumberOfItems() != null ? new Integer(dmRule.getNumberOfItems()) : null;
        this._antecedent = dmRule.getAntecedent() != null ? PredicateRowData.createPredicatesFromDmPredicates(dmRule.getAntecedent()) : null;
        this._consequent = dmRule.getConsequent() != null ? PredicateRowData.createPredicatesFromDmPredicates(dmRule.getConsequent()) : null;
    }

    private String getFullPredicate(Vector<PredicateRowData> vector, RuleContentOption ruleContentOption, boolean bl) {
        Iterator<PredicateRowData> iterator = vector.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().getFullPredicate(ruleContentOption));
            if (!iterator.hasNext()) continue;
            if (bl) {
                stringBuffer.append(" AND<BR>");
                continue;
            }
            stringBuffer.append(" AND ");
        }
        return stringBuffer.toString();
    }

    private String getFullPredicate(Vector<PredicateRowData> vector, RuleContentOption ruleContentOption) {
        return this.getFullPredicate(vector, ruleContentOption, false);
    }

    public String getFullAntecedent() {
        return this.getFullPredicate(this._antecedent, RuleContentOption.NAME_SUBNAME_VALUE);
    }

    public String getFullAntecedent(RuleContentOption ruleContentOption) {
        return this.getFullPredicate(this._antecedent, ruleContentOption);
    }

    public String getFullAntecedent(RuleContentOption ruleContentOption, boolean bl) {
        return this.getFullPredicate(this._antecedent, ruleContentOption, bl);
    }

    public String getFullConsequent() {
        return this.getFullPredicate(this._consequent, RuleContentOption.NAME_SUBNAME_VALUE);
    }

    public String getFullConsequent(RuleContentOption ruleContentOption) {
        return this.getFullPredicate(this._consequent, ruleContentOption);
    }

    public String getFullConsequent(RuleContentOption ruleContentOption, boolean bl) {
        return this.getFullPredicate(this._consequent, ruleContentOption, bl);
    }

    public void setRule_id(Integer n) {
        this._rule_id = n;
    }

    public Integer getRule_id() {
        return this._rule_id;
    }

    public void setRule_support(Double d) {
        this._rule_support = d;
    }

    public Double getRule_support() {
        return this._rule_support;
    }

    public void setRule_confidence(Double d) {
        this._rule_confidence = d;
    }

    public Double getRule_confidence() {
        return this._rule_confidence;
    }

    public void setRule_lift(Double d) {
        this._rule_lift = d;
    }

    public Double getRule_lift() {
        return this._rule_lift;
    }

    public void setAntecedent_support(Double d) {
        this._antecedent_support = d;
    }

    public Double getAntecedent_support() {
        return this._antecedent_support;
    }

    public void setConsequent_support(Double d) {
        this._consequent_support = d;
    }

    public Double getConsequent_support() {
        return this._consequent_support;
    }

    public void setNumber_of_items(Integer n) {
        this._number_of_items = n;
    }

    public Integer getNumber_of_items() {
        return this._number_of_items;
    }

    public void setAntecedent(Vector<PredicateRowData> vector) {
        this._antecedent = vector;
    }

    public Vector<PredicateRowData> getAntecedent() {
        return this._antecedent;
    }

    public void setConsequent(Vector<PredicateRowData> vector) {
        this._consequent = vector;
    }

    public Vector<PredicateRowData> getConsequent() {
        return this._consequent;
    }

    public HashMap<String, RuleAttributeValues> getRuleAttributeValues() {
        HashMap<String, RuleAttributeValues> hashMap = new HashMap<String, RuleAttributeValues>();
        RuleAttributeValues ruleAttributeValues = null;
        for (PredicateRowData predicateRowData : this._antecedent) {
            ruleAttributeValues = new RuleAttributeValues(predicateRowData.getAttribute_name(), predicateRowData.getAttribute_subname(), predicateRowData.getAttribute_confidence(), predicateRowData.getAttribute_support());
            hashMap.put(predicateRowData.getFullAttributeName(), ruleAttributeValues);
        }
        return hashMap;
    }

    public class RuleAttributeValues {
        String _attribute_name;
        String _attribute_subName;
        Double _confidence;
        Double _support;

        public RuleAttributeValues(String string, String string2, Double d, Double d2) {
            this._attribute_name = string;
            this._attribute_subName = string2;
            this._confidence = d;
            this._support = d2;
        }

        public void setAttribute_name(String string) {
            this._attribute_name = string;
        }

        public String getAttribute_name() {
            return this._attribute_name;
        }

        public void setAttribute_subName(String string) {
            this._attribute_subName = string;
        }

        public String getAttribute_subName() {
            return this._attribute_subName;
        }

        public void setConfidence(Double d) {
            this._confidence = d;
        }

        public Double getConfidence() {
            return this._confidence;
        }

        public String getFullAttributeName() {
            String string = this._attribute_subName != null ? this._attribute_name + "." + this._attribute_subName : this._attribute_name;
            return string;
        }

        public void setSupport(Double d) {
            this._support = d;
        }

        public Double getSupport() {
            return this._support;
        }
    }
}

