/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dataminer.server.ServerConstantsLrb;
import oracle.dmt.dataminer.server.model.MiningAlgorithms;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;

public final class MiningAlgorithmOptions
extends Enum<MiningAlgorithmOptions> {
    public static final /* enum */ MiningAlgorithmOptions ALL = new MiningAlgorithmOptions(ServerConstantsLrb.get("ALGO_ALL_ALGORITHMS"));
    public static final /* enum */ MiningAlgorithmOptions APRIORI = new MiningAlgorithmOptions(ServerConstantsLrb.get("ALGO_APRIORI_ASSOCIATION_RULES"));
    public static final /* enum */ MiningAlgorithmOptions DECISION_TREE = new MiningAlgorithmOptions(ServerConstantsLrb.get("ALGO_DECISION_TREE"));
    public static final /* enum */ MiningAlgorithmOptions GENERALIZED_LINEAR_MODEL = new MiningAlgorithmOptions(ServerConstantsLrb.get("ALGO_GENERALIZED_LINEAR_MODEL"));
    public static final /* enum */ MiningAlgorithmOptions KMEANS = new MiningAlgorithmOptions(ServerConstantsLrb.get("ALGO_KMEANS"));
    public static final /* enum */ MiningAlgorithmOptions NAIVE_BAYES = new MiningAlgorithmOptions(ServerConstantsLrb.get("ALGO_NAIVE_BAYES"));
    public static final /* enum */ MiningAlgorithmOptions NON_NEGATIVE_MATRIX_FACTORIZATION = new MiningAlgorithmOptions(ServerConstantsLrb.get("ALGO_NONNEGATIVE_MATRIX_FACTOR"));
    public static final /* enum */ MiningAlgorithmOptions OCLUSTER = new MiningAlgorithmOptions(ServerConstantsLrb.get("ALGO_O_CLUSTER"));
    public static final /* enum */ MiningAlgorithmOptions SUPPORT_VECTOR_MACHINE = new MiningAlgorithmOptions(ServerConstantsLrb.get("ALGO_SUPPORT_VECTOR_MACHINE"));
    private final String translation;
    private static EnumComparator comparator;
    private static final Map<String, MiningAlgorithmOptions> stringToEnum;
    private static final /* synthetic */ MiningAlgorithmOptions[] $VALUES;

    public static MiningAlgorithmOptions[] values() {
        return (MiningAlgorithmOptions[])$VALUES.clone();
    }

    public static MiningAlgorithmOptions valueOf(String string) {
        return Enum.valueOf(MiningAlgorithmOptions.class, string);
    }

    private MiningAlgorithmOptions(String string2) {
        this.translation = string2;
    }

    public static MiningAlgorithmOptions fromString(String string) {
        return stringToEnum.get(string);
    }

    public String toString() {
        return this.translation;
    }

    public static String translateFromODMServerAlgorithm(String string) {
        String string2 = "";
        string2 = string.compareTo("APRIORI_ASSOCIATION_RULES") == 0 ? MiningAlgorithms.APRIORI.toString() : (string.compareTo("DECISION_TREE") == 0 ? MiningAlgorithms.DECISION_TREE.toString() : (string.compareTo("GENERALIZED_LINEAR_MODEL") == 0 ? MiningAlgorithms.GENERALIZED_LINEAR_MODEL.toString() : (string.compareTo("KMEANS") == 0 ? MiningAlgorithms.KMEANS.toString() : (string.compareTo("NAIVE_BAYES") == 0 ? MiningAlgorithms.NAIVE_BAYES.toString() : (string.compareTo("O_CLUSTER") == 0 ? MiningAlgorithms.OCLUSTER.toString() : (string.compareTo("SUPPORT_VECTOR_MACHINES") == 0 ? MiningAlgorithms.SUPPORT_VECTOR_MACHINE.toString() : (string.compareTo("NONNEGATIVE_MATRIX_FACTOR") == 0 ? MiningAlgorithms.NON_NEGATIVE_MATRIX_FACTORIZATION.toString() : "UNKNOWN:" + string)))))));
        return string2;
    }

    public static MiningAlgorithmType translateToODMServerMiningAlgorithm(MiningAlgorithmOptions miningAlgorithmOptions) {
        MiningAlgorithmType miningAlgorithmType = null;
        switch (miningAlgorithmOptions) {
            case APRIORI: {
                miningAlgorithmType = MiningAlgorithmType.APRIORI_ASSOCIATION_RULES;
                break;
            }
            case DECISION_TREE: {
                miningAlgorithmType = MiningAlgorithmType.DECISION_TREE;
                break;
            }
            case GENERALIZED_LINEAR_MODEL: {
                miningAlgorithmType = MiningAlgorithmType.GENERALIZED_LINEAR_MODEL;
                break;
            }
            case KMEANS: {
                miningAlgorithmType = MiningAlgorithmType.KMEANS;
                break;
            }
            case NAIVE_BAYES: {
                miningAlgorithmType = MiningAlgorithmType.NAIVE_BAYES;
                break;
            }
            case NON_NEGATIVE_MATRIX_FACTORIZATION: {
                miningAlgorithmType = MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR;
                break;
            }
            case OCLUSTER: {
                miningAlgorithmType = MiningAlgorithmType.O_CLUSTER;
                break;
            }
            case SUPPORT_VECTOR_MACHINE: {
                miningAlgorithmType = MiningAlgorithmType.SUPPORT_VECTOR_MACHINES;
                break;
            }
            default: {
                assert (false) : "Invalid Algorithm Type";
                break;
            }
        }
        return miningAlgorithmType;
    }

    public static Vector<MiningAlgorithmOptions> getMiningAlgorithmOptions(MiningFunctions miningFunctions) {
        Vector<MiningAlgorithmOptions> vector = new Vector<MiningAlgorithmOptions>();
        if (miningFunctions.equals((Object)MiningFunctions.ANOMALY_DETECTION)) {
            vector.add(SUPPORT_VECTOR_MACHINE);
        } else if (miningFunctions.equals((Object)MiningFunctions.ASSOCIATION_RULES)) {
            vector.add(APRIORI);
        } else if (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION)) {
            vector.add(DECISION_TREE);
            vector.add(GENERALIZED_LINEAR_MODEL);
            vector.add(NAIVE_BAYES);
            vector.add(SUPPORT_VECTOR_MACHINE);
            vector.add(ALL);
        } else if (miningFunctions.equals((Object)MiningFunctions.REGRESSION)) {
            vector.add(GENERALIZED_LINEAR_MODEL);
            vector.add(SUPPORT_VECTOR_MACHINE);
            vector.add(ALL);
        } else if (miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            vector.add(KMEANS);
            vector.add(OCLUSTER);
            vector.add(ALL);
        } else if (miningFunctions.equals((Object)MiningFunctions.FEATURE_EXTRACTION)) {
            vector.add(NON_NEGATIVE_MATRIX_FACTORIZATION);
        }
        Collections.sort(vector, comparator);
        return vector;
    }

    public static MiningAlgorithmOptions getPreferredAlgorithmOptionForModelDetailsNode(MiningFunctions miningFunctions) {
        MiningAlgorithmOptions miningAlgorithmOptions = null;
        if (miningFunctions == null) {
            return miningAlgorithmOptions;
        }
        if (miningFunctions.equals((Object)MiningFunctions.ANOMALY_DETECTION)) {
            miningAlgorithmOptions = SUPPORT_VECTOR_MACHINE;
        } else if (miningFunctions.equals((Object)MiningFunctions.ASSOCIATION_RULES)) {
            miningAlgorithmOptions = APRIORI;
        } else if (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION)) {
            miningAlgorithmOptions = ALL;
        } else if (miningFunctions.equals((Object)MiningFunctions.REGRESSION)) {
            miningAlgorithmOptions = ALL;
        } else if (miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            miningAlgorithmOptions = ALL;
        } else if (miningFunctions.equals((Object)MiningFunctions.FEATURE_EXTRACTION)) {
            miningAlgorithmOptions = NON_NEGATIVE_MATRIX_FACTORIZATION;
        }
        return miningAlgorithmOptions;
    }

    public static MiningAlgorithmType getMiningAlgorithmType(MiningAlgorithmOptions miningAlgorithmOptions) {
        MiningAlgorithmType miningAlgorithmType = null;
        if (miningAlgorithmOptions == null) {
            return miningAlgorithmType;
        }
        if (miningAlgorithmOptions.equals((Object)ALL)) {
            miningAlgorithmType = MiningAlgorithmType.ALL;
        } else if (miningAlgorithmOptions.equals((Object)APRIORI)) {
            miningAlgorithmType = MiningAlgorithmType.APRIORI_ASSOCIATION_RULES;
        } else if (miningAlgorithmOptions.equals((Object)DECISION_TREE)) {
            miningAlgorithmType = MiningAlgorithmType.DECISION_TREE;
        } else if (miningAlgorithmOptions.equals((Object)GENERALIZED_LINEAR_MODEL)) {
            miningAlgorithmType = MiningAlgorithmType.GENERALIZED_LINEAR_MODEL;
        } else if (miningAlgorithmOptions.equals((Object)KMEANS)) {
            miningAlgorithmType = MiningAlgorithmType.KMEANS;
        } else if (miningAlgorithmOptions.equals((Object)NAIVE_BAYES)) {
            miningAlgorithmType = MiningAlgorithmType.NAIVE_BAYES;
        } else if (miningAlgorithmOptions.equals((Object)NON_NEGATIVE_MATRIX_FACTORIZATION)) {
            miningAlgorithmType = MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR;
        } else if (miningAlgorithmOptions.equals((Object)OCLUSTER)) {
            miningAlgorithmType = MiningAlgorithmType.O_CLUSTER;
        } else if (miningAlgorithmOptions.equals((Object)SUPPORT_VECTOR_MACHINE)) {
            miningAlgorithmType = MiningAlgorithmType.SUPPORT_VECTOR_MACHINES;
        }
        return miningAlgorithmType;
    }

    public static MiningAlgorithmOptions getMiningAlgorithmType(MiningAlgorithmType miningAlgorithmType) {
        MiningAlgorithmOptions miningAlgorithmOptions = null;
        if (miningAlgorithmType == null) {
            return miningAlgorithmOptions;
        }
        if (miningAlgorithmType.equals((Object)MiningAlgorithmType.ALL)) {
            miningAlgorithmOptions = ALL;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.APRIORI_ASSOCIATION_RULES)) {
            miningAlgorithmOptions = APRIORI;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.DECISION_TREE)) {
            miningAlgorithmOptions = DECISION_TREE;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.GENERALIZED_LINEAR_MODEL)) {
            miningAlgorithmOptions = GENERALIZED_LINEAR_MODEL;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.KMEANS)) {
            miningAlgorithmOptions = KMEANS;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.NAIVE_BAYES)) {
            miningAlgorithmOptions = NAIVE_BAYES;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR)) {
            miningAlgorithmOptions = NON_NEGATIVE_MATRIX_FACTORIZATION;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.O_CLUSTER)) {
            miningAlgorithmOptions = OCLUSTER;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.SUPPORT_VECTOR_MACHINES)) {
            miningAlgorithmOptions = SUPPORT_VECTOR_MACHINE;
        }
        return miningAlgorithmOptions;
    }

    public static Vector<MiningAlgorithmType> getMiningAlgorithmTypes(MiningFunctions miningFunctions) {
        Vector<MiningAlgorithmType> vector = new Vector<MiningAlgorithmType>();
        if (miningFunctions.equals((Object)MiningFunctions.ANOMALY_DETECTION)) {
            vector.add(MiningAlgorithmType.SUPPORT_VECTOR_MACHINES);
        } else if (miningFunctions.equals((Object)MiningFunctions.ASSOCIATION_RULES)) {
            vector.add(MiningAlgorithmType.APRIORI_ASSOCIATION_RULES);
        } else if (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION)) {
            vector.add(MiningAlgorithmType.DECISION_TREE);
            vector.add(MiningAlgorithmType.GENERALIZED_LINEAR_MODEL);
            vector.add(MiningAlgorithmType.NAIVE_BAYES);
            vector.add(MiningAlgorithmType.SUPPORT_VECTOR_MACHINES);
            vector.add(MiningAlgorithmType.ALL);
        } else if (miningFunctions.equals((Object)MiningFunctions.REGRESSION)) {
            vector.add(MiningAlgorithmType.GENERALIZED_LINEAR_MODEL);
            vector.add(MiningAlgorithmType.SUPPORT_VECTOR_MACHINES);
            vector.add(MiningAlgorithmType.ALL);
        } else if (miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            vector.add(MiningAlgorithmType.KMEANS);
            vector.add(MiningAlgorithmType.O_CLUSTER);
            vector.add(MiningAlgorithmType.ALL);
        } else if (miningFunctions.equals((Object)MiningFunctions.FEATURE_EXTRACTION)) {
            vector.add(MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR);
        }
        Collections.sort(vector, comparator);
        return vector;
    }

    static {
        $VALUES = new MiningAlgorithmOptions[]{ALL, APRIORI, DECISION_TREE, GENERALIZED_LINEAR_MODEL, KMEANS, NAIVE_BAYES, NON_NEGATIVE_MATRIX_FACTORIZATION, OCLUSTER, SUPPORT_VECTOR_MACHINE};
        comparator = new EnumComparator();
        stringToEnum = new HashMap<String, MiningAlgorithmOptions>();
        for (MiningAlgorithmOptions miningAlgorithmOptions : MiningAlgorithmOptions.values()) {
            stringToEnum.put(miningAlgorithmOptions.toString(), miningAlgorithmOptions);
        }
    }

    public static class EnumComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object object, Object object2) {
            String string = object.toString();
            String string2 = object2.toString();
            return string.compareTo(string2);
        }
    }
}

