/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.HashMap;
import java.util.Vector;
import oracle.dmt.dataminer.generated.server.DmHistogramBin;
import oracle.dmt.dataminer.generated.server.DmHistograms;
import oracle.dmt.dataminer.server.model.AttributeBinIdentifier;

public class HistogramRowData {
    private String _attribute_name;
    private String _attribute_subname;
    private Integer _bin_id;
    private Double _lower_bound;
    private Double _upper_bound;
    private String _label;
    private Double _count;

    public HistogramRowData() {
        this._attribute_name = "";
        this._attribute_subname = "";
        this._bin_id = 0;
        this._lower_bound = new Double(0.0);
        this._upper_bound = new Double(0.0);
        this._label = "";
        this._count = new Double(0.0);
    }

    public HistogramRowData(String string, String string2, Integer n, Double d, Double d2, String string3, Double d3) {
        this._attribute_name = string;
        this._attribute_subname = string2;
        this._bin_id = n;
        this._lower_bound = d;
        this._upper_bound = d2;
        this._label = string3;
        this._count = d3;
    }

    public HistogramRowData(DmHistogramBin dmHistogramBin) throws Exception {
        this._attribute_name = dmHistogramBin.getAttributeName();
        this._attribute_subname = dmHistogramBin.getAttributeSubname() != null ? dmHistogramBin.getAttributeSubname() : null;
        this._bin_id = dmHistogramBin.getBinId() != null ? new Integer(dmHistogramBin.getBinId().intValue()) : null;
        this._lower_bound = dmHistogramBin.getLowerBound() != null ? Double.valueOf(dmHistogramBin.getLowerBound().doubleValue()) : null;
        this._upper_bound = dmHistogramBin.getUpperBound() != null ? Double.valueOf(dmHistogramBin.getUpperBound().doubleValue()) : null;
        this._label = dmHistogramBin.getLabel() != null ? dmHistogramBin.getLabel() : null;
        this._count = dmHistogramBin.getCount() != null ? new Double(dmHistogramBin.getCount().doubleValue()) : null;
    }

    public static HashMap<AttributeBinIdentifier, HistogramRowData> createMappedAttributeHistogram(Vector<HistogramRowData> vector) {
        HashMap<AttributeBinIdentifier, HistogramRowData> hashMap = new HashMap<AttributeBinIdentifier, HistogramRowData>();
        AttributeBinIdentifier attributeBinIdentifier = null;
        for (HistogramRowData histogramRowData : vector) {
            attributeBinIdentifier = new AttributeBinIdentifier(histogramRowData.getFullAttributeName(), histogramRowData.getBin_id());
            hashMap.put(attributeBinIdentifier, histogramRowData);
        }
        return hashMap;
    }

    public static Vector<HistogramRowData> createAttributeHistogram(Vector<HistogramRowData> vector, String string) {
        Vector<HistogramRowData> vector2 = new Vector<HistogramRowData>();
        for (HistogramRowData histogramRowData : vector) {
            if (histogramRowData.getFullAttributeName().compareTo(string) != 0) continue;
            vector2.add(histogramRowData);
        }
        return vector2;
    }

    public static Vector<HistogramRowData> createAttributeHistogramFromMap(HashMap<AttributeBinIdentifier, HistogramRowData> hashMap, String string) {
        Vector<HistogramRowData> vector = new Vector<HistogramRowData>();
        boolean bl = true;
        int n = 1;
        HistogramRowData histogramRowData = null;
        AttributeBinIdentifier attributeBinIdentifier = new AttributeBinIdentifier(string, 1);
        while (bl) {
            attributeBinIdentifier.setBin_id(n);
            histogramRowData = hashMap.get(attributeBinIdentifier);
            if (histogramRowData == null) {
                bl = false;
                continue;
            }
            vector.add(histogramRowData);
        }
        return vector;
    }

    public String getFullAttributeName() {
        String string = this._attribute_subname != null ? this._attribute_name + "." + this._attribute_subname : this._attribute_name;
        return string;
    }

    public void setAttribute_name(String string) {
        this._attribute_name = string;
    }

    public String getAttribute_name() {
        return this._attribute_name;
    }

    public void setAttribute_subname(String string) {
        this._attribute_subname = string;
    }

    public String getAttribute_subname() {
        return this._attribute_subname;
    }

    public void setBin_id(Integer n) {
        this._bin_id = n;
    }

    public Integer getBin_id() {
        return this._bin_id;
    }

    public void setLower_bound(Double d) {
        this._lower_bound = d;
    }

    public Double getLower_bound() {
        return this._lower_bound;
    }

    public void setUpper_bound(Double d) {
        this._upper_bound = d;
    }

    public Double getUpper_bound() {
        return this._upper_bound;
    }

    public void setLabel(String string) {
        this._label = string;
    }

    public String getLabel() {
        return this._label;
    }

    public void setCount(Double d) {
        this._count = d;
    }

    public Double getCount() {
        return this._count;
    }

    public static Vector<HistogramRowData> createHistogramsFromDmHistograms(DmHistograms dmHistograms) throws Exception {
        Vector<HistogramRowData> vector = new Vector<HistogramRowData>();
        for (int i = 0; i < dmHistograms.length(); ++i) {
            DmHistogramBin dmHistogramBin = dmHistograms.getElement(i);
            HistogramRowData histogramRowData = new HistogramRowData(dmHistogramBin);
            vector.add(histogramRowData);
        }
        return vector;
    }
}

