/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.server.model.CoefficientSortSpec;
import oracle.dmt.dataminer.server.model.CoefficientWhereSpec;
import oracle.dmt.dataminer.server.model.FilterSetting;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.ModelDetails;
import oracle.dmt.dataminer.server.model.SortSpec;
import oracle.dmt.dataminer.server.model.TargetPriorsPredictionSet;
import oracle.dmt.dataminer.server.model.WhereSpec;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.jdbc.OraclePreparedStatement;

public class FeatureExtraction
extends Model
implements ModelDetails {
    private HashMap<Integer, String> _featureIDToLabelMap = new HashMap();
    private final String FEATURE_ID = "FEATURE_ID";
    private final String MAPPED_FEATURE_ID = "MAPPED_FEATURE_ID";
    public static final String MAXIMUM_ABS_COEFFICIENT_VALUE = "MAXIMUM_ABS_COEFFICIENT_VALUE";
    public static final String TOTAL_COEFFICIENTS = "TOTAL_COEFFICIENTS";
    private static final String QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION = "SELECT COUNT(*) TOTAL_COEFFICIENTS, \n   max(abs(coefficient))MAXIMUM_ABS_COEFFICIENT_VALUE \n   FROM TABLE(dbms_data_mining.get_model_details_nmf(:model_name)) t, \n   TABLE(t.attribute_set) s \n   WHERE t.mapped_feature_id IN(:target_values)  ";
    private static final String QUERY_MIN_MAX = "SELECT  MAX(coefficient) maximum_value \nFROM TABLE(dbms_data_mining.get_model_details_nmf('<model_name>')) t, TABLE(t.attribute_set) s";
    private static final String _TARGET_CONDITION = "  WHERE t.mapped_feature_id = <target_value> \n";
    private static final String QUERY_COEFFICIENTS_ALL = "SELECT * FROM ( \nSELECT * FROM ( \nSELECT \n<select_stmt>\n\tfrom ( \tSELECT CASE WHEN r.attribute_subname IS NOT NULL THEN \n\t      r.attribute_name || '.' ||  r.attribute_subname \n\t     ELSE r.attribute_name \n\t     END \"attribute_name_subname\", \n\t  r.attribute_name \"attribute_name\", \n\t  r.attribute_value \"attribute_value\", \n\t  r.feature_id \"feature_id\", \n\t  r.mapped_feature_id \"mapped_feature_id\" \n  FROM (SELECT t.feature_id, t.mapped_feature_id, s.attribute_name, s.attribute_subname, s.attribute_value \n    FROM TABLE(dbms_data_mining.get_model_details_nmf(<model_name>)) t, \n   TABLE(t.attribute_set) s \n<target_condition> ) r ) \n<name_filter_condition><group_by>) <order> \n) <rownum> \n";
    private static final String QRY_FEATURE_COEFFICIENTS = "SELECT * FROM ( \nSELECT * FROM ( \n  SELECT \"feature_id\", \"mapped_feature_id\", \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"coefficient\" from  \n      (SELECT CASE WHEN r.attribute_subname IS NOT NULL THEN \n                       r.attribute_name || '.' ||  r.attribute_subname \n                  ELSE r.attribute_name \n       END \"attribute_name_subname\", \n       r.attribute_name \"attribute_name\", \n       r.attribute_value \"attribute_value\",  \n       r.coefficient \"coefficient\", \n       r.feature_id \"feature_id\",  \n       r.mapped_feature_id \"mapped_feature_id\" \n  FROM (SELECT t.feature_id, t.mapped_feature_id, s.attribute_name, s.attribute_subname, s.attribute_value, <coefficient_value> \n    FROM TABLE(dbms_data_mining.get_model_details_nmf(:model_name)) t, \n   TABLE(t.attribute_set) s \n     <internal_where_clause> \n ) r  ) \n) <order> \n) <rownum> \n";
    private static final String QRY_FEATURE_COEFFICIENTS_FEATURE_ID = " t.mapped_feature_id = :target_value";
    public static String alter_reverse_expression_feature_id = "when value = [FEATURE_ID] then ";
    public static String alter_reverse_expression_case_rename = "'[NEW_NAME]'\n";
    public static String alter_reverse_expression_case_keep_old = "'[OLD_NAME]'\n";
    public static String alter_reverse_expression_case_end = "                else TO_CHAR(value) end";
    public static String alter_reverse_expression_final = "BEGIN\n  dbms_data_mining.alter_reverse_expression(\n :MODEL_NAME, :CASE_STATEMENT);\nEND;\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initFeatures(Connection connection, String string, String string2) throws Exception {
        SQLHelper sQLHelper = new SQLHelper();
        String string3 = "SELECT t.feature_id, t.mapped_feature_id FROM TABLE(dbms_data_mining.get_model_details_nmf('" + Model.getCombinedUserNameModelName(string, string2, true) + "')) t ORDER BY feature_id";
        try {
            this._featureIDToLabelMap.clear();
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                Integer n = sQLHelper.rs.getInt("FEATURE_ID");
                String string4 = sQLHelper.rs.getString("MAPPED_FEATURE_ID");
                this._featureIDToLabelMap.put(n, string4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            sQLHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<TargetPriorsPredictionSet> getTargetValuePredictionSet(Connection connection, String string, String string2) throws Exception {
        SQLHelper sQLHelper = new SQLHelper();
        Vector<TargetPriorsPredictionSet> vector = new Vector<TargetPriorsPredictionSet>();
        String string3 = "select FEATURE_ID, VALUE from table(FEATURE_SET( " + Model.getCombinedUserNameModelName(string, string2, false) + "  using)) ORDER BY FEATURE_ID";
        String string4 = null;
        try {
            string4 = DatabaseMetadataUtils.createUniqueTableName("ODMR$", connection, "");
            String string5 = "CREATE TABLE " + string4 + " AS " + string3;
            sQLHelper.pstmt = connection.prepareStatement(string5);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            string5 = "SELECT FEATURE_ID, VALUE FROM " + string4;
            sQLHelper.pstmt = connection.prepareStatement(string5);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            ResultSetMetaData resultSetMetaData = sQLHelper.rs.getMetaData();
            int n = resultSetMetaData.getColumnType(1);
            while (sQLHelper.rs.next()) {
                TargetPriorsPredictionSet targetPriorsPredictionSet = null;
                Object object = null;
                if (DatabaseMetadataUtils.isSQLDataTypeNumeric(n)) {
                    object = sQLHelper.rs.getBigDecimal("FEATURE_ID");
                } else if (DatabaseMetadataUtils.isSQLDataTypeString(n)) {
                    object = sQLHelper.rs.getString("FEATURE_ID");
                } else {
                    throw new Exception("Unexpected target data type. Expected either a number or string.");
                }
                targetPriorsPredictionSet = new TargetPriorsPredictionSet(object, n, new Double(sQLHelper.rs.getDouble("VALUE")));
                vector.add(targetPriorsPredictionSet);
            }
            this.initFeatures(connection, string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            DatabaseMetadataUtils.dropTable(connection, null, string4);
            sQLHelper.close();
        }
        return vector;
    }

    public TargetPriorsPredictionSet findMostCommonTargetValue(Vector<TargetPriorsPredictionSet> vector) {
        Double d = new Double(0.0);
        Object object = null;
        TargetPriorsPredictionSet targetPriorsPredictionSet = null;
        for (TargetPriorsPredictionSet targetPriorsPredictionSet2 : vector) {
            if (!(d <= targetPriorsPredictionSet2.getProbability())) continue;
            d = targetPriorsPredictionSet2.getProbability();
            object = targetPriorsPredictionSet2.getPrediction();
            targetPriorsPredictionSet = targetPriorsPredictionSet2;
        }
        assert (object != null) : "Unable to find a target value with a prob value >= 0";
        return targetPriorsPredictionSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getMaxValue(Connection connection, String string, String string2) {
        SQLHelper sQLHelper = new SQLHelper();
        Double d = null;
        String string3 = StringUtils.getReplacedString(QUERY_MIN_MAX, "<model_name>", Model.getCombinedUserNameModelName(string, string2, true));
        try {
            sQLHelper.stmt = connection.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string3);
            if (sQLHelper.rs.next()) {
                d = sQLHelper.rs.getDouble(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            d = null;
        }
        finally {
            sQLHelper.close();
        }
        return d;
    }

    private static String createInternalWhereClause(FilterSetting filterSetting, String string, String string2, String string3) {
        StringBuilder stringBuilder = null;
        if (null != filterSetting.getTargetValue()) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("   WHERE ");
            stringBuilder.append(QRY_FEATURE_COEFFICIENTS_FEATURE_ID);
        }
        if (string != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string);
        }
        if (string != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string);
        }
        if (string2 != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string2);
        }
        if (string3 != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string3);
        }
        return stringBuilder != null ? stringBuilder.toString() : "";
    }

    private String prepareCoefficientSQL(FilterSetting filterSetting) throws Exception {
        String string = QRY_FEATURE_COEFFICIENTS;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        StringBuffer stringBuffer = new StringBuffer();
        String string6 = "";
        Double d = null;
        Double d2 = null;
        Vector<CoefficientSortSpec> vector = null;
        if (filterSetting != null) {
            Object object;
            if (filterSetting.isUseFilterSpecification()) {
                object = filterSetting.getMaxCoefficient();
                if (object != null) {
                    d = new Double(((BigDecimal)object).doubleValue());
                }
                if ((object = filterSetting.getMinCoefficient()) != null) {
                    d2 = new Double(((BigDecimal)object).doubleValue());
                }
            }
            vector = filterSetting.getSortSpecification();
            string2 = "s.coefficient";
            if (d != null) {
                string4 = " AND s.coefficient <= " + d;
            }
            if (d2 != null) {
                string5 = " AND s.coefficient >= " + d2;
            }
            if (filterSetting.getFetchSize() > 0) {
                string6 = " where rownum <= " + filterSetting.getFetchSize();
            }
            if (vector != null && vector.size() > 0) {
                stringBuffer.append("order by ");
                object = vector.iterator();
                while (object.hasNext()) {
                    CoefficientSortSpec coefficientSortSpec = (CoefficientSortSpec)object.next();
                    if (!coefficientSortSpec.isUseIt()) continue;
                    if (coefficientSortSpec.getAttributeName().equals("coefficient")) {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    } else {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    }
                    if (coefficientSortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!object.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        string = StringUtils.getReplacedString(string, "<coefficient_value>", string2);
        string = StringUtils.getReplacedString(string, "<internal_where_clause>", FeatureExtraction.createInternalWhereClause(filterSetting, string3, string4, string5));
        string = StringUtils.getReplacedString(string, "<order>", stringBuffer.toString());
        string = StringUtils.getReplacedString(string, "<rownum>", string6);
        return string;
    }

    private Vector<CoefficientRowData> invokeCoefficientQuery(Connection connection, String string, String string2, String string3, String string4) throws Exception {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string4);
            sQLHelper.opstmt.setStringAtName("model_name", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.opstmt.setStringAtName("target_value", string3);
            sQLHelper.opstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string5;
                String string6 = sQLHelper.rs.getString("attribute_name_subname");
                if (string6 == null) {
                    string6 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
                }
                if ((string5 = sQLHelper.rs.getString("attribute_value")) == null) {
                    string5 = "";
                }
                Double d = sQLHelper.rs.getDouble("coefficient");
                CoefficientRowData coefficientRowData = new CoefficientRowData(string6, string5, d);
                vector.add(coefficientRowData);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    public Vector<CoefficientRowData> getCoefficients(Connection connection, String string, String string2, FilterSetting filterSetting) throws Exception {
        Vector<CoefficientRowData> vector = new Vector();
        String string3 = null;
        string3 = this.prepareCoefficientSQL(filterSetting);
        vector = this.invokeCoefficientQuery(connection, string, string2, filterSetting.getTargetValue() != null ? filterSetting.getTargetValue().toString() : "", string3);
        return vector;
    }

    private HashMap invokeCoefficientsStatisticsQuery(Connection connection, String string, String string2, List<Object> list) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        SQLHelper sQLHelper = new SQLHelper();
        boolean bl = list.get(0) instanceof String;
        String string3 = Model.getCombinedUserNameModelName(string, string2, false);
        String string4 = "";
        boolean bl2 = true;
        for (Object object : list) {
            if (bl2) {
                bl2 = false;
            } else {
                string4 = string4 + ",";
            }
            if (bl) {
                string4 = string4 + "'" + object.toString() + "'";
                continue;
            }
            string4 = string4 + object.toString();
        }
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION);
            sQLHelper.opstmt.setStringAtName("model_name", string3);
            sQLHelper.opstmt.setStringAtName("target_values", string4);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                Object object;
                Integer n = new Integer(sQLHelper.rs.getInt(TOTAL_COEFFICIENTS));
                hashMap.put(TOTAL_COEFFICIENTS, n);
                object = new Double(sQLHelper.rs.getDouble(MAXIMUM_ABS_COEFFICIENT_VALUE));
                hashMap.put(MAXIMUM_ABS_COEFFICIENT_VALUE, object);
            } else {
                hashMap.put(TOTAL_COEFFICIENTS, new Integer(0));
                hashMap.put(MAXIMUM_ABS_COEFFICIENT_VALUE, new Double(0.0));
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    public HashMap getCoefficientStatistics(Connection connection, String string, String string2, List<Object> list) throws Exception {
        assert (list != null) : "Must provide a non null collection of target values.";
        assert (list != null && list.size() > 0) : "Must provide at least one target value";
        HashMap hashMap = null;
        hashMap = this.invokeCoefficientsStatisticsQuery(connection, string, string2, list);
        return hashMap;
    }

    private String prepareCoefficientSQLAll(String string, String string2, FilterSetting filterSetting) throws Exception {
        String string3 = QUERY_COEFFICIENTS_ALL;
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = "";
        String string5 = null;
        String string6 = "";
        StringBuilder stringBuilder = null;
        String string7 = null;
        if (filterSetting != null) {
            Object object;
            Object object2;
            Object object3;
            Vector<CoefficientSortSpec> vector;
            if (filterSetting.getFetchSize() > 0) {
                string4 = " WHERE rownum <= " + filterSetting.getFetchSize();
            }
            if ((vector = filterSetting.getSortSpecification()) != null && vector.size() > 0) {
                stringBuffer.append("order by ");
                object3 = vector.iterator();
                while (object3.hasNext()) {
                    object2 = (CoefficientSortSpec)object3.next();
                    if (!((SortSpec)object2).isUseIt()) continue;
                    object = ((SortSpec)object2).getAttributeName();
                    if (((String)object).equals("attribute_name_subname")) {
                        string5 = "\"attribute_name_subname\", max(\"attribute_name\") \"attribute_name\", max(\"attribute_value\") \"attribute_value\"";
                        string6 = "GROUP BY \"attribute_name_subname\"";
                        stringBuffer.append("\"attribute_name_subname\"");
                    } else if (((String)object).equals("attribute_name")) {
                        string5 = "max(\"attribute_name_subname\") \"attribute_name_subname\", \"attribute_name\", max(\"attribute_value\") \"attribute_value\"";
                        string6 = "GROUP BY \"attribute_name\"";
                        stringBuffer.append("\"attribute_name\"");
                    } else if (((String)object).equals("attribute_value")) {
                        string5 = "\"attribute_name_subname\", \"attribute_name\", \"attribute_value\"";
                        stringBuffer.append("\"attribute_value\"");
                    }
                    if (((SortSpec)object2).isAscending()) {
                        stringBuffer.append(" ASC ");
                    } else {
                        stringBuffer.append(" DESC NULLS LAST ");
                    }
                    if (!object3.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
            if ((object3 = filterSetting.getWhereSpecification()) != null && ((Vector)object3).size() > 0) {
                object2 = ((Vector)object3).iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (!((CoefficientWhereSpec)object).isUseIt()) continue;
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(" WHERE ");
                    }
                    stringBuilder.append(" \"" + ((WhereSpec)object).getLeftSideObject() + "\" ");
                    switch (((WhereSpec)object).getCondition()) {
                        case 1: {
                            stringBuilder.append(" LIKE ");
                            break;
                        }
                        case 2: {
                            stringBuilder.append(" NOT LIKE ");
                            break;
                        }
                        default: {
                            stringBuilder.append(" LIKE ");
                            assert (false) : "Unrecognized Where Action: " + ((WhereSpec)object).getCondition();
                            break;
                        }
                    }
                    stringBuilder.append("'%" + ((WhereSpec)object).getRightSideObject() + "%' \n");
                }
            }
            string7 = null != filterSetting.getTargetValue() ? StringUtils.getReplacedString(_TARGET_CONDITION, "<target_value>", "'" + filterSetting.getTargetValue().toString() + "'") : "";
        }
        string3 = StringUtils.getReplacedString(string3, "<select_stmt>", string5);
        string3 = StringUtils.getReplacedString(string3, "<model_name>", "'" + Model.getCombinedUserNameModelName(string, string2, true) + "'");
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder("");
        }
        string3 = StringUtils.getReplacedString(string3, "<name_filter_condition>", stringBuilder.toString());
        string3 = StringUtils.getReplacedString(string3, "<target_condition>", string7);
        string3 = StringUtils.getReplacedString(string3, "<order>", stringBuffer.toString());
        string3 = StringUtils.getReplacedString(string3, "<group_by>", string6.toString());
        string3 = StringUtils.getReplacedString(string3, "<rownum>", string4);
        return string3;
    }

    private Vector<CoefficientRowData> invokeItemPickerQuery(Connection connection, String string) throws Exception {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.stmt = connection.createStatement();
            sQLHelper.stmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string);
            while (sQLHelper.rs.next()) {
                String string2;
                String string3 = sQLHelper.rs.getString("attribute_name_subname");
                if (string3 == null) {
                    string3 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
                }
                if ((string2 = sQLHelper.rs.getString("attribute_value")) == null) {
                    string2 = "";
                }
                CoefficientRowData coefficientRowData = new CoefficientRowData(string3, string2, null, null);
                vector.add(coefficientRowData);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            vector.clear();
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    public Vector<CoefficientRowData> getAllCoefficients(Connection connection, String string, String string2, FilterSetting filterSetting) throws Exception {
        Vector<CoefficientRowData> vector = new Vector();
        String string3 = null;
        string3 = this.prepareCoefficientSQLAll(string, string2, filterSetting);
        vector = this.invokeItemPickerQuery(connection, string3);
        return vector;
    }

    public boolean isFeatureLabelUniquie(String string) {
        return !this._featureIDToLabelMap.containsValue(string);
    }

    public String renameFeatureLabel(Connection connection, String string, String string2, String string3, String string4) throws Exception {
        Integer comparable2 = null;
        Set<Integer> set = this._featureIDToLabelMap.keySet();
        for (Integer comparable3 : set) {
            String string5 = this._featureIDToLabelMap.get(comparable3);
            if (!string5.equals(string4)) continue;
            comparable2 = comparable3;
            break;
        }
        StringBuilder stringBuilder = new StringBuilder("case ");
        set = this._featureIDToLabelMap.keySet();
        for (Integer n : set) {
            String string6 = this._featureIDToLabelMap.get(n);
            StringBuilder stringBuilder2 = new StringBuilder();
            String string7 = StringUtils.getReplacedString(alter_reverse_expression_feature_id, "[FEATURE_ID]", n.toString());
            stringBuilder2.append(string7);
            if (n.equals(comparable2)) {
                this._featureIDToLabelMap.put(n, string3);
                string7 = StringUtils.getReplacedString(alter_reverse_expression_case_rename, "[NEW_NAME]", string3);
            } else {
                string7 = StringUtils.getReplacedString(alter_reverse_expression_case_keep_old, "[OLD_NAME]", string6);
            }
            stringBuilder2.append(string7);
            stringBuilder.append(stringBuilder2.toString());
        }
        stringBuilder.append(alter_reverse_expression_case_end);
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(alter_reverse_expression_final);
            sQLHelper.opstmt.setStringAtName("MODEL_NAME", Model.getCombinedUserNameModelName(string, string2, true));
            sQLHelper.opstmt.setStringAtName("CASE_STATEMENT", stringBuilder.toString());
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
        }
        catch (Exception exception) {
            if (exception.getMessage().startsWith("ORA-01031")) {
                throw new Exception(CoefficientsLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"));
            }
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return string3;
    }
}

