/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.runner;

import java.awt.Component;
import javax.swing.Icon;
import oracle.dmt.dataminer.runner.JobsPanel;
import oracle.dmt.dataminer.runner.RunManager;
import oracle.dmt.dataminer.runner.RunManagerEvent;
import oracle.dmt.dataminer.runner.RunManagerListener;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.ide.AddinManager;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.javatools.icons.OracleIcons;

final class TasksWindow
extends DockableWindow
implements RunManagerListener {
    public static final String TASKS_WINDOW_ID = "RunManager";
    public static final ViewId VIEW_ID = new ViewId("TASKS_VIEW_TYPE", "RunManager");
    private static TasksWindow _instance = null;
    private JobsPanel jobPanel;

    public TasksWindow() {
        super("TASKS_VIEW_TYPE.RunManager");
        this.setType(32);
    }

    public void dockableShown(DockableEvent dockableEvent) {
        super.dockableShown(dockableEvent);
        if (null == this.getConnectionName()) {
            return;
        }
        this.jobPanel.switchConnection();
    }

    public void dockableHidden(DockableEvent dockableEvent) {
        super.dockableHidden(dockableEvent);
        AddinManager addinManager = AddinManager.getAddinManager();
        RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
        runManager.removeListener(this, this.getConnectionName());
        this.jobPanel.clearTasks();
    }

    public Toolbar getToolbar() {
        return this.jobPanel.getToolbar();
    }

    public String getConnectionName() {
        return this.jobPanel.getConnectionName();
    }

    @Override
    public void jobChanged(RunManagerEvent runManagerEvent) {
        this.jobPanel.changeJobItem(runManagerEvent);
    }

    @Override
    public void jobAdded(RunManagerEvent runManagerEvent) {
        this.jobPanel.addJobItem(runManagerEvent);
    }

    @Override
    public void jobFinished(RunManagerEvent runManagerEvent) {
        this.jobPanel.finishJobItem(runManagerEvent);
    }

    @Override
    public void jobRemoved(RunManagerEvent runManagerEvent) {
        this.jobPanel.removeJobItem(runManagerEvent);
    }

    @Override
    public void connectionLost(RunManagerEvent runManagerEvent) {
        this.jobPanel.connectionLost(runManagerEvent);
    }

    @Override
    public void connectionReestablished(RunManagerEvent runManagerEvent) {
        this.jobPanel.connectionReestablished(runManagerEvent);
    }

    @Override
    public void jobsListenerInitialized() {
        this.jobPanel.jobsListenerInitialized();
    }

    public static TasksWindow getInstance() {
        if (_instance == null) {
            _instance = new TasksWindow();
        }
        return _instance;
    }

    void shutDown() {
        this.jobPanel.saveSettings();
    }

    public Component getGUI() {
        if (this.jobPanel == null) {
            this.jobPanel = new JobsPanel(this);
        }
        return this.jobPanel;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_threadswindow_html");
    }

    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    public String getTabName() {
        return RunManagerLrb.get("TASKS_WINDOW_TITLE");
    }

    public Icon getTabIcon() {
        return OracleIcons.getIcon((String)"runapplication.png");
    }

    public String getTitleName() {
        return RunManagerLrb.get("TASKS_WINDOW_TITLE");
    }

    void clearTasks() {
        this.jobPanel.clearTasks();
    }
}

