/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dmt.dataminer.repository.WorkflowJobNode;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.jdbc.OracleResultSet;

public final class WorkflowJob {
    private BigDecimal _id;
    private String _chainName;
    private String _jobName;
    private String _workflowName;
    private String _projectName;
    private BigDecimal _projectId;
    private Timestamp _startTime;
    private String _activityState;
    private HashMap<String, WorkflowJobNode> _nodes = new HashMap();
    private boolean _hasFailedSteps = false;
    public static final String WORKFLOW_JOBS_TABLE = "odmr_user_workflow_jobs";
    public static final String WORKFLOW_CHAIN_NAME = "WORKFLOW_CHAIN_NAME";
    public static final String WORKFLOW_NAME = "WORKFLOW_NAME";
    public static final String WORKFLOW_ID = "WORKFLOW_ID";
    public static final String WORKFLOW_STATUS = "WORKFLOW_STATUS";
    public static final String PROJECT_NAME = "PROJECT_NAME";
    public static final String PROJECT_ID = "PROJECT_ID";
    public static final String WORKFLOW_JOB_NAME = "WORKFLOW_JOB_NAME";
    public static final String WORKFLOW_JOB_NODES_TABLE = "odmr_user_workflow_running";
    public static final String NODE_ID = "NODE_ID";
    public static final String NODE_STATUS = "NODE_STATUS";
    public static final String SUBNODE_ID = "SUBNODE_ID";
    public static final String SUBNODE_STATUS = "SUBNODE_STATUS";
    public static final String NODE_START_TIME = "NODE_START_TIME";
    public static final String NODE_RUN_TIME = "NODE_RUN_TIME";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<BigDecimal, WorkflowJob> getJobs(Connection connection, int n) throws SQLException {
        HashMap<BigDecimal, WorkflowJob> hashMap = new HashMap<BigDecimal, WorkflowJob>();
        SQLHelper sQLHelper = new SQLHelper();
        String string = "SELECT \n  WORKFLOW_CHAIN_NAME,\n  WORKFLOW_NAME            ,\n  jobs.WORKFLOW_ID              ,\n  WORKFLOW_STATUS          ,\n  PROJECT_NAME             ,\n  PROJECT_ID               ,\n  WORKFLOW_JOB_NAME        ,\n  steps.NODE_ID               ,\n  steps.NODE_STATUS           ,\n  steps.NODE_START_TIME       ,\n  steps.NODE_RUN_TIME         ,\n  steps.subnode_id            ,\n  steps.subnode_status\nFROM \n  odmr_user_workflow_jobs jobs, odmr_user_workflow_all steps\nWHERE \n  jobs.workflow_job_name in (\n    select workflow_job_name from (\n      select t.*, row_number () over (partition by workflow_id order by job_creation_time desc, workflow_chain_name desc) rid from odmr_user_workflow_jobs t\n    ) where rid = 1\n  ) AND steps.wf_job_name (+) = jobs.workflow_job_name\n AND (jobs.JOB_CREATION_TIME > (SYSDATE - INTERVAL '" + n + "' HOUR)) " + "ORDER BY node_start_time desc\n";
        try {
            Connection connection2 = connection;
            synchronized (connection2) {
                if (connection.isClosed()) {
                    throw new RuntimeException("Connection was closed unexpectedly.");
                }
                sQLHelper.pstmt = connection.prepareStatement(string);
                sQLHelper.ors = (OracleResultSet)sQLHelper.pstmt.executeQuery();
                while (sQLHelper.ors.next()) {
                    WorkflowJobNode.SubNode subNode;
                    String string2;
                    HashMap<String, WorkflowJobNode> hashMap2;
                    WorkflowJobNode workflowJobNode;
                    BigDecimal bigDecimal = sQLHelper.ors.getBigDecimal(WORKFLOW_ID);
                    WorkflowJob workflowJob = (WorkflowJob)hashMap.get(bigDecimal);
                    if (workflowJob == null) {
                        workflowJob = new WorkflowJob();
                        workflowJob.setId(bigDecimal);
                        workflowJob.setWorkflowName(sQLHelper.ors.getString(WORKFLOW_NAME));
                        workflowJob.setChainName(sQLHelper.ors.getString(WORKFLOW_CHAIN_NAME));
                        workflowJob.setState(sQLHelper.ors.getString(WORKFLOW_STATUS));
                        workflowJob.setProjectName(sQLHelper.ors.getString(PROJECT_NAME));
                        workflowJob.setProjectId(sQLHelper.ors.getBigDecimal(PROJECT_ID));
                        workflowJob.setName(sQLHelper.ors.getString(WORKFLOW_JOB_NAME));
                        hashMap.put(bigDecimal, workflowJob);
                    }
                    if ((workflowJobNode = (hashMap2 = workflowJob.getNodes()).get(string2 = sQLHelper.ors.getString(NODE_ID))) == null) {
                        workflowJobNode = new WorkflowJobNode();
                        workflowJobNode.setId(sQLHelper.ors.getString(NODE_ID));
                        workflowJobNode.setState(sQLHelper.ors.getString(NODE_STATUS));
                        workflowJobNode.setStartTime(sQLHelper.ors.getTimestamp(NODE_START_TIME));
                        workflowJobNode.setRunTime(sQLHelper.ors.getINTERVALDS(NODE_RUN_TIME));
                        workflowJobNode.setWorkflowName(sQLHelper.ors.getString(WORKFLOW_NAME));
                        workflowJobNode.setWorkflowId(bigDecimal);
                        workflowJobNode.setProjectName(sQLHelper.ors.getString(PROJECT_NAME));
                        if (workflowJobNode.getState() != null) {
                            workflowJob.addNode(workflowJobNode);
                            if (workflowJobNode.getState().equals("FAILED") || workflowJobNode.getState().equals("STOPPED")) {
                                workflowJob.setHasFailedSteps(true);
                            }
                        }
                    }
                    if ((subNode = workflowJobNode.getSubNode(workflowJobNode.getId())) == null) {
                        String string3 = sQLHelper.ors.getString(SUBNODE_ID);
                        String string4 = sQLHelper.ors.getString(SUBNODE_STATUS);
                        if (string3 != null && string4 != null) {
                            workflowJobNode.addSubNode(string3, string4);
                        }
                    }
                    if (string2 == null || !string2.equals("WF_START")) continue;
                    workflowJob.setStartTime(sQLHelper.ors.getTimestamp(NODE_START_TIME));
                }
            }
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    public void setHasFailedSteps(boolean bl) {
        this._hasFailedSteps = bl;
    }

    public boolean getHasFailedSteps() {
        return this._hasFailedSteps;
    }

    public boolean equalsStateOf(WorkflowJob workflowJob) {
        boolean bl;
        boolean bl2 = workflowJob.getState() != null ? this.getState() == null : (bl = this.getState() != null);
        if (bl) {
            return false;
        }
        if (workflowJob.getState() != null && this.getState() != null && !this.getState().equals(workflowJob.getState())) {
            return false;
        }
        if (workflowJob.getChainName() != null && this.getChainName() != null && !workflowJob.getChainName().equals(this.getChainName())) {
            return false;
        }
        boolean bl3 = workflowJob.getStartTime() != null ? this.getStartTime() == null : (bl = this.getStartTime() != null);
        if (bl) {
            return false;
        }
        if (workflowJob.getStartTime() != null && this.getStartTime() != null && !this.getStartTime().equals(workflowJob.getStartTime())) {
            return false;
        }
        if (workflowJob.getHasFailedSteps() != this.getHasFailedSteps()) {
            return false;
        }
        return this.compareNodes(workflowJob.getNodes());
    }

    public boolean isJobFinished() {
        boolean bl = false;
        if (this.getState().equals("INACTIVE") || this.getState().equals("STOPPED") || this.getState().equals("FAILED")) {
            bl = true;
        }
        return bl;
    }

    public boolean isActive() {
        return this.getState().equals("ACTIVE");
    }

    private boolean compareNodes(Map<String, WorkflowJobNode> map) {
        boolean bl = true;
        HashMap<String, WorkflowJobNode> hashMap = this.getNodes();
        Iterator<Map.Entry<String, WorkflowJobNode>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            WorkflowJobNode workflowJobNode = iterator.next().getValue();
            WorkflowJobNode workflowJobNode2 = (WorkflowJobNode)hashMap.get(workflowJobNode.getId());
            if (workflowJobNode2 == null) {
                bl = false;
                break;
            }
            if (workflowJobNode2.getState().equals(workflowJobNode.getState())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void setId(BigDecimal bigDecimal) {
        this._id = bigDecimal;
    }

    public BigDecimal getWorkflowId() {
        return this._id;
    }

    public void setStartTime(Timestamp timestamp) {
        this._startTime = timestamp;
    }

    public Timestamp getStartTime() {
        return this._startTime;
    }

    public void setState(String string) {
        this._activityState = string;
    }

    public String getState() {
        return this._activityState;
    }

    public void addNode(WorkflowJobNode workflowJobNode) {
        this._nodes.put(workflowJobNode.getId(), workflowJobNode);
    }

    public HashMap<String, WorkflowJobNode> getNodes() {
        return this._nodes;
    }

    public void setWorkflowName(String string) {
        this._workflowName = string;
    }

    public String getWorkflowName() {
        return this._workflowName;
    }

    public void setProjectName(String string) {
        this._projectName = string;
    }

    public String getProjectName() {
        return this._projectName;
    }

    public void setChainName(String string) {
        this._chainName = string;
    }

    public String getChainName() {
        return this._chainName;
    }

    public void setName(String string) {
        this._jobName = string;
    }

    public String getName() {
        return this._jobName;
    }

    public void setProjectId(BigDecimal bigDecimal) {
        this._projectId = bigDecimal;
    }

    public BigDecimal getProjectId() {
        return this._projectId;
    }
}

