/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.generated.server.ODMRPkg_Project;
import oracle.dmt.dataminer.generated.server.OdmrImpactReports;
import oracle.dmt.dataminer.repository.LoadableRepositoryObject;
import oracle.dmt.dataminer.repository.StringUtils;

public final class Project
extends LoadableRepositoryObject {
    private Timestamp _creationTime;
    private Timestamp _lastUpdatedTime;
    public static final int NAME_MAX_LENGTH = 30;
    public static final int COMMENT_MAX_LENGTH = 4000;
    public static final String PROJECT_ID = "PROJECT_ID";
    public static final String DB_USER_ID = "DB_USER_ID";
    public static final String PROJECT_NAME = "PROJECT_NAME";
    public static final String CREATION_TIME = "CREATION_TIME";
    public static final String LAST_UPDATED_TIME = "LAST_UPDATED_TIME";
    public static final String COMMENTS = "COMMENTS";
    public static final String ODMR_USER_PROJECTS = "ODMR_USER_PROJECTS";

    public Project(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        super(string, bigDecimal, bigDecimal2);
    }

    @Override
    public void load(Connection connection) throws Exception {
        String string = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String[] stringArray = new String[]{PROJECT_NAME, CREATION_TIME, LAST_UPDATED_TIME, COMMENTS};
        stringArray = Project.delimit(stringArray, ODMR_USER_PROJECTS);
        String[] stringArray2 = new String[]{ODMR_USER_PROJECTS};
        String string2 = Project.delimit(PROJECT_ID, ODMR_USER_PROJECTS) + " = ?";
        string = Project.buildQuery(stringArray, stringArray2, string2);
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setBigDecimal(1, this._id);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                this._name = resultSet.getString(PROJECT_NAME);
                this._comment = resultSet.getString(COMMENTS);
                this._creationTime = resultSet.getTimestamp(CREATION_TIME);
                this._lastUpdatedTime = resultSet.getTimestamp(LAST_UPDATED_TIME);
            } else assert (false) : "Project not found.";
            this.setLoaded(true);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (null != resultSet) {
                try {
                    resultSet.close();
                    resultSet = null;
                }
                catch (Exception exception) {}
            }
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                    preparedStatement = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void unload() throws Exception {
        this._comment = null;
        this._creationTime = null;
        this._lastUpdatedTime = null;
        this.setLoaded(false);
    }

    @Override
    public void refresh(Connection connection) throws Exception {
        this.load(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal createProject(Connection connection, String string, String string2) throws SQLException {
        BigDecimal bigDecimal = null;
        ODMRPkg_Project oDMRPkg_Project = null;
        try {
            oDMRPkg_Project = new ODMRPkg_Project();
            oDMRPkg_Project.setConnection(connection);
            bigDecimal = oDMRPkg_Project.createProject(string, string2);
        }
        finally {
            if (oDMRPkg_Project != null) {
                try {
                    oDMRPkg_Project.release();
                }
                catch (Exception exception) {}
            }
        }
        return bigDecimal;
    }

    public static List<String> getProjectNames(Connection connection) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String[] stringArray = new String[]{PROJECT_NAME};
        stringArray = Project.delimit(stringArray, ODMR_USER_PROJECTS);
        String[] stringArray2 = new String[]{ODMR_USER_PROJECTS};
        string = Project.buildQuery(stringArray, stringArray2);
        try {
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(PROJECT_NAME);
                arrayList.add(string2);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (null != resultSet) {
                try {
                    resultSet.close();
                    resultSet = null;
                }
                catch (Exception exception) {}
            }
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                    preparedStatement = null;
                }
                catch (Exception exception) {}
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Project> getProjects(Connection connection) throws SQLException {
        ArrayList<Project> arrayList = new ArrayList<Project>();
        String string = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String[] stringArray = new String[]{PROJECT_NAME, PROJECT_ID, DB_USER_ID};
        stringArray = Project.delimit(stringArray, ODMR_USER_PROJECTS);
        String[] stringArray2 = new String[]{ODMR_USER_PROJECTS};
        string = Project.buildQuery(stringArray, stringArray2);
        try {
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(PROJECT_NAME);
                BigDecimal bigDecimal = resultSet.getBigDecimal(PROJECT_ID);
                BigDecimal bigDecimal2 = resultSet.getBigDecimal(DB_USER_ID);
                arrayList.add(new Project(string2, bigDecimal, bigDecimal2));
            }
        }
        finally {
            if (null != resultSet) {
                try {
                    resultSet.close();
                    resultSet = null;
                }
                catch (Exception exception) {}
            }
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                    preparedStatement = null;
                }
                catch (Exception exception) {}
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(Connection connection, String string) throws SQLException {
        ODMRPkg_Project oDMRPkg_Project = null;
        try {
            oDMRPkg_Project = new ODMRPkg_Project();
            oDMRPkg_Project.setConnection(connection);
            oDMRPkg_Project.renameProject(this.getId(), string);
        }
        finally {
            if (oDMRPkg_Project != null) {
                try {
                    oDMRPkg_Project.release();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComment(Connection connection, String string) throws SQLException {
        ODMRPkg_Project oDMRPkg_Project = null;
        try {
            oDMRPkg_Project = new ODMRPkg_Project();
            oDMRPkg_Project.setConnection(connection);
            oDMRPkg_Project.setProjectComment(this.getId(), string);
        }
        finally {
            if (oDMRPkg_Project != null) {
                try {
                    oDMRPkg_Project.release();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String createUniqueProjectName(Connection connection, String string) throws SQLException {
        List<String> list = Project.getProjectNames(connection);
        boolean bl = true;
        Integer n = 0;
        String string2 = null;
        assert (list != null) : "Unexpected null pointer for project list.";
        String string3 = "";
        string3 = string.length() > 28 ? string.substring(0, 28) : string;
        while (bl) {
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
            string2 = string3 + Integer.toString(n);
            if (list.contains(string2)) continue;
            bl = false;
        }
        return string2;
    }

    public static boolean validateProjectNameLength(String string) {
        return string.length() <= 30;
    }

    public static boolean validateProjectNameLengthAtDB(Connection connection, String string) {
        return StringUtils.checkStringDBLengthMax(string, connection, 30);
    }

    public static boolean validateProjectNameUnique(Connection connection, String string) throws SQLException {
        List<String> list = Project.getProjectNames(connection);
        assert (list != null) : "Unexpected null pointer for project list.";
        return !list.contains(string);
    }

    public static boolean validateCommentLength(String string) {
        return string.length() <= 4000;
    }

    public static boolean validateCommentLengthAtDB(Connection connection, String string) {
        return StringUtils.checkStringDBLengthMaxLong(string, connection, 4000);
    }

    private void loadedCheck() {
        assert (this.isLoaded()) : "Can not access state prior to object being loaded.";
    }

    public Timestamp getCreationTime() {
        this.loadedCheck();
        return this._creationTime;
    }

    public Timestamp getLastUpdatedTime() {
        this.loadedCheck();
        return this._lastUpdatedTime;
    }

    @Override
    public String getComment() {
        this.loadedCheck();
        return super.getComment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OdmrImpactReports delete(Connection connection, BigDecimal[] bigDecimalArray, boolean bl) throws Exception {
        ODMRPkg_Project oDMRPkg_Project = null;
        OdmrImpactReports odmrImpactReports = null;
        try {
            oDMRPkg_Project = new ODMRPkg_Project();
            oDMRPkg_Project.setConnection(connection);
            for (int i = 0; i < bigDecimalArray.length; ++i) {
                odmrImpactReports = oDMRPkg_Project.deleteProject(bigDecimalArray[i], bl ? "Y" : "N");
            }
        }
        finally {
            if (oDMRPkg_Project != null) {
                try {
                    oDMRPkg_Project.release();
                }
                catch (Exception exception) {}
            }
        }
        return odmrImpactReports;
    }
}

