/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.RepositoryLrb;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.teditor.data.ODMrDataTypesUtil;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.wizard.group.TableRow;
import oracle.ide.Context;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class DatabaseMetadataUtils {
    static final String NUMERICAL_MINING_TYPE = RepositoryLrb.get("MINING_ATTRIBUTE_TYPE_NUMERICAL");
    static final String CATEGORICAL_MINING_TYPE = RepositoryLrb.get("MINING_ATTRIBUTE_TYPE_CATEGORICAL");
    static final String TEXT_MINING_TYPE = RepositoryLrb.get("MINING_ATTRIBUTE_TYPE_TEXT");
    static final String NOT_APPLICABLE_MINING_TYPE = RepositoryLrb.get("NOT_APPLICABLE");
    private static String[] m_TableSpaceObjectTypes = new String[]{"SYNONYM", "TABLE", "VIEW", "SEQUENCE", "PROCEDURE", "PACKAGE", "PACKAGE_BODY", "PROGRAM", "TYPE BODY", "TYPE", "FUNCTION", "JOB", "UNDEFINED", "INDEX PARTITION", "TABLE PARTITION", "MATERIALIZE VIEW"};
    private static String COLUMN_NAME = "COLUMN_NAME";
    private static String DATA_TYPE = "DATA_TYPE";
    private static String CONSTRAINT_TYPE = "CONSTRAINT_TYPE";
    private static String COMMENTS = "COMMENTS";
    private static String INDEX_NAME = "INDEX_NAME";
    public static final String TEMP_TABLE_PREFIX = "ODMR$TMP";
    public static final String HIDDEN_TABLE_PREFIX = "ODMR$";
    static final int RANDOM_RANGE = 999999999;
    static final int INDEX_RANDOM_RANGE = 999999;
    public static final String EXCLUDE_SCHEMAS = "'SELECT_CATALOG_ROLE', 'PUBLIC', 'SYS', 'MDSYS', 'ODMRSYS', 'MDSYS', 'TSMSYS', 'CTXSYS', 'OLAPSYS', 'EXFSYS', 'SYSTEM', 'DBSNMP', 'SYSMAN', 'IX', 'XDB', 'WMSYS', 'ORDSYS'";
    public static final String ESCAPE_STRING = " ESCAPE '@' ";
    public static final String EXCLUDE_TABLES_STRING = "TABLE_NAME NOT LIKE 'BIN$%'AND TABLE_NAME NOT LIKE 'DM$%'AND TABLE_NAME NOT LIKE 'DM4J$%'AND TABLE_NAME NOT LIKE 'DR$%'AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@' ";
    public static final String EXCLUDE_VIEWS_STRING = "VIEW_NAME NOT LIKE 'DM$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'DR$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND VIEW_NAME NOT LIKE 'DM4J$%'  ESCAPE '@' ";
    private static final String GET_TABLE_COLUMNS_CONSTRAINTS = "SELECT c.COLUMN_NAME, c.DATA_TYPE, con.CONSTRAINT_TYPE FROM all_tab_columns c, (SELECT cn.OWNER, cn.TABLE_NAME, cn.COLUMN_NAME, cd.CONSTRAINT_TYPE FROM all_cons_columns cn, all_constraints cd WHERE cn.OWNER = cd.OWNER AND cn.TABLE_NAME = cd.TABLE_NAME AND cn.CONSTRAINT_NAME = cd.CONSTRAINT_NAME AND 'P' = cd.CONSTRAINT_TYPE AND 'ENABLED' = cd.STATUS) con WHERE  c.OWNER = ? AND c.TABLE_NAME = ? AND c.OWNER = con.OWNER(+) AND c.TABLE_NAME = con.TABLE_NAME(+) AND c.COLUMN_NAME = con.COLUMN_NAME(+) ORDER BY column_name ASC";
    private static final String GET_TABLE_COLUMNS = "SELECT c.COLUMN_NAME,\n  c.DATA_TYPE\nFROM all_tab_columns c\nWHERE c.OWNER     = ? \nAND c.TABLE_NAME  = ? \nORDER BY column_name ASC";
    public static final String ATTRIBUTE_TYPE_CATEGORICAL = "Categorical";
    public static final String ATTRIBUTE_TYPE_NUMERICAL = "Numerical";
    public static final String ATTRIBUTE_TYPE_TEXT = "Text";
    public static final String ATTRIBUTE_TYPE_NESTED_NUMERICALS = "Numerical";
    public static final String ATTRIBUTE_TYPE_NESTED_CATEGORICALS = "Categorical";
    public static final String ATTRIBUTE_TYPE_ODMR_HISTOGRAMS = "Categorical";
    public static final String ATTRIBUTE_TYPE_NOT_APPLICABLE = "NotApplicable";
    public static final String ORACLE_VARCHAR2 = "VARCHAR2";
    public static final String ORACLE_CHAR = "CHAR";
    public static final String ORACLE_NVARCHAR2 = "NVARCHAR2";
    public static final String ORACLE_NCHAR = "NCHAR";
    public static final String ORACLE_FLOAT = "FLOAT";
    public static final String ORACLE_NUMBER = "NUMBER";
    public static final String ORACLE_BINARY_DOUBLE = "BINARY_DOUBLE";
    public static final String ORACLE_BINARY_FLOAT = "BINARY_FLOAT";
    public static final String ORACLE_DATE = "DATE";
    public static final String ORACLE_BFILE = "BFILE";
    public static final String ORACLE_XMLTYPE = "XMLTYPE";
    public static final String ORACLE_URITYPE = "URITYPE";
    public static final String ORACLE_BLOB = "BLOB";
    public static final String ORACLE_CLOB = "CLOB";
    public static final String ORACLE_NCLOB = "NCLOB";
    public static final String ORACLE_LONG = "LONG";
    public static final String ORACLE_RAW = "RAW";
    public static final String ORACLE_LONG_RAW = "LONG RAW";
    public static final String ORACLE_NESTED_NUMERICALS = "DM_NESTED_NUMERICALS";
    public static final String ORACLE_NESTED_CATEGORICALS = "DM_NESTED_CATEGORICALS";
    public static final String ORACLE_NESTED_BINARY_DOUBLES = "DM_NESTED_BINARY_DOUBLES";
    public static final String ORACLE_NESTED_BINARY_FLOATS = "DM_NESTED_BINARY_FLOATS";
    public static final String ODMR_HISTOGRAMS = "ODMR_HISTOGRAMS";
    public static final String ORACLE_NESTED_TABLE = "NESTED TABLE";
    public static final String ORACLE_NUMBER_TX = "DM_NESTED_NUMERICALS";
    public static final String ORACLE_VARCHAR2_TX = "DM_NESTED_CATEGORICALS";
    public static final String ORACLE_TIMESTAMP = "TIMESTAMP";
    public static final String ORACLE_TIMSTAMP_WITH_TIME_ZONE = "TIMESTAMP WITH TIME ZONE";
    public static final String ORACLE_TIMSTAMP_WITH_LOCAL_TIME_ZONE = "TIMESTAMP WITH LOCAL TIME ZONE";
    private static final String _WITH_TIMEZONE = "WITH TIME ZONE";
    private static final String _WITH_LOCAL_TIMEZONE = "WITH LOCAL TIME ZONE";
    private static final String[] _INTERVAL_YEAR_TO_MONTH = new String[]{"INTERVAL YEAR", "TO MONTH"};
    private static final String[] _INTERVAL_DAY_TO_SECOND = new String[]{"INTERVAL DAY", "TO SECOND"};
    private static final String[] ORACLE_DATA_TYPES_SUPPORTED = new String[]{"VARCHAR2", "CHAR", "NVARCHAR2", "NCHAR", "FLOAT", "NUMBER", "BINARY_DOUBLE", "BINARY_FLOAT", "DATE", "CLOB", "NCLOB", "DM_NESTED_NUMERICALS", "DM_NESTED_CATEGORICALS", "TIMESTAMP", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH LOCAL TIME ZONE", "DM_NESTED_BINARY_DOUBLES", "DM_NESTED_BINARY_FLOATS", "XMLTYPE"};
    private static final String[] ORACLE_COMPATIBLE_CHARACTER_TYPES = new String[]{"VARCHAR2", "CHAR", "NVARCHAR2", "NCHAR", "CLOB", "NCLOB"};
    private static final String[] ORACLE_COMPATIBLE_TIMESTAMP_TYPES = new String[]{"TIMESTAMP", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH LOCAL TIME ZONE"};
    private static final String[] ORACLE_COMPATIBLE_NUMBER_TYPES = new String[]{"NUMBER", "BINARY_DOUBLE", "BINARY_FLOAT", "FLOAT"};
    private static final String[] ORACLE_NESTED_TYPES_SUPPORTED = new String[]{"DM_NESTED_NUMERICALS", "DM_NESTED_CATEGORICALS"};
    private static final String[] ORACLE_NESTED_TYPES_SUPPORTED_12 = new String[]{"DM_NESTED_NUMERICALS", "DM_NESTED_CATEGORICALS", "DM_NESTED_BINARY_DOUBLES", "DM_NESTED_BINARY_FLOATS"};
    private static final String[] ORACLE_NUMERIC_DATA_TYPES_SUPPORTED = new String[]{"FLOAT", "NUMBER"};
    private static final String[] ORACLE_NUMERIC_DATA_TYPES_SUPPORTED_12 = new String[]{"FLOAT", "NUMBER", "BINARY_DOUBLE", "BINARY_FLOAT"};
    private static final String[] ORACLE_CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED = new String[]{"VARCHAR2", "NUMBER", "FLOAT", "CHAR"};
    private static final String[] ORACLE_CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED_12 = new String[]{"VARCHAR2", "NUMBER", "FLOAT", "CHAR", "BINARY_DOUBLE", "BINARY_FLOAT"};
    private static final String[] ORACLE_NUMERICAL_TARGETS_DATA_TYPES_SUPPORTED = new String[]{"FLOAT", "NUMBER"};
    private static final String[] ORACLE_NUMERICAL_TARGETS_DATA_TYPES_SUPPORTED_12 = new String[]{"FLOAT", "NUMBER", "BINARY_DOUBLE", "BINARY_FLOAT"};
    private static final String[] ORACLE_KEY_DATA_TYPES_SUPPORTED = new String[]{"VARCHAR2", "CHAR", "NVARCHAR2", "NCHAR", "FLOAT", "NUMBER", "BINARY_DOUBLE", "BINARY_FLOAT", "NVARCHAR2", "NCHAR", "DATE", "TIMESTAMP", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH LOCAL TIME ZONE"};
    private static final String[] ORACLE_CASE_DATA_TYPES_SUPPORTED = new String[]{"VARCHAR2", "CHAR", "FLOAT", "NUMBER"};
    private static final String[] ORACLE_CASE_DATA_TYPES_SUPPORTED_12 = new String[]{"VARCHAR2", "CHAR", "FLOAT", "NUMBER", "BINARY_DOUBLE", "BINARY_FLOAT"};
    private static final String[] ORACLE_INDEX_NOT_SUPPORTED = new String[]{"XMLTYPE", "CLOB", "BLOB", "NCLOB", "DM_NESTED_NUMERICALS", "DM_NESTED_CATEGORICALS"};
    static Random randNumberGen = new Random();
    private static String _COLUMN_TYPE = "select COLUMN_NAME, DATA_TYPE from all_tab_columns where OWNER=? AND TABLE_NAME=? AND COLUMN_NAME = ? ";
    private static String _COLUMN_NAME_TYPES = "select COLUMN_NAME, DATA_TYPE from all_tab_columns where OWNER=? AND TABLE_NAME=?";
    private static String COLUMNS_WITH_CONSTRAINTS = "SELECT cols.COLUMN_NAME FROM all_constraints cons, all_cons_columns cols WHERE cols.owner = {2}{0}{2} AND cols.table_name = {2}{1}{2} AND cons.constraint_type IN ( {2}P{2}, {2}R{2}, {2}U{2}, {2}C{2} ) AND cons.constraint_name = cols.constraint_name AND cons.owner = cols.owner ORDER BY cols.table_name, cols.position";
    private static String NOT_NULL = "SELECT column_name FROM all_tab_columns where OWNER = {2}{0}{2} AND TABLE_NAME = {2}{1}{2} AND NULLABLE = {2}N{2}";
    private static String DBMS_SQL_PARSE_TYPE = "DECLARE   curid      INTEGER;\n  colcnt     NUMBER;\n  desctab    dbms_sql.desc_tab3;\n  r_value    INTEGER;\n  ret_value  VARCHAR2(200);\nBEGIN\n  curid := DBMS_SQL.OPEN_CURSOR;\n  DBMS_SQL.PARSE(curid, '[SQL_EXPRESSION]', DBMS_SQL.NATIVE);\n  dbms_sql.describe_columns3(curid, colcnt, desctab);\n       FOR i IN 1 .. colcnt LOOP\n         if (desctab(i).col_type = 1) then\n           ret_value := 'VARCHAR2';\n         elsif (desctab(i).col_type = 2) then\n           ret_value := 'NUMBER';\n         ELSIF (desctab(i).col_type = 100) THEN -- BINARY_FLOAT\n           ret_value := 'NUMBER';\n         ELSIF (desctab(i).col_type = 101) THEN -- BINARY_DOUBLE\n           ret_value := 'NUMBER';\n         elsif (desctab(i).col_type = 11) then\n           ret_value := 'ROWID';\n         elsif (desctab(i).col_type = 12) then\n           ret_value := 'DATE';\n         elsif (desctab(i).col_type = 23) then\n           ret_value := 'RAW';\n         elsif (desctab(i).col_type = 180) then\n           ret_value := 'TIMESTAMP';\n         elsif (desctab(i).col_type = 181) then \n           ret_value := 'TIMESTAMP WITH TIME ZONE';\n         elsif (desctab(i).col_type = 231) then\n           ret_value := 'TIMESTAMP WITH LOCAL TIME ZONE';\n         elsif (desctab(i).col_type = 182) then \n           ret_value := 'INTERVAL YEAR() TO MONTH';\n         elsif (desctab(i).col_type = 183) then\n           ret_value := 'INTERVAL DAY() TO SECOND()';\n         elsif (desctab(i).col_type = 96) then\n           ret_value := 'CHAR';\n         elsif (desctab(i).col_type = 8) then\n           ret_value := 'LONG';\n         elsif (desctab(i).col_type = 112) then\n           ret_value := 'CLOB';\n         elsif (desctab(i).col_type = 113) then\n           ret_value := 'BLOB';\n         elsif (desctab(i).col_type = 114) then \n           ret_value := 'BFILE';\n         elsif (desctab(i).col_type = 208) then \n           ret_value := 'UROWID';\n         elsif (desctab(i).col_type = 109) then\n           ret_value := 'CUSTOM';\n         END IF;\n       end loop;\n  r_value := DBMS_SQL.EXECUTE(curid);\n  r_value := DBMS_SQL.FETCH_ROWS(curid);\n  dbms_sql.close_cursor(curid);\n  ? := ret_value;\n  EXCEPTION WHEN OTHERS THEN\n    DBMS_SQL.CLOSE_CURSOR(curid);\n    ret_value := NULL;    RAISE;  \nEND;\n";
    private static String DBMS_SQL_PARSE_LEGACY_APPLY_TYPE = "DECLARE   intval INTEGER := 0;\n  strval VARCHAR2(256);\n  partyp BINARY_INTEGER;\nBEGIN\n  BEGIN\n    partyp := dbms_utility.get_parameter_value('_dm_enable_legacy_dmf_output_types', intval, strval);\n  EXCEPTION WHEN OTHERS THEN\n    NULL;\n  END;\n  ? := intval;\nEND;\n";

    public static String getReplacedString(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.length() > 0) {
            while ((n2 = string.indexOf(string2, n)) >= 0) {
                stringBuffer.append(string.substring(n, n2));
                stringBuffer.append(string3);
                n = n2 + string2.length();
            }
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dropTableOrView(Connection connection, String string, String string2, boolean bl) throws SQLException, Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string3 = null;
            String string4 = "";
            string4 = string == null ? StringUtils.trimDoubleQuotes(string2) : StringUtils.trimDoubleQuotes(string) + "\"." + "\"" + StringUtils.trimDoubleQuotes(string2);
            string3 = bl ? "DROP TABLE \"" + string4 + "\" PURGE" : "DROP VIEW \"" + string4 + "\"";
            statement = connection.prepareStatement(string3);
            resultSet = statement.executeQuery();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTableAs(Connection connection, String string, String string2, String string3, String string4) throws SQLException {
        String string5 = null;
        Object var6_6 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        string5 = "create table \"{0}\".\"{1}\" as select * from \"{2}\".\"{3}\" ";
        Object[] objectArray = new Object[]{StringUtils.trimDoubleQuotes(string3), StringUtils.trimDoubleQuotes(string4), StringUtils.trimDoubleQuotes(string), StringUtils.trimDoubleQuotes(string2)};
        string5 = MessageFormat.format(string5, objectArray);
        try {
            preparedStatement = connection.prepareStatement(string5);
            preparedStatement.execute();
        }
        finally {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
                preparedStatement = null;
            }
            catch (Exception exception) {}
        }
    }

    public static String getCreateTableAsSQL(String string, String string2, String[] stringArray, String string3, String string4) throws Exception {
        CharSequence charSequence;
        String string5 = null;
        string5 = " execute immediate 'create table \"<outputSchemaName>\".\"<outputTableName>\" as select <selectedColumns> from \"<inputSchemaName>\".\"<inputTableName>\"'; \n";
        if (stringArray == null) {
            string5 = StringUtils.getReplacedString(string5, "<selectedColumns>", "*");
        } else {
            charSequence = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                charSequence = ((StringBuffer)charSequence).append("\"" + DatabaseMetadataUtils.getReplacedString(stringArray[i], "'", "''") + "\"");
                if (i == stringArray.length - 1) continue;
                charSequence = ((StringBuffer)charSequence).append(",");
            }
            string5 = StringUtils.getReplacedString(string5, "<selectedColumns>", ((StringBuffer)charSequence).toString());
        }
        StringUtils.trimDoubleQuotes(string3);
        StringUtils.trimDoubleQuotes(string4);
        StringUtils.trimDoubleQuotes(string);
        StringUtils.trimDoubleQuotes(string2);
        charSequence = DatabaseMetadataUtils.getReplacedString(string2, "'", "''");
        string5 = StringUtils.getReplacedString(string5, "<outputSchemaName>", string3);
        string5 = StringUtils.getReplacedString(string5, "<outputTableName>", string4);
        string5 = StringUtils.getReplacedString(string5, "<inputSchemaName>", string);
        string5 = StringUtils.getReplacedString(string5, "<inputTableName>", (String)charSequence);
        return string5;
    }

    public static String getCreateTableAsSQL(String string, String string2, String string3, String string4) throws Exception {
        return DatabaseMetadataUtils.getCreateTableAsSQL(string, string2, null, string3, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createViewAs(Connection connection, String string, String string2, String string3) throws SQLException {
        String string4 = null;
        PreparedStatement preparedStatement = null;
        string4 = "create view \"{0}\".\"{1}\" as ";
        Object[] objectArray = new Object[]{StringUtils.trimDoubleQuotes(string2), StringUtils.trimDoubleQuotes(string3)};
        string4 = MessageFormat.format(string4, objectArray);
        string4 = string4 + string;
        try {
            preparedStatement = connection.prepareStatement(string4);
            preparedStatement.execute();
        }
        finally {
            try {
                preparedStatement.close();
                preparedStatement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createIndex(Connection connection, String string, String string2, String string3) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string4 = "CREATE INDEX \"" + StringUtils.trimDoubleQuotes(string) + "\".BPRESS_CTX1 ON \"" + StringUtils.trimDoubleQuotes(string) + "\".\"" + StringUtils.trimDoubleQuotes(string2) + "\" " + "(\"" + string3 + "\") INDEXTYPE IS CTXSYS.CONTEXT PARAMETERS('nopopulate')";
        try {
            preparedStatement = connection.prepareStatement(string4);
            preparedStatement.execute();
        }
        finally {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                preparedStatement.close();
                preparedStatement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createContextIndex(Connection connection, String string, String string2, String string3, String string4, String string5) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string6 = "CREATE INDEX \"" + StringUtils.trimDoubleQuotes(string2) + "\".\"" + string.toUpperCase() + "\" ON \"" + StringUtils.trimDoubleQuotes(string2) + "\".\"" + StringUtils.trimDoubleQuotes(string3) + "\" " + "(\"" + string4 + "\") INDEXTYPE IS CTXSYS.CONTEXT PARAMETERS('<settings>')";
        string6 = StringUtils.getReplacedString(string6, "<settings>", string5);
        try {
            preparedStatement = connection.prepareStatement(string6);
            preparedStatement.execute();
        }
        finally {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                preparedStatement.close();
                preparedStatement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static String getCreateContextIndexSQL(String string, String string2, String string3, String string4, String string5) throws Exception {
        String string6 = " execute immediate 'CREATE INDEX \"" + StringUtils.trimDoubleQuotes(string2) + "\".\"" + string.toUpperCase() + "\" ON \"" + StringUtils.trimDoubleQuotes(string2) + "\".\"" + StringUtils.trimDoubleQuotes(string3) + "\" " + "(\"" + string4 + "\") INDEXTYPE IS CTXSYS.CONTEXT PARAMETERS(''<settings>'')'; \n";
        string6 = StringUtils.getReplacedString(string6, "<settings>", string5);
        return string6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropContextIndex(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = "DROP INDEX \"" + StringUtils.trimDoubleQuotes(string) + "\"." + string2.toUpperCase();
        try {
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.execute();
        }
        finally {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                preparedStatement.close();
                preparedStatement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static String getDropContextIndexSQL(String string, String string2) throws Exception {
        String string3 = " execute immediate 'DROP INDEX \"" + StringUtils.trimDoubleQuotes(string) + "\".\"" + string2.toUpperCase() + "\"'; \n";
        return string3;
    }

    public static void dropTable(Connection connection, String string, String string2) throws SQLException, Exception {
        DatabaseMetadataUtils.dropTableOrView(connection, string, string2, true);
    }

    public static void dropView(Connection connection, String string, String string2) throws SQLException, Exception {
        DatabaseMetadataUtils.dropTableOrView(connection, string, string2, false);
    }

    public static Vector getAccessibleSchemas(Connection connection) throws SQLException {
        Vector vector = new Vector();
        return vector;
    }

    public static Vector getAccessableTablesAndViewsOLD(Connection connection, String string) throws SQLException {
        Vector vector = new Vector(1000, 500);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<ArrayList> getDependentTables(Connection connection, String string, String string2) throws SQLException {
        Vector<ArrayList> vector = new Vector<ArrayList>();
        ArrayList<String> arrayList = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        string3 = "select REFERENCED_NAME, REFERENCED_OWNER, REFERENCED_TYPE from ALL_DEPENDENCIES where (OWNER = ? and NAME = ?) and REFERENCED_TYPE in('TABLE','VIEW')";
        try {
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                int n = 0;
                arrayList = new ArrayList<String>(3);
                string4 = resultSet.getString("REFERENCED_NAME");
                arrayList.add(n++, string4);
                string5 = resultSet.getString("REFERENCED_OWNER");
                arrayList.add(n++, string5);
                string6 = resultSet.getString("REFERENCED_TYPE");
                arrayList.add(n++, string6);
                vector.add(arrayList);
            }
        }
        finally {
            if (null != resultSet) {
                try {
                    resultSet.close();
                    resultSet = null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                    preparedStatement = null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<TableRow> getRelatedTables(Connection connection, Vector<TableRow> vector, Vector<TableRow> vector2) throws SQLException {
        assert (connection != null) : "Connection is null for getRelatedTables query";
        assert (vector != null) : "Related To Table List is Null.";
        Vector<TableRow> vector3 = new Vector<TableRow>();
        TableRow tableRow = null;
        String string = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Iterator<TableRow> iterator = vector.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        TableRow tableRow2 = null;
        while (iterator.hasNext()) {
            tableRow2 = iterator.next();
            stringBuffer.append("'" + tableRow2.getMungedSchemaTableName() + "'");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
        if (vector2 != null && (iterator = vector2.iterator()).hasNext()) {
            stringBuffer2.append(",");
            while (iterator.hasNext()) {
                tableRow2 = iterator.next();
                stringBuffer2.append("'" + tableRow2.getMungedSchemaTableName() + "'");
                if (!iterator.hasNext()) continue;
                stringBuffer2.append(",");
            }
        }
        string = "with FOREIGN_KEY_REFS_TO as ( SELECT\n        fk.owner fk_owner, fk.table_name fk_table_name, fk.constraint_name fk_constraint_name, fk.constraint_type fk_constraint_type,\n        fk.r_owner fk_r_owner, fk.r_constraint_name fk_r_constraint_name, look.table_name fk_r_table_name\n        FROM all_constraints fk,\n        all_constraints look\n      WHERE\n        (fk.r_owner not in ('SELECT_CATALOG_ROLE', 'PUBLIC', 'SYS', 'MDSYS', 'ODMRSYS', 'MDSYS', 'TSMSYS', 'CTXSYS', 'OLAPSYS', 'EXFSYS', 'SYSTEM', 'DBSNMP', 'SYSMAN', 'IX', 'XDB', 'WMSYS', 'ORDSYS')) AND\n        (look.owner not in ('SELECT_CATALOG_ROLE', 'PUBLIC', 'SYS', 'MDSYS', 'ODMRSYS', 'MDSYS', 'TSMSYS', 'CTXSYS', 'OLAPSYS', 'EXFSYS', 'SYSTEM', 'DBSNMP', 'SYSMAN', 'IX', 'XDB', 'WMSYS', 'ORDSYS')) AND\n        (fk.owner || fk.table_name not in (" + stringBuffer + ")) AND\n" + "        ((fk.r_owner || fk.r_constraint_name) = (look.owner || look.constraint_name)) AND\n" + "        ( look.owner || look.table_name in (" + stringBuffer + ")) \n" + "      AND  (fk.constraint_type='R')),\n" + " FOREIGN_KEY_REFS_FROM as ( SELECT\n" + "        fk.owner fk_owner, fk.table_name fk_table_name, fk.constraint_name fk_constraint_name, fk.constraint_type fk_constraint_type,\n" + "        fk.r_owner fk_r_owner, fk.r_constraint_name fk_r_constraint_name, look.table_name fk_r_table_name\n" + "        FROM all_constraints fk,\n" + "        all_constraints look\n" + "      WHERE\n" + "        (fk.r_owner not in (" + EXCLUDE_SCHEMAS + ")) AND\n" + "        (look.owner not in (" + EXCLUDE_SCHEMAS + ")) AND\n" + "        (fk.owner || fk.table_name in (" + stringBuffer + ")) AND\n" + "        ((fk.r_owner || fk.r_constraint_name) = (look.owner || look.constraint_name)) AND\n" + "        ( look.owner || look.table_name not in (" + stringBuffer + ")) \n" + "      AND  (fk.constraint_type='R')),\n" + " ALL_REFS as (select * \n" + "    FROM FOREIGN_KEY_REFS_TO\n" + "    UNION\n" + "    select *\n" + "    FROM FOREIGN_KEY_REFS_FROM)\n" + "select *\n" + "from (select case when (fk_owner || fk_table_name in (" + stringBuffer + ")) then fk_r_owner\n" + "            when (fk_r_owner || fk_r_table_name in (" + stringBuffer + ")) then fk_owner\n" + "            else 'ERROR'\n" + "            end \"RELATED_SCHEMA_NAME\",\n" + "        case when (fk_owner || fk_table_name in (" + stringBuffer + ")) then fk_r_table_name\n" + "            when (fk_r_owner || fk_r_table_name in (" + stringBuffer + ")) then fk_table_name\n" + "            else 'ERROR'\n" + "            end \"RELATED_TABLE_NAME\"\n" + "from ALL_REFS) PRE_FILTERED_LIST\n" + "where \"RELATED_SCHEMA_NAME\" || \"RELATED_TABLE_NAME\" not in (" + stringBuffer2 + ")";
        try {
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                tableRow = new TableRow(resultSet.getString("RELATED_SCHEMA_NAME"), resultSet.getString("RELATED_TABLE_NAME"), TableRow.TYPE_TABLE);
                vector3.add(tableRow);
            }
        }
        finally {
            if (null != resultSet) {
                try {
                    resultSet.close();
                    resultSet = null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                    preparedStatement = null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return vector3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getViewText(Connection connection, String string, String string2) throws SQLException {
        String string3 = null;
        String string4 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        string3 = "select TEXT from ALL_VIEWS where OWNER = ? and VIEW_NAME = ?";
        try {
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string4 = resultSet.getString("TEXT");
            }
        }
        finally {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                preparedStatement.close();
                preparedStatement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string4;
    }

    public static Vector<String> getContextSettingsNames(Connection connection, String string, String string2) throws SQLException {
        Vector<String> vector = new Vector<String>(1000, 500);
        String string3 = null;
        string3 = "select PRE_NAME from CTX_PREFERENCES where PRE_CLASS = '" + string2.toUpperCase() + "' " + "AND PRE_OWNER = '" + string + "' " + "order by PRE_NAME ";
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        preparedStatement.setFetchSize(1000);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(resultSet.getString("PRE_NAME"));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector;
    }

    public static Vector<String> getContextSettingsStoplistNames(Connection connection, String string) throws SQLException {
        Vector<String> vector = new Vector<String>(1000, 500);
        String string2 = null;
        string2 = "select SPL_NAME as PRE_NAME from CTX_STOPLISTS where SPL_OWNER = '" + string + "' " + " order by SPL_NAME ";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setFetchSize(1000);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(resultSet.getString("PRE_NAME"));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector;
    }

    public static Vector<String> getContextSettingsSectionNames(Connection connection, String string) throws SQLException {
        Vector<String> vector = new Vector<String>(1000, 500);
        String string2 = null;
        string2 = "select SGP_NAME as PRE_NAME from CTX_SECTION_GROUPS where SGP_OWNER = '" + string + "' " + " order by SGP_NAME ";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setFetchSize(1000);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(resultSet.getString("PRE_NAME"));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> getUserTablesAndViews(Connection connection) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        string = "select TABLE_NAME from USER_TABLES union select VIEW_NAME as TABLE_NAME from USER_VIEWS ";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.pstmt.setFetchSize(5000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                arrayList.add(sQLHelper.rs.getString("TABLE_NAME"));
            }
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }

    public static Vector getAccessableTablesFolder(Connection connection, String string) throws Exception {
        Vector vector = new Vector(1000, 500);
        return vector;
    }

    public static Vector getAccessableViewsFolder(Connection connection, String string) throws Exception {
        Vector vector = new Vector(1000, 500);
        return vector;
    }

    public static Vector getAccessableTables(Connection connection, String string) throws SQLException {
        Vector vector = new Vector(1000, 500);
        return vector;
    }

    public static Vector getAccessableViews(Connection connection, String string) throws SQLException {
        Vector vector = new Vector(1000, 500);
        return vector;
    }

    public static Vector getPrimaryObjectNamespaceVector(Connection connection) throws SQLException {
        return DatabaseMetadataUtils.getNamespaceVector(connection, m_TableSpaceObjectTypes);
    }

    public static HashMap getPrimaryObjectNamespaceHashMap(Connection connection) throws SQLException {
        return DatabaseMetadataUtils.getNamespaceHashMap(connection, m_TableSpaceObjectTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getUserConstraintNamespaceHashMap(Connection connection) throws SQLException {
        HashMap<String, String> hashMap = new HashMap<String, String>(1000);
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("select CONSTRAINT_NAME from USER_CONSTRAINTS ");
        stringBuffer.append("order by CONSTRAINT_NAME");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            preparedStatement.setFetchSize(1000);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashMap.put(resultSet.getString(1), resultSet.getString(1));
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashMap;
    }

    public static String[] getPrimaryObjectNamespace(Connection connection) throws SQLException {
        return DatabaseMetadataUtils.getNamespace(connection, m_TableSpaceObjectTypes);
    }

    private static String addObjectTypes(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("'" + stringArray[i] + "',");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getNamespaceHashMap(Connection connection, String[] stringArray) throws SQLException {
        HashMap<String, String> hashMap = new HashMap<String, String>(1000);
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("select OBJECT_NAME from USER_OBJECTS ");
        stringBuffer.append("where OBJECT_TYPE in (" + DatabaseMetadataUtils.addObjectTypes(stringArray) + ")");
        stringBuffer.append("order by OBJECT_NAME");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            preparedStatement.setFetchSize(1000);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashMap.put(resultSet.getString(1), resultSet.getString(1));
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getNamespaceVector(Connection connection, String[] stringArray) throws SQLException {
        Vector<String> vector = new Vector<String>(1000, 1000);
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("select OBJECT_NAME from USER_OBJECTS ");
        stringBuffer.append("where OBJECT_TYPE in (" + DatabaseMetadataUtils.addObjectTypes(stringArray) + ")");
        stringBuffer.append("order by OBJECT_NAME");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            preparedStatement.setFetchSize(1000);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(resultSet.getString(1));
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getNamespace(Connection connection, String[] stringArray) throws SQLException {
        String[] stringArray2;
        Vector<String> vector = new Vector<String>(1000, 1000);
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("select OBJECT_NAME from USER_OBJECTS ");
        stringBuffer.append("where OBJECT_TYPE in (" + DatabaseMetadataUtils.addObjectTypes(stringArray) + ")");
        stringBuffer.append("order by OBJECT_NAME");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            preparedStatement.setFetchSize(1000);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(resultSet.getString(1));
            }
            stringArray2 = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray2[i] = (String)vector.get(i);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUniqueInNamespace(Connection connection, String[] stringArray, String string) throws SQLException {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("select OBJECT_NAME from USER_OBJECTS ");
        stringBuffer.append("where OBJECT_TYPE in (" + DatabaseMetadataUtils.addObjectTypes(stringArray) + ")");
        stringBuffer.append("and OBJECT_NAME = '" + string + "'");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
        }
        catch (Exception exception) {
            string2 = null;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string2 == null;
    }

    public static String[] getTablesReturnStrings(Connection connection, String string, boolean bl) throws SQLException {
        Vector vector = DatabaseMetadataUtils.getAccessableTablesAndViewsOLD(connection, string);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    public static String getTableComment(Connection connection, String string, String string2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("select COMMENTS  from ALL_TAB_COMMENTS  where OWNER =  ? AND TABLE_NAME = ?");
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string3 = "";
        while (resultSet.next()) {
            string3 = resultSet.getString(COMMENTS);
            if (!resultSet.wasNull()) continue;
            string3 = "";
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRowCount(Connection connection, String string) {
        String string2 = "SELECT count (*) from " + StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(string));
        Statement statement = null;
        ResultSet resultSet = null;
        int n = -1;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = -1;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRowCountFromQuery(Connection connection, String string) throws Exception {
        String string2 = "SELECT count (*) " + string;
        Statement statement = null;
        ResultSet resultSet = null;
        int n = -1;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    public static String getIndexName(Connection connection, String string, String string2, String string3) throws Exception {
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer("select INDEX_NAME  from all_ind_columns  where TABLE_NAME = ?  AND TABLE_OWNER = ?  AND COLUMN_NAME = ?");
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string3);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            string4 = resultSet.getString(INDEX_NAME);
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return string4;
    }

    public static String getContextIndexName(Connection connection, String string, String string2, String string3) throws Exception {
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer("select a.INDEX_NAME  from all_ind_columns a, all_indexes b  where a.TABLE_NAME = ?  AND a.TABLE_OWNER = ?  AND a.COLUMN_NAME = ?  AND a.INDEX_NAME = b.INDEX_NAME  AND b.ITYP_NAME = 'CONTEXT' ");
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string3);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            string4 = resultSet.getString(INDEX_NAME);
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return string4;
    }

    public static void createFeatureTable(Connection connection, String string, String string2, String string3, String string4, String string5) throws Exception {
        String string6 = " BEGIN   ctx_ddl.create_preference('<preferenceTableName>','SVM_CLASSIFIER');  execute immediate 'create table <tempTableName> (id number, cid number)';  execute immediate 'select * from table(drvodm.feature_prep(''<indexName>'',''<caseID>'',''<tempTableName>'',''id'',''cid'',''<featureTableName>'',''<preferenceTableName>''))';  END; ";
        string6 = StringUtils.getReplacedString(string6, "<preferenceTableName>", string);
        string6 = StringUtils.getReplacedString(string6, "<tempTableName>", string2);
        string6 = StringUtils.getReplacedString(string6, "<featureTableName>", string3);
        string6 = StringUtils.getReplacedString(string6, "<indexName>", string4);
        string6 = StringUtils.getReplacedString(string6, "<caseID>", string5);
        PreparedStatement preparedStatement = connection.prepareStatement(string6);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
    }

    public static void createODMrTextTables(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, Integer n, Integer n2, boolean bl, boolean bl2, boolean bl3, Integer n3) throws Exception {
    }

    public static void dropFeatureTable(Connection connection, String string, String string2, String string3) throws Exception {
        String string4 = " BEGIN   ctx_ddl.drop_preference('<preferenceTableName>');  execute immediate 'drop table <tempTableName>';   execute immediate 'drop table <featureTableName>';  END;";
        string4 = StringUtils.getReplacedString(string4, "<preferenceTableName>", string);
        string4 = StringUtils.getReplacedString(string4, "<tempTableName>", string2);
        string4 = StringUtils.getReplacedString(string4, "<featureTableName>", string3);
        PreparedStatement preparedStatement = connection.prepareStatement(string4);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
    }

    public static Vector<String> getColumnNames(Connection connection, String string, String string2) throws Exception {
        Vector<String> vector = new Vector<String>(500, 100);
        StringBuffer stringBuffer = new StringBuffer("select COLUMN_NAME  from all_tab_columns  where TABLE_NAME = ?  AND OWNER = ?");
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        preparedStatement.setFetchSize(500);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(resultSet.getString(COLUMN_NAME));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<Vector> getColumnDetails(Connection connection, String string, String string2) throws Exception {
        Vector<Vector> vector = new Vector<Vector>(500, 100);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(GET_TABLE_COLUMNS);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setFetchSize(500);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Vector<String> vector2 = new Vector<String>(3);
                vector2.add(resultSet.getString(COLUMN_NAME));
                vector2.add(resultSet.getString(DATA_TYPE));
                vector2.add(DatabaseMetadataUtils.getDefaultMiningType(resultSet.getString(DATA_TYPE)));
                vector.add(vector2);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<Vector> getColumnDetailsWithPrimaryKey(Connection connection, String string, String string2) throws Exception {
        Vector<Vector> vector = new Vector<Vector>(500, 100);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(GET_TABLE_COLUMNS_CONSTRAINTS);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setFetchSize(500);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Vector<String> vector2 = new Vector<String>(4);
                vector2.add(resultSet.getString(COLUMN_NAME));
                vector2.add(resultSet.getString(DATA_TYPE));
                vector2.add(DatabaseMetadataUtils.getDefaultMiningType(resultSet.getString(DATA_TYPE)));
                vector2.add(resultSet.getString(CONSTRAINT_TYPE));
                vector.add(vector2);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        }
        return vector;
    }

    public static boolean isTypeSupportedAsTableKey(String string) {
        boolean bl = true;
        for (int i = 0; i < ORACLE_INDEX_NOT_SUPPORTED.length; ++i) {
            if (string.compareTo(ORACLE_INDEX_NOT_SUPPORTED[i]) != 0) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static String[] getOracleKeyDataTypesSupported() {
        return ORACLE_KEY_DATA_TYPES_SUPPORTED;
    }

    public static String[] getOracleDataTypesSupported() {
        return ORACLE_DATA_TYPES_SUPPORTED;
    }

    public static String[] getOracleCategoricalTargetDataTypesSupported() {
        return ORACLE_CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED;
    }

    public static String[] getOracleNumericalTargetDataTypesSupported() {
        return ORACLE_NUMERICAL_TARGETS_DATA_TYPES_SUPPORTED;
    }

    public static boolean isIntervalYearToMonth(String string) {
        return -1 != string.indexOf(_INTERVAL_YEAR_TO_MONTH[0]) && -1 != string.indexOf(_INTERVAL_YEAR_TO_MONTH[1]);
    }

    public static boolean isIntervalDayToSeconds(String string) {
        return -1 != string.indexOf(_INTERVAL_DAY_TO_SECOND[0]) && -1 != string.indexOf(_INTERVAL_DAY_TO_SECOND[1]);
    }

    public static boolean isSupportedNestedType(Context context, String string) throws Exception {
        boolean bl = false;
        Version version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        int n = 0;
        if (version.toCanonicalString().startsWith("11.")) {
            for (n = 0; n < ORACLE_NESTED_TYPES_SUPPORTED.length; ++n) {
                if (string.compareTo(ORACLE_NESTED_TYPES_SUPPORTED[n]) != 0) continue;
                bl = true;
                break;
            }
        } else {
            for (n = 0; n < ORACLE_NESTED_TYPES_SUPPORTED_12.length; ++n) {
                if (string.compareTo(ORACLE_NESTED_TYPES_SUPPORTED_12[n]) != 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean isDataTypeSupported(String string) {
        boolean bl = false;
        for (int i = 0; i < ORACLE_DATA_TYPES_SUPPORTED.length; ++i) {
            if (string.compareTo(ORACLE_DATA_TYPES_SUPPORTED[i]) != 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            bl = DatabaseMetadataUtils.isTimestampDerived(string);
        }
        if (!bl) {
            bl = DatabaseMetadataUtils.isApply_12_1_TypeSupported(string);
        }
        return bl;
    }

    public static boolean isACustomDataType(Context context, String string) throws Exception {
        return DatabaseMetadataUtils.isSupportedNestedType(context, string) || DatabaseMetadataUtils.isApply_12_1_TypeSupported(string);
    }

    public static boolean isACharacterOracleDataType(String string) {
        boolean bl = false;
        for (int i = 0; i < ORACLE_COMPATIBLE_CHARACTER_TYPES.length; ++i) {
            if (string.compareTo(ORACLE_COMPATIBLE_CHARACTER_TYPES[i]) != 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isANumberOracleDataType(String string) {
        boolean bl = false;
        for (int i = 0; i < ORACLE_COMPATIBLE_NUMBER_TYPES.length; ++i) {
            if (string.compareTo(ORACLE_COMPATIBLE_NUMBER_TYPES[i]) != 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isATimeStampOracleDataType(String string) {
        boolean bl = false;
        for (int i = 0; i < ORACLE_COMPATIBLE_TIMESTAMP_TYPES.length; ++i) {
            if (string.compareTo(ORACLE_COMPATIBLE_TIMESTAMP_TYPES[i]) != 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            bl = DatabaseMetadataUtils.isTimestampDerived(string);
        }
        return bl;
    }

    public static boolean isNumericTypeSupported(Context context, String string) throws Exception {
        boolean bl = false;
        Version version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        int n = 0;
        if (version.toCanonicalString().startsWith("11.")) {
            for (n = 0; n < ORACLE_NUMERIC_DATA_TYPES_SUPPORTED.length; ++n) {
                if (string.compareTo(ORACLE_NUMERIC_DATA_TYPES_SUPPORTED[n]) != 0) continue;
                bl = true;
                break;
            }
        } else {
            for (n = 0; n < ORACLE_NUMERIC_DATA_TYPES_SUPPORTED_12.length; ++n) {
                if (string.compareTo(ORACLE_NUMERIC_DATA_TYPES_SUPPORTED_12[n]) != 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static String mapNumericSupportedType(Context context, String string) throws Exception {
        String string2 = null;
        Version version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        int n = 0;
        if (version.toCanonicalString().startsWith("11.")) {
            for (n = 0; n < ORACLE_NUMERIC_DATA_TYPES_SUPPORTED.length; ++n) {
                if (string.compareTo(ORACLE_NUMERIC_DATA_TYPES_SUPPORTED[n]) != 0) continue;
                string2 = string;
                break;
            }
        } else {
            for (n = 0; n < ORACLE_NUMERIC_DATA_TYPES_SUPPORTED_12.length; ++n) {
                if (string.compareTo(ORACLE_NUMERIC_DATA_TYPES_SUPPORTED_12[n]) != 0) continue;
                string2 = string;
                break;
            }
        }
        return string2;
    }

    public static boolean isTimestampDerived(String string) {
        return -1 != string.indexOf(ORACLE_TIMESTAMP);
    }

    public static boolean isTimestamp(String string) {
        return -1 != string.indexOf(ORACLE_TIMESTAMP) && -1 == string.indexOf(_WITH_TIMEZONE);
    }

    public static boolean isTimestampWithTimeZone(String string) {
        return -1 != string.indexOf(ORACLE_TIMESTAMP) && -1 != string.indexOf(_WITH_TIMEZONE);
    }

    public static boolean isTimestampWithLocalTimeZone(String string) {
        if (-1 != string.indexOf(ORACLE_TIMESTAMP)) {
            return -1 != string.indexOf(_WITH_LOCAL_TIMEZONE);
        }
        return false;
    }

    public static boolean isKeyDataTypeSupported(String string) {
        boolean bl = false;
        for (int i = 0; i < ORACLE_KEY_DATA_TYPES_SUPPORTED.length; ++i) {
            if (string.compareTo(ORACLE_KEY_DATA_TYPES_SUPPORTED[i]) != 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isCaseIdDataTypeSupported(Context context, String string) {
        boolean bl = false;
        Version version = null;
        try {
            version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            version = null;
        }
        int n = 0;
        if (version == null || version.toCanonicalString().startsWith("11.")) {
            for (n = 0; n < ORACLE_CASE_DATA_TYPES_SUPPORTED.length; ++n) {
                if (string.compareTo(ORACLE_CASE_DATA_TYPES_SUPPORTED[n]) != 0) continue;
                bl = true;
                break;
            }
        } else {
            for (n = 0; n < ORACLE_CASE_DATA_TYPES_SUPPORTED_12.length; ++n) {
                if (string.compareTo(ORACLE_CASE_DATA_TYPES_SUPPORTED_12[n]) != 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean isTargetCategoricalDataTypeSupported(Context context, String string) throws Exception {
        boolean bl = false;
        Version version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        int n = 0;
        if (version.toCanonicalString().startsWith("11.")) {
            for (n = 0; n < ORACLE_CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED.length; ++n) {
                if (string.compareTo(ORACLE_CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED[n]) != 0) continue;
                bl = true;
                break;
            }
        } else {
            for (n = 0; n < ORACLE_CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED_12.length; ++n) {
                if (string.compareTo(ORACLE_CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED_12[n]) != 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean isApply_12_1_TypeSupported(String string) {
        String[] stringArray = ODMrDataTypesUtil.getApply_12_1_Types();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.compareTo(stringArray[i]) != 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isTargetNumericalDataTypeSupported(Context context, String string) throws Exception {
        boolean bl = false;
        Version version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        int n = 0;
        if (version.toCanonicalString().startsWith("11.")) {
            for (n = 0; n < ORACLE_NUMERICAL_TARGETS_DATA_TYPES_SUPPORTED.length; ++n) {
                if (string.compareTo(ORACLE_NUMERICAL_TARGETS_DATA_TYPES_SUPPORTED[n]) != 0) continue;
                bl = true;
                break;
            }
        } else {
            for (n = 0; n < ORACLE_NUMERICAL_TARGETS_DATA_TYPES_SUPPORTED_12.length; ++n) {
                if (string.compareTo(ORACLE_NUMERICAL_TARGETS_DATA_TYPES_SUPPORTED_12[n]) != 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean canDataBeImplicitlyConverted(String string, String string2) {
        if (DatabaseMetadataUtils.isACharacterOracleDataType(string) && DatabaseMetadataUtils.isACharacterOracleDataType(string2)) {
            return true;
        }
        if (DatabaseMetadataUtils.isANumberOracleDataType(string) && DatabaseMetadataUtils.isANumberOracleDataType(string2)) {
            return true;
        }
        return DatabaseMetadataUtils.isATimeStampOracleDataType(string) && DatabaseMetadataUtils.isATimeStampOracleDataType(string2);
    }

    public static String getDefaultUIMiningType(String string) {
        return DatabaseMetadataUtils.getDefaultMiningType(string, true);
    }

    public static String getDefaultMiningType(String string) {
        return DatabaseMetadataUtils.getDefaultMiningType(string, false);
    }

    public static String getDefaultMiningType(String string, boolean bl) {
        String string2 = null;
        string2 = string.equals(ORACLE_NUMBER) || string.equals(ORACLE_FLOAT) || string.equals(ORACLE_DATE) || string.equals(ORACLE_BINARY_DOUBLE) || string.equals(ORACLE_BINARY_FLOAT) || DatabaseMetadataUtils.isTimestampDerived(string) ? (bl ? NUMERICAL_MINING_TYPE : "Numerical") : (string.equals(ORACLE_VARCHAR2) || string.equals(ORACLE_CHAR) || string.equals(ORACLE_NVARCHAR2) || string.equals(ORACLE_NCHAR) ? (bl ? CATEGORICAL_MINING_TYPE : "Categorical") : (string.equals("DM_NESTED_NUMERICALS") ? (bl ? NUMERICAL_MINING_TYPE : "Numerical") : (string.equals("DM_NESTED_CATEGORICALS") ? (bl ? CATEGORICAL_MINING_TYPE : "Categorical") : (string.equals(ODMR_HISTOGRAMS) ? (bl ? CATEGORICAL_MINING_TYPE : "Categorical") : (string.equals(ORACLE_BFILE) || string.equals(ORACLE_BLOB) || string.equals(ORACLE_CLOB) || string.equals(ORACLE_LONG) || string.equals(ORACLE_XMLTYPE) || string.equals(ORACLE_NCLOB) || string.equals(ORACLE_RAW) || string.equals(ORACLE_LONG_RAW) ? (bl ? TEXT_MINING_TYPE : ATTRIBUTE_TYPE_TEXT) : (bl ? NOT_APPLICABLE_MINING_TYPE : ATTRIBUTE_TYPE_NOT_APPLICABLE))))));
        return string2;
    }

    public static boolean hasColumnName(Connection connection, String string, String string2, String string3) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("select COLUMN_NAME  from all_tab_columns  where TABLE_NAME = ?  AND OWNER = ?  AND COLUMN_NAME = ?");
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string3);
        preparedStatement.setFetchSize(500);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = false;
        while (resultSet.next()) {
            bl = true;
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return bl;
    }

    public static Vector<String> getColumnNames(Connection connection, String string, String string2, String string3) throws Exception {
        Vector<String> vector = new Vector<String>(500, 100);
        StringBuffer stringBuffer = new StringBuffer("select COLUMN_NAME  from all_tab_columns  where TABLE_NAME = ?  AND OWNER = ?  AND DATA_TYPE = ?");
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string3);
        preparedStatement.setFetchSize(500);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(resultSet.getString(COLUMN_NAME));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector;
    }

    public static Vector getColumnNamesBasedOnDataTypes(Connection connection, String string, String string2, Vector vector) throws Exception {
        Vector<String> vector2 = new Vector<String>(500, 100);
        StringBuffer stringBuffer = new StringBuffer("select COLUMN_NAME  from all_tab_columns  where TABLE_NAME = ?  AND OWNER = ?  AND DATA_TYPE IN (");
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer2.append("'" + (String)vector.get(i) + "'" + ",");
        }
        if (vector.size() > 0) {
            stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
            stringBuffer2.append(")");
        }
        stringBuffer.append(stringBuffer2);
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        preparedStatement.setFetchSize(500);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector2.add(resultSet.getString(COLUMN_NAME));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector2;
    }

    public static Vector<String> getSortedColumnNames(Connection connection, String string, String string2) throws Exception {
        Vector<String> vector = new Vector<String>(500, 100);
        StringBuffer stringBuffer = new StringBuffer("select COLUMN_NAME  from all_tab_columns  where TABLE_NAME = ?  AND OWNER = ?  ORDER BY COLUMN_NAME ");
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        preparedStatement.setFetchSize(500);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(resultSet.getString(COLUMN_NAME));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean datasourceExists(Connection connection, String string, String string2) throws Exception {
        String string3;
        String string4 = "select table_name from all_tables where owner = :owner_param and table_name = :table_param";
        String string5 = "select view_name from all_views where owner = :owner_param and view_name = :table_param";
        boolean bl = false;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string.toUpperCase();
            string = DatabaseMetadataUtils.getReplacedString(string, "'", "''");
            string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
            string2 = DatabaseMetadataUtils.getReplacedString(string2, "'", "''");
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string4);
            sQLHelper.opstmt.setStringAtName("owner_param", string);
            sQLHelper.opstmt.setStringAtName("table_param", string2);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next() && (string3 = sQLHelper.rs.getString(1)) != null) {
                boolean bl2 = true;
                return bl2;
            }
        }
        finally {
            sQLHelper.close();
        }
        try {
            sQLHelper = new SQLHelper();
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string5);
            sQLHelper.opstmt.setStringAtName("owner_param", string);
            sQLHelper.opstmt.setStringAtName("table_param", string2);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next() && (string3 = sQLHelper.rs.getString(1)) != null) {
                boolean bl3 = true;
                return bl3;
            }
        }
        finally {
            sQLHelper.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTable(Connection connection, String string, String string2) throws Exception {
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        String string3 = "select table_name from all_tables where owner = :owner_param and table_name = :table_param";
        boolean bl = false;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string4;
            string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string;
            string = DatabaseMetadataUtils.getReplacedString(string, "'", "''");
            string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2;
            string2 = DatabaseMetadataUtils.getReplacedString(string2, "'", "''");
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
            sQLHelper.opstmt.setStringAtName("owner_param", string);
            sQLHelper.opstmt.setStringAtName("table_param", string2);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next() && (string4 = sQLHelper.rs.getString(1)) != null) {
                bl = true;
            }
        }
        finally {
            sQLHelper.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTableOrViewGrantedDirectly(Connection connection, String string, String string2) throws Exception {
        String string3 = "select grantor, grantee, table_schema, table_name, privilege from ALL_TAB_PRIVS \nWHERE TABLE_SCHEMA = :schema_param AND TABLE_NAME = :table_param \nAND GRANTEE IN (:owner_param, 'PUBLIC') AND PRIVILEGE = 'SELECT'";
        boolean bl = false;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string4;
            String string5 = connection.getMetaData().getUserName();
            string5 = StringUtils.isDoubleQuotedString(string5) ? StringUtils.trimDoubleQuotes(string5) : string5;
            string5 = DatabaseMetadataUtils.getReplacedString(string5, "'", "''");
            String string6 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2;
            string6 = DatabaseMetadataUtils.getReplacedString(string6, "'", "''");
            String string7 = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string;
            string7 = DatabaseMetadataUtils.getReplacedString(string7, "'", "''");
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
            sQLHelper.opstmt.setStringAtName("owner_param", string5);
            sQLHelper.opstmt.setStringAtName("table_param", string6);
            sQLHelper.opstmt.setStringAtName("schema_param", string7);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next() && (string4 = sQLHelper.rs.getString(1)) != null) {
                bl = true;
            }
        }
        finally {
            sQLHelper.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTableWithIndex(Connection connection, String string, String string2, String string3, String string4) throws SQLException {
        String string5 = null;
        PreparedStatement preparedStatement = null;
        string5 = "create table \"{0}\".\"{1}\" as ";
        Object[] objectArray = new Object[]{StringUtils.trimDoubleQuotes(string2), StringUtils.trimDoubleQuotes(string3)};
        string5 = MessageFormat.format(string5, objectArray) + string;
        try {
            preparedStatement = connection.prepareStatement(string5);
            preparedStatement.execute();
            if (string4 != null) {
                preparedStatement.close();
                String string6 = DatabaseMetadataUtils.createUniquePKConstraintName(string4, connection);
                string5 = "alter table {0}.{1} add constraint " + string6 + " primary key ({2})";
                objectArray = new Object[]{StringUtils.trimDoubleQuotes(string2), StringUtils.trimDoubleQuotes(string3), StringUtils.trimDoubleQuotes(string4)};
                string5 = MessageFormat.format(string5, objectArray);
                preparedStatement = connection.prepareStatement(string5);
                preparedStatement.execute();
            }
        }
        finally {
            try {
                preparedStatement.close();
                preparedStatement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void createTableAs(Connection connection, String string, String string2, String string3) throws SQLException {
        DatabaseMetadataUtils.createTableWithIndex(connection, string, string2, string3, null);
    }

    public static Hashtable<String, String> getODMrTextLookupTable(Connection connection, String string) throws SQLException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = null;
        string2 = "select ATTRIBUTE_ID, TEXT from " + string.toUpperCase();
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setFetchSize(1000);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            hashtable.put(resultSet.getString("ATTRIBUTE_ID"), resultSet.getString("TEXT"));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return hashtable;
    }

    public static String createUniquePKConstraintName(String string, Connection connection) throws SQLException {
        return DatabaseMetadataUtils.createUniquePKConstraintNameUsinRandom(string, connection);
    }

    public static String createUniquePKConstraintNameUsinRandom(String string, Connection connection) throws SQLException {
        HashMap hashMap = DatabaseMetadataUtils.getUserConstraintNamespaceHashMap(connection);
        String string2 = string.length() > 16 ? string.substring(0, 16) : string;
        String string3 = DatabaseMetadataUtils.createUniqueDBObjNameUsingRandom(connection, string2, hashMap, 999999, "_PK");
        return string3;
    }

    private static String createUniqueDBObjNameUsingRandom(Connection connection, String string, HashMap hashMap, int n, String string2) {
        boolean bl = true;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        while (bl) {
            string3 = String.valueOf(randNumberGen.nextInt(n));
            string4 = string + string3 + string2;
            if (hashMap != null) {
                string5 = (String)hashMap.get(string4);
            }
            if (string5 != null) continue;
            bl = false;
        }
        return string4;
    }

    private static String createUniqueDBObjNameUsingSequence(Connection connection, String string, HashMap hashMap) {
        boolean bl = true;
        Object var4_4 = null;
        String string2 = string;
        String string3 = null;
        int n = 1;
        while (bl) {
            if (hashMap != null) {
                string3 = (String)hashMap.get(string2);
            }
            if (string3 == null) {
                bl = false;
                continue;
            }
            string2 = string + ++n;
        }
        return string2;
    }

    public static boolean isSQLDataTypeNumeric(int n) {
        boolean bl = false;
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isSQLDataTypeString(int n) {
        boolean bl = false;
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isSQLDataTypeDate(int n) {
        boolean bl = false;
        switch (n) {
            case 91: 
            case 92: 
            case 93: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer clobToStringBuffer(Clob clob) throws SQLException {
        if (clob == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        InputStream inputStream = clob.getAsciiStream();
        if (inputStream == null) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            stringBuffer = null;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getColumnType(Connection connection, String string, String string2, String string3) throws Exception {
        String string4 = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(_COLUMN_TYPE.toString());
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setString(2, string2);
            sQLHelper.pstmt.setString(3, string3);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                string4 = sQLHelper.rs.getString("DATA_TYPE");
                if (string4.equals(ORACLE_NVARCHAR2) || string4.equals(ORACLE_VARCHAR2)) {
                    string4 = ORACLE_VARCHAR2;
                } else if (string4.equals(ORACLE_NUMBER)) {
                    string4 = ORACLE_NUMBER;
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            string4 = null;
        }
        finally {
            sQLHelper.close();
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable<String, String> getColumnTypes(Connection connection, String string, String string2) throws Exception {
        String string3 = null;
        SQLHelper sQLHelper = new SQLHelper();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            sQLHelper.pstmt = connection.prepareStatement(_COLUMN_NAME_TYPES.toString());
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setString(2, string2);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            String string4 = null;
            if (sQLHelper.rs.next()) {
                string4 = sQLHelper.rs.getString(1);
                string3 = sQLHelper.rs.getString(2);
                string3 = string3.equals(ORACLE_NVARCHAR2) || string3.equals(ORACLE_VARCHAR2) ? ORACLE_VARCHAR2 : (string3.equals(ORACLE_NUMBER) ? ORACLE_NUMBER : null);
                if (string3 != null) {
                    hashtable.put(string4, string3);
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            string3 = null;
        }
        finally {
            sQLHelper.close();
        }
        return hashtable;
    }

    public static String createUniqueTableNameUsingRandom(String string, Connection connection, int n, String string2) throws SQLException {
        HashMap hashMap = DatabaseMetadataUtils.getPrimaryObjectNamespaceHashMap(connection);
        boolean bl = StringUtils.isDoubleQuotedString(string);
        int n2 = bl ? 15 : 16;
        String string3 = string.length() > n2 ? string.substring(0, n2) : string;
        String string4 = DatabaseMetadataUtils.createUniqueDBObjNameUsingRandom(connection, string3, hashMap, n, string2);
        if (bl) {
            string4 = string4 + "\"";
        }
        return string4;
    }

    public static String createUniqueTableName(String string, Connection connection, String string2) throws SQLException {
        return DatabaseMetadataUtils.createUniqueTableNameUsingRandom(string, connection, 999999999, string2);
    }

    public static String createUniqueTableName(String string, Connection connection) throws SQLException {
        HashMap hashMap = DatabaseMetadataUtils.getPrimaryObjectNamespaceHashMap(connection);
        boolean bl = StringUtils.isDoubleQuotedString(string);
        int n = bl ? 24 : 26;
        String string2 = string.length() > n ? string.substring(0, n) : string;
        String string3 = DatabaseMetadataUtils.createUniqueDBObjNameUsingSequence(connection, string2, hashMap);
        if (bl) {
            string3 = string3 + "\"";
        }
        return string3;
    }

    public static String createUniqueTempTableName(String string, Connection connection) throws SQLException {
        return DatabaseMetadataUtils.createUniqueTableNameUsingRandom(string, connection, 999999999, TEMP_TABLE_PREFIX);
    }

    public static List<String> getRequiredColumns(Connection connection, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        DatabaseMetadataUtils.getRequiredColumnsInternal(connection, COLUMNS_WITH_CONSTRAINTS, string, string2, arrayList);
        DatabaseMetadataUtils.getRequiredColumnsInternal(connection, NOT_NULL, string, string2, arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getRequiredColumnsInternal(Connection connection, String string, String string2, String string3, List<String> list) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new String[]{string2, string3, "'"};
        String string4 = MessageFormat.format(string, objectArray);
        try {
            preparedStatement = connection.prepareStatement(string4);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string5 = resultSet.getString(1);
                if (string5 == null || list.contains(string5)) continue;
                list.add(string5);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getDatabaseVersion(Context context) throws Exception {
        Connection connection = null;
        Version version = null;
        try {
            connection = Connections.getUniqueConnection(context);
            version = ConfigUtils.getDatabaseVersion(connection);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return version;
    }

    public static String getColumnType(Context context, String string) throws Exception {
        Connection connection = null;
        SQLHelper sQLHelper = new SQLHelper();
        String string2 = null;
        try {
            String string3 = StringUtils.escapeSingleQuotesForSQL(string);
            String string4 = StringUtils.getReplacedString(DBMS_SQL_PARSE_TYPE, "[SQL_EXPRESSION]", string3);
            connection = Connections.getUniqueConnection(context);
            sQLHelper.cstmt = connection.prepareCall(string4);
            sQLHelper.cstmt.registerOutParameter(1, 12);
            sQLHelper.cstmt.execute();
            string2 = sQLHelper.cstmt.getString(1);
        }
        catch (Exception exception) {
            string2 = null;
            throw exception;
        }
        finally {
            try {
                sQLHelper.close();
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string2;
    }

    public static boolean isCompatibleDB(Context context, String string) {
        Connection connection = null;
        int n = 0;
        ConfigUtils.Compatibility compatibility = null;
        try {
            connection = Connections.getSharedConnection(context);
            compatibility = ConfigUtils.Compatibility.getCompatibility(connection);
            Version version = compatibility.getDBVersion();
            n = version.compareTo((Object)new Version(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n >= 0;
    }

    public static boolean isLOBType(String string) {
        return string.equals(ORACLE_CLOB) || string.equals(ORACLE_NCLOB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnableLegacyApplyOutputTypes(Context context) {
        Connection connection = null;
        SQLHelper sQLHelper = new SQLHelper();
        int n = 0;
        try {
            connection = Connections.getSharedConnection(context);
            sQLHelper.cstmt = connection.prepareCall(DBMS_SQL_PARSE_LEGACY_APPLY_TYPE);
            sQLHelper.cstmt.registerOutParameter(1, 4);
            sQLHelper.cstmt.execute();
            n = sQLHelper.cstmt.getInt(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            sQLHelper.close();
        }
        return n == 1;
    }

    public static enum AggregateFunctions {
        MAX("MAX()"),
        AVG("AVG()"),
        MIN("MIN()"),
        MEDIAN("MEDIAN()"),
        MODE("STATS_MODE()"),
        SUM("SUM()"),
        VARIANCE("VARIANCE()"),
        STDDEV("STDDEV()"),
        COUNT("COUNT()"),
        COUNT_DISTINCT("COUNT(DISTINCT())");

        private final String sql;
        private static final Map<String, AggregateFunctions> stringToEnum;

        public static AggregateFunctions fromString(String string) {
            return stringToEnum.get(string);
        }

        private AggregateFunctions(String string2) {
            this.sql = string2;
        }

        public static String toAggregateName(String string) {
            String string2 = string.substring(0, string.indexOf("()"));
            string2 = string2.replace('(', '_');
            return string2;
        }

        public String toString() {
            return this.sql;
        }

        public static List<String> listNumericFunctions() {
            return new ArrayList<String>(stringToEnum.keySet());
        }

        public static List<String> listCategoricFunctions() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(MODE.toString());
            arrayList.add(COUNT.toString());
            arrayList.add(COUNT_DISTINCT.toString());
            return arrayList;
        }

        public static boolean isTypeTransparentFunction(String string) {
            if (string.equals(MODE.toString())) {
                return false;
            }
            if (string.equals(COUNT.toString())) {
                return false;
            }
            return !string.equals(COUNT_DISTINCT.toString());
        }

        static {
            stringToEnum = new HashMap<String, AggregateFunctions>();
            for (AggregateFunctions aggregateFunctions : AggregateFunctions.values()) {
                stringToEnum.put(aggregateFunctions.toString(), aggregateFunctions);
            }
        }
    }
}

