/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.property;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.dmt.dataminer.property.Property;
import oracle.dmt.dataminer.property.PropertyConsumer;
import oracle.dmt.dataminer.property.PropertyDockableFactory;
import oracle.dmt.dataminer.property.PropertyLrb;
import oracle.dmt.dataminer.property.PropertyWindow;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.javaxide.Util;
import oracle.ide.layout.ViewId;
import oracle.javatools.jndi.Names;

public class PropertyManager
implements Controller,
Addin {
    private static Icon _icon;
    protected static final String PROPERTY_MANAGER_NAME = "dataminer/property-manager";
    public static final int VIEW_PROPERTY_ID;
    Property property = Property.getInstance();
    PropertyWindow propertyWindow;
    private ArrayList<MetaClass> metaConsumers;

    public Property getProperty() {
        return this.property;
    }

    public static PropertyManager getPropertyManager() {
        PropertyManager propertyManager = (PropertyManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)PROPERTY_MANAGER_NAME);
        return propertyManager;
    }

    public PropertyWindow getPropertyWindow() {
        if (this.propertyWindow == null) {
            this.propertyWindow = PropertyWindow.getInstance();
        }
        return this.propertyWindow;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == VIEW_PROPERTY_ID) {
            DockStation dockStation = DockStation.getDockStation();
            ViewId viewId = new ViewId("DATAMININGPROPERTYFACTORY", "PROPERTY");
            Dockable dockable = dockStation.findDockable(viewId);
            dockStation.activateDockable(dockable);
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    public void initialize() {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)PROPERTY_MANAGER_NAME, (Object)this);
        this.createActions();
        DockStation dockStation = DockStation.getDockStation();
        dockStation.registerDockableFactory("DATAMININGPROPERTYFACTORY", (DockableFactory)PropertyDockableFactory.getInstance());
    }

    private void createActions() {
        IdeAction ideAction = IdeAction.get((int)VIEW_PROPERTY_ID, (String)null, (String)"Property", (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)null, (Icon)this.getIcon(), null, (boolean)true);
        ideAction.addController((Controller)this);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"View"), MenuConstants.SECTION_VIEW_ADDINS);
    }

    public Icon getIcon() {
        if (_icon == null) {
            _icon = UIResourceHelper.getImageIcon(this.getClass(), PropertyLrb.get("PROPERTY_ICON"));
        }
        return _icon;
    }

    public void addPropertyConsumerClass(MetaClass metaClass) {
        if (this.metaConsumers == null) {
            this.metaConsumers = new ArrayList();
        }
        this.metaConsumers.add(metaClass);
    }

    public void removePropertyConsumerClass(MetaClass metaClass) {
        this.metaConsumers.remove(metaClass);
    }

    protected List<PropertyConsumer> getPropertyConsumers() {
        if (this.metaConsumers != null) {
            ArrayList<PropertyConsumer> arrayList = new ArrayList<PropertyConsumer>();
            for (MetaClass metaClass : this.metaConsumers) {
                PropertyConsumer propertyConsumer;
                try {
                    propertyConsumer = (PropertyConsumer)Util.createInstance((MetaClass)metaClass, PropertyConsumer.class);
                }
                catch (Exception exception) {
                    propertyConsumer = null;
                }
                if (propertyConsumer == null) continue;
                arrayList.add(propertyConsumer);
            }
            return Collections.unmodifiableList(arrayList);
        }
        return null;
    }

    static {
        VIEW_PROPERTY_ID = Ide.createCmdID((String)"dataminer.propertyViewProperty");
    }
}

