/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator.wflownodes;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.navigator.BaseDeferredFilter;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ARModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.KMModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NMFModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.OCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMRModelNode;
import oracle.dmt.dataminer.navigator.net.DMURLFileSystemHelper;
import oracle.dmt.dataminer.navigator.wflownodes.ModelRefNavNode;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;

public class ModelRefNavNodeFilter
extends BaseDeferredFilter {
    @Override
    protected List<Element> loadChildrenImpl(TNode tNode) throws Exception {
        ModelRefNavNode modelRefNavNode = (ModelRefNavNode)tNode.getData();
        ConnectionFolder connectionFolder = modelRefNavNode.getConnectionFolder();
        String string = connectionFolder.getUserAccountName();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        modelRefNavNode.open();
        ModelNodeType modelNodeType = (ModelNodeType)modelRefNavNode.getRepositoryData();
        List list = modelNodeType.getModels().getModel();
        for (ModelNodeType.Models.Model model : list) {
            String string2 = string.equals(model.getSchema()) ? "" : model.getSchema() + ".";
            BaseTreeNode baseTreeNode = ModelRefNavNodeFilter.getChildNode(modelRefNavNode.getURL().getPath() + "/" + string2 + model.getName(), model, connectionFolder.getUserAccountName());
            baseTreeNode.setParent(this.getOwner());
            baseTreeNode.setConnectionFolder(connectionFolder);
            arrayList.add((Element)baseTreeNode);
        }
        return arrayList;
    }

    public static BaseTreeNode getChildNode(String string, ModelNodeType.Models.Model model, String string2) throws Exception {
        BaseTreeNode baseTreeNode = null;
        MiningAlgorithmType miningAlgorithmType = model.getMiningAlgorithm();
        Class clazz = null;
        if (miningAlgorithmType.equals((Object)MiningAlgorithmType.NAIVE_BAYES)) {
            clazz = NBModelNode.class;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.DECISION_TREE)) {
            clazz = DTModelNode.class;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.GENERALIZED_LINEAR_MODEL)) {
            if (model.getMiningFunction().equals((Object)MiningFunctionType.CLASSIFICATION)) {
                clazz = GLMCModelNode.class;
            } else if (model.getMiningFunction().equals((Object)MiningFunctionType.REGRESSION)) {
                clazz = GLMRModelNode.class;
            }
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.SUPPORT_VECTOR_MACHINES)) {
            if (model.getMiningFunction().equals((Object)MiningFunctionType.CLASSIFICATION)) {
                clazz = SVMCModelNode.class;
            } else if (model.getMiningFunction().equals((Object)MiningFunctionType.REGRESSION)) {
                clazz = SVMRModelNode.class;
            } else if (model.getMiningFunction().equals((Object)MiningFunctionType.ANOMALY_DETECTION)) {
                clazz = ANModelNode.class;
            }
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.KMEANS)) {
            clazz = KMModelNode.class;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.O_CLUSTER)) {
            clazz = OCModelNode.class;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR)) {
            clazz = NMFModelNode.class;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.APRIORI_ASSOCIATION_RULES)) {
            clazz = ARModelNode.class;
        }
        String string3 = model.getName();
        String string4 = model.getSchema();
        if (string3 != null) {
            URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)string);
            ModelNode modelNode = (ModelNode)NodeFactory.findOrCreate(clazz, (URL)uRL);
            modelNode.setURL(uRL);
            modelNode.setSchema(string4);
            modelNode.setRepositoryData(model);
            baseTreeNode = (BaseTreeNode)((Object)modelNode);
        }
        return baseTreeNode;
    }
}

