/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator.modelnodes;

import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNodesLrb;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMRModelNode;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.ModelGeneralDescription;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.ExceptionDialog;

public abstract class AbstractModelNode
extends BaseTreeNode
implements ModelNode {
    protected String _schema;
    private Boolean _exists;
    private Model _odmModel;
    private Icon _icon;

    public AbstractModelNode(URL uRL) {
        super(uRL);
        this._exists = null;
    }

    @Override
    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("GENERIC_MODEL_NODE_ICON"));
        }
        return this._icon;
    }

    @Override
    public Model getOdmModel() {
        return this._odmModel;
    }

    public AbstractModelNode() {
    }

    @Override
    public Boolean isModelExists() {
        return this._exists;
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        this.unload();
    }

    protected void openImpl() throws IOException {
        super.openImpl();
        this.load();
    }

    @Override
    public boolean mayHaveChildren() {
        return false;
    }

    public void unload() {
        this._exists = null;
        this._odmModel = null;
    }

    @Override
    public void load() {
        LoadInBackground loadInBackground = new LoadInBackground();
        try {
            loadInBackground.setTitle(ModelNodesLrb.get("LOADING_TITLE"));
            loadInBackground.setMessage(ModelNodesLrb.get("LOADING_VIEWER_MSG"));
            loadInBackground.start(true);
        }
        catch (ProgressException progressException) {
            progressException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImpl() {
        Connection connection = null;
        try {
            String string;
            ConnectionFolder connectionFolder = (ConnectionFolder)this.getParent().getAncestor(ConnectionFolder.class, true);
            connection = Connections.getUniqueConnection(connectionFolder.getShortLabel());
            Object object = this.getRepositoryData();
            if (object instanceof ModelType) {
                ModelType modelType = (ModelType)object;
                string = modelType.getName();
            } else if (object instanceof TestModelType.Model) {
                TestModelType.Model model = (TestModelType.Model)object;
                string = model.getName();
            } else if (object instanceof ModelNodeType.Models.Model) {
                ModelNodeType.Models.Model model = (ModelNodeType.Models.Model)object;
                string = model.getName();
            } else {
                throw new RuntimeException("Invalid state detected");
            }
            this._odmModel = new Model(this.getSchema(), string);
            this._odmModel.load(connection);
            this._exists = false == this._odmModel.getModelGeneralDescription().equals(ModelGeneralDescription._NONE);
            if (this._exists.booleanValue() && this instanceof SVMCModelNode) {
                ((SVMCModelNode)this).loadLinearKernel(connection);
            } else if (this._exists.booleanValue() && this instanceof SVMRModelNode) {
                ((SVMRModelNode)this).loadLinearKernel(connection);
            } else if (this._exists.booleanValue() && this instanceof ANModelNode) {
                ((ANModelNode)this).loadLinearKernel(connection);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    @Override
    public void setSchema(String string) {
        this._schema = string;
    }

    @Override
    public String getSchema() {
        return this._schema;
    }

    class LoadInBackground
    extends ProgressRunnable {
        boolean _canceled = false;

        LoadInBackground() {
        }

        protected Object doWork() throws Exception {
            AbstractModelNode.this.loadImpl();
            return Boolean.TRUE;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }
}

