/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.util.IlvXMLConnector;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.diagram.sdm.undo.ContextNodeUndoStateHelper;
import oracle.diagram.sdm.undo.StateHelper;
import oracle.dmt.dataminer.navigator.AbstractSDMEngineNode;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.DataMinerNode;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorWindow;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import org.w3c.dom.Document;

public class WorkflowNode
extends AbstractSDMEngineNode
implements DataMinerNode {
    private static Icon _icon;
    private BigDecimal _id;
    private TNode _parent = null;
    private Object _reposObj = null;
    private WorkflowModel _wfModel = null;
    private ConnectionFolder _connFolder = null;
    private Timestamp _lastSavedOn = new Timestamp(0L);
    private Connection sessionConnection = null;

    public WorkflowNode() {
    }

    public WorkflowNode(URL uRL) {
        super(uRL);
    }

    public void setWorkflowModel(WorkflowModel workflowModel) {
        this._wfModel = workflowModel;
    }

    public WorkflowModel getWorkflowModel() {
        return this._wfModel;
    }

    @Override
    public boolean isDeleteable() {
        return true;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public boolean setReadOnly(boolean bl) {
        try {
            if (this._wfModel == null) {
                throw new RuntimeException("Cannot setReadOnly because WorkflowModel has not been initialized");
            }
            this._wfModel = WorkflowUtils.getWorkflowModel(this);
            this._wfModel.setEditable(!bl);
            if (bl) {
                this.getAttributes().set(ElementAttributes.NON_EDITABLE | ElementAttributes.READ_ONLY);
            } else {
                this.getAttributes().unset(ElementAttributes.NON_EDITABLE | ElementAttributes.READ_ONLY);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return ((Workflow)this.getRepositoryData()).isReadOnly();
    }

    public Timestamp getLastSavedOn() {
        return this._lastSavedOn;
    }

    public void setLastSavedOn(Timestamp timestamp) {
        this._lastSavedOn = timestamp;
    }

    public static WorkflowNode getWorkflowNode(Context context) {
        WorkflowNode workflowNode = null;
        Node node = context.getNode();
        DataMinerNode dataMinerNode = (DataMinerNode)node;
        if (node == null) {
            return null;
        }
        if (node instanceof Connections) {
            return null;
        }
        if (node instanceof ConnectionFolder) {
            return null;
        }
        if (node instanceof ProjectFolder) {
            return null;
        }
        if (node instanceof WorkflowNode) {
            workflowNode = (WorkflowNode)node;
        } else {
            Element element = dataMinerNode.getParent().getAncestor(WorkflowNode.class);
            if (element != null && element instanceof WorkflowNode) {
                workflowNode = (WorkflowNode)element;
            }
        }
        return workflowNode;
    }

    public Icon getIcon() {
        if (_icon == null) {
            _icon = UIResourceHelper.getImageIcon(this.getClass(), DataminerNavigatorLrb.get("WORKFLOW_NODE_ICON"));
        }
        return _icon;
    }

    public Connection getSessionConnection() {
        return this.sessionConnection;
    }

    public void setSessionConnection(Connection connection) {
        this.sessionConnection = connection;
        try {
            this.sessionConnection.setAutoCommit(false);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
        }
    }

    public void closeSessionConnection() {
        if (this.sessionConnection == null) {
            return;
        }
        try {
            Connection connection = this.sessionConnection;
            this.sessionConnection = null;
            connection.commit();
            connection.setAutoCommit(true);
            connection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void renameImpl(URL uRL, URL uRL2) throws IOException {
    }

    @Override
    protected void saveImpl() throws IOException {
        boolean bl = false;
        try {
            this._lastSavedOn = this.save(bl);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException && ((SQLException)exception).getErrorCode() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"The document is currently locked by another user.", (String)"Oracle Data Miner", null);
            }
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
        }
    }

    private Timestamp save(final boolean bl) throws Exception {
        class Worker
        extends ProgressRunnable {
            private boolean _canceled;
            private final Workflow wf;
            protected Timestamp newLastSavedOn;

            Worker() {
                this.wf = (Workflow)WorkflowNode.this.getRepositoryData();
                this.newLastSavedOn = null;
            }

            protected Object doWork() throws Exception {
                this.newLastSavedOn = this.wf.save(WorkflowNode.this.sessionConnection, WorkflowNode.this._lastSavedOn, bl);
                return Boolean.TRUE;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }

            public boolean isCanceled() {
                return this._canceled;
            }
        }
        Worker worker = new Worker();
        worker.setTitle(WorkflowEditorLrb.get("SAVE_WORKFLOW"));
        worker.setMessage(WorkflowEditorLrb.get("SAVE_WORKFLOW_DESCR"));
        worker.setCancelable(false);
        worker.start(true);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.flush((Object)this);
        return worker.newLastSavedOn;
    }

    @Override
    protected void closeImpl() throws IOException {
        super.closeImpl();
        Workflow workflow = (Workflow)this.getRepositoryData();
        workflow.unload();
        List list = EditorManager.getEditorManager().findEditors(Context.newIdeContext((Node)this));
        for (Object e : list) {
            if (!(e instanceof WorkflowEditor)) continue;
            ((WorkflowEditor)e).stopJobMonitoring();
        }
        this.setWorkflowModel(null);
    }

    @Override
    protected void openImpl() throws IOException {
        super.openImpl();
    }

    public static void delete(Map<WorkflowNode, Connection> map) throws Exception {
        if (map.values().size() == 0) {
            return;
        }
        for (WorkflowNode workflowNode : map.keySet()) {
            Workflow.delete(map);
            WorkflowNode.closeNode(workflowNode);
            WorkflowNode.removeNodeFromProject(workflowNode);
        }
    }

    private static void closeNode(final WorkflowNode workflowNode) {
        try {
            if (!EventQueue.isDispatchThread()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            workflowNode.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                });
            } else {
                workflowNode.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void removeNodeFromProject(final WorkflowNode workflowNode) {
        if (!EventQueue.isDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (workflowNode.getParent() == null) {
                            return;
                        }
                        ProjectFolder projectFolder = (ProjectFolder)workflowNode.getParent().getData();
                        projectFolder.remove((Element)workflowNode, true);
                        projectFolder.markDirty(false);
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            ProjectFolder projectFolder = (ProjectFolder)workflowNode.getParent().getData();
            projectFolder.remove((Element)workflowNode, true);
            projectFolder.markDirty(false);
        }
    }

    public String export(Context context) throws Exception {
        final Context context2 = context;
        class Worker
        extends ProgressRunnable {
            private boolean _canceled;
            private final Workflow wf;
            private String workflowXML;

            Worker() {
                this.wf = (Workflow)WorkflowNode.this.getRepositoryData();
            }

            protected Object doWork() throws Exception {
                Connection connection = Connections.getSharedConnection(context2);
                this.workflowXML = this.wf.export(connection, WorkflowNode.this._lastSavedOn, context2);
                return Boolean.TRUE;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }

            public boolean isCanceled() {
                return this._canceled;
            }
        }
        Worker worker = new Worker();
        worker.setTitle(WorkflowEditorLrb.get("SAVE_WORKFLOW"));
        worker.setMessage(WorkflowEditorLrb.get("SAVE_WORKFLOW_DESCR"));
        worker.setCancelable(false);
        worker.start(true);
        return worker.workflowXML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void revertImpl() throws IOException {
        IlvSDMEngine ilvSDMEngine = this.getEngine();
        if (ilvSDMEngine != null && !this.isNew()) {
            this.loadEngine();
        } else {
            super.revertImpl();
        }
    }

    @Override
    protected void loadEngine() throws IOException {
        try {
            String[] stringArray = new String[1];
            URL uRL = this.getClass().getResource("/oracle/dmt/dataminer/navigator/css/default-odmr.css");
            stringArray[0] = uRL.toString();
            this.getEngine().setStyleSheets(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected IlvSDMEngine createEngine() {
        IlvSDMEngine ilvSDMEngine = super.createEngine();
        ilvSDMEngine.setHighlightingSelection(true);
        return ilvSDMEngine;
    }

    @Override
    protected IlvSDMModel createModel() {
        if (this._wfModel == null) {
            this._wfModel = new WorkflowModel();
        }
        return this._wfModel;
    }

    @Override
    protected void installModelFilters(IlvSDMEngine ilvSDMEngine) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = new OdmrSDMUndoFilter(ilvSDMEngine.getModel());
        odmrSDMUndoFilter.addStateHelper((StateHelper)new ContextNodeUndoStateHelper());
        ilvSDMEngine.setModel((IlvSDMModel)odmrSDMUndoFilter);
    }

    @Override
    public Object getRepositoryData() {
        return this._reposObj;
    }

    @Override
    public void setRepositoryData(Object object) {
        this._reposObj = object;
    }

    @Override
    public void setParent(TNode tNode) {
        this._parent = tNode;
    }

    @Override
    public TNode getParent() {
        return this._parent;
    }

    @Override
    public void setConnectionFolder(ConnectionFolder connectionFolder) {
        this._connFolder = connectionFolder;
    }

    public void setId(BigDecimal bigDecimal) {
        this._id = bigDecimal;
    }

    public BigDecimal getId() {
        return this._id;
    }

    @Override
    public ConnectionFolder getConnectionFolder() {
        if (this._parent != null) {
            Element element = this._parent.getAncestor(ConnectionFolder.class);
            return (ConnectionFolder)element;
        }
        return this._connFolder;
    }

    @Override
    public void selectAndOpen(Context context) {
        if (!(context.getView() instanceof NavigatorWindow)) {
            return;
        }
        TreeExplorer treeExplorer = this.getTreeExplorer(context);
        TNode tNode = treeExplorer.searchTNodeBreadthFirst((Element)this, this.getParent());
        if (tNode != null) {
            treeExplorer.setSelected(tNode);
            Context context2 = Context.newIdeContext((Node)this);
            EditorManager.getEditorManager().openDefaultEditorInFrame(context2);
        }
    }

    @Override
    public TreeExplorer getTreeExplorer(Context context) {
        return BaseTreeNode.getTreeExplorerImpl(context);
    }

    @Override
    public BaseTreeNode getRootTreeNode(Context context) {
        return BaseTreeNode.getRootTreeNodeImpl(context);
    }

    @Override
    public void closeChildren() {
        BaseTreeNode.closeChildrenImpl((Node)this);
    }

    private class OdmrXMLConnector
    extends IlvXMLConnector {
        private OdmrXMLConnector() {
        }

        public void writeXML(IlvSDMModel ilvSDMModel, OutputStream outputStream, Enumeration enumeration, Hashtable hashtable) throws IOException {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                this.writeDOM(ilvSDMModel, document, enumeration != null ? enumeration : ilvSDMModel.getObjects(), hashtable);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
                String string = this.getStringFromDoc(document);
                outputStreamWriter.write(string);
                outputStreamWriter.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public String getStringFromDoc(Document document) throws Exception {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            String string = stringWriter.toString();
            return string;
        }
    }
}

