/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.util.Enumeration;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.BaseDeferredFilter;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.ide.Context;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;

public abstract class DataNode
extends BaseTreeNode {
    protected Icon _icon;

    public String getCacheTableName() {
        String string = "";
        DataNodeType dataNodeType = (DataNodeType)this.getRepositoryData();
        if (dataNodeType != null && dataNodeType.getCacheSettings() != null && dataNodeType.getCacheSettings().getOutputTable() != null) {
            return dataNodeType.getCacheSettings().getOutputTable().getName();
        }
        return string;
    }

    public String getCacheSchemaName() {
        ConnectionFolder connectionFolder = (ConnectionFolder)this.getParent().getAncestor(ConnectionFolder.class);
        String string = null;
        try {
            string = connectionFolder.getUserAccountName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public String getUserName() {
        String string = null;
        DataNodeType dataNodeType = (DataNodeType)this.getRepositoryData();
        if (dataNodeType instanceof DataSourceNodeType) {
            string = ((DataSourceNodeType)dataNodeType).getSourceTable().getSchema();
        } else if (dataNodeType instanceof UpdateTableNodeType) {
            string = ((UpdateTableNodeType)dataNodeType).getUpdateTargetTable().getSchema();
        } else {
            ConnectionFolder connectionFolder = (ConnectionFolder)this.getParent().getAncestor(ConnectionFolder.class);
            string = null;
            try {
                string = connectionFolder.getUserAccountName();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    @Override
    public TreeExplorer getTreeExplorer(Context context) {
        return BaseTreeNode.getTreeExplorerImpl(context);
    }

    @Override
    public BaseTreeNode getRootTreeNode(Context context) {
        return BaseTreeNode.getRootTreeNodeImpl(context);
    }

    public static DataNode findDataNode(WorkflowNode workflowNode, String string) {
        DataNode dataNode = null;
        TreeExplorer treeExplorer = workflowNode.getParent().getOwner();
        TNode tNode = treeExplorer.searchTNodeBreadthFirst((Element)workflowNode, workflowNode.getParent());
        Enumeration enumeration = BaseDeferredFilter.getChildTreeNodes(tNode);
        while (enumeration.hasMoreElements()) {
            TNode tNode2 = (TNode)enumeration.nextElement();
            BaseTreeNode baseTreeNode = (BaseTreeNode)tNode2.getData();
            NodeType nodeType = (NodeType)baseTreeNode.getRepositoryData();
            if (!nodeType.getName().equals(string) || !(baseTreeNode instanceof DataNode)) continue;
            dataNode = (DataNode)baseTreeNode;
            break;
        }
        return dataNode;
    }

    public String getSelectSQL() {
        DataNodeType dataNodeType = (DataNodeType)this.getRepositoryData();
        return dataNodeType.getSQLExpression();
    }
}

