/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.DataMinerNode;
import oracle.dmt.dataminer.navigator.net.DMURLFileSystemHelper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;

public abstract class BaseTreeNode
extends DefaultContainer
implements DataMinerNode {
    protected TNode _parent = null;
    protected Object _reposObj = null;
    protected ConnectionFolder _connFolder = null;

    public BaseTreeNode() {
    }

    public boolean isDeleteable() {
        return false;
    }

    public BaseTreeNode(URL uRL) {
        super(uRL);
    }

    @Override
    public void setParent(TNode tNode) {
        this._parent = tNode;
    }

    @Override
    public TNode getParent() {
        return this._parent;
    }

    public void setConnectionFolder(ConnectionFolder connectionFolder) {
        this._connFolder = connectionFolder;
    }

    @Override
    public void closeChildren() {
        BaseTreeNode.closeChildrenImpl((Node)this);
    }

    public static void closeChildrenImpl(Node node) {
        try {
            Iterator iterator = node.getChildren();
            if (iterator == null) {
                return;
            }
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                BaseTreeNode.closeChildrenImpl(node2);
                try {
                    node2.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
        }
    }

    public boolean setReadOnly(boolean bl) {
        if (bl) {
            this.getAttributes().set(ElementAttributes.NON_EDITABLE | ElementAttributes.READ_ONLY);
        } else {
            this.getAttributes().unset(ElementAttributes.NON_EDITABLE | ElementAttributes.READ_ONLY);
        }
        return true;
    }

    public boolean isReadOnly() {
        return this.getAttributes().isSet(ElementAttributes.NON_EDITABLE) && this.getAttributes().isSet(ElementAttributes.NON_EDITABLE);
    }

    @Override
    public Object getRepositoryData() {
        return this._reposObj;
    }

    @Override
    public void setRepositoryData(Object object) {
        this._reposObj = object;
    }

    public String getLabel() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        return DMURLFileSystemHelper.getName(super.getShortLabel());
    }

    @Override
    public ConnectionFolder getConnectionFolder() {
        if (this._parent != null) {
            Element element = this._parent.getAncestor(ConnectionFolder.class);
            return (ConnectionFolder)element;
        }
        return this._connFolder;
    }

    public void selectAndOpen(Context context) {
        if (!(context.getView() instanceof NavigatorWindow)) {
            new Exception("Unexpected state encountered").printStackTrace();
            return;
        }
        TreeExplorer treeExplorer = this.getTreeExplorer(context);
        TNode tNode = treeExplorer.searchTNodeBreadthFirst((Element)this, this.getParent());
        if (tNode != null) {
            treeExplorer.setSelected(tNode);
            Context context2 = Context.newIdeContext((Node)this);
            EditorManager.getEditorManager().openDefaultEditorInFrame(context2);
        }
    }

    public static TreeExplorer getTreeExplorerImpl(Context context) {
        View view = context.getView();
        TreeExplorer treeExplorer = null;
        if (view instanceof NavigatorWindow) {
            treeExplorer = ((NavigatorWindow)context.getView()).getTreeExplorer();
        } else {
            DataMinerNode dataMinerNode = (DataMinerNode)context.getNode();
            treeExplorer = dataMinerNode.getParent().getOwner();
        }
        return treeExplorer;
    }

    @Override
    public TreeExplorer getTreeExplorer(Context context) {
        return BaseTreeNode.getTreeExplorerImpl(context);
    }

    @Override
    public BaseTreeNode getRootTreeNode(Context context) {
        return BaseTreeNode.getRootTreeNodeImpl(context);
    }

    public static BaseTreeNode getRootTreeNodeImpl(Context context) {
        TreeExplorer treeExplorer = BaseTreeNode.getTreeExplorerImpl(context);
        TNode tNode = treeExplorer.getRoot();
        return (BaseTreeNode)tNode.getAncestor(Connections.class, true);
    }

    public Iterator<Element> getChildren() {
        return super.getChildren();
    }
}

