/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.ConnectionFolderFilter;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.ConnectionsFilter;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.ProjectFolderFilter;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.WorkflowNodeFilter;
import oracle.dmt.dataminer.navigator.wflownodes.BuildNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.BuildNavNodeFilter;
import oracle.dmt.dataminer.navigator.wflownodes.ModelRefNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.ModelRefNavNodeFilter;
import oracle.dmt.dataminer.navigator.wflownodes.TestNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.TestNavNodeFilter;
import oracle.ide.net.URLFilter;
import oracle.ideri.navigator.DefaultNavigatorManager;

public abstract class BaseNavigatorManager
extends DefaultNavigatorManager {
    private static List<BaseNavigatorManager> s_mgrs = new ArrayList<BaseNavigatorManager>();
    private static List<FilterDesc> s_filters = new ArrayList<FilterDesc>();

    public BaseNavigatorManager() {
        s_mgrs.add(this);
    }

    public static void addFilter(Class clazz, Class clazz2, URLFilter uRLFilter) {
        for (BaseNavigatorManager baseNavigatorManager : s_mgrs) {
            baseNavigatorManager.registerFilter(clazz, clazz2, uRLFilter);
        }
        s_filters.add(new FilterDesc(clazz, clazz2, uRLFilter));
    }

    public void initialize() {
        super.initialize();
        this.getShowAction();
        for (FilterDesc filterDesc : s_filters) {
            this.registerFilter(filterDesc.m_elemClass, filterDesc.m_filterClass, filterDesc.m_urlFilter);
        }
    }

    static {
        BaseNavigatorManager.addFilter(Connections.class, ConnectionsFilter.class, null);
        BaseNavigatorManager.addFilter(ProjectFolder.class, ProjectFolderFilter.class, null);
        BaseNavigatorManager.addFilter(ConnectionFolder.class, ConnectionFolderFilter.class, null);
        BaseNavigatorManager.addFilter(WorkflowNode.class, WorkflowNodeFilter.class, null);
        BaseNavigatorManager.addFilter(BuildNavNode.class, BuildNavNodeFilter.class, null);
        BaseNavigatorManager.addFilter(ModelRefNavNode.class, ModelRefNavNodeFilter.class, null);
        BaseNavigatorManager.addFilter(TestNavNode.class, TestNavNodeFilter.class, null);
    }

    private static class FilterDesc {
        private Class m_elemClass;
        private Class m_filterClass;
        private URLFilter m_urlFilter;

        private FilterDesc(Class clazz, Class clazz2, URLFilter uRLFilter) {
            this.m_elemClass = clazz;
            this.m_filterClass = clazz2;
            this.m_urlFilter = uRLFilter;
        }
    }
}

