/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerState;
import oracle.dmt.dataminer.property.PropertyConsumer;
import oracle.dmt.dataminer.property.PropertyWindowGUI;
import oracle.dmt.dataminer.server.model.MiningAttributeInfo;
import oracle.ide.view.View;

public class AttributeTransformPropertyPanel
extends PropertyWindowGUI
implements ActionListener {
    private View _consumerView;
    private boolean _loaded;
    private SettingsViewerState _state;
    private JComboBox _attributeCombo;
    private JLabel _attributeLabel;
    private JComboBox _nestedAttributeCombo;
    private JLabel _reverseTransformationsLabel;
    private JLabel _transformationsLabel;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;

    public AttributeTransformPropertyPanel() {
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this._attributeLabel = new JLabel();
        this._attributeCombo = new JComboBox();
        this.jLabel1 = new JLabel();
        this._nestedAttributeCombo = new JComboBox();
        this._transformationsLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this._reverseTransformationsLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.jSeparator1 = new JSeparator();
        this._attributeLabel.setText("Attribute:");
        this._attributeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel1.setText("Nested Attribute:");
        this._nestedAttributeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._transformationsLabel.setText("Input Transformation:");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this._reverseTransformationsLabel.setText("Reverse Transformation:");
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea2);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 196, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 196, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 196, Short.MAX_VALUE).addComponent(this._transformationsLabel, -2, 180, -2).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this._attributeLabel, GroupLayout.Alignment.LEADING, -1, 63, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this._nestedAttributeCombo, 0, 108, Short.MAX_VALUE).addComponent(this._attributeCombo, GroupLayout.Alignment.LEADING, 0, 108, Short.MAX_VALUE))).addComponent(this._reverseTransformationsLabel, -2, 180, -2)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._attributeLabel).addComponent(this._attributeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this._nestedAttributeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._transformationsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 103, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._reverseTransformationsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 103, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void setupUI(View view) throws Exception {
        if (this._consumerView == view) {
            return;
        }
        if (view == null) {
            return;
        }
        PropertyConsumer propertyConsumer = (PropertyConsumer)view;
        this._consumerView = view;
        DataMinerViewGUI dataMinerViewGUI = (DataMinerViewGUI)this._consumerView.getGUI();
        dataMinerViewGUI.addDataMinerViewListener(this);
        if (!propertyConsumer.isLoaded()) {
            this._consumerView = view;
            return;
        }
        this.setupUIDetail();
    }

    private void setupUIDetail() {
        PropertyConsumer propertyConsumer = (PropertyConsumer)this._consumerView;
        this._state = (SettingsViewerState)propertyConsumer.getCachedPropertyState();
        assert (this._state != null) : "Settings Viewer  state is null.";
        this.loadState();
        this.enableAllControls(true);
        this.setLoaded(true);
    }

    private void loadState() {
        this._attributeCombo.setModel(new DefaultComboBoxModel<MiningAttributeInfo>(this._state.getSignatureTableModel().getDataVector()));
        MiningAttributeInfo miningAttributeInfo = this._state.getLastSelectedAttribute();
        if (miningAttributeInfo == null) {
            miningAttributeInfo = this._state.getSignatureTableModel().getDataVector().elementAt(0);
        }
        this._attributeCombo.setSelectedItem(miningAttributeInfo);
        this._attributeCombo.addActionListener(this);
        String string = miningAttributeInfo.getDataType();
        Boolean bl = string.equals("DM_NESTED_NUMERICALS") || string.equals("DM_NESTED_CATEGORICALS");
        this._nestedAttributeCombo.setVisible(bl);
        if (miningAttributeInfo != null) {
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2 = miningAttributeInfo.getExpression();
            if (stringBuffer2 != null && 0 != stringBuffer2.length()) {
                this.jTextArea1.setText(stringBuffer2.toString());
            }
            if ((stringBuffer = miningAttributeInfo.getRevExpression()) != null && 0 != stringBuffer.length()) {
                this.jTextArea2.setText(stringBuffer2.toString());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._attributeCombo)) {
            StringBuffer stringBuffer;
            MiningAttributeInfo miningAttributeInfo = (MiningAttributeInfo)this._attributeCombo.getSelectedItem();
            StringBuffer stringBuffer2 = miningAttributeInfo.getExpression();
            if (stringBuffer2 != null && 0 != stringBuffer2.length()) {
                this.jTextArea1.setText(stringBuffer2.toString());
            }
            if ((stringBuffer = miningAttributeInfo.getRevExpression()) != null && 0 != stringBuffer.length()) {
                this.jTextArea2.setText(stringBuffer2.toString());
            }
        }
    }

    @Override
    public void unloadUI() throws Exception {
        this.enableAllControls(false);
        if (this._consumerView == null) {
            return;
        }
        DataMinerViewGUI dataMinerViewGUI = (DataMinerViewGUI)this._consumerView.getGUI();
        dataMinerViewGUI.removeDataMinerViewListener(this);
        this.updateInput();
        ((PropertyConsumer)this._consumerView).setCachedPropertyState(this._state);
        this.clearState();
        this.setLoaded(false);
    }

    private void clearState() {
        this._consumerView = null;
    }

    public void updateInput() throws Exception {
    }

    @Override
    public boolean isLoaded() {
        return this._loaded;
    }

    private void setLoaded(boolean bl) {
        this._loaded = bl;
    }

    @Override
    public void initUI() {
        this.enableAllControls(false);
        this.jTextArea1.setEditable(false);
        this.jTextArea2.setEditable(false);
    }

    @Override
    public void initRes() {
    }

    @Override
    public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
    }

    @Override
    public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
        if (!this.isLoaded() && this._consumerView != null) {
            this.setupUIDetail();
        }
    }

    private void enableAllControls(boolean bl) {
    }
}

