/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.glmdetails;

import java.awt.Component;
import java.sql.Connection;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.mviewer.ModelMessagePanel;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.mviewer.glmdetails.GLMDetailsLrb;
import oracle.dmt.dataminer.mviewer.glmdetails.GLMDetailsTableModel;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.server.model.GLMModelDetailsRowData;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.SwingWorker;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class DetailsPanel
extends DataMinerViewGUI {
    private GLMDetailsTableModel _table;
    private ModelViewerState1 _state;
    private GenericTable _jDetailsGenericTable;
    private JScrollPane jScrollDetails;

    public DetailsPanel(Editor editor, Context context) throws Exception {
        super(editor, context);
        ModelNode modelNode = (ModelNode)context.getNode();
        if (modelNode == null) {
            System.out.println("null node");
        }
        if (!modelNode.isModelExists().booleanValue()) {
            this.add(new ModelMessagePanel(ModelViewerLrb.get("MODEL_DOES_NOT_EXIST")));
            return;
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jScrollDetails = new JScrollPane();
        this._jDetailsGenericTable = new GenericTable();
        this._jDetailsGenericTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{"Marital Status", "Single"}, {"Marital Status", "Married"}, {"Year of Birth", "1965-1973"}, {"Year of Birth", "1974-1985"}}, new String[]{"Name", "Value"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jScrollDetails.setViewportView((Component)this._jDetailsGenericTable);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollDetails, -1, 474, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollDetails, -1, 278, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this._table = new GLMDetailsTableModel(this._context);
        this.setLoadingIndicator();
        this._jDetailsGenericTable.setModel((TableModel)((Object)this._table));
        this._jDetailsGenericTable.setShowGrid(true);
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    private void setLoadingIndicator() {
        this._table.clearRows();
        GLMModelDetailsRowData gLMModelDetailsRowData = new GLMModelDetailsRowData(GLMDetailsLrb.get("DETAILS_LOADING"));
        this._table.addRow(gLMModelDetailsRowData);
    }

    public boolean isClassification() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof GLMCModelNode;
    }

    public boolean isRegression() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof GLMRModelNode;
    }

    public HelpInfo getHelpInfo() {
        String string = "Help Topic Not Specified";
        if (this.isClassification()) {
            string = "glmc_global_details_help";
        } else if (this.isRegression()) {
            string = "glmr_global_details_help";
        }
        return new HelpInfo(string);
    }

    class NumberRenderer
    extends DefaultTableCellRenderer {
        @Override
        public void setValue(Object object) {
            String string = NumericFormat.format((Double)object, true, 8) + "";
            super.setValue(string);
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        public LoadUI(boolean bl) {
        }

        public LoadUI() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object construct() {
            Connection connection = null;
            try {
                connection = Connections.getUniqueConnection(DetailsPanel.this._context);
                DetailsPanel.this._state = new ModelViewerState1(DetailsPanel.this._context);
                DetailsPanel.this._state.load(connection);
                DetailsPanel.this._table.load(DetailsPanel.this._state);
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {}
            }
            return this._success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            block5: {
                try {
                    if (this._success && this._ex == null) break block5;
                    DetailsPanel.this._table.clearRows();
                    GLMModelDetailsRowData gLMModelDetailsRowData = new GLMModelDetailsRowData(GLMDetailsLrb.get("DETAILS_FAILURE"));
                    DetailsPanel.this._table.addRow(gLMModelDetailsRowData);
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)GLMDetailsLrb.get("DETAILS_VIEWER_FAILURE_TITLE"), (String)GLMDetailsLrb.get("DETAILS_VIEWER_FAILURE_MESG"), null);
                        break block5;
                    }
                    MessageDialog.error((Component)Ide.getMainWindow(), null, (String)GLMDetailsLrb.get("DETAILS_VIEWER_FAILURE_TITLE"), (String)GLMDetailsLrb.get("DETAILS_VIEWER_FAILURE_MESG"));
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)GLMDetailsLrb.get("DETAILS_VIEWER_FAILURE_TITLE"), (String)GLMDetailsLrb.get("DETAILS_VIEWER_FAILURE_MESG"), null);
                }
            }
        }
    }
}

