/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree;

import java.awt.Component;
import java.awt.Container;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreePreferencesSettings;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class TreeNodePreferencesPanel
extends DefaultTraversablePanel
implements DataminerGUIPanel {
    private JLabel longTargetValuesLabel;
    private NumberTextField maxLengthEdit;
    private JLabel truncateEditLabel;
    private static final int MIN_TARGET_VALUE_LEN = 6;
    private static final int MAX_TARGET_VALUE_LEN = 30;

    public TreeNodePreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.maxLengthEdit = new NumberTextField();
        this.truncateEditLabel = new JLabel();
        this.longTargetValuesLabel = new JLabel();
        this.truncateEditLabel.setText("Maximum Length:");
        this.longTargetValuesLabel.setText("Target Value");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.truncateEditLabel).addGap(4, 4, 4).addComponent((Component)this.maxLengthEdit, -1, 49, Short.MAX_VALUE).addGap(243, 243, 243)).addGroup(groupLayout.createSequentialGroup().addComponent(this.longTargetValuesLabel).addContainerGap(329, Short.MAX_VALUE)))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.longTargetValuesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.truncateEditLabel).addComponent((Component)this.maxLengthEdit, -2, -1, -2)).addContainerGap(249, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DecisionTreeEditorLrb.get("LONG_VALUES_LABEL"), this.longTargetValuesLabel);
        hashMap.put(DecisionTreeEditorLrb.get("TRUNCATE_LABEL"), this.truncateEditLabel);
        UIResourceHelper.setComponentText(hashMap);
        this.setHelpID("data_miner_prefs");
    }

    @Override
    public void initUI() {
        NumberTextField numberTextField = this.maxLengthEdit;
        numberTextField.setDataType(Integer.class);
        numberTextField.setSigned(false);
        this.maxLengthEdit.setLocale(this.getLocale());
        this.maxLengthEdit.setToolTipText(DecisionTreeEditorLrb.get("TRUNCATE_TIP"));
    }

    public void onEntry(TraversableContext traversableContext) {
        DecisionTreePreferencesSettings decisionTreePreferencesSettings = TreeNodePreferencesPanel.getPreferences(traversableContext);
        NumberTextField numberTextField = this.maxLengthEdit;
        numberTextField.setNumber((Number)decisionTreePreferencesSettings.getMaxTargetValueDisplayLength());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DecisionTreePreferencesSettings decisionTreePreferencesSettings = TreeNodePreferencesPanel.getPreferences(traversableContext);
        NumberTextField numberTextField = this.maxLengthEdit;
        int n = numberTextField.getNumber().intValue();
        if (n < 6 || n > 30) {
            numberTextField.requestFocusInWindow();
            Object[] objectArray = new Object[]{"6", "30"};
            String string = MessageFormat.format(DecisionTreeEditorLrb.get("TREE_NODE_MIN_MAX"), objectArray);
            throw new TraversalException(string);
        }
        decisionTreePreferencesSettings.setMaxTargetValueDisplayLength(n);
    }

    private static DecisionTreePreferencesSettings getPreferences(TraversableContext traversableContext) {
        return DecisionTreePreferencesSettings.getInstance(traversableContext.getPropertyStorage());
    }
}

