/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreePreferencesSettings;
import oracle.dmt.dataminer.mviewer.dtree.TreeRule;
import oracle.dmt.dataminer.mviewer.dtree.model.TreeNode;

public class RulePane
extends JPanel
implements DataminerGUIPanel {
    private TreeNode treeNode;
    private JScrollPane ruleScrollPane;
    private JEditorPane ruleViewPane;
    private JCheckBox wrapCheckbox;

    public RulePane(TreeNode treeNode) {
        this.treeNode = treeNode;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.ruleScrollPane = new JScrollPane();
        this.ruleViewPane = new JEditorPane();
        this.wrapCheckbox = new JCheckBox();
        this.ruleScrollPane.setViewportView(this.ruleViewPane);
        this.wrapCheckbox.setText(DecisionTreeEditorLrb.get("WRAP_RULE_OPTION"));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.wrapCheckbox, -2, 71, -2).addContainerGap(369, Short.MAX_VALUE)).addComponent(this.ruleScrollPane, GroupLayout.Alignment.TRAILING, -1, 440, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.ruleScrollPane, -1, 66, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wrapCheckbox)));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        final DecisionTreePreferencesSettings decisionTreePreferencesSettings = DecisionTreePreferencesSettings.getInstance();
        this.wrapCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = decisionTreePreferencesSettings.getWrapNodeRules();
                bl = !bl;
                decisionTreePreferencesSettings.setWrapNodeRules(bl);
                String string = TreeRule.getRulesHtml(RulePane.this.treeNode, bl);
                RulePane.this.displayRules(string);
            }
        });
        boolean bl = decisionTreePreferencesSettings.getWrapNodeRules();
        this.wrapCheckbox.setSelected(bl);
        String string = TreeRule.getRulesHtml(this.treeNode, bl);
        this.displayRules(string);
    }

    private void displayRules(String string) {
        this.ruleViewPane.setContentType("text/html");
        this.ruleViewPane.setText(string);
        this.ruleViewPane.select(0, 0);
        this.ruleViewPane.setEditable(false);
    }
}

