/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree;

import ilog.views.IlvManagerView;
import ilog.views.sdm.IlvSDMEngine;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.dmt.dataminer.mviewer.dt.schema.Node;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditor;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dtree.model.TreeNode;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;

public class DecisionTreeContextMenu
implements ContextMenuListener,
Controller {
    private static DecisionTreeContextMenu _instance = null;
    protected static int PRIMARY_EDIT_ACTION_ID = Ide.createCmdID((String)"EditNodeAction");
    protected static int SECONDARY_EDIT_ACTION_ID = Ide.createCmdID((String)"EditNodeActionSecondary");
    protected static int TERTIARY_EDIT_ACTION_ID = Ide.createCmdID((String)"EditNodeActionTertiary");

    public static DecisionTreeContextMenu getInstance() {
        if (_instance == null) {
            _instance = new DecisionTreeContextMenu();
        }
        return _instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        View view = context.getView();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        if (!(view instanceof DecisionTreeEditor)) return;
        Object object = ((DiagramView)view).getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)object);
        if (ilvSDMEngine == null) return;
        Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof TreeNode)) continue;
            arrayList.add((TreeNode)e);
        }
        if (arrayList.size() == 0) {
            return;
        }
        object = (TreeNode)arrayList.get(0);
        ilvSDMEngine = ((TreeNode)object).getData();
        int n = arrayList.size();
        IdeAction ideAction = IdeAction.get((int)PRIMARY_EDIT_ACTION_ID);
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ideAction, 1.0f);
        ideAction.addController((Controller)this);
        IdeAction ideAction2 = IdeAction.get((int)SECONDARY_EDIT_ACTION_ID);
        JMenuItem jMenuItem2 = contextMenu.createMenuItem((ToggleAction)ideAction2, 1.0f);
        ideAction2.addController((Controller)this);
        IdeAction ideAction3 = IdeAction.get((int)TERTIARY_EDIT_ACTION_ID);
        JMenuItem jMenuItem3 = contextMenu.createMenuItem((ToggleAction)ideAction3, 1.0f);
        ideAction3.addController((Controller)this);
        if (n != 1) return;
        if (this.isRequirePrimaryEditMenu((Node)ilvSDMEngine)) {
            jMenuItem.setText(this.getPrimaryEditMenuText((Node)ilvSDMEngine));
            contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
        }
        if (this.isRequireSecondaryEditMenu((Node)ilvSDMEngine)) {
            jMenuItem2.setText(this.getSecondaryEditMenuText((Node)ilvSDMEngine));
            contextMenu.add((Component)jMenuItem2, MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        }
        if (!this.isRequireTertiaryEditMenu((Node)ilvSDMEngine)) return;
        jMenuItem3.setText(this.getTertiaryEditMenuText((Node)ilvSDMEngine));
        contextMenu.add((Component)jMenuItem3, MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
    }

    private boolean isRequirePrimaryEditMenu(Node node) {
        return true;
    }

    private boolean isRequireSecondaryEditMenu(Node node) {
        return false;
    }

    private boolean isRequireTertiaryEditMenu(Node node) {
        return false;
    }

    private String getPrimaryEditMenuText(Node node) {
        if (node instanceof Node) {
            return DecisionTreeEditorLrb.get("EDIT_NODE");
        }
        if (node != null) {
            new Exception("Node type: " + node.getClass().getName() + " not handled in WorflowContextMenu.getPrimaryEditMenuText ()").printStackTrace();
        }
        return null;
    }

    private String getSecondaryEditMenuText(Node node) {
        return DecisionTreeEditorLrb.get("BUILD_NODE_SECONDARY");
    }

    private String getTertiaryEditMenuText(Node node) {
        return DecisionTreeEditorLrb.get("DATA_SOURCE_NODE_TERTIARY");
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public static void handlePrimaryEdit(Context context, DecisionTreeEditor decisionTreeEditor) throws Exception {
        TreeNode treeNode = decisionTreeEditor.getSelectedDiagramNode();
        if (!(treeNode instanceof TreeNode)) {
            new Exception("Node type: " + treeNode.getClass().getName() + " not handled in WorflowContextMenu.handlePrimaryEdit ()").printStackTrace();
        }
    }

    private void handleSecondaryEdit(Context context, DecisionTreeEditor decisionTreeEditor) throws Exception {
        TreeNode treeNode = decisionTreeEditor.getSelectedDiagramNode();
        if (!(treeNode instanceof TreeNode)) {
            new Exception("Node type: " + treeNode.getClass().getName() + " not handled in WorflowContextMenu.handleSecondaryEdit ()").printStackTrace();
        }
    }

    private void handleTertiaryEdit(Context context, DecisionTreeEditor decisionTreeEditor) throws Exception {
        TreeNode treeNode = decisionTreeEditor.getSelectedDiagramNode();
        if (!(treeNode instanceof TreeNode)) {
            new Exception("Node type: " + treeNode.getClass().getName() + " not handled in WorflowContextMenu.handleSecondaryEdit ()").printStackTrace();
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        View view = context.getView();
        if (!(view instanceof DecisionTreeEditor)) {
            return false;
        }
        DecisionTreeEditor decisionTreeEditor = (DecisionTreeEditor)view;
        if (ideAction.getCommandId() == PRIMARY_EDIT_ACTION_ID || ideAction.equals(IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES))) {
            try {
                DecisionTreeContextMenu.handlePrimaryEdit(context, decisionTreeEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == SECONDARY_EDIT_ACTION_ID) {
            try {
                this.handleSecondaryEdit(context, decisionTreeEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == TERTIARY_EDIT_ACTION_ID) {
            try {
                this.handleTertiaryEdit(context, decisionTreeEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        Object object;
        Object object2;
        View view = context.getView();
        if (!(view instanceof DecisionTreeEditor)) {
            return false;
        }
        DTModelNode dTModelNode = (DTModelNode)context.getNode();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        IlvManagerView ilvManagerView = ((DiagramView)view).getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            object2 = ilvSDMEngine.getSelectedObjects();
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                if (!(object instanceof TreeNode)) continue;
                arrayList.add((TreeNode)object);
            }
        } else {
            return true;
        }
        if (arrayList.size() == 0) {
            return true;
        }
        object2 = (TreeNode)arrayList.get(0);
        object = ((TreeNode)object2).getData();
        int n = arrayList.size();
        boolean bl = false;
        if (ideAction.getCommandId() == PRIMARY_EDIT_ACTION_ID || ideAction.equals(IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES))) {
            if (this.isRequirePrimaryEditMenu((Node)object)) {
                bl = n == 1 && !dTModelNode.isReadOnly();
            }
            ideAction.setEnabled(bl);
            return true;
        }
        if (ideAction.getCommandId() == SECONDARY_EDIT_ACTION_ID) {
            if (this.isRequireSecondaryEditMenu((Node)object)) {
                bl = n == 1 && !dTModelNode.isReadOnly();
            }
            ideAction.setEnabled(bl);
            return true;
        }
        if (ideAction.getCommandId() == TERTIARY_EDIT_ACTION_ID) {
            if (this.isRequireTertiaryEditMenu((Node)object)) {
                bl = n == 1 && !dTModelNode.isReadOnly();
            }
            ideAction.setEnabled(bl);
            return true;
        }
        return true;
    }
}

