/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.compare;

import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.GenericTableFixedColumns;
import oracle.dmt.dataminer.controls.HistogramBarRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.compare.CoefCompareMainPanel;
import oracle.dmt.dataminer.mviewer.compare.CompareLrb;
import oracle.dmt.dataminer.mviewer.compare.CompareState;
import oracle.dmt.dataminer.mviewer.compare.CompareTableModel;
import oracle.dmt.dataminer.mviewer.compare.NBProbabilitiesCompareTableModel;
import oracle.dmt.dataminer.mviewer.compare.SVMCPropensitiesCompareTableModel;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.server.model.CompareFilterSetting;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.wizard.group.GroupLrb;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.SwingWorker;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class CompareViewer
extends JPanel
implements DataminerGUIPanel {
    private ComponentWithTitlebar<JComponent> _jCoefViewerComponent;
    private CompareState _state;
    private Context _context;
    private CoefCompareMainPanel _mainPanel;
    private GenericTableFixedColumns jCoeffCompareNiceTable = new CustomGenericTable();
    private JScrollPane jScrollPane1;
    JLabel _jRowsOutOfTotalLabel = new JLabel();
    private JComponent _findPane;
    private SearchField _jFilterCtl = new SearchField();
    public static final int COMPARE_FILTER_COEFFICIENT_ALL_OR = 0;
    public static final int COMPARE_FILTER_COEFFICIENT_ALL_AND = 1;
    public static final int COMPARE_FILTER_COLUMN_NAME = 2;
    public static final int COMPARE_FILTER_COLUMN_VALUE = 3;
    public static final int COMPARE_FILTER_COLUMN_PROPENSITY_FOR_TARGET_ONE = 4;
    public static final int COMPARE_FILTER_COLUMN_PROPENSITY_FOR_TARGET_TWO = 5;
    private static final int COMPARE_FROZEN_COLUMNS = 0;
    private SearchCategory _defaultNBSearchCategory = new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_ATTRIBUTE_NAME"));
    private SearchCategory _defaultSVMSearchCategory = new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_ATTRIBUTE_NAME"));
    private SearchCategory _defaultGLMSearchCategory = new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_ATTRIBUTE_NAME"));
    private int _currentSearchCategory = 2;
    private NumberFormat _labelFormat = NumericFormat.getInstance(true, 8, 1, 0);
    private boolean _loadedFilterSetting = false;
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);

    public CompareViewer(CoefCompareMainPanel coefCompareMainPanel, Context context, CompareState compareState) {
        this._mainPanel = coefCompareMainPanel;
        this._context = context;
        this._state = compareState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jCoefViewerComponent = new ComponentWithTitlebar();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this._jCoefViewerComponent, -1, 634, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jCoefViewerComponent, -1, 266, Short.MAX_VALUE));
    }

    @Override
    public void initRes() {
        this.loadRowsOutOfTotalLabel(new Integer(0), new Integer(0));
    }

    @Override
    public void initUI() {
        this.setLoading(true);
        this.jScrollPane1 = new JScrollPane((Component)((Object)this.jCoeffCompareNiceTable));
        this.jCoeffCompareNiceTable.setFillsViewportHeight(true);
        this._jCoefViewerComponent.setComponent((JComponent)this.jScrollPane1);
        this._jCoefViewerComponent.setLabel(this._jRowsOutOfTotalLabel);
        ControlBar controlBar = new ControlBar();
        this.setupFilterControl(controlBar);
        this._jCoefViewerComponent.setControlBar(controlBar);
        this.jCoeffCompareNiceTable.setSelectionMode(2);
        this.jCoeffCompareNiceTable.setShowGrid(true);
        this.initializeControls();
        this._labelFormat.setMaximumFractionDigits(this._modelViewerPrefenceSettings.getNumericalPrecisionLevel());
        this._labelFormat.setMinimumFractionDigits(this._modelViewerPrefenceSettings.getNumericalPrecisionLevel());
        this._labelFormat.setMinimumIntegerDigits(1);
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    private void setupFilterControl(ControlBar controlBar) {
        this._findPane = new Box(2);
        this._jFilterCtl = this.searchField();
        if (this.isSVM()) {
            this.setupSVMFilterCtl();
        } else if (this.isGLM()) {
            this.setupGLMFilterCtl();
        } else if (this.isNB()) {
            this.setupNBFilterCtl();
        } else if (!this.isAnomaly()) assert (false) : "Unsupported model node";
        this._findPane.setName("Find");
        this._findPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this._findPane.add((Component)this._jFilterCtl);
        Dimension dimension = this._findPane.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 145);
        Dimension dimension3 = this.derive(dimension, 80);
        this._findPane.setPreferredSize(dimension2);
        this._findPane.setMaximumSize(dimension2);
        this._findPane.setMinimumSize(dimension3);
        controlBar.add((Component)this._findPane);
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private SearchField searchField() {
        SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                CompareViewer.this.translateSearchCategoryToConstant(CompareViewer.this._jFilterCtl.getSelectedCategory());
                CompareViewer.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                CompareViewer.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                CompareViewer.this.processFilter(string);
            }
        });
        return searchField;
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = CompareLrb.get("PROPENSITIES_ROWS_OUT_OF_TOTAL");
        int n3 = 1;
        if (n == 0 && n2 == 0) {
            n3 = 0;
        }
        if (this.isSVM() || this.isGLM() || this.isNB() || this.isAnomaly()) {
            n3 = 0;
        }
        Integer n4 = new Integer(n2 + n3);
        String string2 = NumericFormat.format(n);
        String string3 = NumericFormat.format(n4);
        String string4 = MessageFormat.format(string, string2, string3);
        this._jRowsOutOfTotalLabel.setText(string4);
    }

    private void setLoading(boolean bl) {
        this._mainPanel.updateLoading(bl);
    }

    private void setLoaded(boolean bl) {
        if (!this._loadedFilterSetting) {
            this._mainPanel.setFilterPanelInitialState(this._state.getFilterSetting());
            this._loadedFilterSetting = true;
        }
        this._mainPanel.updateLoaded(bl);
    }

    public void setFilterState(CompareFilterSetting compareFilterSetting) {
        if (this.isLoading()) {
            return;
        }
        this._state.setFilterSetting(compareFilterSetting);
        this.prepareReload();
    }

    public CompareFilterSetting getCachedFilterState() {
        return this._state.getCachedFilterSetting();
    }

    public void setCachedFilterState(CompareFilterSetting compareFilterSetting) {
        this._state.setCachedFilterSetting(compareFilterSetting);
    }

    void prepareReload() {
        this.setLoading(true);
        this.prepareForNewQuery();
        LoadUI loadUI = new LoadUI(true);
        loadUI.start();
    }

    private void prepareForNewQuery() {
        this._state.clearRows();
        if (this._state.isNB() || this._state.isSVM() || this._state.isGLM() || this._state.isAnomaly()) {
            CoefficientRowData coefficientRowData = new CoefficientRowData(CompareLrb.get("COEFFICIENT_LOADING"));
            this._state.addRow(coefficientRowData);
            this.jCoeffCompareNiceTable.setModel((TableModel)((Object)this._state.getTableModel()));
        }
        this.jCoeffCompareNiceTable.setSorted(false);
        this.enableControls(false);
    }

    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    private void initializeControls() {
        CompareTableModel compareTableModel = null;
        if (this.isNB()) {
            CoefficientRowData coefficientRowData = new CoefficientRowData(CompareLrb.get("COEFFICIENT_LOADING"));
            compareTableModel = new NBProbabilitiesCompareTableModel();
            compareTableModel.addRow(coefficientRowData);
            this.jCoeffCompareNiceTable.setModel((TableModel)((Object)compareTableModel));
        } else if (this.isSVM()) {
            CoefficientRowData coefficientRowData = new CoefficientRowData(CompareLrb.get("COEFFICIENT_LOADING"));
            compareTableModel = new SVMCPropensitiesCompareTableModel();
            compareTableModel.addRow(coefficientRowData);
            this.jCoeffCompareNiceTable.setModel((TableModel)((Object)compareTableModel));
        } else if (this.isGLM()) {
            CoefficientRowData coefficientRowData = new CoefficientRowData(CompareLrb.get("COEFFICIENT_LOADING"));
            compareTableModel = new SVMCPropensitiesCompareTableModel();
            compareTableModel.addRow(coefficientRowData);
            this.jCoeffCompareNiceTable.setModel((TableModel)((Object)compareTableModel));
        } else if (!this.isAnomaly()) assert (false) : "Unsupported model node";
        this.setupLoadingTable();
    }

    private void setupLoadingTable() {
        this.jCoeffCompareNiceTable.setFixedColumnCount(0);
        this.jCoeffCompareNiceTable.setModel((TableModel)((Object)new LoadingTableModel()));
        this.jCoeffCompareNiceTable.findOrCreateTableRowHeader(this.jScrollPane1);
        this.jCoeffCompareNiceTable.setSorted(false);
        this.jCoeffCompareNiceTable.setCellRenderers();
    }

    private void setupNBFilterCtl() {
        this._currentSearchCategory = 2;
        this._jFilterCtl.addCategory(new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_ALL_OR")));
        this._jFilterCtl.addCategory(new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_ALL_AND")));
        this._jFilterCtl.addCategory(this._defaultNBSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_ATTRIBUTE_VALUE")));
        this._jFilterCtl.addCategory(new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_PROPENSITY_ONE")));
        this._jFilterCtl.addCategory(new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_PROPENSITY_TWO")));
        this._jFilterCtl.setSelectedCategory(this._defaultNBSearchCategory);
    }

    private void setupSVMFilterCtl() {
        this._currentSearchCategory = 2;
        this._jFilterCtl.addCategory(new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_ALL_OR")));
        this._jFilterCtl.addCategory(new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_ALL_AND")));
        this._jFilterCtl.addCategory(this._defaultSVMSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_ATTRIBUTE_VALUE")));
        this._jFilterCtl.addCategory(new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_PROPENSITY_ONE")));
        this._jFilterCtl.addCategory(new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_PROPENSITY_TWO")));
        this._jFilterCtl.setSelectedCategory(this._defaultSVMSearchCategory);
    }

    private void setupGLMFilterCtl() {
        this._currentSearchCategory = 2;
        this._jFilterCtl.addCategory(new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_ALL_OR")));
        this._jFilterCtl.addCategory(new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_ALL_AND")));
        this._jFilterCtl.addCategory(this._defaultGLMSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_ATTRIBUTE_VALUE")));
        this._jFilterCtl.addCategory(new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_PROPENSITY_ONE")));
        this._jFilterCtl.addCategory(new SearchCategory(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_PROPENSITY_TWO")));
        this._jFilterCtl.setSelectedCategory(this._defaultGLMSearchCategory);
    }

    public HelpInfo getHelpInfo() {
        return this._state.getHelpInfo();
    }

    private boolean isNB() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof NBModelNode;
    }

    private boolean isSVM() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        if (modelNode instanceof SVMCModelNode) {
            return ((SVMCModelNode)modelNode).isLinearKernel() != false;
        }
        return false;
    }

    private boolean isAnomaly() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        if (modelNode instanceof ANModelNode) {
            return ((ANModelNode)modelNode).isLinearKernel() != false;
        }
        return false;
    }

    private boolean isGLM() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof GLMCModelNode;
    }

    private void processFilter(String string) {
        try {
            if (this._state.isNB()) {
                NBProbabilitiesCompareTableModel nBProbabilitiesCompareTableModel = this._state.getNBFilteredPropensities(string, this._currentSearchCategory);
                this.setupCompareTable(nBProbabilitiesCompareTableModel);
            } else if (this._state.isSVM()) {
                SVMCPropensitiesCompareTableModel sVMCPropensitiesCompareTableModel = this._state.getSVMFilteredPropensities(string, this._currentSearchCategory);
                this.setupCompareTable(sVMCPropensitiesCompareTableModel);
            } else if (this._state.isGLM()) {
                SVMCPropensitiesCompareTableModel sVMCPropensitiesCompareTableModel = this._state.getGLMFilteredPropensities(string, this._currentSearchCategory);
                this.setupCompareTable(sVMCPropensitiesCompareTableModel);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)GroupLrb.get("CREATE_GROUP_FAILURE_TITLE"), (String)GroupLrb.get("CREATE_GROUP_FAILURE_MESG"), null);
        }
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = -1;
        if (this._state.isNB() || this._state.isSVM() || this._state.isGLM() || this._state.isAnomaly()) {
            if (searchCategory.getLabel().equals(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_ALL_OR"))) {
                this._currentSearchCategory = 0;
            } else if (searchCategory.getLabel().equals(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_ALL_AND"))) {
                this._currentSearchCategory = 1;
            } else if (searchCategory.getLabel().equals(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_ATTRIBUTE_NAME"))) {
                this._currentSearchCategory = 2;
            } else if (searchCategory.getLabel().equals(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_ATTRIBUTE_VALUE"))) {
                this._currentSearchCategory = 3;
            } else if (searchCategory.getLabel().equals(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_PROPENSITY_ONE"))) {
                this._currentSearchCategory = 4;
            } else if (searchCategory.getLabel().equals(CompareLrb.get("COMPARE_EDITOR_FILTER_CATEGORY_PROPENSITY_TWO"))) {
                this._currentSearchCategory = 5;
            } else assert (false) : "Invalid Search Category Code";
        } else assert (false) : "Invalid Search Category Code";
        return n;
    }

    private void setupCompareTable(CompareTableModel compareTableModel) {
        compareTableModel.updatePropensityColumnIdentifiers(this.isAnomaly() ? CoefViewerState.predictiveValuesToString(this._state.getSelectedTargetClass()) : this._state.getSelectedTargetClass().toString(), this.isAnomaly() ? CoefViewerState.predictiveValuesToString(this._state.getSecondSelectedTargetClass()) : this._state.getSecondSelectedTargetClass().toString());
        this.jCoeffCompareNiceTable.setFixedColumnCount(0);
        this.jCoeffCompareNiceTable.setModel((TableModel)((Object)compareTableModel));
        this.jCoeffCompareNiceTable.findOrCreateTableRowHeader(this.jScrollPane1);
        this.jCoeffCompareNiceTable.setSorted(true);
        this.jCoeffCompareNiceTable.addDynamicCellRenderers();
        this.jCoeffCompareNiceTable.setCellRenderers();
        if (this.isAnomaly()) {
            this.jCoeffCompareNiceTable.setSortColumn(2, false);
            this.jCoeffCompareNiceTable.setSortColumn(3, false);
        }
    }

    private void enableControls(boolean bl) {
        this._jFilterCtl.setEnabled(bl);
    }

    class LoadingTableModel
    extends GenericBaseTableModel {
        public final int NAME = 0;
        public final int COLUMN_COUNT = 1;
        private String[] columnNames = new String[]{CoefficientsLrb.get("PRIORS_ATTRIBUTE_NAME")};

        LoadingTableModel() {
            this.setColumnIdentifiers(this.columnNames);
            this.setRowCount(1);
            this.setColumnCount(this.columnNames.length);
        }

        public Object getValueAt(int n, int n2) {
            return CompareLrb.get("COEFFICIENT_LOADING");
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        public Object construct() {
            try {
                if (this._reload) {
                    CompareViewer.this._state.reloadPropensities();
                } else {
                    CompareViewer.this._state.load();
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return CompareViewer.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    if (CompareViewer.this._jFilterCtl.getText().trim().length() > 0) {
                        if (CompareViewer.this._state.isNB()) {
                            CompareViewer.this.setupCompareTable(CompareViewer.this._state.getNBFilteredPropensities(CompareViewer.this._jFilterCtl.getText(), CompareViewer.this._currentSearchCategory));
                        } else if (CompareViewer.this._state.isSVM() || CompareViewer.this.isAnomaly()) {
                            if (CompareViewer.this.isAnomaly()) {
                                CompareViewer.this._state.setSortByAbsoluteValue(CompareViewer.this._state.getFilterSetting().getFilterAndSortByAbsolute());
                            }
                            CompareViewer.this.setupCompareTable(CompareViewer.this._state.getSVMFilteredPropensities(CompareViewer.this._jFilterCtl.getText(), CompareViewer.this._currentSearchCategory));
                        } else if (CompareViewer.this._state.isGLM()) {
                            CompareViewer.this.setupCompareTable(CompareViewer.this._state.getGLMFilteredPropensities(CompareViewer.this._jFilterCtl.getText(), CompareViewer.this._currentSearchCategory));
                        }
                    } else if (CompareViewer.this._state.isNB() || CompareViewer.this._state.isSVM() || CompareViewer.this._state.isGLM() || CompareViewer.this._state.isAnomaly()) {
                        if (CompareViewer.this.isAnomaly()) {
                            CompareViewer.this._state.setSortByAbsoluteValue(CompareViewer.this._state.getFilterSetting().getFilterAndSortByAbsolute());
                        }
                        CompareViewer.this.setupCompareTable(CompareViewer.this._state.getTableModel());
                    }
                    CompareViewer.this._mainPanel.updateTargetCombos();
                    CompareViewer.this.loadRowsOutOfTotalLabel(new Integer(CompareViewer.this._state.getTableModel().getRowCount()), CompareViewer.this._state.getTotalDetailCount());
                    CompareViewer.this.enableControls(true);
                    CompareViewer.this.setLoaded(true);
                } else {
                    if (CompareViewer.this._state.getTableModel() != null) {
                        CompareViewer.this._state.clearRows();
                        if (CompareViewer.this._state.isNB() || CompareViewer.this._state.isSVM() || CompareViewer.this._state.isGLM() || CompareViewer.this._state.isAnomaly()) {
                            CoefficientRowData coefficientRowData = new CoefficientRowData(CompareLrb.get("COEFFICIENT_FAILURE"));
                            CompareViewer.this._state.addRow(coefficientRowData);
                            CompareViewer.this.setupCompareTable(CompareViewer.this._state.getTableModel());
                        }
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)CompareLrb.get("COEFFICIENT_VIEWER_FAILURE_TITLE"), (String)CompareLrb.get("COEFFICIENT_VIEWER_FAILURE_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), null, (String)CompareLrb.get("COEFFICIENT_VIEWER_FAILURE_TITLE"), (String)CompareLrb.get("COEFFICIENT_VIEWER_FAILURE_MESG"));
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CompareLrb.get("COEFFICIENT_VIEWER_FAILURE_TITLE"), (String)CompareLrb.get("COEFFICIENT_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                CompareViewer.this.setLoading(false);
            }
        }
    }

    class CustomHistogramBarRenderer
    extends HistogramBarRenderer {
        public CustomHistogramBarRenderer(long l, boolean bl, NumberFormat numberFormat) {
            super(l, bl, numberFormat);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    class CustomGenericTable
    extends GenericTableFixedColumns {
        CustomGenericTable() {
        }

        protected void setColumnVisible(TableColumn tableColumn, int n, boolean bl) {
        }

        @Override
        protected void handleSelectionChanged(ListSelectionModel listSelectionModel) {
        }

        @Override
        public void addDynamicCellRenderers() {
            if (CompareViewer.this._state.isNB() || CompareViewer.this._state.isSVM() || CompareViewer.this._state.isGLM() || CompareViewer.this._state.isAnomaly()) {
                this.addCellRenderer(CompareViewer.this._state.getTableModel().getColumnName(2), new CustomHistogramBarRenderer(1L, true, CompareViewer.this._labelFormat));
                this.addCellRenderer(CompareViewer.this._state.getTableModel().getColumnName(3), new CustomHistogramBarRenderer(1L, true, CompareViewer.this._labelFormat));
            }
        }
    }
}

