/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.utils.AbsoluteNumberComparator;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.javatools.ui.search.SearchMatcher;

public class NBProbabilitiesTableModel
extends GenericBaseTableModel {
    private Vector<CoefficientRowData> _data = new Vector();
    private static final int COLUMN_COUNT = 3;
    public static final int ATTRIBUTE = 0;
    public static final int VALUE = 1;
    public static final int PROBABILITY = 2;
    private boolean _absoluteSort = false;
    private String[] _columnNames = new String[]{CoefficientsLrb.get("PRIORS_ATTRIBUTE_NAME"), CoefficientsLrb.get("PRIORS_ATTRIBUTE_VALUE"), CoefficientsLrb.get("PRIORS_ATTRIBUTE_PROBABILITY")};

    public NBProbabilitiesTableModel() {
        this.setColumnIdentifiers(this._columnNames);
        this.setRowCount(0);
        this.setColumnCount(3);
    }

    public NBProbabilitiesTableModel(Vector<CoefficientRowData> vector) {
        this.setColumnIdentifiers(this._columnNames);
        this._data = vector;
        this.setRowCount(vector.size());
        this.setColumnCount(3);
    }

    public void updateColumnIdentifiers(String string) {
        Object[] objectArray = new String[this._columnNames.length];
        System.arraycopy(this._columnNames, 0, objectArray, 0, this._columnNames.length);
        objectArray[2] = objectArray[2] + string;
        this.setColumnIdentifiers(objectArray);
    }

    public int getRowCount() {
        return this._data == null ? 0 : this._data.size();
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public CoefficientRowData getRow(int n) {
        return this._data.get(n);
    }

    public Vector<CoefficientRowData> getDataVector() {
        return this._data;
    }

    public Comparator getColumnSortComparator(int n) {
        Comparator comparator = null;
        comparator = this._absoluteSort && n == 2 ? AbsoluteNumberComparator.getComparator() : super.getColumnSortComparator(n);
        return comparator;
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        CoefficientRowData coefficientRowData = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = coefficientRowData.getAttributeFullName();
                break;
            }
            case 1: {
                object = coefficientRowData.getValue();
                break;
            }
            case 2: {
                if (coefficientRowData.getCoefficient1() != null) {
                    object = coefficientRowData.getCoefficient1() * 100.0;
                    break;
                }
                object = coefficientRowData.getCoefficient1();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing coefficients";
                break;
            }
        }
        return object == null ? " " : object;
    }

    public void setAbsoluteValueSort(boolean bl) {
        this._absoluteSort = bl;
    }

    public boolean getAbsoluteValueSort() {
        return this._absoluteSort;
    }

    public void addRow(CoefficientRowData coefficientRowData) {
        this._data.add(coefficientRowData);
    }

    public void addRows(Vector<CoefficientRowData> vector) {
        for (CoefficientRowData coefficientRowData : vector) {
            this._data.add(coefficientRowData);
        }
    }

    public NBProbabilitiesTableModel getFilteredProbabilities(String string, int n) throws Exception {
        SearchMatcher searchMatcher;
        Vector<CoefficientRowData> vector = null;
        boolean bl = n == 0;
        switch (n) {
            case 2: 
            case 3: {
                searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
                break;
            }
            case 0: 
            case 1: 
            case 4: {
                searchMatcher = SearchMatcher.getPrefixMatcher((CharSequence)string, (boolean)true, (boolean)bl);
                break;
            }
            default: {
                assert (false) : "Invalid coefficient filter category.";
                searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
            }
        }
        Vector<CoefficientRowData> vector2 = this.getDataVector();
        vector = new Vector<CoefficientRowData>();
        Iterator<CoefficientRowData> iterator = vector2.iterator();
        CoefficientRowData coefficientRowData = null;
        boolean bl2 = string.length() <= 0;
        boolean bl3 = false;
        while (iterator.hasNext()) {
            coefficientRowData = iterator.next();
            if (bl2) {
                bl3 = true;
            } else {
                String string2;
                switch (n) {
                    case 2: {
                        string2 = coefficientRowData.getAttributeFullName();
                        break;
                    }
                    case 3: {
                        string2 = coefficientRowData.getValue();
                        break;
                    }
                    case 4: {
                        string2 = coefficientRowData.getCoefficient1() != null ? NumericFormat.format(coefficientRowData.getCoefficient1() * 100.0, true, 8) + "" : "";
                        break;
                    }
                    case 0: 
                    case 1: {
                        String string3 = coefficientRowData.getCoefficient1() != null ? NumericFormat.format(coefficientRowData.getCoefficient1() * 100.0, true, 8) + "" : "";
                        string2 = coefficientRowData.getAttributeFullName() + " " + coefficientRowData.getValue() + " " + string3;
                        break;
                    }
                    default: {
                        assert (false) : "Invalid coefficient filter category.";
                        string2 = coefficientRowData.getAttributeFullName();
                    }
                }
                bl3 = searchMatcher.matches((CharSequence)string2);
            }
            if (!bl3) continue;
            vector.add(coefficientRowData);
        }
        return new NBProbabilitiesTableModel(vector);
    }
}

