/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.server.model.GLMCoefficientRowData;
import oracle.dmt.dataminer.utils.AbsoluteNumberComparator;
import oracle.dmt.dataminer.utils.NumberComparator;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.javatools.ui.search.SearchMatcher;

public class GLMCoefViewerTableModel
extends GenericBaseTableModel {
    private Vector<GLMCoefficientRowData> _data = new Vector(1000, 500);
    private boolean _covarianceMatrixTrue = true;
    private boolean _classification = true;
    private static final int COLUMN_CLASSIFICATION_COUNT = 12;
    private static final int COLUMN_REGRESSION_COUNT = 9;
    private static final int COLUMN_COUNT_COVARIANCE_FALSE = 5;
    private static final int COLUMN_COUNT_COVARIANCE_FALSE_REGRESSION = 4;
    public static final int ATTRIBUTE = 0;
    public static final int VALUE = 1;
    public static final int COEEFICIENT = 2;
    public static final int STD_COEFFICIENT = 3;
    public static final int STD_ERROR = 4;
    public static final int TEST_STATISTIC = 5;
    public static final int P_VALUE = 6;
    public static final int LOWER_COEFF_LIMIT = 7;
    public static final int UPPER_COEFF_LIMIT = 8;
    public static final int EXP_LOWER_COEFF_LIMIT = 10;
    public static final int EXP_UPPER_COEFF_LIMIT = 11;
    private boolean _absoluteSort = false;
    private String[] _columnNamesClassification = new String[]{CoefficientsLrb.get("ATTRIBUTE_COLUMN"), CoefficientsLrb.get("VALUE_COLUMN"), CoefficientsLrb.get("COEFFICIENT_COLUMN"), CoefficientsLrb.get("STD_COEFFICIENT_COLUMN"), CoefficientsLrb.get("STD_ERROR_COLUMN"), CoefficientsLrb.get("TEST_STATISTIC_COLUMN"), CoefficientsLrb.get("P_VALUE_COLUMN"), CoefficientsLrb.get("LOWER_COEFF_LIMIT_COLUMN"), CoefficientsLrb.get("UPPER_COEFF_LIMIT_COLUMN"), CoefficientsLrb.get("EXP_COEFFICIENT_COLUMN"), CoefficientsLrb.get("EXP_LOWER_COEFF_LIMIT_COLUMN"), CoefficientsLrb.get("EXP_UPPER_COEFF_LIMIT_COLUMN")};
    private String[] _columnNamesRegression = new String[]{CoefficientsLrb.get("ATTRIBUTE_COLUMN"), CoefficientsLrb.get("VALUE_COLUMN"), CoefficientsLrb.get("COEFFICIENT_COLUMN"), CoefficientsLrb.get("STD_COEFFICIENT_COLUMN"), CoefficientsLrb.get("STD_ERROR_COLUMN"), CoefficientsLrb.get("TEST_STATISTIC_COLUMN"), CoefficientsLrb.get("P_VALUE_COLUMN"), CoefficientsLrb.get("LOWER_COEFF_LIMIT_COLUMN"), CoefficientsLrb.get("UPPER_COEFF_LIMIT_COLUMN")};
    private String[] _columnNamesCovarianceFalse = new String[]{CoefficientsLrb.get("ATTRIBUTE_COLUMN"), CoefficientsLrb.get("VALUE_COLUMN"), CoefficientsLrb.get("COEFFICIENT_COLUMN"), CoefficientsLrb.get("STD_COEFFICIENT_COLUMN"), CoefficientsLrb.get("EXP_COEFFICIENT_COLUMN")};
    private String[] _columnNamesCovarianceFalseRegression = new String[]{CoefficientsLrb.get("ATTRIBUTE_COLUMN"), CoefficientsLrb.get("VALUE_COLUMN"), CoefficientsLrb.get("COEFFICIENT_COLUMN"), CoefficientsLrb.get("STD_COEFFICIENT_COLUMN")};

    public GLMCoefViewerTableModel() {
        this.setColumnIdentifiers(this._columnNamesClassification);
        this.setRowCount(0);
        this.setColumnCount(12);
    }

    public GLMCoefViewerTableModel(Vector<GLMCoefficientRowData> vector, boolean bl, boolean bl2) {
        this._covarianceMatrixTrue = bl;
        this._classification = bl2;
        if (this._covarianceMatrixTrue) {
            if (bl2) {
                this.setColumnIdentifiers(this._columnNamesClassification);
                this.setColumnCount(12);
            } else {
                this.setColumnIdentifiers(this._columnNamesRegression);
                this.setColumnCount(9);
            }
        } else if (bl2) {
            this.setColumnIdentifiers(this._columnNamesCovarianceFalse);
            this.setColumnCount(5);
        } else {
            this.setColumnIdentifiers(this._columnNamesCovarianceFalseRegression);
            this.setColumnCount(4);
        }
        this._data = vector;
        this.setRowCount(vector.size());
    }

    public int getColumn_Exp_Cofficient_Column_Number() {
        if (this._classification && this._covarianceMatrixTrue) {
            return 9;
        }
        if (this._classification) {
            return 4;
        }
        return -1;
    }

    public GLMCoefViewerTableModel getFilteredCoefficients(String string, int n) throws Exception {
        SearchMatcher searchMatcher;
        Vector<GLMCoefficientRowData> vector = null;
        boolean bl = n == 0;
        switch (n) {
            case 2: 
            case 3: {
                searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
                break;
            }
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                searchMatcher = SearchMatcher.getPrefixMatcher((CharSequence)string, (boolean)true, (boolean)bl);
                break;
            }
            default: {
                assert (false) : "Invalid coefficient filter category.";
                searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
            }
        }
        Vector<GLMCoefficientRowData> vector2 = this.getDataVector();
        vector = new Vector<GLMCoefficientRowData>(1000, 500);
        Iterator<GLMCoefficientRowData> iterator = vector2.iterator();
        GLMCoefficientRowData gLMCoefficientRowData = null;
        boolean bl2 = string.length() <= 0;
        boolean bl3 = false;
        while (iterator.hasNext()) {
            gLMCoefficientRowData = iterator.next();
            if (bl2) {
                bl3 = true;
            } else {
                String string2;
                switch (n) {
                    case 2: {
                        string2 = gLMCoefficientRowData.getAttributeFullName();
                        break;
                    }
                    case 3: {
                        string2 = gLMCoefficientRowData.getValue();
                        break;
                    }
                    case 4: {
                        string2 = gLMCoefficientRowData.getCoefficient1() != null ? NumericFormat.format(gLMCoefficientRowData.getCoefficient1(), true, 8) + "" : "";
                        break;
                    }
                    case 5: {
                        string2 = gLMCoefficientRowData.getStd_error() != null ? NumericFormat.format(gLMCoefficientRowData.getStd_error(), true, 8) + "" : "";
                        break;
                    }
                    case 6: {
                        string2 = gLMCoefficientRowData.getTest_statistic() != null ? NumericFormat.format(gLMCoefficientRowData.getTest_statistic(), true, 8) + "" : "";
                        break;
                    }
                    case 7: {
                        string2 = gLMCoefficientRowData.getP_value() != null ? NumericFormat.format(gLMCoefficientRowData.getP_value(), true, 8) + "" : "";
                        break;
                    }
                    case 8: {
                        string2 = gLMCoefficientRowData.getStd_coefficient() != null ? NumericFormat.format(gLMCoefficientRowData.getStd_coefficient(), true, 8) + "" : "";
                        break;
                    }
                    case 9: {
                        string2 = gLMCoefficientRowData.getLower_coeff_limit() != null ? NumericFormat.format(gLMCoefficientRowData.getLower_coeff_limit(), true, 8) + "" : "";
                        break;
                    }
                    case 10: {
                        string2 = gLMCoefficientRowData.getUpper_coeff_limit() != null ? NumericFormat.format(gLMCoefficientRowData.getUpper_coeff_limit(), true, 8) + "" : "";
                        break;
                    }
                    case 11: {
                        string2 = gLMCoefficientRowData.getExp_coefficient() != null ? NumericFormat.format(gLMCoefficientRowData.getExp_coefficient(), true, 8) + "" : "";
                        break;
                    }
                    case 12: {
                        string2 = gLMCoefficientRowData.getExp_lower_coeff_limit() != null ? NumericFormat.format(gLMCoefficientRowData.getExp_lower_coeff_limit(), true, 8) + "" : "";
                        break;
                    }
                    case 13: {
                        string2 = gLMCoefficientRowData.getExp_upper_coeff_limit() != null ? NumericFormat.format(gLMCoefficientRowData.getExp_upper_coeff_limit(), true, 8) + "" : "";
                        break;
                    }
                    case 0: 
                    case 1: {
                        string2 = gLMCoefficientRowData.getAttributeFullName() + " " + gLMCoefficientRowData.getValue();
                        break;
                    }
                    default: {
                        assert (false) : "Invalid coefficient filter category.";
                        string2 = gLMCoefficientRowData.getAttributeFullName();
                    }
                }
                bl3 = searchMatcher.matches((CharSequence)string2);
            }
            if (!bl3) continue;
            vector.add(gLMCoefficientRowData);
        }
        return new GLMCoefViewerTableModel(vector, this._covarianceMatrixTrue, this._classification);
    }

    public void addRows(Vector<GLMCoefficientRowData> vector) {
        for (GLMCoefficientRowData gLMCoefficientRowData : vector) {
            this.getDataVector().add(gLMCoefficientRowData);
        }
    }

    public int getRowCount() {
        if (this._data == null) {
            return 0;
        }
        return this._data.size();
    }

    public void clearRows() {
        this._data.clear();
        this.fireTableDataChanged();
    }

    public GLMCoefficientRowData getRow(int n) {
        return this._data.get(n);
    }

    public void addSelection(GLMCoefViewerTableModel gLMCoefViewerTableModel, int[] nArray) {
        Vector<GLMCoefficientRowData> vector = gLMCoefViewerTableModel.getDataVector();
        GLMCoefficientRowData gLMCoefficientRowData = null;
        for (int i = 0; i < nArray.length; ++i) {
            gLMCoefficientRowData = vector.elementAt(nArray[i]);
            this._data.add(gLMCoefficientRowData);
        }
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public Vector<GLMCoefficientRowData> getDataVector() {
        return this._data;
    }

    public void removeSelectedRows(int[] nArray) {
        Vector<GLMCoefficientRowData> vector = new Vector<GLMCoefficientRowData>();
        GLMCoefficientRowData gLMCoefficientRowData = null;
        for (int i = 0; i < nArray.length; ++i) {
            gLMCoefficientRowData = this._data.elementAt(nArray[i]);
            vector.add(gLMCoefficientRowData);
        }
        this._data.removeAll(vector);
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public Comparator getColumnSortComparator(int n) {
        Comparator comparator = null;
        comparator = this._absoluteSort && n != 0 && n != 1 ? AbsoluteNumberComparator.getComparator() : (!this._absoluteSort && n != 0 && n != 1 ? NumberComparator.getComparator() : super.getColumnSortComparator(n));
        return comparator;
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        GLMCoefficientRowData gLMCoefficientRowData = this._data.get(n);
        Object object = null;
        if (n2 == this.getColumn_Exp_Cofficient_Column_Number()) {
            object = gLMCoefficientRowData.getExp_coefficient();
            return object;
        }
        switch (n2) {
            case 0: {
                object = gLMCoefficientRowData.getAttributeFullName();
                break;
            }
            case 1: {
                object = gLMCoefficientRowData.getValue();
                break;
            }
            case 2: {
                object = gLMCoefficientRowData.getCoefficient1();
                break;
            }
            case 4: {
                object = gLMCoefficientRowData.getStd_error();
                break;
            }
            case 5: {
                object = gLMCoefficientRowData.getTest_statistic();
                break;
            }
            case 6: {
                object = gLMCoefficientRowData.getP_value();
                break;
            }
            case 3: {
                object = gLMCoefficientRowData.getStd_coefficient();
                break;
            }
            case 7: {
                object = gLMCoefficientRowData.getLower_coeff_limit();
                break;
            }
            case 8: {
                object = gLMCoefficientRowData.getUpper_coeff_limit();
                break;
            }
            case 10: {
                object = gLMCoefficientRowData.getExp_lower_coeff_limit();
                break;
            }
            case 11: {
                object = gLMCoefficientRowData.getExp_upper_coeff_limit();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing coefficients";
                break;
            }
        }
        if (object == null) {
            return "";
        }
        return object;
    }

    public void setAbsoluteValueSort(boolean bl) {
        this._absoluteSort = bl;
    }

    public boolean getAbsoluteValueSort() {
        return this._absoluteSort;
    }

    public void addRow(GLMCoefficientRowData gLMCoefficientRowData) {
        this._data.add(gLMCoefficientRowData);
        this.fireTableDataChanged();
    }

    public boolean isClassification() {
        return this._classification;
    }
}

