/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientItemTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.GLMCoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.NBProbabilitiesTableModel;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NMFModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMRModelNode;
import oracle.dmt.dataminer.server.model.Classification;
import oracle.dmt.dataminer.server.model.CoefficientBaseData;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.server.model.CoefficientSortSpec;
import oracle.dmt.dataminer.server.model.FeatureExtraction;
import oracle.dmt.dataminer.server.model.GLMCoefficientRowData;
import oracle.dmt.dataminer.server.model.GLMModelDetailsRowData;
import oracle.dmt.dataminer.server.model.GeneralizedLinearModelC;
import oracle.dmt.dataminer.server.model.GeneralizedLinearModelR;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.NaiveBayes;
import oracle.dmt.dataminer.server.model.SVMBiasRowData;
import oracle.dmt.dataminer.server.model.SortSpec;
import oracle.dmt.dataminer.server.model.SupportVectorMachinesAnomaly;
import oracle.dmt.dataminer.server.model.SupportVectorMachinesC;
import oracle.dmt.dataminer.server.model.SupportVectorMachinesR;
import oracle.dmt.dataminer.server.model.TargetPriorsPredictionSet;
import oracle.dmt.dataminer.utils.ObjectComparator;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.help.HelpInfo;
import oracle.javatools.data.PropertyStorage;

public class CoefViewerState {
    private boolean _loaded;
    private boolean _covarianceIndicator = true;
    private Vector<TargetPriorsPredictionSet> _targetValuePriors;
    private SupportVectorMachinesC _modelSVMClassification = null;
    private SupportVectorMachinesR _modelSVMRegression = null;
    private GeneralizedLinearModelC _modelGLMClassification = null;
    private GeneralizedLinearModelR _modelGLMRegression = null;
    private NaiveBayes _modelNaiveNayes;
    private FeatureExtraction _modelNMFFeature = null;
    private String _modelName;
    private String _userName;
    private Context _context;
    private CoefficientFilterSetting _filterSetting;
    private CoefficientFilterSetting _cachedFilterSetting;
    private CoefViewerTableModel _svmTableModel;
    private GLMCoefViewerTableModel _glmTableModel;
    private NBProbabilitiesTableModel _nbTableModel;
    private CoefViewerTableModel _nmfTableModel;
    private Vector<SVMBiasRowData> _classificationBias;
    private SVMBiasRowData _regressionBias;
    private ModelViewerState1 _modelViewerState1;
    private Object _selectedTargetClass;
    private CoefficientItemTableModel _filterItemTableModel;
    private Integer _totalDetailCount = new Integer(0);
    private Double _maximumABSCoefficient = new Double(0.0);
    private boolean _queryForTotalDetailCount = true;
    private Vector<CoefficientSortSpec> _sortSpecs = new Vector();
    public static final String SORT_OPTION_NAME = CoefficientsLrb.get("FILTER_SORT_OPTION_NAME");
    public static final String SORT_OPTION_NAME_SUBNAME = CoefficientsLrb.get("FILTER_SORT_OPTION_NAME_SUBNAME");
    public static final String SORT_OPTION_VALUE = CoefficientsLrb.get("FILTER_SORT_OPTION_VALUE");
    public static final String ORDER_BY_DESCENDING = CoefficientsLrb.get("DESCENDING");
    public static final String ORDER_BY_ASCENDING = CoefficientsLrb.get("ASCENDING");
    protected static final String[] SORT_ORDER_COMBO_VALUES = new String[]{ORDER_BY_DESCENDING, ORDER_BY_ASCENDING};
    private static Hashtable<String, String> _sortMap = new Hashtable();
    static final String TYPICAL;
    static final String OUTLIER;
    private String _predictiveValue;
    private static Map<String, Integer> _predictiveValues;
    private static Preferences _p;
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);

    public static String predictiveValuesToString(Object object) {
        if (object instanceof BigDecimal) {
            if (((BigDecimal)object).intValue() == 1) {
                return TYPICAL;
            }
            return OUTLIER;
        }
        return object.toString();
    }

    public static String getSortColumnName(String string) {
        return _sortMap.get(string);
    }

    public CoefViewerState(Context context) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
        try {
            this._sortSpecs.add(new CoefficientSortSpec("attribute_name_subname", SortSpec.SORT_DECENDING, true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isFeatureLabelUniquie(String string) {
        return this._modelNMFFeature.isFeatureLabelUniquie(string);
    }

    public void reloadFeatureValues() throws Exception {
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            this._targetValuePriors = this._modelNMFFeature.getTargetValuePredictionSet(connection, this._userName, this._modelName);
            this._filterSetting.setTargetValuePriors(this._targetValuePriors);
            this.loadDefaultTargetValue();
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public CoefViewerState reloadCoefficients() throws Exception {
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            if (this._queryForTotalDetailCount) {
                LoadTotalCount loadTotalCount = new LoadTotalCount(this._userName, this._modelName, this.generateTargetValuesCollection());
                loadTotalCount.start();
                this.loadCoefficients(connection);
                loadTotalCount.join();
                if (loadTotalCount.getException() != null) {
                    throw loadTotalCount.getException();
                }
                this._totalDetailCount = loadTotalCount.getCount();
                this._maximumABSCoefficient = loadTotalCount.getMaximumABSCoefficient();
                this._queryForTotalDetailCount = false;
            } else {
                this.initInternalTable();
                this.loadCoefficients(connection);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this;
    }

    public boolean isClassification() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof SVMCModelNode || modelNode instanceof GLMCModelNode || modelNode instanceof ANModelNode || modelNode instanceof NBModelNode;
    }

    public boolean isFeatureExtraction() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof NMFModelNode;
    }

    public boolean isRegression() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof SVMRModelNode || modelNode instanceof GLMRModelNode;
    }

    public boolean isSVM() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof SVMCModelNode || modelNode instanceof SVMRModelNode;
    }

    public boolean isAnomaly() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof ANModelNode;
    }

    public boolean isGLM() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof GLMCModelNode || modelNode instanceof GLMRModelNode;
    }

    public boolean isNB() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof NBModelNode;
    }

    public boolean isNMF() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof NMFModelNode;
    }

    public CoefViewerState load() throws Exception {
        Connection connection = null;
        Classification classification = new Classification();
        try {
            Object object;
            connection = Connections.getUniqueConnection(this._context);
            this._modelViewerState1 = new ModelViewerState1(this._context);
            this._modelViewerState1.load(connection);
            Model model = null;
            if (this._modelViewerState1.getOdmModel().getModelGeneralDescription().isClassificationModel() && this._modelViewerState1.getOdmModel().getModelGeneralDescription().isSupportVectorMachinesAlgorithm()) {
                model = this.isAnomaly() ? new SupportVectorMachinesAnomaly() : new SupportVectorMachinesC();
                this._modelSVMClassification = model;
            } else if (this._modelViewerState1.getOdmModel().getModelGeneralDescription().isRegressionModel() && this._modelViewerState1.getOdmModel().getModelGeneralDescription().isSupportVectorMachinesAlgorithm()) {
                model = new SupportVectorMachinesR();
                this._modelSVMRegression = (SupportVectorMachinesR)model;
            } else if (this._modelViewerState1.getOdmModel().getModelGeneralDescription().isClassificationModel() && this._modelViewerState1.getOdmModel().getModelGeneralDescription().isGeneralizedLinearModelAlgorithm()) {
                model = new GeneralizedLinearModelC();
                this._modelGLMClassification = (GeneralizedLinearModelC)model;
            } else if (this._modelViewerState1.getOdmModel().getModelGeneralDescription().isRegressionModel() && this._modelViewerState1.getOdmModel().getModelGeneralDescription().isGeneralizedLinearModelAlgorithm()) {
                model = new GeneralizedLinearModelR();
                this._modelGLMRegression = (GeneralizedLinearModelR)model;
            } else if (this._modelViewerState1.getOdmModel().getModelGeneralDescription().isClassificationModel() && this._modelViewerState1.getOdmModel().getModelGeneralDescription().isNaiveBayesAlgorithm()) {
                this._modelNaiveNayes = new NaiveBayes();
            } else if (this._modelViewerState1.getOdmModel().getModelGeneralDescription().isFeatureExtractionModel()) {
                model = new FeatureExtraction();
                this._modelNMFFeature = (FeatureExtraction)model;
            } else {
                throw new Exception(CoefficientsLrb.get("COEFFICIENT_VIEWER_UNRECOGNIZED_MODEL_TYPE"));
            }
            this._modelName = this._modelViewerState1.getModelName();
            this._userName = this._modelViewerState1.getUserName();
            this._filterSetting = new CoefficientFilterSetting(this);
            if (this.isAnomaly()) {
                this._filterSetting.setFilterByAbsolute(true);
            }
            this._cachedFilterSetting = new CoefficientFilterSetting(this);
            LoadCovarianceIndicator loadCovarianceIndicator = null;
            if (this.isGLM()) {
                loadCovarianceIndicator = new LoadCovarianceIndicator();
                loadCovarianceIndicator.start();
            }
            if (this.isClassification()) {
                if (this.isSVM() || this.isAnomaly()) {
                    object = null;
                    object = this._modelSVMClassification.getAbsMaxValue(connection, this._userName, this._modelName);
                    this._filterSetting.setMinCoefficient(new BigDecimal((Double)object * -1.0));
                    this._filterSetting.setMaxCoefficient(new BigDecimal((Double)object));
                    this._cachedFilterSetting.setMinCoefficient(new BigDecimal((Double)object * -1.0));
                    this._cachedFilterSetting.setMaxCoefficient(new BigDecimal((Double)object));
                } else if (this.isGLM()) {
                    object = this._modelGLMClassification.getMinMaxValue(connection, this._userName, this._modelName);
                    this._filterSetting.setMinCoefficient(new BigDecimal(object[0]));
                    this._filterSetting.setMaxCoefficient(new BigDecimal((Double)object[1]));
                    this._cachedFilterSetting.setMinCoefficient(new BigDecimal((Double)object[0]));
                    this._cachedFilterSetting.setMaxCoefficient(new BigDecimal((Double)object[1]));
                }
            } else if (this.isFeatureExtraction()) {
                object = null;
                object = this._modelNMFFeature.getMaxValue(connection, this._userName, this._modelName);
                this._filterSetting.setMinCoefficient(BigDecimal.ZERO);
                this._filterSetting.setMaxCoefficient(new BigDecimal((Double)object));
                this._cachedFilterSetting.setMinCoefficient(BigDecimal.ZERO);
                this._cachedFilterSetting.setMaxCoefficient(new BigDecimal((Double)object));
            }
            if (this.isClassification()) {
                this._targetValuePriors = classification.getTargetValuePredictionSet(connection, this._userName, this._modelName);
                if (this._targetValuePriors.size() <= 2 && this._targetValuePriors.size() != 2) {
                    throw new Exception(CoefficientsLrb.get("COEFFICIENT_VIEWER_NO_TARGET_PRIORS_VALUES"));
                }
                this._filterSetting.setTargetValuePriors(this._targetValuePriors);
            } else if (this.isRegression()) {
                object = classification.getRegressionModelTarget(connection, this._userName, this._modelName);
                this._filterSetting.setTargetValue(object);
            } else if (this.isFeatureExtraction()) {
                this._targetValuePriors = ((FeatureExtraction)model).getTargetValuePredictionSet(connection, this._userName, this._modelName);
                this._filterSetting.setTargetValuePriors(this._targetValuePriors);
            }
            this.loadDefaultTargetValue();
            object = new LoadTotalCount(this._userName, this._modelName, this.generateTargetValuesCollection());
            ((Thread)object).start();
            if (this.isGLM()) {
                loadCovarianceIndicator.join();
                if (loadCovarianceIndicator.getException() != null) {
                    throw loadCovarianceIndicator.getException();
                }
                this._covarianceIndicator = loadCovarianceIndicator.isIsCovarianceTrue();
            }
            this.initInternalTable();
            this.loadCoefficients(connection);
            ((Thread)object).join();
            if (((LoadTotalCount)object).getException() != null) {
                throw ((LoadTotalCount)object).getException();
            }
            this._totalDetailCount = ((LoadTotalCount)object).getCount();
            this._maximumABSCoefficient = ((LoadTotalCount)object).getMaximumABSCoefficient();
            this._queryForTotalDetailCount = false;
            this._loaded = true;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this;
    }

    private ArrayList<Object> generateTargetValuesCollection() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this._selectedTargetClass);
        return arrayList;
    }

    private void initInternalTable() {
        if (this.isSVM() || this.isAnomaly()) {
            Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
            if (this.isClassification()) {
                vector = new Vector();
            } else if (this.isRegression()) {
                vector = new Vector();
            }
            this._svmTableModel = new CoefViewerTableModel(vector);
        } else if (this.isGLM()) {
            boolean bl = false;
            Vector<GLMCoefficientRowData> vector = new Vector<GLMCoefficientRowData>();
            if (this.isClassification()) {
                vector = new Vector();
            } else if (this.isRegression()) {
                vector = new Vector();
            }
            this._glmTableModel = new GLMCoefViewerTableModel(vector, this.isCovarianceIndicator(), this.isClassification());
        } else if (this.isNB()) {
            Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
            this._nbTableModel = new NBProbabilitiesTableModel(vector);
        } else if (this.isNMF()) {
            Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
            vector = new Vector();
            this._nmfTableModel = new CoefViewerTableModel(vector);
        } else assert (false) : "CoefViewerState not loaded.";
    }

    private void loadDefaultTargetValue() {
        if (this.isClassification()) {
            if (this.isSVM() || this.isAnomaly()) {
                this.setSelectedTargetClass(this._modelSVMClassification.findMostCommonTargetValue(this._targetValuePriors).getPrediction());
            } else if (this.isGLM()) {
                this.setSelectedTargetClass(this._modelGLMClassification.findMostCommonTargetValue(this._targetValuePriors).getPrediction());
            } else if (this.isNB()) {
                this.setSelectedTargetClass(this._modelNaiveNayes.findMostCommonTargetValue(this._targetValuePriors).getPrediction());
            }
        } else if (this.isFeatureExtraction()) {
            this.setSelectedTargetClass(this._modelNMFFeature.findMostCommonTargetValue(this._targetValuePriors).getPrediction());
        }
    }

    private boolean loadCovarianceMatrixIndicator() throws Exception {
        boolean bl = false;
        Vector<GLMModelDetailsRowData> vector = null;
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            ModelNode modelNode = (ModelNode)this._context.getNode();
            vector = modelNode instanceof GLMCModelNode ? this._modelGLMClassification.getGlobalDetails(connection, this._userName, this._modelName) : this._modelGLMRegression.getGlobalDetails(connection, this._userName, this._modelName);
            for (GLMModelDetailsRowData gLMModelDetailsRowData : vector) {
                if (gLMModelDetailsRowData.getName().compareTo("VALID_COVARIANCE_MATRIX") != 0) continue;
                bl = (Boolean)gLMModelDetailsRowData.getValue();
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public CoefViewerTableModel getSVMFilteredCoefficients(String string, int n) throws Exception {
        return this._svmTableModel.getFilteredCoefficients(string, n);
    }

    public GLMCoefViewerTableModel getGLMFilteredCoefficients(String string, int n) throws Exception {
        return this._glmTableModel.getFilteredCoefficients(string, n);
    }

    public NBProbabilitiesTableModel getNBFilteredCoefficients(String string, int n) throws Exception {
        return this._nbTableModel.getFilteredProbabilities(string, n);
    }

    public CoefViewerTableModel getNMFFilteredCoefficients(String string, int n) throws Exception {
        return this._nmfTableModel.getFilteredCoefficients(string, n);
    }

    private void loadCoefficients(Connection connection) throws Exception {
        if (this.isSVM() || this.isAnomaly()) {
            Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
            if (this.isClassification()) {
                vector = this._modelSVMClassification.getCoefficients(connection, this._userName, this._modelName, this._filterSetting);
            } else if (this.isRegression()) {
                vector = this._modelSVMRegression.getCoefficients(connection, this._userName, this._modelName, this._filterSetting);
            }
            this._svmTableModel.clearRows();
            this._svmTableModel.addRows(vector);
        } else if (this.isGLM()) {
            Vector<GLMCoefficientRowData> vector = new Vector<GLMCoefficientRowData>();
            if (this.isClassification()) {
                vector = this._modelGLMClassification.getCoefficients(connection, this._userName, this._modelName, this._filterSetting);
            } else if (this.isRegression()) {
                vector = this._modelGLMRegression.getCoefficients(connection, this._userName, this._modelName, this._filterSetting);
            }
            this._glmTableModel.clearRows();
            this._glmTableModel.addRows(vector);
        } else if (this.isNB()) {
            Vector<CoefficientRowData> vector = this._modelNaiveNayes.getProbabilities(connection, this._userName, this._modelName, this._filterSetting);
            this._nbTableModel.clearRows();
            this._nbTableModel.addRows(vector);
        } else if (this.isNMF()) {
            Vector<CoefficientRowData> vector = new Vector();
            vector = this._modelNMFFeature.getCoefficients(connection, this._userName, this._modelName, this._filterSetting);
            this._nmfTableModel.clearRows();
            this._nmfTableModel.addRows(vector);
        } else assert (false) : "CoefViewerState not loaded.";
    }

    private void loadBias(Connection connection) throws Exception {
        if (this._modelSVMClassification != null) {
            this._classificationBias = this._modelSVMClassification.getBiases(connection, this._userName, this._modelName);
        } else {
            this._regressionBias = this._modelSVMRegression.getBias(connection, this._userName, this._modelName, null);
        }
    }

    public BigDecimal getBias() {
        BigDecimal bigDecimal = null;
        if (this._modelSVMClassification != null) {
            String string = this.getSelectedTargetClass().toString();
            for (SVMBiasRowData sVMBiasRowData : this._classificationBias) {
                if (!sVMBiasRowData.getClassValue().equals(string)) continue;
                bigDecimal = sVMBiasRowData.getBias();
                break;
            }
            if (this.getFilterSetting().isBinaryClassModel() && bigDecimal == null) {
                bigDecimal = this._classificationBias.get(0).getBias().negate();
            }
        } else if (this._modelSVMRegression != null) {
            bigDecimal = this._regressionBias.getBias();
        }
        return bigDecimal;
    }

    public HelpInfo getHelpInfo() {
        String string = "Help Topic Not Specified";
        if (this.isSVM() && this.isClassification()) {
            string = "svmc_coeff_help";
        } else if (this.isSVM() && this.isRegression()) {
            string = "svmr_coeff_help";
        } else if (this.isGLM() && this.isClassification()) {
            string = "glmc_coeff_help";
        } else if (this.isGLM() && this.isRegression()) {
            string = "glmr_coeff_help";
        } else if (this.isNB()) {
            string = "nb_coeff_help";
        } else if (this.isAnomaly()) {
            string = "svmc_coeff_help_grid";
        } else if (this.isNMF()) {
            string = "nmf_coeff_help";
        }
        return new HelpInfo(string);
    }

    public void setFilterSetting(CoefficientFilterSetting coefficientFilterSetting) {
        this._filterSetting = coefficientFilterSetting;
        if (this.getSelectedTargetClass() != null) {
            this._filterSetting.setTargetValue(this.getSelectedTargetClass());
        }
        if (this.getTargetValuePrior() != null) {
            this._filterSetting.setTargetValuePriors(this.getTargetValuePrior());
        }
    }

    public CoefficientFilterSetting getFilterSetting() {
        return this._filterSetting;
    }

    public Vector<Object> getTargetPredictions() {
        return ObjectComparator.getTargetPredictions(this._targetValuePriors);
    }

    public Vector<TargetPriorsPredictionSet> getTargetValuePrior() {
        return this._targetValuePriors;
    }

    public void setSelectedTargetClass(Object object) {
        this._selectedTargetClass = object;
        this._queryForTotalDetailCount = true;
        this._filterSetting.setTargetValue(object);
    }

    public Object getSelectedTargetClass() {
        return this._selectedTargetClass;
    }

    public void clearRows() {
        if (this.isSVM() || this.isAnomaly()) {
            this._svmTableModel.clearRows();
        } else if (this.isGLM()) {
            this._glmTableModel.clearRows();
        } else if (this.isNB()) {
            this._nbTableModel.clearRows();
        } else if (this.isNMF()) {
            this._nmfTableModel.clearRows();
        } else assert (false) : "CoefViewerState not loaded.";
    }

    public void addRow(CoefficientRowData coefficientRowData) {
        if (this.isSVM() || this.isAnomaly()) {
            this._svmTableModel.addRow(coefficientRowData);
        } else if (this.isNB()) {
            this._nbTableModel.addRow(coefficientRowData);
        } else if (this.isNMF()) {
            this._nmfTableModel.addRow(coefficientRowData);
        } else assert (false) : "Loaded a SVM Coefficient row when model was not SVM.";
    }

    public void addRow(GLMCoefficientRowData gLMCoefficientRowData) {
        if (this.isGLM()) {
            this._glmTableModel.addRow(gLMCoefficientRowData);
        } else assert (false) : "Loaded a GLM Coefficient row when model was not GLM.";
    }

    public GenericBaseTableModel getTableModel() {
        if (this.isSVM() || this.isAnomaly()) {
            return this._svmTableModel;
        }
        if (this.isGLM()) {
            return this._glmTableModel;
        }
        if (this.isNB()) {
            return this._nbTableModel;
        }
        if (this.isNMF()) {
            return this._nmfTableModel;
        }
        assert (false) : "CoefViewerState not loaded.";
        return null;
    }

    public void setCachedFilterSetting(CoefficientFilterSetting coefficientFilterSetting) {
        this._cachedFilterSetting = coefficientFilterSetting;
    }

    public CoefficientFilterSetting getCachedFilterSetting() {
        return this._cachedFilterSetting;
    }

    public void setSortByAbsoluteValue(boolean bl) {
        this._cachedFilterSetting.setFilterByAbsolute(bl);
        if (this.isSVM() || this.isAnomaly()) {
            this._svmTableModel.setAbsoluteValueSort(bl);
        } else if (this.isGLM()) {
            this._glmTableModel.setAbsoluteValueSort(bl);
        } else if (this.isNB()) {
            this._nbTableModel.setAbsoluteValueSort(bl);
        } else assert (false) : "CoefViewerState not loaded.";
    }

    public boolean getSortByAbsoluteValue() {
        boolean bl = false;
        if (this.isSVM() || this.isAnomaly()) {
            bl = this._svmTableModel.getAbsoluteValueSort();
        } else if (this.isGLM()) {
            bl = this._glmTableModel.getAbsoluteValueSort();
        } else if (this.isNB()) {
            bl = this._nbTableModel.getAbsoluteValueSort();
        } else assert (false) : "CoefViewerState not loaded.";
        return bl;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public Vector<? extends CoefficientBaseData> getData(Vector<CoefficientSortSpec> vector) throws Exception {
        return this.getAllData(vector);
    }

    public Vector<? extends CoefficientBaseData> getAllData(CoefficientFilterSetting coefficientFilterSetting) throws Exception {
        Connection connection = null;
        Vector<Object> vector = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            if (this.isSVM()) {
                vector = new Vector();
                if (this.isClassification()) {
                    vector = this._modelSVMClassification.getAllCoefficients(connection, this._userName, this._modelName, coefficientFilterSetting);
                } else if (this.isRegression()) {
                    vector = this._modelSVMRegression.getAllCoefficients(connection, this._userName, this._modelName, coefficientFilterSetting);
                }
            } else if (this.isGLM()) {
                vector = new Vector();
                if (this.isClassification()) {
                    vector = this._modelGLMClassification.getAllCoefficients(connection, this._userName, this._modelName, coefficientFilterSetting);
                } else if (this.isRegression()) {
                    vector = this._modelGLMRegression.getAllCoefficients(connection, this._userName, this._modelName, coefficientFilterSetting);
                }
            } else if (this.isNB()) {
                vector = this._modelNaiveNayes.getAllProbabilities(connection, this._userName, this._modelName, coefficientFilterSetting);
            } else if (this.isNMF()) {
                vector = new Vector();
                vector = this._modelNMFFeature.getAllCoefficients(connection, this._userName, this._modelName, coefficientFilterSetting);
            } else assert (false) : "CoefViewerState not loaded.";
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    private Vector<? extends CoefficientBaseData> getAllData(Vector<CoefficientSortSpec> vector) throws Exception {
        CoefficientFilterSetting coefficientFilterSetting = new CoefficientFilterSetting();
        coefficientFilterSetting.setUseFilterSpecification(false);
        coefficientFilterSetting.setFetchSize(this._modelViewerPrefenceSettings.getFetchSizeOtherModels());
        coefficientFilterSetting.setSortSpecification(vector);
        coefficientFilterSetting.setWhereSpecification(null);
        Connection connection = null;
        Vector<Object> vector2 = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            if (this.isSVM()) {
                vector2 = new Vector();
                if (this.isClassification()) {
                    vector2 = this._modelSVMClassification.getAllCoefficients(connection, this._userName, this._modelName, coefficientFilterSetting);
                } else if (this.isRegression()) {
                    vector2 = this._modelSVMRegression.getAllCoefficients(connection, this._userName, this._modelName, coefficientFilterSetting);
                }
            } else if (this.isGLM()) {
                vector2 = new Vector();
                if (this.isClassification()) {
                    vector2 = this._modelGLMClassification.getAllCoefficients(connection, this._userName, this._modelName, coefficientFilterSetting);
                } else if (this.isRegression()) {
                    vector2 = this._modelGLMRegression.getAllCoefficients(connection, this._userName, this._modelName, coefficientFilterSetting);
                }
            } else if (this.isNB()) {
                vector2 = this._modelNaiveNayes.getAllProbabilities(connection, this._userName, this._modelName, coefficientFilterSetting);
            } else if (this.isNMF()) {
                vector2 = new Vector();
                vector2 = this._modelNMFFeature.getAllCoefficients(connection, this._userName, this._modelName, coefficientFilterSetting);
            } else assert (false) : "CoefViewerState not loaded.";
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector2;
    }

    public void setSortSpec(Vector<CoefficientSortSpec> vector) {
        this._sortSpecs = new Vector<CoefficientSortSpec>(vector);
    }

    public Vector<CoefficientSortSpec> getSortSpec() {
        return this._sortSpecs;
    }

    public static boolean isNameSortOption(Vector<CoefficientSortSpec> vector) {
        for (CoefficientSortSpec coefficientSortSpec : vector) {
            String string = coefficientSortSpec.getAttributeName();
            if (!string.equals("attribute_name")) continue;
            return true;
        }
        return false;
    }

    public static boolean isNameSubnameSortOption(Vector<CoefficientSortSpec> vector) {
        for (CoefficientSortSpec coefficientSortSpec : vector) {
            String string = coefficientSortSpec.getAttributeName();
            if (!string.equals("attribute_name_subname")) continue;
            return true;
        }
        return false;
    }

    public static boolean isValueSortOption(Vector<CoefficientSortSpec> vector) {
        for (CoefficientSortSpec coefficientSortSpec : vector) {
            String string = coefficientSortSpec.getAttributeName();
            if (!string.equals("attribute_value")) continue;
            return true;
        }
        return false;
    }

    public Vector<CoefficientBaseData> getSelectedFilterItems() {
        Vector<CoefficientBaseData> vector;
        Vector<CoefficientBaseData> vector2 = vector = this._filterItemTableModel != null ? new Vector<CoefficientBaseData>(this._filterItemTableModel.getDataVector()) : new Vector();
        if (vector.isEmpty()) {
            return vector;
        }
        return vector;
    }

    public String getPredictiveValue() {
        return this._predictiveValue;
    }

    public void setPredictiveValue(String string) {
        this._predictiveValue = string;
        if (this._filterSetting != null) {
            this.setSelectedTargetClass(this.translatePredictiveValue(string));
        }
    }

    public Integer translatePredictiveValue(String string) {
        return _predictiveValues.get(string);
    }

    public void setFilterItemTableModel(CoefficientItemTableModel coefficientItemTableModel) {
        this._filterItemTableModel = coefficientItemTableModel;
    }

    public CoefficientItemTableModel getFilterItemTableModel() {
        return this._filterItemTableModel;
    }

    public Integer getTotalDetailCount() {
        return this._totalDetailCount;
    }

    public boolean isCovarianceIndicator() {
        return this._covarianceIndicator;
    }

    public Double getMaximumABSCoefficient() {
        return this._maximumABSCoefficient;
    }

    public String renameFeatureLabel(String string, String string2) throws Exception {
        Connection connection = null;
        String string3 = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            string3 = this._modelNMFFeature.renameFeatureLabel(connection, this._userName, this._modelName, string, string2);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string3;
    }

    static {
        _sortMap.put(SORT_OPTION_NAME_SUBNAME, "attribute_name_subname");
        _sortMap.put(SORT_OPTION_NAME, "attribute_name");
        _sortMap.put(SORT_OPTION_VALUE, "attribute_value");
        TYPICAL = CoefficientsLrb.get("TARGET_VALUE_TYPICAL");
        OUTLIER = CoefficientsLrb.get("TARGET_VALUE_OUTLIER");
        _predictiveValues = new HashMap<String, Integer>();
        _predictiveValues.put(TYPICAL, 1);
        _predictiveValues.put(OUTLIER, 0);
        _p = Preferences.getPreferences();
    }

    private class LoadCovarianceIndicator
    extends Thread {
        Exception _ex = null;
        boolean _success = false;
        boolean _isCovarianceTrue = false;

        @Override
        public void run() {
            try {
                this._isCovarianceTrue = CoefViewerState.this.loadCovarianceMatrixIndicator();
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
            }
        }

        public boolean isSuccessful() {
            return this._success;
        }

        public Exception getException() {
            return this._ex;
        }

        public boolean isIsCovarianceTrue() {
            return this._isCovarianceTrue;
        }
    }

    private class LoadTotalCount
    extends Thread {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;
        String _userName;
        String _modelNamel;
        List<Object> _targetValues;
        Integer _count = new Integer(0);
        Double _maximumABSCoefficient = new Double(0.0);

        public LoadTotalCount(String string, String string2, List<Object> list) {
            this._userName = string;
            CoefViewerState.this._modelName = string2;
            this._targetValues = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection connection = null;
            try {
                connection = Connections.getUniqueConnection(CoefViewerState.this._context);
                Integer n = new Integer(0);
                Double d = new Double(0.0);
                if (CoefViewerState.this.isSVM() || CoefViewerState.this.isAnomaly()) {
                    if (CoefViewerState.this.isClassification()) {
                        HashMap hashMap = CoefViewerState.this._modelSVMClassification.getCoefficientStatistics(connection, this._userName, CoefViewerState.this._modelName, this._targetValues, CoefViewerState.this._filterSetting);
                        n = (Integer)hashMap.get("TOTAL_COEFFICIENTS");
                        d = (Double)hashMap.get("MAXIMUM_ABS_COEFFICIENT_VALUE");
                    } else if (CoefViewerState.this.isRegression()) {
                        HashMap hashMap = CoefViewerState.this._modelSVMRegression.getCoefficientStatistics(connection, this._userName, CoefViewerState.this._modelName);
                        n = (Integer)hashMap.get("TOTAL_COEFFICIENTS");
                        d = (Double)hashMap.get("MAXIMUM_ABS_COEFFICIENT_VALUE");
                    }
                } else if (CoefViewerState.this.isGLM()) {
                    if (CoefViewerState.this.isClassification()) {
                        HashMap hashMap = CoefViewerState.this._modelGLMClassification.getCoefficientStatistics(connection, this._userName, CoefViewerState.this._modelName, this._targetValues, CoefViewerState.this._filterSetting);
                        n = (Integer)hashMap.get("TOTAL_COEFFICIENTS");
                        d = (Double)hashMap.get("MAXIMUM_ABS_COEFFICIENT_VALUE");
                    } else if (CoefViewerState.this.isRegression()) {
                        HashMap hashMap = CoefViewerState.this._modelGLMRegression.getCoefficientStatistics(connection, this._userName, CoefViewerState.this._modelName);
                        n = (Integer)hashMap.get("TOTAL_COEFFICIENTS");
                        d = (Double)hashMap.get("MAXIMUM_ABS_COEFFICIENT_VALUE");
                    }
                } else if (CoefViewerState.this.isNB()) {
                    n = CoefViewerState.this._modelNaiveNayes.getTotalCountProbabilities(connection, this._userName, CoefViewerState.this._modelName, this._targetValues);
                } else if (CoefViewerState.this.isNMF()) {
                    HashMap hashMap = CoefViewerState.this._modelNMFFeature.getCoefficientStatistics(connection, this._userName, CoefViewerState.this._modelName, this._targetValues);
                    n = (Integer)hashMap.get("TOTAL_COEFFICIENTS");
                    d = (Double)hashMap.get("MAXIMUM_ABS_COEFFICIENT_VALUE");
                } else assert (false) : "CoefViewerState not loaded. ";
                this._count = n;
                this._maximumABSCoefficient = d;
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            finally {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }

        public boolean isSuccessful() {
            return this._success;
        }

        public Exception getException() {
            return this._ex;
        }

        public Integer getCount() {
            return this._count;
        }

        public Double getMaximumABSCoefficient() {
            return this._maximumABSCoefficient;
        }
    }
}

