/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.GenericTableFixedColumns;
import oracle.dmt.dataminer.controls.HistogramBarRenderer;
import oracle.dmt.dataminer.filter.FilterEvent;
import oracle.dmt.dataminer.filter.FilterListener;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.GLMCoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoeffViewer;
import oracle.dmt.dataminer.mviewer.coefficients.NBProbabilitiesTableModel;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NMFModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.server.model.GLMCoefficientRowData;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.wizard.group.GroupLrb;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.SwingWorker;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class CoefViewer
extends JPanel
implements GeneralCoeffViewer {
    CoefViewerState _state;
    Context _context;
    CoefViewerMainPanel _mainPanel;
    private CustomGenericTable _jCoefNiceTable = new CustomGenericTable();
    JScrollPane jScrollPane1;
    JLabel _jRowsOutOfTotalLabel = new JLabel();
    private JComponent _findPane;
    public static final String COEFFICIENT_VIEWER_ID = "COEFFICIENT_VIEWER_ID";
    private SearchField _jFilterCtl;
    public static final int SVM_FILTER_COEFFICIENT_ALL_OR = 0;
    public static final int SVM_FILTER_COEFFICIENT_ALL_AND = 1;
    public static final int SVM_FILTER_COEFFICIENT_NAME = 2;
    public static final int SVM_FILTER_COEFFICIENT_VALUE = 3;
    public static final int SVM_FILTER_COEFFICIENT = 4;
    private static final int SVM_FROZEN_COLUMNS = 0;
    private int _currentSearchCategory = 2;
    private SearchCategory _defaultSVMSearchCategory = new SearchCategory(CoefficientsLrb.get("SVM_FILTER_CATEGORY_NAME"));
    public static final int GLM_FILTER_COEFFICIENT_ALL_OR = 0;
    public static final int GLM_FILTER_COEFFICIENT_ALL_AND = 1;
    public static final int GLM_FILTER_COEFFICIENT_NAME = 2;
    public static final int GLM_FILTER_COEFFICIENT_VALUE = 3;
    public static final int GLM_FILTER_COEFFICIENT = 4;
    public static final int GLM_FILTER_STD_ERROR = 5;
    public static final int GLM_FILTER_TEST_STATISTIC = 6;
    public static final int GLM_FILTER_P_VALUE = 7;
    public static final int GLM_FILTER_STD_COEFFICIENT = 8;
    public static final int GLM_FILTER_LOWER_COEFF_LIMIT = 9;
    public static final int GLM_FILTER_UPPER_COEFF_LIMIT = 10;
    public static final int GLM_FILTER_EXP_COEFFICIENT = 11;
    public static final int GLM_FILTER_EXP_LOWER_COEFF_LIMIT = 12;
    public static final int GLM_FILTER_EXP_UPPER_COEFF_LIMIT = 13;
    private static final int GLM_FROZEN_COLUMNS = 2;
    private SearchCategory _defaultGLMSearchCategory = new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_NAME"));
    public static final int NB_FILTER_COEFFICIENT_ALL_OR = 0;
    public static final int NB_FILTER_COEFFICIENT_ALL_AND = 1;
    public static final int NB_FILTER_COLUMN_NAME = 2;
    public static final int NB_FILTER_COLUMN_VALUE = 3;
    public static final int NB_FILTER_COLUMN_PROBABILITY = 4;
    private static final int NB_FROZEN_COLUMNS = 0;
    private SearchCategory _defaultNBSearchCategory = new SearchCategory(CoefficientsLrb.get("NB_PRIORS_EDITOR_FILTER_CATEGORY_ATTRIBUTE_NAME"));
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private static String _LOADING_SVM = CoefficientsLrb.get("COEFFICIENT_LOADING");
    private static String _LOADING_GLM = CoefficientsLrb.get("STATISTICS_LOADING");
    private static String _LOADING_NB = CoefficientsLrb.get("PROBABILITIES_LOADING");
    private static String _LOADING_NMF = CoefficientsLrb.get("COEFFICIENT_LOADING");
    private NumberFormat _labelNumericalFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getNumericalPrecisionLevel(), 0, 0);
    private NumberFormat _labelPercentageFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private HistogramBarRenderer _barRenderer = null;
    private boolean _loadedFilterSetting = false;
    private ComponentWithTitlebar<JComponent> _jCoefViewerComponent;

    public CoefViewer(CoefViewerMainPanel coefViewerMainPanel, Context context, CoefViewerState coefViewerState) throws Exception {
        this._mainPanel = coefViewerMainPanel;
        this._context = context;
        this._state = coefViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jCoefViewerComponent = new ComponentWithTitlebar();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this._jCoefViewerComponent, -1, 484, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jCoefViewerComponent, GroupLayout.Alignment.TRAILING, -1, 208, Short.MAX_VALUE));
    }

    @Override
    public JPanel getUIComponent() {
        return this;
    }

    @Override
    public void initRes() {
        this.loadRowsOutOfTotalLabel(new Integer(0), new Integer(0));
    }

    @Override
    public void initUI() {
        this.setLoading(true);
        this.jScrollPane1 = new JScrollPane((Component)((Object)this._jCoefNiceTable));
        this._jCoefNiceTable.setFillsViewportHeight(true);
        this._jCoefViewerComponent.setComponent((JComponent)this.jScrollPane1);
        this._jCoefViewerComponent.setLabel(this._jRowsOutOfTotalLabel);
        ControlBar controlBar = new ControlBar();
        this.setupFilterControl(controlBar);
        this._jCoefViewerComponent.setControlBar(controlBar);
        this._jCoefNiceTable.setSelectionMode(2);
        this._jCoefNiceTable.setShowGrid(true);
        this.initializeControls();
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = "";
        if (this.isSVM() || this.isAnomaly() || this.isNMF()) {
            string = CoefficientsLrb.get("COEFFICIENTS_ROWS_OUT_OF_TOTAL");
        } else if (this.isNB()) {
            string = CoefficientsLrb.get("PROBABILTIES_ROWS_OUT_OF_TOTAL");
        } else if (this.isGLM()) {
            string = CoefficientsLrb.get("COEFFICIENTS_ROWS_OUT_OF_TOTAL");
        }
        int n3 = 1;
        if (n == 0 && n2 == 0) {
            n3 = 0;
        }
        if (this.isSVM() || this.isGLM() || this.isAnomaly() || this.isNMF()) {
            n3 = 0;
        }
        Integer n4 = new Integer(n2 + n3);
        String string2 = NumericFormat.format(n);
        String string3 = NumericFormat.format(n4);
        String string4 = MessageFormat.format(string, string2, string3);
        this._jRowsOutOfTotalLabel.setText(string4);
    }

    private SearchField searchField() {
        SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                CoefViewer.this.translateSearchCategoryToConstant(CoefViewer.this._jFilterCtl.getSelectedCategory());
                CoefViewer.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                CoefViewer.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                CoefViewer.this.processFilter(string);
            }
        });
        return searchField;
    }

    private void setupFilterControl(ControlBar controlBar) {
        this._findPane = new Box(2);
        this._jFilterCtl = this.searchField();
        if (this.isSVM() || this.isAnomaly() || this.isNMF()) {
            this.setupSVMFilterCtl();
        } else if (this.isGLM()) {
            this.setupGLMFilterCtl();
        } else if (this.isNB()) {
            this.setupNBFilterCtl();
        } else assert (false) : "Unsupported model node";
        this._findPane.setName("Find");
        this._findPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this._findPane.add((Component)this._jFilterCtl);
        Dimension dimension = this._findPane.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 145);
        Dimension dimension3 = this.derive(dimension, 80);
        this._findPane.setPreferredSize(dimension2);
        this._findPane.setMaximumSize(dimension2);
        this._findPane.setMinimumSize(dimension3);
        controlBar.add((Component)this._findPane);
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private void setLoading(boolean bl) {
        this._mainPanel.updateLoading(bl);
    }

    private void setLoaded(boolean bl) {
        if (!this._loadedFilterSetting) {
            this._mainPanel.setFilterPanelInitialState(this._state.getFilterSetting());
            this._loadedFilterSetting = true;
        }
        this._mainPanel.updateLoaded(bl);
    }

    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    @Override
    public void setFilterState(CoefficientFilterSetting coefficientFilterSetting) {
        if (this.isLoading()) {
            return;
        }
        this._state.setFilterSetting(coefficientFilterSetting);
        this.prepareReload();
    }

    public void setFilterState(FilterEvent filterEvent) {
    }

    public CoefficientFilterSetting getFilterState() {
        return this._state.getFilterSetting();
    }

    @Override
    public CoefficientFilterSetting getCachedFilterState() {
        return this._state.getCachedFilterSetting();
    }

    @Override
    public void setCachedFilterState(CoefficientFilterSetting coefficientFilterSetting) {
        this._state.setCachedFilterSetting(coefficientFilterSetting);
    }

    @Override
    public void prepareReload() {
        this.setLoading(true);
        this.prepareForNewQuery();
        LoadUI loadUI = new LoadUI(true);
        loadUI.start();
    }

    private void enableControls(boolean bl) {
        this._jFilterCtl.setEnabled(bl);
    }

    void prepareForNewQuery() {
        this._jCoefNiceTable.setLoading(true);
        this._state.clearRows();
        if (this._state.isSVM() || this._state.isNB() || this._state.isAnomaly()) {
            CoefficientRowData coefficientRowData = new CoefficientRowData(this._state.isSVM() || this._state.isAnomaly() ? _LOADING_SVM : _LOADING_NB);
            this._state.addRow(coefficientRowData);
            this._jCoefNiceTable.setModel((TableModel)this._state.getTableModel());
            this._jCoefNiceTable.setSorted(true);
        } else if (this._state.isGLM()) {
            GLMCoefficientRowData gLMCoefficientRowData = new GLMCoefficientRowData(_LOADING_GLM);
            this._state.addRow(gLMCoefficientRowData);
            this._jCoefNiceTable.setModel((TableModel)this._state.getTableModel());
        } else if (this._state.isNMF()) {
            CoefficientRowData coefficientRowData = new CoefficientRowData(_LOADING_NMF);
            this._state.addRow(coefficientRowData);
            this._jCoefNiceTable.setModel((TableModel)this._state.getTableModel());
            this._jCoefNiceTable.setSorted(true);
        }
        this.enableControls(false);
    }

    private boolean isSVM() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof SVMCModelNode;
    }

    private boolean isAnomaly() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof ANModelNode;
    }

    private boolean isGLM() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof GLMCModelNode;
    }

    private boolean isNB() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof NBModelNode;
    }

    private boolean isNMF() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof NMFModelNode;
    }

    private void initializeControls() {
        this.setupLoadingTable();
        this.enableControls(false);
    }

    private void setupSVMFilterCtl() {
        this._currentSearchCategory = 2;
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("SVM_FILTER_CATEGORY_ALL_OR")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("SVM_FILTER_CATEGORY_ALL_AND")));
        this._jFilterCtl.addCategory(this._defaultSVMSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("SVM_FILTER_CATEGORY_VALUE")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("SVM_FILTER_CATEGORY_COEFFICIENT")));
        this._jFilterCtl.setSelectedCategory(this._defaultSVMSearchCategory);
    }

    private void setupNBFilterCtl() {
        this._currentSearchCategory = 2;
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("NB_PRIORS_EDITOR_FILTER_CATEGORY_ALL_OR")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("NB_PRIORS_EDITOR_FILTER_CATEGORY_ALL_AND")));
        this._jFilterCtl.addCategory(this._defaultNBSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("NB_PRIORS_EDITOR_FILTER_CATEGORY_ATTRIBUTE_VALUE")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("NB_PRIORS_EDITOR_FILTER_CATEGORY_PROBABILITY_VALUE")));
        this._jFilterCtl.setSelectedCategory(this._defaultNBSearchCategory);
    }

    private void setupGLMFilterCtl() {
        this._currentSearchCategory = 2;
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_ALL_OR")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_ALL_AND")));
        this._jFilterCtl.addCategory(this._defaultGLMSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_VALUE")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_COEFFICIENT")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_STD_ERROR")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_TEST_STATISTIC")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_P_VALUE")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("STD_COEFFICIENT_COLUMN")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_LOWER_COEFF_LIMIT")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_UPPER_COEFF_LIMIT")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_EXP_COEFFICIENT")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_EXP_LOWER_COEFF_LIMIT")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_EXP_UPPER_COEFF_LIMIT")));
        this._jFilterCtl.setSelectedCategory(this._defaultGLMSearchCategory);
    }

    private void reviseGLMFilterCtl() {
        this._currentSearchCategory = 2;
        this._jFilterCtl.clearCategories();
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_ALL_OR")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_ALL_AND")));
        this._jFilterCtl.addCategory(this._defaultGLMSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_VALUE")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_COEFFICIENT")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("STD_COEFFICIENT_COLUMN")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_EXP_COEFFICIENT")));
        this._jFilterCtl.setSelectedCategory(this._defaultGLMSearchCategory);
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = -1;
        if (this._state.isSVM() || this._state.isAnomaly() || this._state.isNMF()) {
            if (searchCategory.getLabel().equals(CoefficientsLrb.get("SVM_FILTER_CATEGORY_ALL_OR"))) {
                this._currentSearchCategory = 0;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("SVM_FILTER_CATEGORY_ALL_AND"))) {
                this._currentSearchCategory = 1;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("SVM_FILTER_CATEGORY_NAME"))) {
                this._currentSearchCategory = 2;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("SVM_FILTER_CATEGORY_VALUE"))) {
                this._currentSearchCategory = 3;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("SVM_FILTER_CATEGORY_COEFFICIENT"))) {
                this._currentSearchCategory = 4;
            } else assert (false) : "Invalid Search Category Code";
        } else if (this._state.isGLM()) {
            if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_ALL_OR"))) {
                this._currentSearchCategory = 0;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_ALL_AND"))) {
                this._currentSearchCategory = 1;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_NAME"))) {
                this._currentSearchCategory = 2;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_VALUE"))) {
                this._currentSearchCategory = 3;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_COEFFICIENT"))) {
                this._currentSearchCategory = 4;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_STD_ERROR"))) {
                this._currentSearchCategory = 5;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_TEST_STATISTIC"))) {
                this._currentSearchCategory = 6;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_P_VALUE"))) {
                this._currentSearchCategory = 7;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("STD_COEFFICIENT_COLUMN"))) {
                this._currentSearchCategory = 8;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_LOWER_COEFF_LIMIT"))) {
                this._currentSearchCategory = 9;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_UPPER_COEFF_LIMIT"))) {
                this._currentSearchCategory = 10;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_EXP_COEFFICIENT"))) {
                this._currentSearchCategory = 11;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_EXP_LOWER_COEFF_LIMIT"))) {
                this._currentSearchCategory = 12;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_EXP_UPPER_COEFF_LIMIT"))) {
                this._currentSearchCategory = 13;
            } else assert (false) : "Invalid Search Category Code";
        } else if (this._state.isNB()) {
            if (searchCategory.getLabel().equals(CoefficientsLrb.get("NB_PRIORS_EDITOR_FILTER_CATEGORY_ALL_OR"))) {
                this._currentSearchCategory = 0;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("NB_PRIORS_EDITOR_FILTER_CATEGORY_ALL_AND"))) {
                this._currentSearchCategory = 1;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("NB_PRIORS_EDITOR_FILTER_CATEGORY_ATTRIBUTE_NAME"))) {
                this._currentSearchCategory = 2;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("NB_PRIORS_EDITOR_FILTER_CATEGORY_ATTRIBUTE_VALUE"))) {
                this._currentSearchCategory = 3;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("NB_PRIORS_EDITOR_FILTER_CATEGORY_PROBABILITY_VALUE"))) {
                this._currentSearchCategory = 4;
            } else assert (false) : "Invalid Search Category Code";
        } else assert (false) : "Invalid Search Category Code";
        return n;
    }

    private void processFilter(String string) {
        try {
            GenericBaseTableModel genericBaseTableModel;
            if (this._state.isSVM() || this._state.isAnomaly()) {
                genericBaseTableModel = this._state.getSVMFilteredCoefficients(string, this._currentSearchCategory);
                this.setupSVMTable((CoefViewerTableModel)genericBaseTableModel);
            } else if (this._state.isGLM()) {
                genericBaseTableModel = this._state.getGLMFilteredCoefficients(string, this._currentSearchCategory);
                this.setupGLMTable((GLMCoefViewerTableModel)genericBaseTableModel);
            }
            if (this._state.isNB()) {
                genericBaseTableModel = this._state.getNBFilteredCoefficients(string, this._currentSearchCategory);
                this.setupNBTable((NBProbabilitiesTableModel)genericBaseTableModel);
            }
            if (this._state.isNMF()) {
                genericBaseTableModel = this._state.getNMFFilteredCoefficients(string, this._currentSearchCategory);
                this.setupSVMTable((CoefViewerTableModel)genericBaseTableModel);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)GroupLrb.get("CREATE_GROUP_FAILURE_TITLE"), (String)GroupLrb.get("CREATE_GROUP_FAILURE_MESG"), null);
        }
    }

    private void setupSVMTable(CoefViewerTableModel coefViewerTableModel) {
        this._jCoefNiceTable.setFixedColumnCount(0);
        coefViewerTableModel.setAbsoluteValueSort(this._state.getFilterSetting().getFilterAndSortByAbsolute());
        this._jCoefNiceTable.setModel((TableModel)((Object)coefViewerTableModel));
        this._jCoefNiceTable.findOrCreateTableRowHeader(this.jScrollPane1);
        this._jCoefNiceTable.setSorted(true);
        this._jCoefNiceTable.addDynamicCellRenderers();
        this._jCoefNiceTable.setCellRenderers();
        this._barRenderer.setMaximumValue(this._state.getMaximumABSCoefficient().longValue());
        if (this.isAnomaly()) {
            this._jCoefNiceTable.setSortColumn(2, false);
        }
        this._jCoefNiceTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CoefViewer.this.repaint();
                        }
                    });
                }
            }
        });
    }

    private void setupNBTable(NBProbabilitiesTableModel nBProbabilitiesTableModel) {
        nBProbabilitiesTableModel.updateColumnIdentifiers(this._state.getSelectedTargetClass().toString());
        nBProbabilitiesTableModel.setAbsoluteValueSort(this._state.getFilterSetting().getFilterAndSortByAbsolute());
        this._jCoefNiceTable.setFixedColumnCount(0);
        this._jCoefNiceTable.setModel((TableModel)((Object)nBProbabilitiesTableModel));
        this._jCoefNiceTable.findOrCreateTableRowHeader(this.jScrollPane1);
        this._jCoefNiceTable.setSorted(true);
        this._jCoefNiceTable.addDynamicCellRenderers();
        this._jCoefNiceTable.setCellRenderers();
        this._barRenderer.setMaximumValue(100L);
        this._jCoefNiceTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CoefViewer.this.repaint();
                        }
                    });
                }
            }
        });
    }

    private void setupGLMTable(GLMCoefViewerTableModel gLMCoefViewerTableModel) {
        this._jCoefNiceTable.setFixedColumnCount(2);
        gLMCoefViewerTableModel.setAbsoluteValueSort(this._state.getFilterSetting().getFilterAndSortByAbsolute());
        this._jCoefNiceTable.setSorted(true);
        this._jCoefNiceTable.setAutoCreateRowSorter(true);
        this._jCoefNiceTable.setModel((TableModel)((Object)gLMCoefViewerTableModel));
        String string = gLMCoefViewerTableModel.getColumnName(0);
        this._jCoefNiceTable.setFixedColumnPreferredWidth(string, 175);
        String string2 = gLMCoefViewerTableModel.getColumnName(1);
        this._jCoefNiceTable.setFixedColumnPreferredWidth(string2, 175);
        this.jScrollPane1 = new JScrollPane((Component)((Object)this._jCoefNiceTable));
        this._jCoefNiceTable.setFillsViewportHeight(true);
        this._jCoefViewerComponent.setComponent((JComponent)this.jScrollPane1);
        this._jCoefNiceTable.findOrCreateTableRowHeader(this.jScrollPane1);
        this._jCoefNiceTable.setSorted(true);
        int n = this._jCoefNiceTable.getColumnModel().getTotalColumnWidth();
        Dimension dimension = this.jScrollPane1.getViewport().getPreferredSize();
        if ((double)n < dimension.getWidth()) {
            this._jCoefNiceTable.setAutoResizeMode(3);
        } else {
            this._jCoefNiceTable.setAutoResizeMode(0);
        }
        this._jCoefNiceTable.addDynamicCellRenderers();
        TableColumnModel tableColumnModel = this._jCoefNiceTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(150);
        tableColumnModel.getColumn(gLMCoefViewerTableModel.getColumn_Exp_Cofficient_Column_Number() - 2).setPreferredWidth(100);
        tableColumnModel.getColumn(1).setPreferredWidth(130);
        if (this._state.isCovarianceIndicator()) {
            tableColumnModel.getColumn(8).setPreferredWidth(150);
            tableColumnModel.getColumn(9).setPreferredWidth(150);
            tableColumnModel.getColumn(5).setPreferredWidth(130);
            tableColumnModel.getColumn(4).setPreferredWidth(100);
            tableColumnModel.getColumn(2).setPreferredWidth(130);
            tableColumnModel.getColumn(3).setPreferredWidth(100);
            tableColumnModel.getColumn(6).setPreferredWidth(130);
            this._jCoefNiceTable.addCellRenderer(this._state.getTableModel().getColumnName(11), new NumberRenderer());
            this._jCoefNiceTable.addCellRenderer(this._state.getTableModel().getColumnName(7), new NumberRenderer());
            this._jCoefNiceTable.addCellRenderer(this._state.getTableModel().getColumnName(10), new NumberRenderer());
            this._jCoefNiceTable.addCellRenderer(this._state.getTableModel().getColumnName(6), new NumberRenderer());
            this._jCoefNiceTable.addCellRenderer(this._state.getTableModel().getColumnName(4), new NumberRenderer());
            this._jCoefNiceTable.addCellRenderer(this._state.getTableModel().getColumnName(5), new NumberRenderer());
            this._jCoefNiceTable.addCellRenderer(this._state.getTableModel().getColumnName(8), new NumberRenderer());
        }
        this._jCoefNiceTable.addCellRenderer(this._state.getTableModel().getColumnName(gLMCoefViewerTableModel.getColumn_Exp_Cofficient_Column_Number()), new NumberRenderer());
        this._jCoefNiceTable.setCellRenderers();
        this._barRenderer.setMaximumValue(this._state.getMaximumABSCoefficient().longValue());
        this._jCoefNiceTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CoefViewer.this.repaint();
                        }
                    });
                }
            }
        });
    }

    @Override
    public HelpInfo getHelpInfo() {
        return this._state.getHelpInfo();
    }

    private String formatCellValue(Object object, FormatType formatType) {
        String string = "";
        if (object == null) {
            string = null;
        } else if (object != null) {
            string = object instanceof Double ? (formatType == FormatType.PERCENTAGE ? NumericFormat.format((Double)object, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()) + "" : NumericFormat.format((Double)object, true, this._modelViewerPrefenceSettings.getNumericalPrecisionLevel()) + "") : object.toString();
        }
        return string;
    }

    private void setupLoadingTable() {
        this._jCoefNiceTable.setFixedColumnCount(0);
        this._jCoefNiceTable.setModel((TableModel)((Object)new LoadingTableModel()));
        this._jCoefNiceTable.findOrCreateTableRowHeader(this.jScrollPane1);
        this._jCoefNiceTable.setSorted(true);
        this._jCoefNiceTable.setCellRenderers();
    }

    class LoadingTableModel
    extends GenericBaseTableModel {
        public final int NAME = 0;
        public final int COLUMN_COUNT = 1;
        private String[] columnNames = new String[]{CoefficientsLrb.get("PRIORS_ATTRIBUTE_NAME")};

        LoadingTableModel() {
            this.setColumnIdentifiers(this.columnNames);
            this.setRowCount(1);
            this.setColumnCount(this.columnNames.length);
        }

        public Object getValueAt(int n, int n2) {
            if (CoefViewer.this.isSVM() || CoefViewer.this._state.isAnomaly()) {
                return _LOADING_SVM;
            }
            if (CoefViewer.this.isGLM()) {
                return _LOADING_GLM;
            }
            if (CoefViewer.this.isNB()) {
                return _LOADING_NB;
            }
            if (CoefViewer.this.isNMF()) {
                return _LOADING_NMF;
            }
            return "unknown details";
        }
    }

    class CoefficientFilterListener
    implements FilterListener {
        CoefficientFilterListener() {
        }

        @Override
        public void applyEvent(FilterEvent filterEvent) {
            CoefViewer.this.setFilterState(filterEvent);
        }
    }

    class NumberRenderer
    extends DefaultTableCellRenderer {
        FormatType _formatType = FormatType.NUMERICAL;

        public NumberRenderer() {
        }

        public NumberRenderer(FormatType formatType) {
            this._formatType = formatType;
        }

        @Override
        public void setValue(Object object) {
            String string = CoefViewer.this.formatCellValue(object, this._formatType);
            super.setValue(string);
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        public Object construct() {
            try {
                if (this._reload) {
                    CoefViewer.this._state.reloadCoefficients();
                } else {
                    CoefViewer.this._state.load();
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return CoefViewer.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    if (CoefViewer.this._jFilterCtl.getText().trim().length() > 0) {
                        if (CoefViewer.this._state.isSVM() || CoefViewer.this._state.isAnomaly()) {
                            CoefViewer.this.setupSVMTable(CoefViewer.this._state.getSVMFilteredCoefficients(CoefViewer.this._jFilterCtl.getText(), CoefViewer.this._currentSearchCategory));
                            if (CoefViewer.this.isAnomaly()) {
                                CoefViewer.this._state.setSortByAbsoluteValue(CoefViewer.this._state.getFilterSetting().getFilterAndSortByAbsolute());
                            }
                        } else if (CoefViewer.this._state.isNMF()) {
                            CoefViewer.this.setupSVMTable(CoefViewer.this._state.getNMFFilteredCoefficients(CoefViewer.this._jFilterCtl.getText(), CoefViewer.this._currentSearchCategory));
                            if (CoefViewer.this.isAnomaly()) {
                                CoefViewer.this._state.setSortByAbsoluteValue(CoefViewer.this._state.getFilterSetting().getFilterAndSortByAbsolute());
                            }
                        } else if (CoefViewer.this._state.isGLM()) {
                            if (this._reload) {
                                CoefViewer.this.setupGLMTable(CoefViewer.this._state.getGLMFilteredCoefficients(CoefViewer.this._jFilterCtl.getText(), CoefViewer.this._currentSearchCategory));
                            } else {
                                if (!CoefViewer.this._state.isCovarianceIndicator()) {
                                    CoefViewer.this.reviseGLMFilterCtl();
                                }
                                CoefViewer.this.setupGLMTable(CoefViewer.this._state.getGLMFilteredCoefficients(CoefViewer.this._jFilterCtl.getText(), CoefViewer.this._currentSearchCategory));
                            }
                        } else if (CoefViewer.this._state.isNB()) {
                            CoefViewer.this.setupNBTable(CoefViewer.this._state.getNBFilteredCoefficients(CoefViewer.this._jFilterCtl.getText(), CoefViewer.this._currentSearchCategory));
                        }
                    } else if (CoefViewer.this._state.isSVM() || CoefViewer.this._state.isAnomaly() || CoefViewer.this._state.isNMF()) {
                        if (CoefViewer.this.isAnomaly()) {
                            CoefViewer.this._state.setSortByAbsoluteValue(CoefViewer.this._state.getFilterSetting().getFilterAndSortByAbsolute());
                        }
                        CoefViewer.this.setupSVMTable((CoefViewerTableModel)CoefViewer.this._state.getTableModel());
                    } else if (CoefViewer.this._state.isGLM()) {
                        if (this._reload) {
                            CoefViewer.this.setupGLMTable((GLMCoefViewerTableModel)CoefViewer.this._state.getTableModel());
                        } else {
                            if (!CoefViewer.this._state.isCovarianceIndicator()) {
                                CoefViewer.this.reviseGLMFilterCtl();
                            }
                            CoefViewer.this.setupGLMTable((GLMCoefViewerTableModel)CoefViewer.this._state.getTableModel());
                        }
                    } else if (CoefViewer.this._state.isNB()) {
                        CoefViewer.this.setupNBTable((NBProbabilitiesTableModel)CoefViewer.this._state.getTableModel());
                    }
                    CoefViewer.this._mainPanel.updateTarget();
                    CoefViewer.this.loadRowsOutOfTotalLabel(new Integer(CoefViewer.this._state.getTableModel().getRowCount()), CoefViewer.this._state.getTotalDetailCount());
                    CoefViewer.this.enableControls(true);
                    CoefViewer.this._labelNumericalFormat.setMaximumFractionDigits(CoefViewer.this._modelViewerPrefenceSettings.getNumericalPrecisionLevel());
                    CoefViewer.this._labelNumericalFormat.setMinimumFractionDigits(CoefViewer.this._modelViewerPrefenceSettings.getNumericalPrecisionLevel());
                    CoefViewer.this._labelNumericalFormat.setMinimumIntegerDigits(1);
                    CoefViewer.this._labelPercentageFormat.setMaximumFractionDigits(CoefViewer.this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
                    CoefViewer.this._labelPercentageFormat.setMinimumFractionDigits(CoefViewer.this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
                    CoefViewer.this._labelPercentageFormat.setMinimumIntegerDigits(1);
                    if (CoefViewer.this._jCoefNiceTable.getRowCount() > 0) {
                        CoefViewer.this._jCoefNiceTable.setSelectedRowsInModel(new int[]{0});
                    }
                    CoefViewer.this.setLoaded(true);
                } else {
                    if (CoefViewer.this._state.getTableModel() != null) {
                        CoefViewer.this._state.clearRows();
                        if (CoefViewer.this._state.isSVM() || CoefViewer.this._state.isAnomaly() || CoefViewer.this._state.isNMF()) {
                            CoefficientRowData coefficientRowData = new CoefficientRowData(CoefficientsLrb.get("COEFFICIENT_FAILURE"));
                            CoefViewer.this._state.addRow(coefficientRowData);
                            CoefViewer.this.setupSVMTable((CoefViewerTableModel)CoefViewer.this._state.getTableModel());
                        } else if (CoefViewer.this._state.isGLM()) {
                            GLMCoefficientRowData gLMCoefficientRowData = new GLMCoefficientRowData(CoefficientsLrb.get("STATISTICS_FAILURE"));
                            CoefViewer.this._state.addRow(gLMCoefficientRowData);
                            CoefViewer.this.setupGLMTable((GLMCoefViewerTableModel)CoefViewer.this._state.getTableModel());
                        } else if (CoefViewer.this._state.isNB()) {
                            CoefficientRowData coefficientRowData = new CoefficientRowData(CoefficientsLrb.get("PROBABILITIES_FAILURE"));
                            CoefViewer.this._state.addRow(coefficientRowData);
                            CoefViewer.this.setupNBTable((NBProbabilitiesTableModel)CoefViewer.this._state.getTableModel());
                        }
                        CoefViewer.this.loadRowsOutOfTotalLabel(new Integer(CoefViewer.this._state.getTableModel().getRowCount()), CoefViewer.this._state.getTotalDetailCount());
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)CoefficientsLrb.get("COEFFICIENT_VIEWER_FAILURE_TITLE"), (String)CoefficientsLrb.get("COEFFICIENT_VIEWER_FAILURE_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), null, (String)CoefficientsLrb.get("COEFFICIENT_VIEWER_FAILURE_TITLE"), (String)CoefficientsLrb.get("COEFFICIENT_VIEWER_FAILURE_MESG"));
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("COEFFICIENT_VIEWER_FAILURE_TITLE"), (String)CoefficientsLrb.get("COEFFICIENT_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                CoefViewer.this.setLoading(false);
            }
        }
    }

    class CustomGenericTable
    extends GenericTableFixedColumns {
        CustomGenericTable() {
        }

        protected void setColumnVisible(TableColumn tableColumn, int n, boolean bl) {
        }

        @Override
        protected void handleSelectionChanged(ListSelectionModel listSelectionModel) {
        }

        @Override
        public void addDynamicCellRenderers() {
            if (CoefViewer.this._state.isSVM() || CoefViewer.this._state.isAnomaly()) {
                CoefViewer.this._barRenderer = new HistogramBarRenderer(1L, true, CoefViewer.this._labelNumericalFormat);
                this.addCellRenderer(CoefViewer.this._state.getTableModel().getColumnName(2), CoefViewer.this._barRenderer);
            } else if (CoefViewer.this._state.isGLM()) {
                CoefViewer.this._barRenderer = new HistogramBarRenderer(1L, true, CoefViewer.this._labelNumericalFormat);
                this.addCellRenderer(CoefViewer.this._state.getTableModel().getColumnName(2), CoefViewer.this._barRenderer);
                this.addCellRenderer(CoefViewer.this._state.getTableModel().getColumnName(3), CoefViewer.this._barRenderer);
            } else if (CoefViewer.this._state.isNB()) {
                CoefViewer.this._barRenderer = new HistogramBarRenderer(1L, true, CoefViewer.this._labelNumericalFormat);
                this.addCellRenderer(CoefViewer.this._state.getTableModel().getColumnName(2), CoefViewer.this._barRenderer);
            } else if (CoefViewer.this._state.isNMF()) {
                CoefViewer.this._barRenderer = new HistogramBarRenderer(1L, true, CoefViewer.this._labelPercentageFormat);
                this.addCellRenderer(CoefViewer.this._state.getTableModel().getColumnName(2), CoefViewer.this._barRenderer);
            }
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            string = CoefViewer.this.isNB() ? CoefViewer.this.formatCellValue(object, FormatType.PERCENTAGE) : CoefViewer.this.formatCellValue(object, FormatType.NUMERICAL);
            return string;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = "";
            Object object = null;
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            object = this.getValueAt(n, n2);
            string = CoefViewer.this.isNB() ? CoefViewer.this.formatCellValue(object, FormatType.PERCENTAGE) : CoefViewer.this.formatCellValue(object, FormatType.NUMERICAL);
            return string;
        }
    }

    private static enum FormatType {
        PERCENTAGE,
        NUMERICAL;

    }
}

