/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree.model;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.model.IlvDefaultSDMNode;
import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusterTreeSymbol;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditor;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusterTreeSDMModel;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.TreeLink;
import oracle.dmt.dataminer.navigator.modelnodes.ClusteringModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.OCModelNode;
import oracle.dmt.dataminer.server.model.CentroidRowData;
import oracle.dmt.dataminer.server.model.ClusteringDetailRow;
import oracle.dmt.dataminer.server.model.PredicateRowData;
import oracle.dmt.dataminer.server.model.RuleRowData;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.Context;

public class TreeNode
extends IlvDefaultSDMNode
implements PropertyChangeListener {
    protected ClusteringDetailRow _metaData;
    protected Map<String, PredicateRowData> _topItems;
    protected List<CentroidRowData> _topCentroids;
    protected String _tag;
    protected Context _context;
    private String _id;
    private String _x;
    private String _y;
    private double _recordCount = 0.0;
    private double _totalRecords = 0.0;
    private String _supportDisplayValue;
    private Integer _expanded = 1;
    private String _splitColumn;
    private Boolean _splitVisible;
    private int maxValuesDisplayed = 0;
    private int valuesDisplayed = 0;
    private int maxAttributeLength;
    private int maxValueLength;
    private static String freqBarWidth = "15";
    private static Integer minBarHeight = 0;
    private static Integer maxBarHeight = 20;
    private static Font treeFont = new Font("Dialog", 0, 12);
    private static Font treeTitltFont = new Font("Dialog", 1, 13);
    private static final String LABEL = "label";
    private static final String TOOLTIP = "tooltip";
    private static final String SPLIT = "split";
    private static final String SPLIT_VISIBLE = "isSplitVisible";
    private static final String SUPPORT = "support";
    private static final String COUNT = "count";
    private static final String TITLE = "nodeTitle";
    private static final String TEXT = "text";
    private static final String EXPANDABLE = "isExpandable";
    private static final String EXPANDED = "expanded";
    private static final String HEADER_VISIBLE = "isHeaderDetailVisible";
    private static final String CHART_VISIBLE = "barChartVisible";
    private static final String CHART_BAR_WIDTH = "chartBarWidth";
    private static final String MAX_FREQ_HEIGHT = "maxFreqHeight";
    private static final String MIN_FREQ_HEIGHT = "minFreqHeight";
    private static final String ITEMS_DISPLAYED = "numberOfItems";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String FONT = "font";
    private static final String TITLE_FONT = "titleFont";

    public TreeNode(String string) {
        super(string);
    }

    public TreeNode(String string, ClusteringDetailRow clusteringDetailRow, Context context) {
        super(string);
        Vector<PredicateRowData> vector;
        this._tag = string;
        this._metaData = clusteringDetailRow;
        this._context = context;
        this._x = "-1";
        this._y = "-1";
        this.setMaxValuesDisplayed(this.getModel().getMaxTargetValuesDisplayed());
        this.maxAttributeLength = 30;
        this.maxValueLength = 30;
        this._totalRecords = this.getModel().getRootNodeMetadata().getCount().doubleValue();
        this._recordCount = this.getData().getCount().doubleValue();
        double d = this._recordCount / this._totalRecords;
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(2);
        this._supportDisplayValue = ClusteringTreeEditorLrb.get("CLUSTER_PERCENT") + " " + numberFormat.format(d);
        this._splitColumn = null;
        this._splitVisible = false;
        if (this._context.getNode() instanceof OCModelNode && (vector = this.getData().getSplit_predicate()).size() > 0) {
            String string2;
            this._splitVisible = true;
            PredicateRowData predicateRowData = vector.get(0);
            this._splitColumn = string2 = TreeNode.getQualifiedAttributeName(predicateRowData);
        }
        this.initTopItems();
    }

    private void initTopItems() {
        Vector<Object> vector;
        this._topItems = new LinkedHashMap<String, PredicateRowData>();
        Comparator<PredicateRowData> comparator = new Comparator<PredicateRowData>(){

            @Override
            public int compare(PredicateRowData predicateRowData, PredicateRowData predicateRowData2) {
                return predicateRowData.getAttribute_confidence().compareTo(predicateRowData2.getAttribute_confidence()) * -1;
            }
        };
        RuleRowData ruleRowData = this._metaData.getRule();
        if (ruleRowData != null) {
            String string;
            vector = ruleRowData.getAntecedent();
            ArrayList arrayList = new ArrayList();
            Object object = new ArrayList();
            for (PredicateRowData predicateRowData : vector) {
                string = TreeNode.getQualifiedAttributeName(predicateRowData);
                if (object.contains(string)) continue;
                arrayList.add(predicateRowData);
                object.add(string);
            }
            Collections.sort(arrayList, comparator);
            Iterator<Object> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                PredicateRowData predicateRowData = (PredicateRowData)iterator.next();
                string = TreeNode.getQualifiedAttributeName(predicateRowData);
                this._topItems.put(string, predicateRowData);
            }
        }
        vector = this._metaData.getCentroid();
        this._topCentroids = new ArrayList<CentroidRowData>();
        for (Object object : vector) {
            this._topCentroids.add((CentroidRowData)object);
        }
    }

    public static String getQualifiedAttributeName(PredicateRowData predicateRowData) {
        String string = predicateRowData.getAttribute_subname() != null ? predicateRowData.getAttribute_name() + "." + predicateRowData.getAttribute_subname() : predicateRowData.getAttribute_name();
        return string;
    }

    public static String getQualifiedAttributeName(CentroidRowData centroidRowData) {
        String string = centroidRowData.getAttribute_subname() != null ? centroidRowData.getAttribute_name() + "." + centroidRowData.getAttribute_subname() : centroidRowData.getAttribute_name();
        return string;
    }

    public Map<String, PredicateRowData> getTopItems() {
        return this._topItems;
    }

    public List<CentroidRowData> getTopCentroids() {
        return this._topCentroids;
    }

    public void setMaxValuesDisplayed(int n) {
        this.maxValuesDisplayed = n;
    }

    private IlvSDMEngine getEngine() {
        IlvSDMEngine ilvSDMEngine = null;
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this._context.getNode();
        try {
            ilvSDMEngine = clusteringModelNode.getEngine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return ilvSDMEngine;
    }

    public ClusterTreeSDMModel getModel() {
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this._context.getNode();
        SDMUndoFilter sDMUndoFilter = this.getFilterModel();
        if (sDMUndoFilter == null) {
            return null;
        }
        return (ClusterTreeSDMModel)clusteringModelNode.getFilteredModel(sDMUndoFilter);
    }

    public SDMUndoFilter getFilterModel() {
        IlvSDMEngine ilvSDMEngine = this.getEngine();
        if (ilvSDMEngine == null) {
            return null;
        }
        return (SDMUndoFilter)ilvSDMEngine.getModel();
    }

    public void assignPropertyChangeListener(IlvSDMEngine ilvSDMEngine) {
        IlvGraphic ilvGraphic = ilvSDMEngine.getGraphic((Object)this, true);
        if (ilvGraphic == null || !(ilvGraphic instanceof ClusterTreeSymbol)) {
            throw new RuntimeException("not an instance of ClusterTreeSymbol");
        }
        ClusterTreeSymbol clusterTreeSymbol = (ClusterTreeSymbol)ilvGraphic;
        clusterTreeSymbol.addParameterChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        this.getUndoFilter().setObjectProperty((Object)this, string, object);
    }

    public SDMUndoFilter getUndoFilter() {
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this._context.getNode();
        IlvSDMEngine ilvSDMEngine = null;
        try {
            ilvSDMEngine = clusteringModelNode.getEngine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (ilvSDMEngine == null) {
            return null;
        }
        return (SDMUndoFilter)ilvSDMEngine.getModel();
    }

    public String getTag() {
        return this._tag;
    }

    public String getID() {
        return this._id;
    }

    public void setID(String string) {
        this._id = string;
    }

    public String[] getPropertyNames() {
        String[] stringArray = new String[]{};
        return stringArray;
    }

    public Object getProperty(String string) {
        Object object = null;
        try {
            if (string.equals("userObject") || string.equals("CSSclass")) {
                object = this.getData().getId();
            } else if (string.equals(X)) {
                object = this._x;
            } else if (string.equals(Y)) {
                object = this._y;
            } else if (string.endsWith(TITLE)) {
                object = this.getClusterTitle();
            } else if (string.equals(ITEMS_DISPLAYED)) {
                object = this.getItemsDisplayedCount();
            } else if (string.startsWith(TEXT)) {
                object = this.getAttributeText(string);
            } else if (string.equals(MIN_FREQ_HEIGHT)) {
                object = minBarHeight.toString();
            } else if (string.equals(MAX_FREQ_HEIGHT)) {
                object = maxBarHeight.toString();
            } else if (string.equals(CHART_BAR_WIDTH)) {
                object = freqBarWidth;
            } else if (string.equals(CHART_VISIBLE)) {
                object = Boolean.FALSE;
            } else if (string.equals(HEADER_VISIBLE)) {
                object = this.getModel().isHeaderDetailVisible().toString();
            } else if (string.equals(TOOLTIP)) {
                object = this.getToolTip();
            } else if (string.equals(LABEL)) {
                object = this.getData().getId();
            } else if (string.equals(EXPANDED)) {
                object = "" + this._expanded;
            } else if (string.equals(EXPANDABLE)) {
                object = "" + (this.getData().getChild().size() != 0);
            } else if (string.equals(COUNT)) {
                object = this.getCountDisplayString();
            } else if (string.equals(SUPPORT)) {
                object = this.getSupportValue();
            } else {
                if (string.equals(SPLIT_VISIBLE)) {
                    return this.isSplitVisible().toString();
                }
                if (string.equals(SPLIT)) {
                    object = this.getSplitDisplayString();
                } else if (string.equals(FONT)) {
                    object = treeFont;
                } else if (string.equals(TITLE_FONT)) {
                    object = treeTitltFont;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    public void setProperty(String string, Object object) {
        if (string.equals(X)) {
            this._x = (String)object;
        } else if (string.equals(Y)) {
            this._y = (String)object;
        } else if (string.equals(EXPANDED)) {
            this._expanded = (Integer)object;
        } else {
            System.out.println("Unhandled setProperty (" + string + ") to " + object);
        }
    }

    public String getClusterTitle() {
        return ClusteringTreeEditorLrb.get("CLUSTER_TITLE") + " " + this.getData().getCluster_id();
    }

    private String getCountDisplayString() {
        return ClusteringTreeEditorLrb.get("CLUSTER_COUNT") + " " + this.getData().getCount();
    }

    private String getSplitDisplayString() {
        return ClusteringTreeEditorLrb.get("CLUSTER_SPLIT") + " " + this.getSplitColumn();
    }

    private String getToolTip() {
        String string = "<html>";
        string = string + this.getClusterTitle();
        string = string + "<br>";
        string = string + this.getCountDisplayString();
        string = string + "<br>";
        string = string + this.getSupportValue();
        String string2 = this.getSplitColumn();
        if (string2 != null) {
            string = string + "<br>";
            string = string + this.getSplitDisplayString();
        }
        string = string + "</html>";
        return string;
    }

    private String getAttributeText(String string) {
        int n = Integer.valueOf(string.substring(4, 6)) - 1;
        if (n >= this.valuesDisplayed) {
            return null;
        }
        return this.getAttributeDetailString(n);
    }

    private String getItemsDisplayedCount() {
        this.valuesDisplayed = this._topCentroids.size() < this.maxValuesDisplayed ? this._topCentroids.size() : this.maxValuesDisplayed;
        String string = "" + this.valuesDisplayed;
        return string;
    }

    private String getSupportValue() {
        return this._supportDisplayValue;
    }

    private String getSplitColumn() {
        if (this._splitVisible.booleanValue()) {
            return this._splitColumn;
        }
        return null;
    }

    private Boolean isSplitVisible() {
        if (!this.getModel().isLoaded().booleanValue()) {
            return false;
        }
        return this._splitVisible;
    }

    private boolean isExpanded() {
        return this._expanded == 1;
    }

    private List<TreeNode> findChildNodes() {
        ClusterTreeSDMModel clusterTreeSDMModel = this.getModel();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        List<TreeLink> list = clusterTreeSDMModel.findLinksFromNode((IlvSDMNode)this);
        for (TreeLink treeLink : list) {
            arrayList.add((TreeNode)treeLink.getTo());
        }
        return arrayList;
    }

    public void setChildrenVisibility() {
        IlvSDMEngine ilvSDMEngine = this.getEngine();
        if (ilvSDMEngine == null) {
            throw new RuntimeException("Could not obtain engine.");
        }
        IlvGraphic ilvGraphic = ilvSDMEngine.getGraphic((Object)this, false);
        IlvGrapher ilvGrapher = ilvSDMEngine.getGrapher();
        ilvGrapher.setVisibleBranch(ilvGraphic, 0, this.isExpanded(), true);
        if (this.isExpanded()) {
            List<TreeNode> list = this.findChildNodes();
            for (TreeNode treeNode : list) {
                this.refreshChildrenVisibility(treeNode, ilvSDMEngine, ilvGrapher);
            }
        }
        ilvGrapher.reDraw();
    }

    private void refreshChildrenVisibility(TreeNode treeNode, IlvSDMEngine ilvSDMEngine, IlvGrapher ilvGrapher) {
        if (!treeNode.isExpanded()) {
            ilvGrapher.setVisibleBranch(ilvSDMEngine.getGraphic((Object)treeNode, false), 0, treeNode.isExpanded(), true);
            return;
        }
        List<TreeNode> list = treeNode.findChildNodes();
        for (TreeNode treeNode2 : list) {
            this.refreshChildrenVisibility(treeNode2, ilvSDMEngine, ilvGrapher);
        }
    }

    public String getAttributeDetailString(int n) {
        CentroidRowData centroidRowData = this._topCentroids.get(n);
        if (centroidRowData == null) {
            return "";
        }
        String string = TreeNode.getQualifiedAttributeName(centroidRowData);
        ClusteringTreeEditor clusteringTreeEditor = (ClusteringTreeEditor)this.getContext().getView();
        string = UIResourceHelper.trucateUIStringMiddle(string, clusteringTreeEditor.getMaxAttributeLength());
        String string2 = centroidRowData.getMode();
        Double d = centroidRowData.getMean();
        string = string + ": ";
        if (string2 != null) {
            string = string + UIResourceHelper.trucateUIStringMiddle(string2, clusteringTreeEditor.getMaxAttributeLength());
        } else if (d != null) {
            NumberFormat numberFormat = clusteringTreeEditor.getNumberFormat();
            String string3 = numberFormat.format(d);
            string = string + UIResourceHelper.trucateUIStringMiddle(string3, clusteringTreeEditor.getMaxAttributeLength());
        } else {
            string = string + "";
        }
        return string;
    }

    public String[] getDependentProperties(String string) {
        return new String[0];
    }

    public final ClusteringDetailRow getData() {
        return this._metaData;
    }

    private static TreeNode createNode(String string, Context context, ClusteringDetailRow clusteringDetailRow) throws Exception {
        TreeNode treeNode = null;
        String string2 = TreeNode.class.getPackage().getName() + "." + string;
        Class<?> clazz = Class.forName(string2);
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        Constructor<?> constructor = null;
        for (int i = 0; i < constructorArray.length && (constructor = constructorArray[i]).getGenericParameterTypes().length != 3; ++i) {
        }
        treeNode = (TreeNode)constructor.newInstance(string, clusteringDetailRow, context);
        if (clusteringDetailRow == null) {
            treeNode.initNewInstance(context);
        }
        return treeNode;
    }

    public static TreeNode createNode(ClusteringDetailRow clusteringDetailRow, Context context) throws Exception {
        TreeNode treeNode = null;
        treeNode = TreeNode.createNode(TreeNode.class.getSimpleName(), context, clusteringDetailRow);
        return treeNode;
    }

    public static TreeNode createNode(String string, Context context) throws Exception {
        TreeNode treeNode = null;
        treeNode = TreeNode.createNode(string, context, null);
        return treeNode;
    }

    protected void initNewInstance(Context context) {
        try {
            Class<?> clazz = Class.forName(ClusteringDetailRow.class.getPackage().getName());
            this.setData((ClusteringDetailRow)clazz.newInstance());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._context = context;
    }

    private void setData(ClusteringDetailRow clusteringDetailRow) {
        this._metaData = clusteringDetailRow;
    }

    protected Context getContext() {
        return this._context;
    }

    public TreeNode findParentNode() {
        ClusterTreeSDMModel clusterTreeSDMModel = this.getModel();
        TreeNode treeNode = null;
        ClusteringDetailRow clusteringDetailRow = this.getData();
        List<TreeLink> list = clusterTreeSDMModel.findLinksToNode((IlvSDMNode)this);
        for (TreeLink treeLink : list) {
            TreeNode treeNode2 = (TreeNode)treeLink.getTo();
            if (!treeNode2.getData().getId().equals(clusteringDetailRow.getId())) continue;
            treeNode = (TreeNode)treeLink.getFrom();
            break;
        }
        return treeNode;
    }
}

