/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusterTreeSDMModel;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.TreeNode;
import oracle.dmt.dataminer.server.model.PredicateRowData;
import oracle.dmt.dataminer.server.model.RuleRowData;

public class TreeRule {
    private static String ruleSeparatorIf = ClusteringTreeEditorLrb.get("RULE_SEPARATOR_IF");
    private static String ruleSeparatorAnd = ClusteringTreeEditorLrb.get("RULE_SEPARATOR_AND");
    private static String ruleSeparatorThen = ClusteringTreeEditorLrb.get("RULE_SEPARATOR_THEN");
    private static String ruleSeparatorRoot = "";
    private static Map<String, String> mathSymbolsHtml = new HashMap<String, String>();
    private static Map<String, String> reverseMathSymbolsHtml = new HashMap<String, String>();
    private static Map<String, String> mathSymbols = new HashMap<String, String>();
    private static Map<String, String> reverseMathSymbols = new HashMap<String, String>();
    private static Map<String, String> categoricalOperators = new HashMap<String, String>();
    private static final String GT = ">";
    private static final String LT = "<";
    private static final String GTE = ">=";
    private static final String LTE = "<=";
    private static final String GREATER = ">";
    private static final String LESS = "<";
    private static final String EQUAL = "=";
    private static final String ISIN = "IN";
    private static final String ISNOTIN = "NOT IN";
    private static final String IS = "IS";
    private static final String ISNOT = "IS NOT";
    private static final String I1 = "  ";
    private static final String I2 = "    ";
    private static final String I3 = "      ";
    private static final String SPACE = " ";

    private static boolean isSecondaryRule(RuleElement ruleElement, RuleElement ruleElement2) {
        String string = ruleElement2.getOperator();
        String string2 = ruleElement.getOperator();
        return !((!string.equals(">") && !string.equals(GTE) || !string2.equals("<") && !string2.equals(LTE)) && (!string.equals("<") && !string.equals(LTE) || !string2.equals(">") && !string2.equals(GTE)) || ruleElement2.getSecondaryRule() != null);
    }

    public static String getRulesHtml(TreeNode treeNode, boolean bl, int n) {
        String string = "";
        LinkedHashMap<String, RuleElement> linkedHashMap = new LinkedHashMap<String, RuleElement>();
        RuleRowData ruleRowData = treeNode.getData().getRule();
        if (ruleRowData == null) {
            return "<html>" + ClusteringTreeEditorLrb.get("RULES_NONE") + "</hmtl>";
        }
        Vector<PredicateRowData> vector = ruleRowData.getAntecedent();
        List<RuleElement> list = TreeRule.getAllRules(treeNode, vector, n);
        for (RuleElement ruleElement : list) {
            if (linkedHashMap.containsKey(ruleElement.getField())) {
                RuleElement ruleElement2 = (RuleElement)linkedHashMap.get(ruleElement.getField());
                if (TreeRule.isSecondaryRule(ruleElement, ruleElement2)) {
                    ruleElement2.setSecondaryRule(ruleElement);
                    continue;
                }
                if (!ruleElement.getOperator().equals(ISIN)) continue;
                ruleElement2.setExpression(ruleElement2.getExpression() + ", " + ruleElement.getExpression());
                continue;
            }
            linkedHashMap.put(ruleElement.getField(), ruleElement);
        }
        string = "<html>\n";
        Collection collection = linkedHashMap.values();
        string = string + TreeRule.getRulesHtmlTable(collection, treeNode, bl, true);
        string = string + "</html>\n";
        return string;
    }

    public static String getSplitRulesHtml(TreeNode treeNode, boolean bl) {
        String string = "";
        LinkedHashMap<String, RuleElement> linkedHashMap = new LinkedHashMap<String, RuleElement>();
        TreeNode treeNode2 = treeNode.findParentNode();
        boolean bl2 = false;
        ClusterTreeSDMModel clusterTreeSDMModel = treeNode.getModel();
        if (treeNode2 == null) {
            return "None";
        }
        if (!clusterTreeSDMModel.isSplitPredicateForNode(treeNode)) {
            bl2 = true;
        }
        Vector<PredicateRowData> vector = treeNode2.getData().getSplit_predicate();
        List<RuleElement> list = TreeRule.getAllRules(treeNode, vector, 0);
        for (RuleElement ruleElement : list) {
            if (linkedHashMap.containsKey(ruleElement.getField())) {
                RuleElement ruleElement2 = (RuleElement)linkedHashMap.get(ruleElement.getField());
                if (TreeRule.isSecondaryRule(ruleElement, ruleElement2)) {
                    ruleElement2.setSecondaryRule(ruleElement);
                    continue;
                }
                if (!ruleElement.getOperator().equals(ISIN)) continue;
                ruleElement2.setExpression(ruleElement2.getExpression() + ", " + ruleElement.getExpression());
                continue;
            }
            linkedHashMap.put(ruleElement.getField(), ruleElement);
        }
        if (bl2) {
            TreeRule.complementAllRules(linkedHashMap.values());
        }
        string = "<html>\n";
        string = string + ClusteringTreeEditorLrb.get("CLUSTER_SPLIT_PREDICATE") + "<br>";
        Collection collection = linkedHashMap.values();
        string = string + TreeRule.getRulesHtmlTable(collection, treeNode, bl, false);
        string = string + "</html>\n";
        return string;
    }

    private static void complementAllRules(Collection<RuleElement> collection) {
        for (RuleElement ruleElement : collection) {
            String string = TreeRule.getComplementOperator(ruleElement.getOperator());
            ruleElement.setOperator(string);
            RuleElement ruleElement2 = ruleElement.getSecondaryRule();
            if (ruleElement2 == null) continue;
            string = TreeRule.getComplementOperator(ruleElement2.getOperator());
            ruleElement2.setOperator(TreeRule.getComplementOperator(string));
        }
    }

    private static String getComplementOperator(String string) {
        if (string.equals(">")) {
            return LTE;
        }
        if (string.equals("<")) {
            return GTE;
        }
        if (string.equals(LTE)) {
            return ">";
        }
        if (string.equals(GTE)) {
            return "<";
        }
        if (string.equals(ISIN)) {
            return ISNOTIN;
        }
        if (string.equals(IS)) {
            return ISNOT;
        }
        throw new RuntimeException("Unexpected operator encountered");
    }

    private static List<RuleElement> getAllRules(TreeNode treeNode, Vector<PredicateRowData> vector, int n) {
        List list;
        Object object;
        Object object2;
        ArrayList<RuleElement> arrayList = new ArrayList<RuleElement>();
        HashMap hashMap = new HashMap();
        for (int i = 0; i < vector.size(); ++i) {
            object2 = vector.get(i);
            String string = TreeNode.getQualifiedAttributeName((PredicateRowData)object2);
            object = (List)hashMap.get(string);
            if (object == null) {
                list = new ArrayList<Object>();
                list.add(object2);
                hashMap.put(string, list);
                continue;
            }
            object.add(object2);
        }
        Set<String> set = treeNode.getTopItems().keySet();
        object2 = set.iterator();
        int n2 = 0;
        while (object2.hasNext()) {
            object = (String)object2.next();
            list = (List)hashMap.get(object);
            if (list == null) continue;
            for (PredicateRowData predicateRowData : list) {
                arrayList.add(TreeRule.constructRuleElement(predicateRowData));
            }
            if (n == 0 || ++n2 < n) continue;
            break;
        }
        return arrayList;
    }

    private static String getRulesHtmlTable(Collection<RuleElement> collection, TreeNode treeNode, boolean bl, boolean bl2) {
        String string = "";
        String string2 = bl2 ? "  <table>\n" : "  <table width=\"400\">\n";
        int n = 0;
        for (RuleElement ruleElement : collection) {
            String string3 = TreeRule.getFormattedPredicateString(ruleElement);
            if (bl2) {
                string = n == 0 ? ruleSeparatorIf : ruleSeparatorAnd;
            }
            string2 = string2 + TreeRule.getTableRow(true, string3, string, bl);
            ++n;
        }
        if (bl2) {
            string = ruleSeparatorThen;
            string2 = string2 + TreeRule.getTableRow(true, ClusteringTreeEditorLrb.get("RULE_CONSEQUENT") + SPACE + treeNode.getData().getCluster_id(), string, bl);
        }
        string2 = string2 + "  </table>\n";
        return string2;
    }

    private static String getTableRow(boolean bl, String string, String string2, boolean bl2) {
        String string3 = "";
        String string4 = bl ? string2 : "";
        String string5 = bl2 ? "" : "nowrap";
        string3 = string3 + "    <tr>\n";
        string3 = string3 + "      <td align=\"left\" valign=\"top\" style=\"font-family: monospace\"><b>" + string4 + "</b></td>\n";
        string3 = string3 + "      <td style=\"font-family: monospace\" " + string5 + ">" + string + "</td>\n";
        string3 = string3 + "    </tr>\n";
        return string3;
    }

    private static String getMathSymbolForOperator(String string, boolean bl, boolean bl2) {
        string = string.trim();
        Map<String, String> map = bl2 ? (bl ? reverseMathSymbolsHtml : mathSymbolsHtml) : (bl ? reverseMathSymbols : mathSymbols);
        return map.get(string);
    }

    public static String getFormattedPredicateString(RuleElement ruleElement) {
        return TreeRule.getFormattedPredicateString(ruleElement, 0);
    }

    public static String getFormattedPredicateString(RuleElement ruleElement, int n) {
        return TreeRule.getFormattedPredicateString(ruleElement, true, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFormattedPredicateString(RuleElement ruleElement, boolean bl, int n) {
        String string = "";
        String string2 = ruleElement.getOperator();
        if (string2.equals(ISIN) || string2.equals(IS) || string2.equals(ISNOTIN) || string2.equals(ISNOT)) {
            string = string + ruleElement.getField() + SPACE;
            string = string + categoricalOperators.get(ruleElement.getOperator()) + SPACE;
            string = string + "(" + ruleElement.getExpression() + ")";
        } else if (ruleElement.getSecondaryRule() == null) {
            string = string + ruleElement.getField() + SPACE;
            string = string + TreeRule.getMathSymbolForOperator(ruleElement.getOperator(), false, bl) + SPACE;
            string = string + ruleElement.getExpression();
        } else {
            if (ruleElement.getSecondaryRule() == null) throw new RuntimeException("Unexpected expression");
            RuleElement ruleElement2 = ruleElement.getSecondaryRule();
            if (ruleElement.getOperator().startsWith("<")) {
                string = string + ruleElement2.getExpression() + SPACE;
                string = string + TreeRule.getMathSymbolForOperator(ruleElement2.getOperator(), true, bl) + SPACE;
                string = string + ruleElement.getField() + SPACE;
                string = string + TreeRule.getMathSymbolForOperator(ruleElement.getOperator(), false, bl) + SPACE;
                string = string + ruleElement.getExpression();
            } else {
                if (!ruleElement.getOperator().startsWith(">")) throw new RuntimeException("Unexpected expression");
                string = string + ruleElement.getExpression() + SPACE;
                string = string + TreeRule.getMathSymbolForOperator(ruleElement.getOperator(), true, bl) + SPACE;
                string = string + ruleElement2.getField() + SPACE;
                string = string + TreeRule.getMathSymbolForOperator(ruleElement2.getOperator(), false, bl) + SPACE;
                string = string + ruleElement2.getExpression();
            }
        }
        if (n <= 0) return string;
        if (string.length() <= n) return string;
        return string.substring(0, n) + " ...";
    }

    public static String getFormattedExpressionString(RuleElement ruleElement, int n) {
        String string = "";
        if (ruleElement.getOperator().equals(ISIN) || ruleElement.getOperator().equals(IS)) {
            string = string + categoricalOperators.get(ruleElement.getOperator()) + SPACE;
            string = string + "(" + ruleElement.getExpression() + ")";
        } else if (ruleElement.getSecondaryRule() == null) {
            string = string + TreeRule.getMathSymbolForOperator(ruleElement.getOperator(), false, false) + SPACE;
            string = string + ruleElement.getExpression();
        }
        if (n > 0 && string.length() > n) {
            string = string.substring(0, n) + " ...";
        }
        return string;
    }

    private static RuleElement constructRuleElement(PredicateRowData predicateRowData) {
        RuleElement ruleElement = new RuleElement();
        String string = predicateRowData.getAttribute_str_value();
        if (string != null) {
            ruleElement.setExpression("\"" + predicateRowData.getValue() + "\"");
        } else {
            ruleElement.setExpression(predicateRowData.getValue());
        }
        ruleElement.setField(TreeNode.getQualifiedAttributeName(predicateRowData));
        ruleElement.setOperator(predicateRowData.getConditional_operator());
        return ruleElement;
    }

    static {
        mathSymbolsHtml.put(">", "&gt");
        mathSymbolsHtml.put("<", "&lt");
        mathSymbolsHtml.put(GTE, "&gt=");
        mathSymbolsHtml.put(LTE, "&lt=");
        mathSymbolsHtml.put(EQUAL, EQUAL);
        reverseMathSymbolsHtml.put(">", "&lt");
        reverseMathSymbolsHtml.put("<", "&gt");
        reverseMathSymbolsHtml.put(GTE, "&lt=");
        reverseMathSymbolsHtml.put(LTE, "&gt=");
        reverseMathSymbolsHtml.put(EQUAL, EQUAL);
        mathSymbols.put(">", ">");
        mathSymbols.put("<", "<");
        mathSymbols.put(GTE, GTE);
        mathSymbols.put(LTE, LTE);
        mathSymbols.put(EQUAL, EQUAL);
        reverseMathSymbols.put(">", ">");
        reverseMathSymbols.put("<", "<");
        reverseMathSymbols.put(GTE, GTE);
        reverseMathSymbols.put(LTE, LTE);
        reverseMathSymbols.put(EQUAL, EQUAL);
        categoricalOperators.put(ISIN, ClusteringTreeEditorLrb.get("RULE_IS_IN_COMPARISON"));
        categoricalOperators.put(IS, ClusteringTreeEditorLrb.get("RULE_IS_COMPARISON"));
        categoricalOperators.put(ISNOTIN, ClusteringTreeEditorLrb.get("RULE_IS_NOT_IN_COMPARISON"));
        categoricalOperators.put(ISNOT, ClusteringTreeEditorLrb.get("RULE_IS_NOT_COMPARISON"));
    }

    public static class RuleElement {
        String field = null;
        String operator = null;
        String expression = null;
        RuleElement secondaryRule = null;

        public void setField(String string) {
            this.field = string;
        }

        public String getField() {
            return this.field;
        }

        public void setOperator(String string) {
            this.operator = string;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setExpression(String string) {
            this.expression = string;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setSecondaryRule(RuleElement ruleElement) {
            this.secondaryRule = ruleElement;
        }

        public RuleElement getSecondaryRule() {
            return this.secondaryRule;
        }
    }
}

