/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClusterViewerState;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClustersLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusterTreeSDMModel;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.TreeNode;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.modelnodes.ClusteringModelNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.ClusteringDetailRow;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OraclePreparedStatement;

public class RenameClusterDialog
extends JPanel
implements DataminerGUIPanel {
    private TreeNode _treeNode;
    private Context _context;
    private JTextField clusterNameEdit;
    private JLabel clusterNameLabel;
    protected JEWTDialog _dlg;
    protected String wizName = "Rename Cluster";
    private boolean _dirty = false;

    public RenameClusterDialog(Context context, TreeNode treeNode) {
        this._treeNode = treeNode;
        this._context = context;
        this.initComponents();
        this.initUI();
        this.initRes();
    }

    private void initComponents() {
        this.clusterNameLabel = new JLabel();
        this.clusterNameEdit = new JTextField();
        this.clusterNameLabel.setLabelFor(this.clusterNameEdit);
        this.clusterNameLabel.setText("Cluster Name:");
        this.clusterNameEdit.setText("Cluster Name");
        this.clusterNameEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RenameClusterDialog.this.clusterNameEditActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.clusterNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clusterNameEdit, -2, 159, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clusterNameLabel).addComponent(this.clusterNameEdit, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void clusterNameEditActionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(ClusteringTreeEditorLrb.get("CLUSTER_NAME"), this.clusterNameLabel);
        UIResourceHelper.setComponentText(hashMap);
    }

    @Override
    public void initUI() {
        this.clusterNameEdit.setText(this._treeNode.getData().getCluster_id());
    }

    private boolean doWork() {
        String string;
        String string2 = this._treeNode.getData().getCluster_id();
        if (string2.equals(string = this.clusterNameEdit.getText())) {
            return true;
        }
        if (string.trim().length() == 0) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareClustersLrb.get("COMPARE_CLUSTERS_NAME_EMPTY"), (String)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_FAILURE_TITLE"), null);
            return false;
        }
        ClusteringDetailRow clusteringDetailRow = null;
        try {
            clusteringDetailRow = this.renameClusterLabel(string, string2);
        }
        catch (ClusterIdNotUniqueException clusterIdNotUniqueException) {
            MessageDialog.error((Component)this, (Object)ClusteringTreeEditorLrb.get("CLUSTER_NAME_INUSE"), (String)ClusteringTreeEditorLrb.get("CLUSTER_NAME_INUSE_TITLE"), null);
            return false;
        }
        catch (Exception exception) {
            if (exception.getMessage().equals(CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_NO_PRIVILEGE_MESG"))) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_NO_PRIVILEGE_MESG"), (String)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_FAILURE_TITLE"), null);
            }
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_FAILURE_TITLE"), (String)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_FAILURE_MESG"), null);
        }
        if (!clusteringDetailRow.getCluster_id().equals(string)) {
            return false;
        }
        this._treeNode.getModel().fireDataChanged(this._treeNode);
        UpdateMessage.firePropertiesChanged((Subject)this._context.getNode(), null, (Object)clusteringDetailRow);
        return true;
    }

    public ClusteringDetailRow renameClusterLabel(String string, String string2) throws Exception {
        Object object;
        Object object2;
        Connection connection = null;
        HashMap<String, ClusteringDetailRow> hashMap = null;
        Vector<ClusteringDetailRow> vector = new Vector<ClusteringDetailRow>();
        ClusterTreeSDMModel clusterTreeSDMModel = this._treeNode.getModel();
        Enumeration<IlvSDMNode> enumeration = clusterTreeSDMModel.getObjects();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            if (!(object2 instanceof TreeNode)) continue;
            object = (TreeNode)object2;
            if (string.equals(((TreeNode)object).getData().getCluster_id())) {
                throw new ClusterIdNotUniqueException();
            }
            vector.add(((TreeNode)object).getData());
        }
        hashMap = ClusteringDetailRow.createMappedClusterLabelToID(vector, false);
        object2 = (ClusteringDetailRow)hashMap.get(string2);
        object = (ClusteringModelNode)this._context.getNode();
        String string3 = ((ClusteringModelNode)object).getModelLoader().getModelName();
        StringBuilder stringBuilder = new StringBuilder("case ");
        for (ClusteringDetailRow clusteringDetailRow : vector) {
            StringBuilder stringBuilder2 = new StringBuilder();
            String string4 = StringUtils.getReplacedString(CompareClusterViewerState.alter_reverse_expression_cluster_id, "[CLUSTER_ID]", clusteringDetailRow.getId().toString());
            stringBuilder2.append(string4);
            if (((ClusteringDetailRow)object2).getId().equals(clusteringDetailRow.getId())) {
                clusteringDetailRow.setCluster_id(string);
                string4 = StringUtils.getReplacedString(CompareClusterViewerState.alter_reverse_expression_case_rename, "[NEW_NAME]", string);
            } else {
                string4 = StringUtils.getReplacedString(CompareClusterViewerState.alter_reverse_expression_case_keep_old, "[OLD_NAME]", clusteringDetailRow.getCluster_id());
            }
            stringBuilder2.append(string4);
            stringBuilder.append(stringBuilder2.toString());
        }
        stringBuilder.append(CompareClusterViewerState.alter_reverse_expression_case_end);
        SQLHelper sQLHelper = new SQLHelper();
        try {
            connection = Connections.getUniqueConnection(this._context);
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(CompareClusterViewerState.alter_reverse_expression_final);
            sQLHelper.opstmt.setStringAtName("MODEL_NAME", Model.getCombinedUserNameModelName(((ClusteringModelNode)object).getModelLoader().getUserName(), string3, true));
            sQLHelper.opstmt.setStringAtName("CASE_STATEMENT", stringBuilder.toString());
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            ((ClusteringDetailRow)object2).setCluster_id(string);
        }
        catch (Exception exception) {
            if (exception.getMessage().startsWith("ORA-01031")) {
                throw new Exception(CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_NO_PRIVILEGE_MESG"));
            }
            throw exception;
        }
        finally {
            sQLHelper.close();
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return object2;
    }

    protected JEWTDialog buildDialog(Context context, TreeNode treeNode) {
        RenameClusterDialog renameClusterDialog = new RenameClusterDialog(context, treeNode);
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
        jEWTDialog.setContent((Component)renameClusterDialog);
        jEWTDialog.setTitle(this.getDialogTitle());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "renameCluster.htm");
        return jEWTDialog;
    }

    protected String getDialogTitle() {
        return ClusteringTreeEditorLrb.get("RENAME_CLUSTER_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(Context context, TreeNode treeNode) {
        boolean bl = false;
        try {
            JEWTDialog jEWTDialog = this.buildDialog(context, treeNode);
            jEWTDialog.setResizable(true);
            final RenameClusterDialog renameClusterDialog = (RenameClusterDialog)jEWTDialog.getContent();
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object)) {
                        if (!renameClusterDialog.doWork()) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                        if (renameClusterDialog.isDirty()) {
                            RenameClusterDialog.this.setDirty(true);
                        }
                    }
                }
            });
            this._dlg = jEWTDialog;
            if (jEWTDialog != null) {
                bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
        }
        finally {
            if (!bl) {
                this.cancel();
            }
        }
        return bl;
    }

    protected void cancel() {
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    class ClusterIdNotUniqueException
    extends Exception {
        ClusterIdNotUniqueException() {
        }
    }
}

