/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreePreferencesSettings;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditorLrb;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;

public class ClusteringTreePreferencesPanel
extends DefaultTraversablePanel
implements ActionListener,
DataminerGUIPanel {
    private JRadioButton horizontalRb;
    private JLabel infoLabel;
    private JLabel layoutOptionsLabel;
    private JLabel nodeOptionsLabel;
    private JCheckBox showDetailChk;
    private JRadioButton verticalRb;

    public ClusteringTreePreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.nodeOptionsLabel = new JLabel();
        this.showDetailChk = new JCheckBox();
        this.layoutOptionsLabel = new JLabel();
        this.verticalRb = new JRadioButton();
        this.horizontalRb = new JRadioButton();
        this.infoLabel = new JLabel();
        this.nodeOptionsLabel.setText("Default Node Display Options");
        this.showDetailChk.setSelected(true);
        this.showDetailChk.setText("Show Detailed Header");
        this.layoutOptionsLabel.setText("Default Layout");
        this.verticalRb.setText("Vertical");
        this.horizontalRb.setText("Horizontal");
        this.infoLabel.setText("Info text");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.infoLabel, -2, 326, -2)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.showDetailChk)).addComponent(this.nodeOptionsLabel))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.horizontalRb).addComponent(this.verticalRb))).addComponent(this.layoutOptionsLabel)))).addContainerGap(133, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.nodeOptionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showDetailChk).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.layoutOptionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.verticalRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.horizontalRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 156, Short.MAX_VALUE).addComponent(this.infoLabel).addContainerGap()));
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(ClusteringTreeEditorLrb.get("NODE_OPTIONS_LABEL"), this.nodeOptionsLabel);
        hashMap.put(ClusteringTreeEditorLrb.get("SHOW_DETAIL_HEADER"), this.showDetailChk);
        hashMap.put(ClusteringTreeEditorLrb.get("LAYOUT_OPTIONS_LABEL"), this.layoutOptionsLabel);
        UIResourceHelper.setComponentText(hashMap);
        this.setHelpID("data_miner_prefs");
        this.verticalRb.setText(ClusteringTreeEditorLrb.get("VERTICAL"));
        this.horizontalRb.setText(ClusteringTreeEditorLrb.get("HORIZONTAL"));
    }

    @Override
    public void initUI() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.horizontalRb);
        buttonGroup.add(this.verticalRb);
        this.infoLabel.setVisible(false);
        this.infoLabel.setText(DecisionTreeEditorLrb.get("INFO_LABEL"));
        this.infoLabel.setIcon(UIResourceHelper.getImageIcon(this.getClass(), DecisionTreeEditorLrb.get("DEFAULT_PREFS_INFO_ICON")));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.infoLabel.setVisible(true);
    }

    public void onEntry(TraversableContext traversableContext) {
        ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesPanel.getPreferences(traversableContext);
        this.showDetailChk.setSelected(clusteringTreePreferencesSettings.isShowNodeDetailHeader());
        this.horizontalRb.setSelected(clusteringTreePreferencesSettings.isHorizontalLayout());
        this.verticalRb.setSelected(!clusteringTreePreferencesSettings.isHorizontalLayout());
        this.showDetailChk.addActionListener(this);
        this.horizontalRb.addActionListener(this);
        this.verticalRb.addActionListener(this);
    }

    public void onExit(TraversableContext traversableContext) {
        ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesPanel.getPreferences(traversableContext);
        clusteringTreePreferencesSettings.setShowNodeDetailHeader(this.showDetailChk.isSelected());
        clusteringTreePreferencesSettings.setHorizontalOrientation(this.horizontalRb.isSelected());
        this.showDetailChk.removeActionListener(this);
        this.horizontalRb.removeActionListener(this);
        this.verticalRb.removeActionListener(this);
    }

    private static ClusteringTreePreferencesSettings getPreferences(TraversableContext traversableContext) {
        return ClusteringTreePreferencesSettings.getInstance(traversableContext.getPropertyStorage());
    }
}

