/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import ilog.views.IlvManagerView;
import ilog.views.sdm.IlvSDMEngine;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditor;
import oracle.dmt.dataminer.mviewer.clustering.tree.RenameClusterDialog;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.TreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;

public class ClusteringTreeContextMenu
implements ContextMenuListener,
Controller {
    private static ClusteringTreeContextMenu _instance = null;
    protected static int RENAME_NODE_ACTION_ID = Ide.createCmdID((String)"RenameNodeAction");
    protected static int PRIMARY_EDIT_ACTION_ID = Ide.createCmdID((String)"EditNodeAction");
    protected static int SECONDARY_EDIT_ACTION_ID = Ide.createCmdID((String)"EditNodeActionSecondary");
    protected static int TERTIARY_EDIT_ACTION_ID = Ide.createCmdID((String)"EditNodeActionTertiary");

    public static ClusteringTreeContextMenu getInstance() {
        if (_instance == null) {
            _instance = new ClusteringTreeContextMenu();
        }
        return _instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void menuWillShow(ContextMenu contextMenu) {
        contextMenu.removeAll();
        Context context = contextMenu.getContext();
        View view = context.getView();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        if (!(view instanceof ClusteringTreeEditor)) return;
        IlvManagerView ilvManagerView = ((DiagramView)view).getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine == null) return;
        Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof TreeNode)) continue;
            arrayList.add((TreeNode)e);
        }
        if (arrayList.size() == 0) {
            return;
        }
        int n = arrayList.size();
        ilvSDMEngine = IdeAction.get((int)PRIMARY_EDIT_ACTION_ID);
        ilvSDMEngine.addController((Controller)this);
        if (n != 1) return;
        enumeration = IdeAction.get((int)RENAME_NODE_ACTION_ID);
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)enumeration, 1.0f);
        jMenuItem.setText("Rename Node...");
        enumeration.addController(this);
        contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        try {
            ClusteringTreeContextMenu.handlePrimaryEdit(context, (ClusteringTreeEditor)context.getView());
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
        }
        return true;
    }

    public static void handlePrimaryEdit(Context context, ClusteringTreeEditor clusteringTreeEditor) throws Exception {
        TreeNode treeNode = clusteringTreeEditor.getSelectedDiagramNode();
        if (!(treeNode instanceof TreeNode)) {
            return;
        }
        ClusteringTreeContextMenu.handleRename(context, clusteringTreeEditor);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        View view = context.getView();
        if (!(view instanceof ClusteringTreeEditor)) {
            return false;
        }
        ClusteringTreeEditor clusteringTreeEditor = (ClusteringTreeEditor)view;
        if (ideAction.getCommandId() == PRIMARY_EDIT_ACTION_ID || ideAction.equals(IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES))) {
            try {
                ClusteringTreeContextMenu.handlePrimaryEdit(context, clusteringTreeEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == RENAME_NODE_ACTION_ID) {
            try {
                ClusteringTreeContextMenu.handleRename(context, clusteringTreeEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        return false;
    }

    private static void handleRename(Context context, ClusteringTreeEditor clusteringTreeEditor) throws Exception {
        TreeNode treeNode;
        RenameClusterDialog renameClusterDialog;
        boolean bl;
        TreeNode treeNode2 = clusteringTreeEditor.getSelectedDiagramNode();
        if (treeNode2 instanceof TreeNode && (bl = (renameClusterDialog = new RenameClusterDialog(context, treeNode = treeNode2)).invoke(context, treeNode))) {
            clusteringTreeEditor.refreshLayout(treeNode2);
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        View view = context.getView();
        if (!(view instanceof ClusteringTreeEditor)) {
            return false;
        }
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        IlvManagerView ilvManagerView = ((DiagramView)view).getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof TreeNode)) continue;
                arrayList.add((TreeNode)e);
            }
        } else {
            return true;
        }
        if (arrayList.size() == 0) {
            return true;
        }
        if (ideAction.getCommandId() == PRIMARY_EDIT_ACTION_ID || ideAction.equals(IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES))) {
            ideAction.setEnabled(true);
            return true;
        }
        if (ideAction.getCommandId() == SECONDARY_EDIT_ACTION_ID) {
            ideAction.setEnabled(false);
            return true;
        }
        if (ideAction.getCommandId() == TERTIARY_EDIT_ACTION_ID) {
            ideAction.setEnabled(false);
            return true;
        }
        return true;
    }
}

