/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreePreferencesSettings;
import oracle.dmt.dataminer.mviewer.clustering.tree.TreeRule;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.TreeNode;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class ClusterRulePane
extends JPanel
implements DataminerGUIPanel {
    private TreeNode treeNode;
    private JScrollPane _ruleScrollPane;
    private JEditorPane _ruleViewPane;
    private JComboBox _topItemSelect;
    private JLabel _componentLabel;
    private JLabel _comboLabel;
    private boolean wrap;
    private int topNAttributes;
    private JPanel contentPanel;
    private JCheckBox wrapCheckbox;

    public ClusterRulePane(TreeNode treeNode) {
        this.treeNode = treeNode;
        String[] stringArray = new String[11];
        stringArray[0] = ClusteringTreeEditorLrb.get("ALL_ITEMS");
        stringArray[1] = new Integer(1).toString();
        new Integer(1);
        stringArray[2] = Integer.toString(2);
        new Integer(1);
        stringArray[3] = Integer.toString(3);
        new Integer(1);
        stringArray[4] = Integer.toString(4);
        new Integer(1);
        stringArray[5] = Integer.toString(5);
        new Integer(1);
        stringArray[6] = Integer.toString(6);
        new Integer(1);
        stringArray[7] = Integer.toString(7);
        new Integer(1);
        stringArray[8] = Integer.toString(8);
        new Integer(1);
        stringArray[9] = Integer.toString(9);
        new Integer(1);
        stringArray[10] = Integer.toString(10);
        String[] stringArray2 = stringArray;
        this._topItemSelect = new JComboBox<String>(stringArray2);
        this._componentLabel = new JLabel();
        this._comboLabel = new JLabel();
        this._comboLabel.setLabelFor(this._topItemSelect);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.wrapCheckbox = new JCheckBox();
        this.contentPanel = new JPanel();
        this.wrapCheckbox.setText("Wrap");
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 2));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.wrapCheckbox, -2, 71, -2).addContainerGap(369, Short.MAX_VALUE)).addComponent(this.contentPanel, -1, 440, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.contentPanel, -1, 97, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wrapCheckbox)));
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(ClusteringTreeEditorLrb.get("RULE_CONTAINER_LABEL"), this._componentLabel);
        hashMap.put(ClusteringTreeEditorLrb.get("TOP_N_ITEMS_LABEL"), this._comboLabel);
        hashMap.put(ClusteringTreeEditorLrb.get("WRAP_RULE_OPTION"), this.wrapCheckbox);
        UIResourceHelper.setComponentText(hashMap);
    }

    @Override
    public void initUI() {
        final ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
        this._ruleScrollPane = new JScrollPane();
        this._ruleViewPane = new JEditorPane();
        this._ruleScrollPane.setViewportView(this._ruleViewPane);
        this.topNAttributes = clusteringTreePreferencesSettings.getTopNRuleAttributes();
        this._topItemSelect.setSelectedIndex(this.topNAttributes);
        this._topItemSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusterRulePane.this.topNAttributes = ((JComboBox)actionEvent.getSource()).getSelectedIndex();
                clusteringTreePreferencesSettings.setTopNRuleAttributes(ClusterRulePane.this.topNAttributes);
                String string = TreeRule.getRulesHtml(ClusterRulePane.this.treeNode, ClusterRulePane.this.wrap, ClusterRulePane.this.topNAttributes);
                ClusterRulePane.this.displayRules(string);
            }
        });
        ControlBar controlBar = new ControlBar();
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setControlBar(controlBar);
        componentWithTitlebar.setLabel(this._componentLabel);
        componentWithTitlebar.add((Component)this._ruleScrollPane);
        controlBar.add((Component)this._comboLabel);
        controlBar.add((Component)new JLabel(" "));
        controlBar.add((Component)this._topItemSelect);
        this.contentPanel.add((Component)componentWithTitlebar);
        this.wrap = clusteringTreePreferencesSettings.getWrapNodeRules();
        this.wrapCheckbox.setSelected(this.wrap);
        this.wrapCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusterRulePane.this.wrap = ((JCheckBox)actionEvent.getSource()).isSelected();
                clusteringTreePreferencesSettings.setWrapNodeRules(ClusterRulePane.this.wrap);
                String string = TreeRule.getRulesHtml(ClusterRulePane.this.treeNode, ClusterRulePane.this.wrap, ClusterRulePane.this.topNAttributes);
                ClusterRulePane.this.displayRules(string);
            }
        });
        String string = TreeRule.getRulesHtml(this.treeNode, this.wrap, this.topNAttributes);
        this.displayRules(string);
    }

    private void displayRules(String string) {
        this._ruleViewPane.setContentType("text/html");
        this._ruleViewPane.setText(string);
        this._ruleViewPane.select(0, 0);
        this._ruleViewPane.setEditable(false);
    }
}

