/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.compare;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.GenericTableFixedColumns;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.MiniHistogramCellRenderer;
import oracle.dmt.dataminer.controls.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;
import oracle.dmt.dataminer.mviewer.clustering.compare.ClusterCompareTableModel;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClusterViewerState;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClustersLrb;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClustersModelRow;
import oracle.dmt.dataminer.mviewer.clustering.compare.RenameClusterDialog;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class CompareClustersMainPanel
extends DataMinerViewGUI {
    private static Icon _icon;
    private CompareClusterViewerState _state;
    private JPanel _jlegendPanel;
    private JPanel _jGraphMainPanel;
    private JPanel _jGraphPanel;
    private GraphPanel[] _graphPanel;
    private JScrollPane jScrollPane1;
    private CustomGenericTable _jClusterDetailTable;
    private JLabel _jRowsOutOfTotalLabel = new JLabel();
    private JComponent _findPane;
    private boolean _reload = true;
    private int FIXED_COLUMNS = 0;
    private Dimension _histogramRowDimension = new Dimension(120, 25);
    private boolean _loadedFilterSetting = false;
    private static Preferences _p;
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private static String _tooManyAttributes;
    private static String _noSelectedAttributes;
    public static final int FILTER_DETAIL_ATTRIBUTE = 0;
    public static final int FILTER_DETAIL_RANK = 1;
    private SearchField _jFilterCtl = new SearchField();
    private SearchCategory _defaultSearchCategory = new SearchCategory(CompareClustersLrb.get("COMPARE_CLUSTERS_DETAIL_TABLE_COLUMN_NAME"));
    private int _currentSearchCategory = 0;
    private JButton _jApplyFilterButton;
    private JComboBox _jCluster1Combo;
    private JLabel _jCluster1ComboLabel;
    private JComboBox _jCluster2Combo;
    private JLabel _jCluster2ComboLabel;
    private JPanel _jDetailPanel;
    private JSpinner _jFetchSize;
    private JLabel _jFetchSizeLabel;
    private JCheckBox _jLeafsOnlyCheckBox;
    private JButton jBtnClister1Edit;
    private JButton jBtnClister2Edit;
    private ComponentWithTitlebar<JComponent> jClusterCompareComponentWithTitlebar;
    private JSplitPane jSplitPane1;
    private JLabel _cluster1Label;
    private JLabel _cluster2Label;

    public CompareClusterViewerState getState() {
        return this._state;
    }

    public CompareClustersMainPanel(Editor editor, Context context) {
        super(editor, context);
        this._state = new CompareClusterViewerState(context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jCluster1ComboLabel = new JLabel();
        this._jCluster1Combo = new JComboBox();
        this.jBtnClister1Edit = new JButton();
        this._jCluster2ComboLabel = new JLabel();
        this._jCluster2Combo = new JComboBox();
        this.jBtnClister2Edit = new JButton();
        this._jLeafsOnlyCheckBox = new JCheckBox();
        this._jApplyFilterButton = new JButton();
        this._jFetchSizeLabel = new JLabel();
        this._jFetchSize = new JSpinner();
        this.jSplitPane1 = new JSplitPane();
        this._jDetailPanel = new JPanel();
        this.jClusterCompareComponentWithTitlebar = new ComponentWithTitlebar();
        this._jCluster1ComboLabel.setText("Cluster 1:");
        this._jCluster1Combo.setMaximumSize(new Dimension(150, 20));
        this._jCluster1Combo.setMinimumSize(new Dimension(150, 20));
        this._jCluster1Combo.setPreferredSize(new Dimension(150, 20));
        this._jCluster1Combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareClustersMainPanel.this._jCluster1ComboActionPerformed(actionEvent);
            }
        });
        this.jBtnClister1Edit.setText("Edit");
        this.jBtnClister1Edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareClustersMainPanel.this.jBtnClister1EditActionPerformed(actionEvent);
            }
        });
        this._jCluster2ComboLabel.setText("Cluster 2:");
        this._jCluster2Combo.setMaximumSize(new Dimension(150, 20));
        this._jCluster2Combo.setMinimumSize(new Dimension(150, 20));
        this._jCluster2Combo.setPreferredSize(new Dimension(150, 20));
        this._jCluster2Combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareClustersMainPanel.this._jCluster2ComboActionPerformed(actionEvent);
            }
        });
        this.jBtnClister2Edit.setText("Edit");
        this.jBtnClister2Edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareClustersMainPanel.this.jBtnClister2EditActionPerformed(actionEvent);
            }
        });
        this._jLeafsOnlyCheckBox.setText("Leafs Only");
        this._jApplyFilterButton.setText("Query");
        this._jApplyFilterButton.setHorizontalAlignment(11);
        this._jApplyFilterButton.setMaximumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setMinimumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setPreferredSize(new Dimension(87, 23));
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareClustersMainPanel.this._jApplyFilterButtonActionPerformed(actionEvent);
            }
        });
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jFetchSizeLabel.setPreferredSize(new Dimension(60, 14));
        this._jFetchSize.setMaximumSize(new Dimension(87, 20));
        this._jFetchSize.setMinimumSize(new Dimension(87, 20));
        this._jFetchSize.setPreferredSize(new Dimension(87, 20));
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.8);
        this.jSplitPane1.setLastDividerLocation(400);
        GroupLayout groupLayout = new GroupLayout(this._jDetailPanel);
        this._jDetailPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 738, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 368, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this._jDetailPanel);
        this.jSplitPane1.setLeftComponent((Component)this.jClusterCompareComponentWithTitlebar);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING, -1, 740, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this._jCluster1ComboLabel, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jCluster1Combo, -2, 134, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnClister1Edit).addGap(18, 18, 18).addComponent(this._jCluster2ComboLabel, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jCluster2Combo, -2, 134, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnClister2Edit)).addGroup(groupLayout2.createSequentialGroup().addComponent(this._jLeafsOnlyCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 466, Short.MAX_VALUE).addComponent(this._jFetchSizeLabel, -2, 76, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jFetchSize, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this._jApplyFilterButton, GroupLayout.Alignment.TRAILING, -1, 106, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout2.linkSize(0, this.jBtnClister1Edit, this.jBtnClister2Edit);
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jCluster1ComboLabel).addComponent(this._jApplyFilterButton, -2, -1, -2).addComponent(this._jCluster2Combo, -2, -1, -2).addComponent(this.jBtnClister2Edit).addComponent(this._jCluster2ComboLabel).addComponent(this._jCluster1Combo, -2, -1, -2).addComponent(this.jBtnClister1Edit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jFetchSize, -2, -1, -2).addComponent(this._jLeafsOnlyCheckBox).addComponent(this._jFetchSizeLabel, -2, -1, -2)).addGap(11, 11, 11).addComponent(this.jSplitPane1, -1, 379, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.linkSize(1, this.jBtnClister1Edit, this.jBtnClister2Edit);
        groupLayout2.linkSize(1, this._jCluster1Combo, this._jCluster2Combo);
    }

    private void _jCluster1ComboActionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        this._state.setClusterLabel1((String)this._jCluster1Combo.getSelectedItem());
        if (this._reload) {
            this._jApplyFilterButton_actionPerformed(null);
        }
    }

    private void _jCluster2ComboActionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        this._state.setClusterLabel2((String)this._jCluster2Combo.getSelectedItem());
        if (this._reload) {
            this._jApplyFilterButton_actionPerformed(null);
        }
    }

    private void _jApplyFilterButtonActionPerformed(ActionEvent actionEvent) {
        this._jApplyFilterButton_actionPerformed(actionEvent);
    }

    private void jBtnClister1EditActionPerformed(ActionEvent actionEvent) {
        this.renameCluster(this._jCluster1Combo, this._jCluster2Combo);
    }

    private void jBtnClister2EditActionPerformed(ActionEvent actionEvent) {
        this.renameCluster(this._jCluster2Combo, this._jCluster1Combo);
    }

    @Override
    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)ClusterLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(ClusterLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(ClusterLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(this.getIcon());
        this._jApplyFilterButton.setToolTipText(ClusterLrb.get("QUERY_ADA"));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSize, (String)ClusterLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(ClusterLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(ClusterLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSize.setToolTipText(ClusterLrb.get("FETCH_SIZE_ADA") + "\n" + ClusterLrb.get("FETCH_SIZE_RANGE"));
        this._jFetchSize.setModel(new SpinnerNumberModel(CompareClusterViewerState._initial_fetchsize, 1, Integer.MAX_VALUE, 100));
        ResourceUtils.resButton((AbstractButton)this.jBtnClister1Edit, (String)CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_EDIT"));
        this.jBtnClister1Edit.getAccessibleContext().setAccessibleName(CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_EDIT"));
        this.jBtnClister1Edit.getAccessibleContext().setAccessibleDescription(CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_EDIT_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jBtnClister2Edit, (String)CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_EDIT2"));
        this.jBtnClister2Edit.getAccessibleContext().setAccessibleName(CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_EDIT"));
        this.jBtnClister2Edit.getAccessibleContext().setAccessibleDescription(CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_EDIT_ADA"));
        ResourceUtils.resButton((AbstractButton)this._jLeafsOnlyCheckBox, (String)ClusterLrb.get("LEAVES_ONLY"));
        this._jLeafsOnlyCheckBox.getAccessibleContext().setAccessibleName(ClusterLrb.get("LEAVES_ONLY"));
        this._jLeafsOnlyCheckBox.getAccessibleContext().setAccessibleDescription(ClusterLrb.get("LEAVES_ONLY_ADA"));
        this._jLeafsOnlyCheckBox.setToolTipText(ClusterLrb.get("LEAVES_ONLY_ADA"));
        ResourceUtils.resLabel((JLabel)this._jCluster1ComboLabel, (Component)this._jCluster1Combo, (String)CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_CLUSTER1"));
        this._jCluster1ComboLabel.getAccessibleContext().setAccessibleName(CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_CLUSTER1"));
        this._jCluster1ComboLabel.getAccessibleContext().setAccessibleDescription(CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_CLUSTER1_ADA"));
        ResourceUtils.resLabel((JLabel)this._jCluster2ComboLabel, (Component)this._jCluster2Combo, (String)CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_CLUSTER2"));
        this._jCluster2ComboLabel.getAccessibleContext().setAccessibleName(CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_CLUSTER2"));
        this._jCluster2ComboLabel.getAccessibleContext().setAccessibleDescription(CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_CLUSTER2_ADA"));
        this.loadRowsOutOfTotalLabel(0, 0);
    }

    @Override
    public void initUI() {
        this._jFetchSize.setLocale(Locale.getDefault());
        this._jLeafsOnlyCheckBox.setSelected(true);
        this._jLeafsOnlyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareClustersMainPanel.this._jLeafsOnlyCheckBox_actionPerformed(actionEvent);
            }
        });
        this._jGraphPanel = new JPanel();
        this._jGraphPanel.setLayout(new BorderLayout());
        this._jGraphPanel.setPreferredSize(new Dimension(300, 300));
        this._jGraphMainPanel = new JPanel();
        this._jGraphMainPanel.setLayout(new BorderLayout());
        this._jGraphMainPanel.setPreferredSize(new Dimension(300, 300));
        this._jGraphMainPanel.add((Component)this._jGraphPanel, "Center");
        this.jSplitPane1.setResizeWeight(0.8);
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setRightComponent(this._jGraphMainPanel);
        this._jClusterDetailTable = new CustomGenericTable();
        this.jScrollPane1 = new JScrollPane((Component)((Object)this._jClusterDetailTable));
        this._jClusterDetailTable.setFillsViewportHeight(true);
        this.jClusterCompareComponentWithTitlebar.setComponent((JComponent)this.jScrollPane1);
        this.jClusterCompareComponentWithTitlebar.setLabel(this._jRowsOutOfTotalLabel);
        ControlBar controlBar = new ControlBar();
        this.setupFilterControl(controlBar);
        this.jClusterCompareComponentWithTitlebar.setControlBar(controlBar);
        this._jClusterDetailTable.setShowGrid(true);
        this.jClusterCompareComponentWithTitlebar.setPreferredSize(new Dimension(400, 400));
        this.jSplitPane1.setTopComponent((Component)this.jClusterCompareComponentWithTitlebar);
        this.setLoading(true);
        this.initializeControls();
        this.addListeners();
        this.jSplitPane1.updateUI();
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    private void addListeners() {
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                CompareClustersMainPanel.this.translateSearchCategoryToConstant(CompareClustersMainPanel.this._jFilterCtl.getSelectedCategory());
                CompareClustersMainPanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                CompareClustersMainPanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                CompareClustersMainPanel.this.processFilter(string);
            }
        });
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = -1;
        if (searchCategory.getLabel().equals(CompareClustersLrb.get("COMPARE_CLUSTERS_DETAIL_SEARCH_CATEGORY_NAME"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(CompareClustersLrb.get("COMPARE_CLUSTERS_DETAIL_SEARCH_CATEGORY_RANK"))) {
            this._currentSearchCategory = 1;
        } else assert (false) : "Invalid Search Category Code";
        return n;
    }

    private void processFilter(String string) {
        try {
            GenericBaseTableModel genericBaseTableModel = this._state.getFilteredStatistics(string, this._currentSearchCategory);
            this.setupTable(genericBaseTableModel);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_TITLE"), (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_MESG"), null);
        }
    }

    private void initializeControls() {
        this.setupTable(new ClusterCompareTableModel());
        this.enableControls(false);
    }

    private void setupFilterControl(ControlBar controlBar) {
        this._findPane = new Box(2);
        this._jFilterCtl = this.searchField();
        this._jFilterCtl.setStyle(SearchField.Style.FILTER);
        this._jFilterCtl.addCategory(this._defaultSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(CompareClustersLrb.get("COMPARE_CLUSTERS_DETAIL_SEARCH_CATEGORY_RANK")));
        this._jFilterCtl.setSelectedCategory(this._defaultSearchCategory);
        this._findPane.setName("Find");
        this._findPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this._findPane.add((Component)this._jFilterCtl);
        Dimension dimension = this._findPane.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 145);
        Dimension dimension3 = this.derive(dimension, 80);
        this._findPane.setPreferredSize(dimension2);
        this._findPane.setMaximumSize(dimension2);
        this._findPane.setMinimumSize(dimension3);
        controlBar.add((Component)this._findPane);
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private SearchField searchField() {
        SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                CompareClustersMainPanel.this.translateSearchCategoryToConstant(CompareClustersMainPanel.this._jFilterCtl.getSelectedCategory());
                CompareClustersMainPanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                CompareClustersMainPanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                CompareClustersMainPanel.this.processFilter(string);
            }
        });
        return searchField;
    }

    public void loadClusterCombos() {
        String string;
        List<String> list = this._state.getClusterLabels();
        this._jCluster1Combo.setModel(new DefaultComboBoxModel<String>(new Vector<String>(list)));
        if (list.size() > 1) {
            this._jCluster2Combo.setModel(new DefaultComboBoxModel<String>(new Vector<String>(list)));
        }
        String string2 = string = this._state.getClusterLabel1();
        if (list.contains(string)) {
            this._jCluster1Combo.setSelectedItem(string);
        } else {
            string2 = list.get(0);
            this._state.setClusterLabel1(string2);
            this._jCluster1Combo.setSelectedItem(string2);
        }
        String string3 = this._state.getClusterLabel2();
        if (string3 == null) {
            return;
        }
        String string4 = string3;
        if (list.contains(string3)) {
            this._jCluster2Combo.setSelectedItem(string3);
        } else {
            int n = 0;
            do {
                if (list.contains(string3)) continue;
                string4 = list.get(n++);
            } while (string4.equals(string2));
            this._state.setClusterLabel2(string4);
            this._jCluster2Combo.setSelectedItem(string4);
        }
    }

    private void enableControls(boolean bl) {
        this._jApplyFilterButton.setEnabled(bl);
        this._jFetchSize.setEnabled(bl);
        this._jFetchSizeLabel.setEnabled(bl);
        this._jCluster1Combo.setEnabled(bl);
        this._jCluster2Combo.setEnabled(bl);
        this.jBtnClister1Edit.setEnabled(bl);
        this.jBtnClister2Edit.setEnabled(bl);
    }

    private void _jLeafsOnlyCheckBox_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        boolean bl = this._jLeafsOnlyCheckBox.isSelected();
        this._state.setLeafsOnlyNew(bl);
        this._reload = false;
        this.loadClusterCombos();
        this._reload = true;
        if (null == this._state.getClusterLabel2()) {
            return;
        }
        this._jApplyFilterButton_actionPerformed(null);
    }

    protected void _jApplyFilterButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this._jApplyFilterButton.setEnabled(false);
            if (this.validateSettings()) {
                this.setLoading(true);
                this._jClusterDetailTable.setModel((TableModel)((Object)new ClusterCompareTableModel()));
                LoadUI loadUI = new LoadUI(true);
                loadUI.start();
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
            this._jApplyFilterButton.setEnabled(this._state.getClusterLabel2() != null);
        }
    }

    private void renameCluster(JComboBox jComboBox, JComboBox jComboBox2) {
        RenameClusterDialog renameClusterDialog = new RenameClusterDialog();
        String string = (String)jComboBox.getSelectedItem();
        if (renameClusterDialog.invoke(this._context, this._state, string)) {
            try {
                String string2 = this._state.renameClusterLabelNew(renameClusterDialog.getCurrentName(), string);
                this.setLoading(true);
                String string3 = (String)jComboBox.getSelectedItem();
                Vector<String> vector = new Vector<String>(this._state.getClusterLabels());
                jComboBox.setModel(new DefaultComboBoxModel<String>(vector));
                jComboBox.getModel().setSelectedItem(string2);
                String string4 = (String)jComboBox2.getSelectedItem();
                jComboBox2.setModel(new DefaultComboBoxModel<String>(vector));
                if (string3.equals(string4)) {
                    jComboBox2.getModel().setSelectedItem(string2);
                } else {
                    jComboBox2.getModel().setSelectedItem(string4);
                }
                this._jApplyFilterButton_actionPerformed(null);
            }
            catch (Exception exception) {
                if (exception.getMessage().equals(CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_NO_PRIVILEGE_MESG"))) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_NO_PRIVILEGE_MESG"), (String)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_FAILURE_TITLE"), null);
                }
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_FAILURE_TITLE"), (String)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_FAILURE_MESG"), null);
            }
        }
    }

    private boolean validateSettings() throws Exception {
        boolean bl = false;
        bl = true;
        Number number = this.getNumber(this._jFetchSize);
        this._state.getFilterSetting().setFetchSize(number.intValue());
        this._state.getFilterSetting().setUseFilterSpecification(false);
        return bl;
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = ClusterLrb.get("ATTRIBUTES_ROWS_OUT_OF_TOTAL");
        String string2 = NumericFormat.format(n);
        String string3 = NumericFormat.format(n2);
        String string4 = MessageFormat.format(string, string2, string3);
        this._jRowsOutOfTotalLabel.setText(string4);
    }

    public HelpInfo getHelpInfo() {
        String string = "cluster_compare_help";
        return new HelpInfo(string);
    }

    @Override
    public void setLoading(boolean bl) {
        super.setLoading(bl);
        this.enableControls(!bl);
    }

    public Icon getIcon() {
        if (_icon == null) {
            _icon = UIResourceHelper.getImageIcon(this.getClass(), ClusterLrb.get("QUERY_ICON"));
        }
        return _icon;
    }

    private void setupTable(GenericBaseTableModel genericBaseTableModel) {
        this._jClusterDetailTable.setFixedColumnCount(this.FIXED_COLUMNS);
        this._jClusterDetailTable.setModel((TableModel)genericBaseTableModel);
        this._jClusterDetailTable.setSelectionMode(2);
        this._jClusterDetailTable.findOrCreateTableRowHeader(this.jScrollPane1);
        this._jClusterDetailTable.setSorted(true);
        this._jClusterDetailTable.addDynamicCellRenderers();
        this._jClusterDetailTable.disallowSorting(ClusterCompareTableModel._colNames.get(3));
        this._jClusterDetailTable.setCellRenderers();
        this._jClusterDetailTable.setUpdateSelectionOnSort(true);
        this._jClusterDetailTable.setAutoResizeMode(3);
        this._jClusterDetailTable.getTableHeader().setReorderingAllowed(false);
        this._jClusterDetailTable.setColumnSelectorAvailable(false);
        TableColumnModel tableColumnModel = this._jClusterDetailTable.getColumnModel();
        if (genericBaseTableModel instanceof ClusterCompareTableModel) {
            tableColumnModel.getColumn(0 - this.FIXED_COLUMNS).setPreferredWidth(200);
            tableColumnModel.getColumn(1 - this.FIXED_COLUMNS).setPreferredWidth(50);
            tableColumnModel.getColumn(2 - this.FIXED_COLUMNS).setPreferredWidth(100);
            tableColumnModel.getColumn(3 - this.FIXED_COLUMNS).setPreferredWidth(150);
            tableColumnModel.getColumn(4 - this.FIXED_COLUMNS).setPreferredWidth(100);
            tableColumnModel.getColumn(5 - this.FIXED_COLUMNS).setPreferredWidth(100);
        } else {
            tableColumnModel.getColumn(0).setPreferredWidth(800);
        }
    }

    @Override
    public void setLoaded(boolean bl) {
        super.setLoaded(bl);
        if (!this._loadedFilterSetting) {
            this._loadedFilterSetting = true;
        }
    }

    public void createMessagePanel(String string) {
        this._jGraphPanel.removeAll();
        this._jGraphPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont((float)font.getSize() * 2.0f);
        jLabel.setFont(font2);
        int n = this._jGraphPanel.getGraphics() != null ? this._jGraphPanel.getGraphics().getFontMetrics(font2).stringWidth(string) : 400;
        Dimension dimension = this._jGraphPanel.getSize();
        jPanel.add(Box.createHorizontalStrut((dimension.width - n) / 2));
        jPanel.add(jLabel);
        this._jGraphPanel.add(jPanel);
        this._jGraphPanel.updateUI();
        this.hideLegendPanel();
    }

    private void handleSelectionChanged() {
        if (!(this._jClusterDetailTable.getBaseModel() instanceof ClusterCompareTableModel)) {
            return;
        }
        boolean bl = true;
        int[] nArray = this._jClusterDetailTable.getSelectedRowsInModel();
        String string = null;
        if (null == nArray || nArray.length == 0) {
            bl = false;
            string = _noSelectedAttributes;
        } else if (nArray.length > 12) {
            bl = false;
            string = _tooManyAttributes;
        }
        if (!bl) {
            this.createMessagePanel(string);
            return;
        }
        if (!this._state.isLoaded()) {
            return;
        }
        LoadGraphPanel loadGraphPanel = new LoadGraphPanel(nArray);
        loadGraphPanel.start();
    }

    private String formatCellValue(Object object, FormatType formatType) {
        String string = "";
        if (object == null) {
            string = null;
        } else if (object != null) {
            string = object instanceof Double ? (formatType == FormatType.PERCENTAGE ? NumericFormat.format((Double)object, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()) + "" : NumericFormat.format((Double)object, true, this._modelViewerPrefenceSettings.getNumericalPrecisionLevel()) + "") : object.toString();
        }
        return string;
    }

    private void showLegendPanel(GraphDataModel graphDataModel) {
        if (this._jlegendPanel != null) {
            this._cluster1Label.setText(graphDataModel.getRowLabels()[1].toString());
            this._cluster2Label.setText(graphDataModel.getRowLabels()[0].toString());
        } else {
            this._jlegendPanel = new JPanel(new FlowLayout());
            DynamicIcon dynamicIcon = new DynamicIcon(CompareClusterViewerState.colors[1]);
            this._cluster1Label = new JLabel(graphDataModel.getRowLabels()[1].toString(), dynamicIcon, 2);
            this._jlegendPanel.add(this._cluster1Label);
            DynamicIcon dynamicIcon2 = new DynamicIcon(CompareClusterViewerState.colors[0]);
            this._cluster2Label = new JLabel(graphDataModel.getRowLabels()[0].toString(), dynamicIcon2, 2);
            this._jlegendPanel.add(this._cluster2Label);
        }
    }

    private void hideLegendPanel() {
        if (this._jlegendPanel != null) {
            this._jGraphMainPanel.remove(this._jlegendPanel);
        }
    }

    static /* synthetic */ GraphPanel[] access$2502(CompareClustersMainPanel compareClustersMainPanel, GraphPanel[] graphPanelArray) {
        compareClustersMainPanel._graphPanel = graphPanelArray;
        return graphPanelArray;
    }

    static {
        _p = Preferences.getPreferences();
        _tooManyAttributes = CompareClustersLrb.get("COMPARE_CLUSTERS_DETAIL_SELECTED_ATTRIBUTES_LIMIT");
        _noSelectedAttributes = CompareClustersLrb.get("COMPARE_CLUSTERS_DETAIL_SELECTED_ATTRIBUTES_NONE");
    }

    class DynamicIcon
    implements Icon {
        Color color;

        DynamicIcon(Color color) {
            this.color = color;
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.color);
            graphics.fillRect(0, 2, 10, 10);
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        private Integer clusterId;

        ComboBoxRenderer(Integer n) {
            this.clusterId = n;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            DynamicIcon dynamicIcon = new DynamicIcon(CompareClusterViewerState.colors[this.clusterId]);
            if (!bl) {
                this.setForeground(jList.getForeground());
                this.setBackground(jList.getBackground());
            } else {
                this.setForeground(jList.getSelectionForeground());
                this.setBackground(jList.getSelectionBackground());
            }
            if (dynamicIcon != null) {
                this.setIcon(dynamicIcon);
            }
            this.setText(object.toString());
            return this;
        }
    }

    private class LoadGraphPanel
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        GraphDataModel[] localGraphModel = null;
        int[] _selectedRowsInModel;

        public LoadGraphPanel(int[] nArray) {
            this._selectedRowsInModel = nArray;
            this.localGraphModel = new GraphDataModel[nArray.length];
        }

        public Object construct() {
            try {
                ClusterCompareTableModel clusterCompareTableModel = (ClusterCompareTableModel)((Object)CompareClustersMainPanel.this._jClusterDetailTable.getBaseModel());
                Vector<CompareClustersModelRow> vector = clusterCompareTableModel.getDataVector();
                for (int i = 0; i < this._selectedRowsInModel.length; ++i) {
                    CompareClustersModelRow compareClustersModelRow = vector.get(this._selectedRowsInModel[i]);
                    String string = compareClustersModelRow.getFullAttributeName();
                    this.localGraphModel[i] = CompareClustersMainPanel.this._state.createGraphDataModelForAttribute(string);
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
                exception.printStackTrace();
            }
            return CompareClustersMainPanel.this._state;
        }

        public void finished() {
            if (this._success && this._ex == null) {
                int n;
                int n2 = this._selectedRowsInModel.length;
                CompareClustersMainPanel.access$2502(CompareClustersMainPanel.this, new GraphPanel[n2]);
                for (n = 0; n < n2; ++n) {
                    ((CompareClustersMainPanel)CompareClustersMainPanel.this)._graphPanel[n] = new GraphPanel(this.localGraphModel[n]);
                    this.localGraphModel[n].setDepthRadius(CompareClustersMainPanel.this._state.getDepthRadius());
                    boolean bl = false;
                    if (n2 == 1) {
                        bl = true;
                        this.localGraphModel[n].setLegendSeriesCount(2);
                    }
                    this.localGraphModel[n].setLegendVisible(bl);
                    CompareClustersMainPanel.this._graphPanel[n].initGraph();
                    this.localGraphModel[n].setStyleSelection(CompareClustersMainPanel.this._state.getStyleSelection());
                    CompareClustersMainPanel.this._graphPanel[n].updateGraphStyle();
                }
                CompareClustersMainPanel.this._jGraphPanel.removeAll();
                if (n2 == 1) {
                    CompareClustersMainPanel.this._jGraphPanel.setLayout(new BorderLayout());
                    CompareClustersMainPanel.this._jGraphPanel.add((Component)CompareClustersMainPanel.this._graphPanel[0], "Center");
                } else if (n2 % 3 == 0) {
                    CompareClustersMainPanel.this._jGraphPanel.setLayout(new GridLayout(0, 3));
                } else {
                    CompareClustersMainPanel.this._jGraphPanel.setLayout(new GridLayout(0, 2));
                }
                for (n = 0; n < n2; ++n) {
                    CompareClustersMainPanel.this._jGraphPanel.add(CompareClustersMainPanel.this._graphPanel[n]);
                }
                CompareClustersMainPanel.this._jGraphPanel.updateUI();
                if (n2 == 1) {
                    CompareClustersMainPanel.this.hideLegendPanel();
                } else {
                    CompareClustersMainPanel.this.showLegendPanel(this.localGraphModel[0]);
                    CompareClustersMainPanel.this._jGraphMainPanel.add((Component)CompareClustersMainPanel.this._jlegendPanel, "Last");
                }
                CompareClustersMainPanel.this._jGraphMainPanel.updateUI();
            }
        }
    }

    private class NumberRenderer
    extends DefaultTableCellRenderer {
        FormatType _formatType = FormatType.NUMERICAL;

        public NumberRenderer() {
        }

        public NumberRenderer(FormatType formatType) {
            this._formatType = formatType;
        }

        @Override
        public void setValue(Object object) {
            String string = CompareClustersMainPanel.this.formatCellValue(object, this._formatType);
            super.setValue(string);
        }
    }

    class CustomGenericTable
    extends GenericTableFixedColumns {
        CustomGenericTable() {
            this.adjustRowHeight((int)CompareClustersMainPanel.this._histogramRowDimension.getHeight());
            this.addCellRenderer(ClusterCompareTableModel._colNames.get(1), new NumberRenderer(FormatType.NUMERICAL));
            this.addCellRenderer(ClusterCompareTableModel._colNames.get(2), new NumberRenderer(FormatType.NUMERICAL));
        }

        @Override
        protected void handleSelectionChanged(ListSelectionModel listSelectionModel) {
            CompareClustersMainPanel.this.handleSelectionChanged();
        }

        @Override
        public void addDynamicCellRenderers() {
            this.addCellRenderer(ClusterCompareTableModel._colNames.get(3), new MiniHistogramCellRenderer(CompareClustersMainPanel.this._state, CompareClustersMainPanel.this._histogramRowDimension, 20));
            this.addCellRenderer(CompareClustersMainPanel.this._state.getTableModel().getColumnName(1), new NumberCellRenderer());
            this.addCellRenderer(CompareClustersMainPanel.this._state.getTableModel().getColumnName(2), new NumberCellRenderer());
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            string = n2 + CompareClustersMainPanel.this.FIXED_COLUMNS == 3 ? MessageFormat.format(CompareClustersLrb.get("COMPARE_CLUSTERS_DETAIL_TABLE_TOOL_TIP_DISTRIBUTION"), this.getValueAt(n, 0), CompareClustersMainPanel.this._jCluster1Combo.getSelectedItem(), CompareClustersMainPanel.this._jCluster2Combo.getSelectedItem()) : CompareClustersMainPanel.this.formatCellValue(object, FormatType.NUMERICAL);
            return string;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            Object object = null;
            String string = "";
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            object = this.getValueAt(n, n2);
            string = n2 + CompareClustersMainPanel.this.FIXED_COLUMNS == 3 ? MessageFormat.format(CompareClustersLrb.get("COMPARE_CLUSTERS_DETAIL_TABLE_TOOL_TIP_DISTRIBUTION"), this.getValueAt(n, 0), CompareClustersMainPanel.this._jCluster1Combo.getSelectedItem().toString(), CompareClustersMainPanel.this._jCluster2Combo.getSelectedItem().toString()) : CompareClustersMainPanel.this.formatCellValue(object, FormatType.NUMERICAL);
            return string;
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        public Object construct() {
            try {
                if (this._reload) {
                    CompareClustersMainPanel.this._state.reload();
                } else {
                    CompareClustersMainPanel.this._state.load();
                }
                this._success = CompareClustersMainPanel.this._state.isLoaded();
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
                exception.printStackTrace();
            }
            return CompareClustersMainPanel.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    if (!this._reload) {
                        Vector<String> vector = new Vector<String>(CompareClustersMainPanel.this._state.getClusterLabels());
                        CompareClustersMainPanel.this._jCluster1Combo.setModel(new DefaultComboBoxModel<String>(vector));
                        CompareClustersMainPanel.this._jCluster1Combo.setSelectedItem(CompareClustersMainPanel.this._state.getClusterLabel1());
                        CompareClustersMainPanel.this._jCluster1Combo.setRenderer(new ComboBoxRenderer((Integer)0));
                        if (CompareClustersMainPanel.this._state.getClusterLabel2() == null) {
                            CompareClustersMainPanel.this._jCluster2Combo.setVisible(false);
                            CompareClustersMainPanel.this._jCluster2ComboLabel.setVisible(false);
                            CompareClustersMainPanel.this.jBtnClister2Edit.setVisible(false);
                            if (vector.size() <= 1) {
                                CompareClustersMainPanel.this._jLeafsOnlyCheckBox.setSelected(false);
                                CompareClustersMainPanel.this._jLeafsOnlyCheckBox.setEnabled(false);
                            }
                        } else {
                            CompareClustersMainPanel.this._jCluster2Combo.setModel(new DefaultComboBoxModel<String>(vector));
                            CompareClustersMainPanel.this._jCluster2Combo.setSelectedItem(CompareClustersMainPanel.this._state.getClusterLabel2());
                            CompareClustersMainPanel.this._jCluster2Combo.setRenderer(new ComboBoxRenderer((Integer)1));
                        }
                    }
                    CompareClustersMainPanel.this._state.reloadClusterCacheNew();
                    if (CompareClustersMainPanel.this._jFilterCtl.getText().trim().length() > 0) {
                        CompareClustersMainPanel.this.setupTable(CompareClustersMainPanel.this._state.getFilteredStatistics(CompareClustersMainPanel.this._jFilterCtl.getText(), CompareClustersMainPanel.this._currentSearchCategory));
                    } else {
                        CompareClustersMainPanel.this.setupTable(CompareClustersMainPanel.this._state.getTableModel());
                    }
                    if (!this._reload) {
                        CompareClustersMainPanel.this._jClusterDetailTable.setSortColumn(1, true);
                    }
                    CompareClustersMainPanel.this.loadRowsOutOfTotalLabel(new Integer(CompareClustersMainPanel.this._state.getTableModel().getRowCount()), CompareClustersMainPanel.this._state.getTotalNumberOfModelAttributesNew());
                    CompareClustersMainPanel.this.enableControls(true);
                    if (CompareClustersMainPanel.this._jClusterDetailTable.getRowCount() > 0) {
                        int n = CompareClustersMainPanel.this._jClusterDetailTable.convertRowIndexToModel(0);
                        CompareClustersMainPanel.this._jClusterDetailTable.setSelectedRowsInModel(new int[]{n});
                    }
                    CompareClustersMainPanel.this.setLoaded(true);
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_TITLE"), (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), null, (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_TITLE"), (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_MESG"));
                }
                CompareClustersMainPanel.this.setLoading(false);
            }
            catch (Exception exception) {
                try {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_TITLE"), (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_MESG"), null);
                    CompareClustersMainPanel.this.setLoading(false);
                }
                catch (Throwable throwable) {
                    CompareClustersMainPanel.this.setLoading(false);
                    CompareClustersMainPanel.this._jApplyFilterButton.setEnabled(CompareClustersMainPanel.this._state.getClusterLabel2() != null);
                    throw throwable;
                }
                CompareClustersMainPanel.this._jApplyFilterButton.setEnabled(CompareClustersMainPanel.this._state.getClusterLabel2() != null);
            }
            CompareClustersMainPanel.this._jApplyFilterButton.setEnabled(CompareClustersMainPanel.this._state.getClusterLabel2() != null);
        }
    }

    private static enum FormatType {
        PERCENTAGE,
        NUMERICAL;

    }
}

