/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.sql.Connection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.server.model.AssociationRules;
import oracle.dmt.dataminer.server.model.FilterItemSet;
import oracle.dmt.dataminer.server.model.Item;
import oracle.dmt.dataminer.server.model.ItemSet;
import oracle.dmt.dataminer.server.model.ItemSetFilterSetting;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.javatools.ui.search.SearchMatcher;

public class ARItemTableModel
extends GenericBaseTableModel {
    private Vector<FilterItemSet> _data = new Vector(1000, 500);
    private ARItemTableModel _filteredItems;
    private Context _context;
    private AssociationRules _model;
    private ItemSetFilterSetting _filterSetting;
    private static final int COLUMN_COUNT = 4;
    private static final int COLUMN_COUNT_WITHOUT_SUPPORT = 3;
    public static final int NAME = 0;
    public static final int VALUE = 1;
    public static final int SUPPORT = 2;
    public static final int FILTER = 3;
    public static final int FILTER_WITHOUT_SUPPORT = 2;
    private static Icon _bothIcon;
    private static Icon _associationIcon;
    private static Icon _conditionIcon;
    private boolean _includeSupportColumn = true;
    private NAME_DISPLAY _nameDisplay = NAME_DISPLAY.NAME_SUBNAME;
    private String[] _columnNames = new String[]{ARRulesLrb.get("ADD_ITEM_NAME_COLUMN"), ARRulesLrb.get("ADD_ITEM_VALUE_COLUMN"), ARRulesLrb.get("ADD_ITEM_SUPPORT_COLUMN"), ARRulesLrb.get("ADD_ITEM_FILTER_COLUMN")};
    private String[] _columnNamesWithoutSupport = new String[]{ARRulesLrb.get("ADD_ITEM_NAME_COLUMN"), ARRulesLrb.get("ADD_ITEM_VALUE_COLUMN"), ARRulesLrb.get("ADD_ITEM_FILTER_COLUMN")};

    public boolean isIncludeSupportColumn() {
        return this._includeSupportColumn;
    }

    public void setNameDisplay(NAME_DISPLAY nAME_DISPLAY) {
        this._nameDisplay = nAME_DISPLAY;
    }

    public NAME_DISPLAY getNameDisplay() {
        return this._nameDisplay;
    }

    public ARItemTableModel(boolean bl) {
        this._includeSupportColumn = bl;
        if (this._includeSupportColumn) {
            this.setColumnIdentifiers(this._columnNames);
            this.setColumnCount(4);
        } else {
            this.setColumnIdentifiers(this._columnNamesWithoutSupport);
            this.setColumnCount(3);
        }
        this.loadIcons();
        this.setRowCount(0);
    }

    public ARItemTableModel(Vector<FilterItemSet> vector, boolean bl) {
        this._includeSupportColumn = bl;
        if (this._includeSupportColumn) {
            this.setColumnIdentifiers(this._columnNames);
            this.setColumnCount(4);
        } else {
            this.setColumnIdentifiers(this._columnNamesWithoutSupport);
            this.setColumnCount(3);
        }
        this.loadIcons();
        this._data = vector;
        this.setRowCount(vector.size());
    }

    public ARItemTableModel(Context context, AssociationRules associationRules, ItemSetFilterSetting itemSetFilterSetting, ARItemTableModel aRItemTableModel, boolean bl) {
        this.loadIcons();
        this._includeSupportColumn = bl;
        if (this._includeSupportColumn) {
            this.setColumnIdentifiers(this._columnNames);
            this.setColumnCount(4);
        } else {
            this.setColumnIdentifiers(this._columnNamesWithoutSupport);
            this.setColumnCount(3);
        }
        this.setRowCount(0);
        this._context = context;
        this._model = associationRules;
        this._filterSetting = itemSetFilterSetting;
        this._filteredItems = aRItemTableModel;
    }

    private void loadIcons() {
        _bothIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), ARRulesLrb.get("BOTH_ITEM_ICON"));
        _associationIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), ARRulesLrb.get("ASSOCIATION_ITEM_ICON"));
        _conditionIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), ARRulesLrb.get("CONDITION_ITEM_ICON"));
    }

    public void load() throws Exception {
        assert (this._model != null) : "Model is null, unable to load.";
        assert (this._context != null) : "Context is null, unable to load.";
        Connection connection = null;
        Vector<Object> vector = new Vector();
        try {
            connection = Connections.getUniqueConnection(this._context);
            vector = this._model.getItemSets(connection, this._model.getUserName(), this._model.getModelName(), this._filterSetting);
            this._data = vector;
            this.removeExistingFilteredItems();
            this.setRowCount(this._data.size());
            this.fireTableDataChanged();
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void removeExistingFilteredItems() {
        Vector<FilterItemSet> vector = this._filteredItems.getDataVector();
        Iterator<FilterItemSet> iterator = vector.iterator();
        Vector<FilterItemSet> vector2 = new Vector<FilterItemSet>();
        block0: while (iterator.hasNext()) {
            Iterator<FilterItemSet> iterator2 = this._data.iterator();
            FilterItemSet filterItemSet = iterator.next();
            Item item = filterItemSet.getItems().get(0);
            while (iterator2.hasNext()) {
                FilterItemSet filterItemSet2 = iterator2.next();
                Item item2 = filterItemSet2.getItems().get(0);
                if (!item.getFullAttributeName().equals(item2.getFullAttributeName())) continue;
                if (item.getValue() == null && item.getValue() == null) {
                    vector2.add(filterItemSet2);
                    continue block0;
                }
                if (item.getValue() == null || item.getValue() == null || !item.getValue().equals(item2.getValue())) continue;
                vector2.add(filterItemSet2);
                continue block0;
            }
        }
        this._data.removeAll(vector2);
    }

    public ARItemTableModel getFilteredRules(String string, int n) throws Exception {
        Vector<FilterItemSet> vector = null;
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Vector<FilterItemSet> vector2 = this.getDataVector();
        vector = new Vector<FilterItemSet>(1000, 500);
        Iterator<FilterItemSet> iterator = vector2.iterator();
        FilterItemSet filterItemSet = null;
        Item item = null;
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        Object var11_12 = null;
        while (iterator.hasNext()) {
            filterItemSet = iterator.next();
            if (bl) {
                bl2 = true;
            } else {
                String string2 = "";
                item = filterItemSet.getItems().get(0);
                switch (n) {
                    case 0: {
                        string2 = item.getFullAttributeName();
                        break;
                    }
                    case 1: {
                        string2 = item.getValue();
                        break;
                    }
                    default: {
                        assert (false) : "Invalid item filter category.";
                        string2 = item.getFullAttributeName();
                    }
                }
                bl2 = string2 == null ? false : searchMatcher.matches((CharSequence)string2);
            }
            if (!bl2) continue;
            vector.add(filterItemSet);
        }
        return new ARItemTableModel(vector, false);
    }

    public void addRows(Vector<FilterItemSet> vector) {
        for (FilterItemSet filterItemSet : vector) {
            this.getDataVector().add(filterItemSet);
        }
    }

    public int getRowCount() {
        if (this._data == null) {
            return 0;
        }
        return this._data.size();
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public ItemSet getRow(int n) {
        return this._data.get(n);
    }

    public void addSelection(ARItemTableModel aRItemTableModel, int[] nArray) {
        Vector<FilterItemSet> vector = aRItemTableModel.getDataVector();
        FilterItemSet filterItemSet = null;
        for (int i = 0; i < nArray.length; ++i) {
            filterItemSet = vector.elementAt(nArray[i]);
            this._data.add(filterItemSet);
        }
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public void setFilterActionForAll(int n) {
        for (FilterItemSet filterItemSet : this._data) {
            filterItemSet.setFilterAction(n);
        }
    }

    public void setFilterActionForSelected(int n, int[] nArray) {
        FilterItemSet filterItemSet = null;
        for (int i = 0; i < nArray.length; ++i) {
            filterItemSet = this._data.elementAt(nArray[i]);
            filterItemSet.setFilterAction(n);
        }
        this.fireTableDataChanged();
    }

    public Vector<FilterItemSet> getDataVector() {
        return this._data;
    }

    public void removeSelectedRows(int[] nArray) {
        Vector<FilterItemSet> vector = new Vector<FilterItemSet>();
        FilterItemSet filterItemSet = null;
        for (int i = 0; i < nArray.length; ++i) {
            filterItemSet = this._data.elementAt(nArray[i]);
            vector.add(filterItemSet);
        }
        this._data.removeAll(vector);
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 3;
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        FilterItemSet filterItemSet = this._data.get(n);
        Object object = null;
        Item item = filterItemSet.getItems().get(0);
        switch (n2) {
            case 0: {
                if (this._nameDisplay == NAME_DISPLAY.SUB_NAME_ONLY) {
                    object = item.getAttribute_subname();
                    break;
                }
                if (this._nameDisplay == NAME_DISPLAY.NAME_ONLY) {
                    object = item.getAttribute_name();
                    break;
                }
                if (this._nameDisplay == NAME_DISPLAY.NAME_SUBNAME) {
                    object = item.getFullAttributeName();
                    break;
                }
                object = item.getFullAttributeName();
                break;
            }
            case 1: {
                if (item.getValue() == null) {
                    object = "";
                    break;
                }
                object = item.getValue();
                break;
            }
            case 2: {
                if (this._includeSupportColumn) {
                    if (filterItemSet.getSupport() != null) {
                        object = filterItemSet.getSupport() * 100.0;
                        break;
                    }
                    object = filterItemSet.getSupport();
                    break;
                }
                object = this.getFilterData(filterItemSet);
                break;
            }
            case 3: {
                object = this.getFilterData(filterItemSet);
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing items";
                break;
            }
        }
        return object;
    }

    private Object getFilterData(FilterItemSet filterItemSet) {
        int n = filterItemSet.getFilterAction();
        Object object = n == 0 ? new JLabel(ARRulesLrb.get("FILTER_BOTH"), _bothIcon, 10) : (n == 1 ? new JLabel(ARRulesLrb.get("FILTER_CONDITION"), _conditionIcon, 10) : (n == 2 ? new JLabel(ARRulesLrb.get("FILTER_ASSOCIATION"), _associationIcon, 10) : "Unknown Action"));
        return object;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 3) {
            FilterItemSet filterItemSet = this._data.get(n);
            JLabel jLabel = (JLabel)object;
            if (jLabel.getText() == ARRulesLrb.get("FILTER_BOTH")) {
                filterItemSet.setFilterAction(0);
            } else if (jLabel.getText() == ARRulesLrb.get("FILTER_CONDITION")) {
                filterItemSet.setFilterAction(1);
            } else if (jLabel.getText() == ARRulesLrb.get("FILTER_ASSOCIATION")) {
                filterItemSet.setFilterAction(2);
            }
        } else {
            this.setValueAt(object, n, n2);
        }
    }

    public void addRow(FilterItemSet filterItemSet) {
        this._data.add(filterItemSet);
    }

    public static enum NAME_DISPLAY {
        SUB_NAME_ONLY,
        NAME_ONLY,
        NAME_SUBNAME;

    }
}

