/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.arrules.ARItemTableModel;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesViewerState;
import oracle.dmt.dataminer.server.model.AssociationRules;
import oracle.dmt.dataminer.server.model.ItemSetFilterSetting;
import oracle.dmt.dataminer.server.model.SortSpec;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.controls.JLabelListCellRenderer;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class ARItemFilterEditor
extends JPanel
implements DataminerGUIPanel {
    private Context _context;
    private ItemSetFilterSetting _filterSetting;
    private static Icon _icon;
    private AssociationRules _model;
    private GenericTable _table;
    private ARRulesViewerState _arViewerState;
    private ARItemTableModel.NAME_DISPLAY _nameDisplay;
    private boolean _displayValueColumn = true;
    private boolean _hideResultTypeCombo = false;
    private boolean _loading = false;
    private ARItemTableModel _itemTableModel = null;
    private ARItemTableModel _filterItemTableModel;
    public static final int ITEMS_FILTER_NAME = 0;
    public static final int ITEMS_FILTER_VALUE = 1;
    private SearchField _jFilterCtl;
    private static Icon _bothIcon;
    private static Icon _associationIcon;
    private static Icon _conditionIcon;
    private static Icon _collapseIcon;
    private static Icon _expandIcon;
    private int _currentSearchCategory = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(ARRulesLrb.get("ADD_ITEM_NAME_CATEGORY_NAME"));
    private static final String RESULT_TYPE_NAME;
    private static final String RESULT_TYPE_NAME_SUBNAME;
    private static final String RESULT_TYPE_NAME_SUBNAME_VALUE;
    private boolean _filterExpanded = false;
    private static final String SORT_BY_ATTRIBUTE;
    private static final String SORT_BY_SUPPORT;
    private static final String SORT_BY_VALUE;
    private static final String ORDER_BY_DESCENDING;
    private static final String ORDER_BY_ASCENDING;
    private static final String[] SORT_ORDER_COMBO_VALUES;
    JLabel _jRowsOutOfTotalLabel = new JLabel();
    private GenericTable _jItemsGenericTable = new ARItemSetsGenericTable();
    JScrollPane jScrollPane1;
    private JComponent _findPane;
    private static Preferences _p;
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private JComboBox _jAddOptionCombo;
    private JLabel _jAddOptionLbl;
    private JButton _jExpandButton;
    private JLabel _jFetchSizeLabel;
    private JSpinner _jFetchSizeValue;
    private JLabel _jItemNameFilterLbl;
    private JTextField _jItemNameFilterValue;
    private ComponentWithTitlebar<JComponent> _jItemsetViewerComponent;
    private JScrollPane _jPageDescPanel;
    private JButton _jQueryItemsButton;
    private JComboBox _jResultTypeCombo;
    private JLabel _jResultTypeLbl;
    private JLabel _jSortByLabel1;
    private JComboBox _jSortCombo1;
    private JComboBox _jSortOrderCombo1;

    public ARItemFilterEditor(Context context, ARItemTableModel aRItemTableModel, GenericTable genericTable, ARRulesViewerState aRRulesViewerState) throws Exception {
        this._filterItemTableModel = aRItemTableModel;
        this._context = context;
        this._filterSetting = new ItemSetFilterSetting();
        this._model = aRRulesViewerState.getModel();
        this._table = genericTable;
        this._arViewerState = aRRulesViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jPageDescPanel = new JScrollPane();
        this._jItemNameFilterLbl = new JLabel();
        this._jItemNameFilterValue = new JTextField();
        this._jQueryItemsButton = new JButton();
        this._jResultTypeLbl = new JLabel();
        this._jResultTypeCombo = new JComboBox();
        this._jAddOptionLbl = new JLabel();
        this._jAddOptionCombo = new JComboBox();
        this._jFetchSizeLabel = new JLabel();
        this._jFetchSizeValue = new JSpinner();
        this._jSortByLabel1 = new JLabel();
        this._jSortCombo1 = new JComboBox();
        this._jSortOrderCombo1 = new JComboBox();
        this._jExpandButton = new JButton();
        this._jItemsetViewerComponent = new ComponentWithTitlebar();
        this._jPageDescPanel.setBorder(null);
        this._jItemNameFilterLbl.setText("Name Filter:");
        this._jQueryItemsButton.setText("Search");
        this._jResultTypeLbl.setText("Result Type:");
        this._jResultTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Name", "Name, Subname", "Name, Subname, Value"}));
        this._jAddOptionLbl.setText("Add Items As:");
        this._jAddOptionCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Both", "Association", "Condition"}));
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jSortByLabel1.setText("Sort by:");
        this._jExpandButton.setText("More");
        this._jExpandButton.setHorizontalAlignment(11);
        this._jExpandButton.setMaximumSize(new Dimension(63, 23));
        this._jExpandButton.setMinimumSize(new Dimension(63, 23));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this._jItemsetViewerComponent, GroupLayout.Alignment.LEADING, -1, 802, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this._jSortByLabel1, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jSortCombo1, -2, 138, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jSortOrderCombo1, -2, 124, -2)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this._jPageDescPanel, -1, 731, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jQueryItemsButton)).addGroup(groupLayout.createSequentialGroup().addComponent(this._jAddOptionLbl, -2, 136, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jAddOptionCombo, -2, 153, -2)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this._jFetchSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jFetchSizeValue, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 510, Short.MAX_VALUE).addComponent(this._jExpandButton, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jItemNameFilterLbl, -1, 93, Short.MAX_VALUE).addComponent(this._jResultTypeLbl, -1, 93, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jResultTypeCombo, -2, 138, -2).addComponent(this._jItemNameFilterValue, -2, 138, -2)))).addContainerGap()));
        groupLayout.linkSize(0, this._jFetchSizeLabel, this._jItemNameFilterLbl, this._jResultTypeLbl, this._jSortByLabel1);
        groupLayout.linkSize(0, this._jFetchSizeValue, this._jItemNameFilterValue, this._jResultTypeCombo, this._jSortCombo1);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this._jPageDescPanel, -2, 37, -2).addGap(9, 9, 9).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jSortByLabel1).addComponent(this._jSortCombo1, -2, -1, -2).addComponent(this._jSortOrderCombo1, -2, -1, -2))).addComponent(this._jQueryItemsButton)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jFetchSizeValue, -2, -1, -2).addComponent(this._jFetchSizeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jItemNameFilterValue, -2, -1, -2).addComponent(this._jItemNameFilterLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jResultTypeLbl).addComponent(this._jResultTypeCombo, -2, -1, -2))).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jExpandButton, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this._jItemsetViewerComponent, -1, 253, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jAddOptionCombo, -2, -1, -2).addComponent(this._jAddOptionLbl)).addContainerGap()));
    }

    @Override
    public void initRes() {
        this._jPageDescPanel.setViewportView((Component)new JMultiLineLabel(ARRulesLrb.get("ADD_ITEM_DIALOG_DESC")));
        this._jPageDescPanel.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ADD_ITEM_DIALOG_DESC"));
        ResourceUtils.resButton((AbstractButton)this._jQueryItemsButton, (String)ARRulesLrb.get("ADD_ITEM_QUERY"));
        this._jQueryItemsButton.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ADD_ITEM_QUERY"));
        this._jQueryItemsButton.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("ADD_ITEM_QUERY_ADA"));
        this._jQueryItemsButton.setIcon(this.getIcon());
        ResourceUtils.resButton((AbstractButton)this._jExpandButton, (String)ARRulesLrb.get("MORE"));
        this._jExpandButton.setIcon(this.getExpandIcon());
        this._jExpandButton.getAccessibleContext().setAccessibleName(ARRulesLrb.get("MORE"));
        this._jExpandButton.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("MORE_ADA"));
        this._jExpandButton.setHorizontalTextPosition(10);
        ResourceUtils.resLabel((JLabel)this._jItemNameFilterLbl, (Component)this._jItemNameFilterValue, (String)ARRulesLrb.get("ADD_ITEM_NAME_FILTER"));
        this._jItemNameFilterLbl.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ADD_ITEM_NAME_FILTER"));
        this._jItemNameFilterLbl.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("ADD_ITEM_NAME_FILTER_ADA"));
        this._jItemNameFilterLbl.setLabelFor(this._jItemNameFilterValue);
        this._jItemNameFilterValue.setToolTipText(ARRulesLrb.get("ADD_ITEM_NAME_FILTER_ADA"));
        ResourceUtils.resLabel((JLabel)this._jResultTypeLbl, (Component)this._jResultTypeCombo, (String)ARRulesLrb.get("ADD_ITEM_RESULT_TYPE"));
        this._jResultTypeLbl.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ADD_ITEM_RESULT_TYPE"));
        this._jResultTypeLbl.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("ADD_ITEM_RESULT_TYPE_ADA"));
        this._jResultTypeLbl.setLabelFor(this._jResultTypeCombo);
        _bothIcon = UIResourceHelper.getImageIcon(this.getClass(), ARRulesLrb.get("BOTH_ITEM_ICON"));
        _associationIcon = UIResourceHelper.getImageIcon(this.getClass(), ARRulesLrb.get("ASSOCIATION_ITEM_ICON"));
        _conditionIcon = UIResourceHelper.getImageIcon(this.getClass(), ARRulesLrb.get("CONDITION_ITEM_ICON"));
        this._jResultTypeCombo.setToolTipText(ARRulesLrb.get("ADD_ITEM_RESULT_TYPE_ADA"));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSizeValue, (String)ARRulesLrb.get("ADD_ITEM_FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ADD_ITEM_FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("ADD_ITEM_FETCH_SIZE_ADA"));
        this._jFetchSizeValue.setToolTipText(ARRulesLrb.get("ADD_ITEM_FETCH_SIZE_ADA") + "\n" + ARRulesLrb.get("ADD_ITEM_FETCH_SIZE_RANGE"));
        this._jFetchSizeValue.setModel(new SpinnerNumberModel(this._modelViewerPrefenceSettings.getFetchSizeARModel(), 1, Integer.MAX_VALUE, 100));
        ResourceUtils.resLabel((JLabel)this._jAddOptionLbl, (Component)this._jAddOptionCombo, (String)ARRulesLrb.get("ADD_ITEM_INCLUDE_TYPE"));
        this._jAddOptionLbl.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ADD_ITEM_INCLUDE_TYPE"));
        this._jAddOptionLbl.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("ADD_ITEM_INCLUDE_TYPE_ADA"));
        JLabel jLabel = new JLabel(ARRulesLrb.get("ADD_ITEM_INCLUDE_BOTH"), _bothIcon, 10);
        JLabel jLabel2 = new JLabel(ARRulesLrb.get("ADD_ITEM_INCLUDE_ASSOCIATION"), _associationIcon, 10);
        JLabel jLabel3 = new JLabel(ARRulesLrb.get("ADD_ITEM_INCLUDE_CONDITION"), _conditionIcon, 10);
        Object[] objectArray = new JLabel[]{jLabel, jLabel3, jLabel2};
        this._jAddOptionCombo.setModel(new DefaultListComboBoxModel(objectArray));
        this._jAddOptionCombo.setSelectedItem(jLabel2);
        this._jAddOptionCombo.setToolTipText(ARRulesLrb.get("ADD_ITEM_INCLUDE_TYPE_ADA"));
        ResourceUtils.resLabel((JLabel)this._jSortByLabel1, (Component)this._jSortCombo1, (String)ARRulesLrb.get("SORT_BY"));
        this._jSortByLabel1.getAccessibleContext().setAccessibleName(ARRulesLrb.get("SORT_BY"));
        this._jSortByLabel1.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("SORT_BY_ADA"));
        this._jSortCombo1.setToolTipText(ARRulesLrb.get("SORT_BY_ADA"));
        this._jSortOrderCombo1.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ORDER"));
        this._jSortOrderCombo1.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("ORDER_ADA"));
        this._jSortOrderCombo1.setModel(new DefaultComboBoxModel<String>(SORT_ORDER_COMBO_VALUES));
        this._jSortOrderCombo1.setSelectedItem(ORDER_BY_ASCENDING);
        this._jSortOrderCombo1.setToolTipText(ARRulesLrb.get("ORDER_ADA"));
        this.loadRowsOutOfTotalLabel(0, 0);
    }

    private void setLoading(boolean bl) {
        this._loading = bl;
        this.displayLoading(bl);
        this._jQueryItemsButton.setEnabled(!this._loading);
        this._jFilterCtl.setEnabled(!this._loading);
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"add_item_filters");
        this.jScrollPane1 = new JScrollPane((Component)this._jItemsGenericTable);
        this._jItemsGenericTable.setFillsViewportHeight(true);
        this._jItemsetViewerComponent.setComponent((JComponent)this.jScrollPane1);
        this._jItemsetViewerComponent.setLabel(this._jRowsOutOfTotalLabel);
        ControlBar controlBar = new ControlBar();
        this.setupFilterControl(controlBar);
        this._jItemsetViewerComponent.setControlBar(controlBar);
        this._jQueryItemsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ARItemFilterEditor.this._jQueryItemsButton_actionPerformed(actionEvent);
            }
        });
        this._jExpandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ARItemFilterEditor.this._jExpandButton_actionPerformed(actionEvent);
            }
        });
        this._jResultTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ARItemFilterEditor.this._jResultTypeCombo_actionPerformed(actionEvent);
            }
        });
        JLabelListCellRenderer jLabelListCellRenderer = new JLabelListCellRenderer();
        this._jAddOptionCombo.setRenderer(jLabelListCellRenderer);
        this.loadStateBasedOnModelContent();
        this.showExtraFilterControls(false);
        this.setLoading(true);
        this.loadTable();
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = ARRulesLrb.get("ITEMS_ROWS_OUT_OF_TOTAL");
        String string2 = NumericFormat.format(n);
        String string3 = "Loading...";
        if (n2 != null) {
            string3 = NumericFormat.format(n2);
        }
        String string4 = MessageFormat.format(string, string2, string3);
        this._jRowsOutOfTotalLabel.setText(string4);
    }

    private SearchField searchField() {
        SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        return searchField;
    }

    private void setupFilterControl(ControlBar controlBar) {
        this._findPane = new Box(2);
        this._jFilterCtl = this.searchField();
        this._jFilterCtl.setStyle(SearchField.Style.FILTER);
        this._jFilterCtl.setStyle(SearchField.Style.FILTER);
        this._currentSearchCategory = 0;
        this._jFilterCtl.addCategory(this._defaultSearchCategory);
        this._jFilterCtl.setSelectedCategory(this._defaultSearchCategory);
        this._findPane.setName("Find");
        this._findPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this._findPane.add((Component)this._jFilterCtl);
        Dimension dimension = this._findPane.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 145);
        Dimension dimension3 = this.derive(dimension, 80);
        this._findPane.setPreferredSize(dimension2);
        this._findPane.setMaximumSize(dimension2);
        this._findPane.setMinimumSize(dimension3);
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                ARItemFilterEditor.this.translateSearchCategoryToConstant(ARItemFilterEditor.this._jFilterCtl.getSelectedCategory());
                ARItemFilterEditor.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                ARItemFilterEditor.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                ARItemFilterEditor.this.processFilter(string);
            }
        });
        controlBar.add((Component)this._findPane);
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private void loadStateBasedOnModelContent() {
        this._nameDisplay = this._arViewerState.isOnlyOneColumnNameInModelItems() && !this._arViewerState.isNoSubNameColumnsInModelItems() ? ARItemTableModel.NAME_DISPLAY.SUB_NAME_ONLY : (this._arViewerState.isNoSubNameColumnsInModelItems() ? ARItemTableModel.NAME_DISPLAY.NAME_ONLY : ARItemTableModel.NAME_DISPLAY.NAME_SUBNAME);
        this._displayValueColumn = !this._arViewerState.isOnlyOneConstantValueInModelItems();
        this.setupCombos();
    }

    private void setupCombos() {
        if (this._nameDisplay == ARItemTableModel.NAME_DISPLAY.SUB_NAME_ONLY) {
            if (this._displayValueColumn) {
                String[] stringArray = new String[]{RESULT_TYPE_NAME_SUBNAME, RESULT_TYPE_NAME_SUBNAME_VALUE};
                this._jResultTypeCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
                this._jResultTypeCombo.setSelectedItem(RESULT_TYPE_NAME_SUBNAME_VALUE);
                this._hideResultTypeCombo = true;
            } else {
                String[] stringArray = new String[]{RESULT_TYPE_NAME_SUBNAME, RESULT_TYPE_NAME_SUBNAME_VALUE};
                this._jResultTypeCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
                this._jResultTypeCombo.setSelectedItem(RESULT_TYPE_NAME_SUBNAME_VALUE);
                this._hideResultTypeCombo = true;
            }
        } else if (this._nameDisplay == ARItemTableModel.NAME_DISPLAY.NAME_ONLY) {
            if (this._displayValueColumn) {
                String[] stringArray = new String[]{RESULT_TYPE_NAME, RESULT_TYPE_NAME_SUBNAME_VALUE};
                this._jResultTypeCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
                this._jResultTypeCombo.setSelectedItem(RESULT_TYPE_NAME_SUBNAME_VALUE);
                this._hideResultTypeCombo = true;
            } else {
                String[] stringArray = new String[]{RESULT_TYPE_NAME_SUBNAME, RESULT_TYPE_NAME_SUBNAME_VALUE};
                this._jResultTypeCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
                this._jResultTypeCombo.setSelectedItem(RESULT_TYPE_NAME_SUBNAME_VALUE);
                this._hideResultTypeCombo = true;
            }
        } else if (this._nameDisplay == ARItemTableModel.NAME_DISPLAY.NAME_SUBNAME) {
            if (this._displayValueColumn) {
                String[] stringArray = new String[]{RESULT_TYPE_NAME, RESULT_TYPE_NAME_SUBNAME, RESULT_TYPE_NAME_SUBNAME_VALUE};
                this._jResultTypeCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
                this._jResultTypeCombo.setSelectedItem(RESULT_TYPE_NAME_SUBNAME_VALUE);
                this._hideResultTypeCombo = false;
            } else {
                String[] stringArray = new String[]{RESULT_TYPE_NAME_SUBNAME, RESULT_TYPE_NAME_SUBNAME_VALUE};
                this._jResultTypeCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
                this._jResultTypeCombo.setSelectedItem(RESULT_TYPE_NAME_SUBNAME_VALUE);
                this._hideResultTypeCombo = false;
            }
        }
        String[] stringArray = this._displayValueColumn ? new String[]{SORT_BY_ATTRIBUTE, SORT_BY_SUPPORT, SORT_BY_VALUE} : new String[]{SORT_BY_ATTRIBUTE, SORT_BY_SUPPORT};
        this._jSortCombo1.setModel(new DefaultComboBoxModel<String>(stringArray));
        this._jSortCombo1.setSelectedItem(SORT_BY_ATTRIBUTE);
    }

    private void setSortState(int n, boolean bl, String string, String string2) throws Exception {
        SortSpec sortSpec = this._filterSetting.getSortSpecification().get(n);
        sortSpec.setUseIt(bl);
        if (string == SORT_BY_ATTRIBUTE) {
            sortSpec.setAttributeName("FULL_NAME");
        } else if (string == SORT_BY_SUPPORT) {
            sortSpec.setAttributeName("SUPPORT");
        } else if (string == SORT_BY_VALUE) {
            sortSpec.setAttributeName("ATTRIBUTE_VALUE");
        } else {
            throw new Exception("Unrecognized sort value selection: " + string);
        }
        if (string2 == ORDER_BY_DESCENDING) {
            sortSpec.setSortDirection(SortSpec.SORT_DECENDING);
        } else if (string2 == ORDER_BY_ASCENDING) {
            sortSpec.setSortDirection(SortSpec.SORT_ASCENDING);
        } else {
            throw new Exception("Unrecognized sort order selection: " + string2);
        }
    }

    private void showExtraFilterControls(boolean bl) {
        if (this._hideResultTypeCombo) {
            this._jResultTypeCombo.setVisible(false);
            this._jResultTypeLbl.setVisible(false);
        } else {
            this._jResultTypeCombo.setVisible(bl);
            this._jResultTypeLbl.setVisible(bl);
        }
        this._jItemNameFilterLbl.setVisible(bl);
        this._jItemNameFilterValue.setVisible(bl);
    }

    public Icon getExpandIcon() {
        if (_expandIcon == null) {
            _expandIcon = UIResourceHelper.getImageIcon(this.getClass(), ARRulesLrb.get("EXPAND_ICON"));
        }
        return _expandIcon;
    }

    public Icon getCollapseIcon() {
        if (_collapseIcon == null) {
            _collapseIcon = UIResourceHelper.getImageIcon(this.getClass(), ARRulesLrb.get("COLLAPSE_ICON"));
        }
        return _collapseIcon;
    }

    protected void _jExpandButton_actionPerformed(ActionEvent actionEvent) {
        if (this._filterExpanded) {
            this._filterExpanded = false;
            this.showExtraFilterControls(this._filterExpanded);
            ResourceUtils.resButton((AbstractButton)this._jExpandButton, (String)ARRulesLrb.get("MORE"));
            this._jExpandButton.setIcon(this.getExpandIcon());
            this._jExpandButton.getAccessibleContext().setAccessibleName(ARRulesLrb.get("MORE"));
            this._jExpandButton.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("MORE_ADA"));
            this._jExpandButton.setHorizontalTextPosition(10);
        } else {
            this._filterExpanded = true;
            this.showExtraFilterControls(this._filterExpanded);
            ResourceUtils.resButton((AbstractButton)this._jExpandButton, (String)ARRulesLrb.get("HIDE"));
            this._jExpandButton.setIcon(this.getCollapseIcon());
            this._jExpandButton.getAccessibleContext().setAccessibleName(ARRulesLrb.get("HIDE"));
            this._jExpandButton.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("HIDE_ADA"));
            this._jExpandButton.setHorizontalTextPosition(10);
        }
    }

    private void processFilter(String string) {
        try {
            if (this._itemTableModel != null) {
                ARItemTableModel aRItemTableModel = this._itemTableModel.getFilteredRules(string, this._currentSearchCategory);
                this.setupTable(aRItemTableModel);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ARRulesLrb.get("ADD_ITEM_QUERY_FAILURE_TITLE"), (String)ARRulesLrb.get("ADD_ITEM_QUERY_FAILURE_MESSAGE"), null);
        }
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = 1;
        if (searchCategory.getLabel().equals(ARRulesLrb.get("ADD_ITEM_NAME_CATEGORY_NAME"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(ARRulesLrb.get("ADD_ITEM_NAME_CATEGORY_VALUE"))) {
            this._currentSearchCategory = 1;
        } else {
            n = -1;
            assert (false) : "Invalid Search Category Code";
        }
        return n;
    }

    private void loadTable() {
        try {
            QueryItems queryItems = new QueryItems();
            queryItems.start();
            if (queryItems.getException() != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)queryItems.getException(), (String)ARRulesLrb.get("ADD_ITEM_QUERY_FAILURE_TITLE"), (String)ARRulesLrb.get("ADD_ITEM_QUERY_FAILURE_MESSAGE"), null);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ARRulesLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)ARRulesLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
        }
    }

    public void displayFailed() {
        this.loadEmptyItemsTable(true);
    }

    public void displayNoResults() {
        String string = ARRulesLrb.get("ADD_ITEMS_LOADING_HEADER");
        String string2 = ARRulesLrb.get("ADD_ITEMS_NO_RESULTS");
        this._jItemsGenericTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{string2}}, new String[]{string}));
        this._jItemsGenericTable.setAutoResizeMode(4);
    }

    private void setupTable(ARItemTableModel aRItemTableModel) {
        this._jItemsGenericTable.setModel((TableModel)((Object)aRItemTableModel));
        this._jItemsGenericTable.setSorted(true);
        this._jItemsGenericTable.setColumnSelectorAvailable(false);
        aRItemTableModel.setNameDisplay(this._nameDisplay);
        if (aRItemTableModel.isIncludeSupportColumn()) {
            this._jItemsGenericTable.getColumnModel().getColumn(2).setCellRenderer(new NumberRenderer());
        }
        this.loadRowsOutOfTotalLabel(this._jItemsGenericTable.getRowCount(), this._arViewerState.getTotalNumberOfSingleOccuringItems());
        if (this._displayValueColumn) {
            this._jItemsGenericTable.setHiddenColumns(new int[]{2});
        } else {
            this._jItemsGenericTable.setHiddenColumns(new int[]{1, 2});
        }
    }

    public Icon getIcon() {
        if (_icon == null) {
            _icon = UIResourceHelper.getImageIcon(this.getClass(), ARRulesLrb.get("QUERY_ICON"));
        }
        return _icon;
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    private void displayLoading(boolean bl) {
        if (bl) {
            this.loadEmptyItemsTable(false);
            this._jItemsGenericTable.setAutoResizeMode(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _jQueryItemsButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.clearTable();
            this.setLoading(true);
            this.loadRowsOutOfTotalLabel(0, this._arViewerState.getTotalNumberOfSingleOccuringItems());
            this.loadTable();
        }
        finally {
            this.setLoading(false);
        }
    }

    private void clearTable() {
        TableModel tableModel = this._jItemsGenericTable.getModel();
        if (tableModel instanceof ARItemTableModel) {
            ((ARItemTableModel)((Object)tableModel)).clearRows();
        }
    }

    private void loadEmptyItemsTable(boolean bl) {
        String string = ARRulesLrb.get("ADD_ITEMS_LOADING_HEADER");
        String string2 = bl ? ARRulesLrb.get("ADD_ITEMS_FAILURE") : ARRulesLrb.get("ADD_ITEMS_LOADING");
        this._jItemsGenericTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{string2}}, new String[]{string}));
        this._jItemsGenericTable.setAutoResizeMode(4);
    }

    protected void _jResultTypeCombo_actionPerformed(ActionEvent actionEvent) {
    }

    private String formatValue(Object object) {
        String string = "";
        if (object == null) {
            string = null;
        } else if (object != null) {
            string = object instanceof Double ? NumericFormat.format((Double)object, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()) + "" : object.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWork() {
        int[] nArray;
        boolean bl;
        block6: {
            bl = true;
            nArray = this._jItemsGenericTable.getSelectedRowsInModel();
            if (nArray.length != 0) break block6;
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)ARRulesLrb.get("ADD_ITEM_QUERY_VALIDATION_MESSAGE"), (String)ARRulesLrb.get("ADD_ITEM_QUERY_VALIDATION_TITLE"), null);
            boolean bl2 = false;
            return bl2;
        }
        try {
            String string = ((JLabel)this._jAddOptionCombo.getSelectedItem()).getText();
            int n = this.translateFilterAction(string);
            ARItemTableModel aRItemTableModel = (ARItemTableModel)((Object)this._jItemsGenericTable.getModel());
            aRItemTableModel.setFilterActionForAll(n);
            this._filterItemTableModel.addSelection(aRItemTableModel, nArray);
            if (this._table.getRowCount() > 0) {
                this._table.reSort();
                this._table.setRowSelectionInterval(0, 0);
                this._table.scrollToSelection();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private int translateFilterAction(String string) {
        int n = -1;
        if (string == ARRulesLrb.get("ADD_ITEM_INCLUDE_BOTH")) {
            n = 0;
        } else if (string == ARRulesLrb.get("ADD_ITEM_INCLUDE_CONDITION")) {
            n = 1;
        } else if (string == ARRulesLrb.get("ADD_ITEM_INCLUDE_ASSOCIATION")) {
            n = 2;
        } else assert (false) : "Unknown filter action";
        return n;
    }

    static {
        RESULT_TYPE_NAME = ARRulesLrb.get("RESULT_TYPE_NAME");
        RESULT_TYPE_NAME_SUBNAME = ARRulesLrb.get("RESULT_TYPE_NAME_SUBNAME");
        RESULT_TYPE_NAME_SUBNAME_VALUE = ARRulesLrb.get("RESULT_TYPE_NAME_SUBNAME_VALUE");
        SORT_BY_ATTRIBUTE = ARRulesLrb.get("ADD_ITEMS_SORT_BY_ATTRIBUTE");
        SORT_BY_SUPPORT = ARRulesLrb.get("ADD_ITEMS_SORT_BY_SUPPORT");
        SORT_BY_VALUE = ARRulesLrb.get("ADD_ITEMS_SORT_BY_VALUE");
        ORDER_BY_DESCENDING = ARRulesLrb.get("DESCENDING");
        ORDER_BY_ASCENDING = ARRulesLrb.get("ASCENDING");
        SORT_ORDER_COMBO_VALUES = new String[]{ORDER_BY_DESCENDING, ORDER_BY_ASCENDING};
        _p = Preferences.getPreferences();
    }

    class ARItemSetsGenericTable
    extends GenericTable {
        public ARItemSetsGenericTable() {
            this.setShowHorizontalLines(true);
            this.setShowVerticalLines(true);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Object object;
            String string = "";
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            try {
                object = this.getValueAt(n, n2);
            }
            catch (Exception exception) {
                return string;
            }
            string = ARItemFilterEditor.this.formatValue(object);
            return string;
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            string = ARItemFilterEditor.this.formatValue(object);
            return string;
        }
    }

    class NumberRenderer
    extends DefaultTableCellRenderer {
        @Override
        public void setValue(Object object) {
            String string = "";
            string = ARItemFilterEditor.this.formatValue(object);
            super.setValue(string);
        }
    }

    class QueryItems
    extends SwingWorker {
        private Exception _exception;
        boolean _success = false;
        ARItemTableModel _tableModel;

        public Exception getException() {
            return this._exception;
        }

        public Object construct() {
            try {
                ARItemFilterEditor.this._filterSetting.setFetchSize(ARItemFilterEditor.this.getNumber(ARItemFilterEditor.this._jFetchSizeValue).intValue());
                ARItemFilterEditor.this._filterSetting.setNameFilter(ARItemFilterEditor.this._jItemNameFilterValue.getText());
                ARItemFilterEditor.this._filterSetting.setUseNumberOfItems(true);
                ARItemFilterEditor.this._filterSetting.setNumberOfItems(new Integer(1));
                ARItemFilterEditor.this._filterSetting.setUseTopN(false);
                ARItemFilterEditor.this._filterSetting.setTopNBySupport(ARItemFilterEditor.this.getNumber(ARItemFilterEditor.this._jFetchSizeValue).intValue());
                String string = (String)ARItemFilterEditor.this._jResultTypeCombo.getSelectedItem();
                if (string == RESULT_TYPE_NAME) {
                    ARItemFilterEditor.this._filterSetting.setResultType(1);
                } else if (string == RESULT_TYPE_NAME_SUBNAME) {
                    ARItemFilterEditor.this._filterSetting.setResultType(2);
                } else if (string == RESULT_TYPE_NAME_SUBNAME_VALUE) {
                    ARItemFilterEditor.this._filterSetting.setResultType(3);
                } else {
                    throw new Exception("Invalid Result Type");
                }
                ARItemFilterEditor.this.setSortState(0, true, (String)ARItemFilterEditor.this._jSortCombo1.getSelectedItem(), (String)ARItemFilterEditor.this._jSortOrderCombo1.getSelectedItem());
                this._tableModel = new ARItemTableModel(ARItemFilterEditor.this._context, ARItemFilterEditor.this._model, ARItemFilterEditor.this._filterSetting, (ARItemTableModel)((Object)ARItemFilterEditor.this._table.getModel()), ((ARItemTableModel)((Object)ARItemFilterEditor.this._table.getModel())).isIncludeSupportColumn());
                this._tableModel.load();
                this._success = true;
            }
            catch (Exception exception) {
                this._exception = exception;
            }
            return this._success;
        }

        public void finished() {
            ARItemFilterEditor.this.setLoading(false);
            if (this._success) {
                if (this._tableModel.getRowCount() != 0) {
                    ARItemFilterEditor.this._itemTableModel = this._tableModel;
                    ARItemFilterEditor.this.setupTable(this._tableModel);
                } else {
                    ARItemFilterEditor.this.displayNoResults();
                }
            } else {
                if (this._exception != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._exception, (String)ARRulesLrb.get("ADD_ITEM_QUERY_FAILURE_TITLE"), (String)ARRulesLrb.get("ADD_ITEM_QUERY_FAILURE_MESSAGE"), null);
                }
                ARItemFilterEditor.this._itemTableModel = null;
                ARItemFilterEditor.this.displayFailed();
            }
        }
    }
}

