/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer;

import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;

public class ModelViewerPreferencesPanel
extends DefaultTraversablePanel {
    private Integer _percentagePrecisionLevel = new Integer(4);
    private Integer _numericalPrecisionLevel = new Integer(4);
    private Integer _fetchSizeARModel = new Integer(10000);
    private Integer _fetchSizeOtherModels = new Integer(10000);
    private Integer _fetchSizeClusteringModel = new Integer(100);
    private JSpinner _jFetchSizeARValueSpinner;
    private JSpinner _jFetchSizeClusteringValueSpinner;
    private JLabel _jFetchSizeForARLabel;
    private JLabel _jFetchSizeForClusteringLabel;
    private JLabel _jFetchSizeForOthersLabel;
    private JSpinner _jFetchSizeForOthersValueSpinner;
    private JLabel _jFetchSizeGroupDescription;
    private JSpinner _jNumericalPrecisionValueSpinner;
    private JLabel _jNumericalValuesPrecisionLabel;
    private JSpinner _jPercentagePrecisionValueSpinner;
    private JLabel _jPercentageValuesPrecisionLabel;
    private JLabel _jPrecisionGroupDescription;

    public ModelViewerPreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jPercentageValuesPrecisionLabel = new JLabel();
        this._jPercentagePrecisionValueSpinner = new JSpinner();
        this._jPrecisionGroupDescription = new JLabel();
        this._jNumericalValuesPrecisionLabel = new JLabel();
        this._jNumericalPrecisionValueSpinner = new JSpinner();
        this._jFetchSizeGroupDescription = new JLabel();
        this._jFetchSizeForARLabel = new JLabel();
        this._jFetchSizeARValueSpinner = new JSpinner();
        this._jFetchSizeForOthersLabel = new JLabel();
        this._jFetchSizeForOthersValueSpinner = new JSpinner();
        this._jFetchSizeForClusteringLabel = new JLabel();
        this._jFetchSizeClusteringValueSpinner = new JSpinner();
        this._jPercentageValuesPrecisionLabel.setText("Percentage Based Values:");
        this._jPrecisionGroupDescription.setText("Precision Settings:");
        this._jNumericalValuesPrecisionLabel.setText("Numerical Values:");
        this._jFetchSizeGroupDescription.setText("Fetch Size Settings:");
        this._jFetchSizeForARLabel.setText("Association Rules Model:");
        this._jFetchSizeForOthersLabel.setText("All Other Models:");
        this._jFetchSizeForClusteringLabel.setText("Clustering Model:");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jNumericalValuesPrecisionLabel, -1, -1, Short.MAX_VALUE).addComponent(this._jPercentageValuesPrecisionLabel, -1, 195, Short.MAX_VALUE)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jFetchSizeForOthersLabel, -1, -1, Short.MAX_VALUE).addComponent(this._jFetchSizeForClusteringLabel, -1, -1, Short.MAX_VALUE).addComponent(this._jFetchSizeForARLabel, -1, 148, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 81, Short.MAX_VALUE).addComponent(this._jNumericalPrecisionValueSpinner, -2, 47, -2)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 81, Short.MAX_VALUE).addComponent(this._jPercentagePrecisionValueSpinner, -2, 47, -2)).addComponent(this._jFetchSizeARValueSpinner, GroupLayout.Alignment.TRAILING, -1, 128, Short.MAX_VALUE).addComponent(this._jFetchSizeClusteringValueSpinner, GroupLayout.Alignment.TRAILING, -1, 128, Short.MAX_VALUE).addComponent(this._jFetchSizeForOthersValueSpinner, GroupLayout.Alignment.TRAILING, -1, 128, Short.MAX_VALUE)).addGap(64, 64, 64)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this._jFetchSizeGroupDescription, -1, 240, Short.MAX_VALUE).addContainerGap(150, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this._jPrecisionGroupDescription, -1, 366, Short.MAX_VALUE).addContainerGap(24, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jPrecisionGroupDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(groupLayout.createSequentialGroup().addComponent(this._jPercentageValuesPrecisionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jNumericalValuesPrecisionLabel)).addGroup(groupLayout.createSequentialGroup().addComponent(this._jPercentagePrecisionValueSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jNumericalPrecisionValueSpinner, -2, -1, -2))).addGap(18, 18, 18).addComponent(this._jFetchSizeGroupDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jFetchSizeForARLabel).addComponent(this._jFetchSizeARValueSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jFetchSizeClusteringValueSpinner, -2, -1, -2).addComponent(this._jFetchSizeForClusteringLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jFetchSizeForOthersValueSpinner, -2, -1, -2).addComponent(this._jFetchSizeForOthersLabel)).addContainerGap(117, Short.MAX_VALUE)));
    }

    public void initRes() {
        this._jPrecisionGroupDescription.setText(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_SETTING"));
        this._jPrecisionGroupDescription.getAccessibleContext().setAccessibleName(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_SETTING"));
        this._jPrecisionGroupDescription.getAccessibleContext().setAccessibleDescription(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_SETTING_ADA"));
        this._jPercentageValuesPrecisionLabel.setText(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_PERCENTAGE_SETTING"));
        this._jPercentageValuesPrecisionLabel.setDisplayedMnemonic(StringUtils.getMnemonic(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_PERCENTAGE_SETTING_MNEMONIC")));
        this._jPercentageValuesPrecisionLabel.getAccessibleContext().setAccessibleName(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_PERCENTAGE_SETTING"));
        this._jPercentageValuesPrecisionLabel.getAccessibleContext().setAccessibleDescription(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_PERCENTAGE_SETTING_ADA"));
        this._jPercentageValuesPrecisionLabel.setLabelFor(this._jPercentagePrecisionValueSpinner);
        this._jNumericalValuesPrecisionLabel.setText(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_NUMERICAL_SETTING"));
        this._jNumericalValuesPrecisionLabel.setDisplayedMnemonic(StringUtils.getMnemonic(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_NUMERICAL_SETTING_MNEMONIC")));
        this._jNumericalValuesPrecisionLabel.getAccessibleContext().setAccessibleName(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_NUMERICAL_SETTING"));
        this._jNumericalValuesPrecisionLabel.getAccessibleContext().setAccessibleDescription(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_NUMERICAL_SETTING_ADA"));
        this._jNumericalValuesPrecisionLabel.setLabelFor(this._jNumericalPrecisionValueSpinner);
        this._jPercentagePrecisionValueSpinner.setModel(new SpinnerNumberModel(this._percentagePrecisionLevel, 0, 12, 1));
        this._jNumericalPrecisionValueSpinner.setModel(new SpinnerNumberModel(this._numericalPrecisionLevel, 0, 12, 1));
        this._jFetchSizeGroupDescription.setText(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_SETTING"));
        this._jFetchSizeGroupDescription.getAccessibleContext().setAccessibleName(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_SETTING"));
        this._jFetchSizeGroupDescription.getAccessibleContext().setAccessibleDescription(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_SETTING_ADA"));
        this._jFetchSizeForARLabel.setText(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_AR_SETTING"));
        this._jFetchSizeForARLabel.setDisplayedMnemonic(StringUtils.getMnemonic(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_AR_SETTING_MNEMONIC")));
        this._jFetchSizeForARLabel.getAccessibleContext().setAccessibleName(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_AR_SETTING"));
        this._jFetchSizeForARLabel.getAccessibleContext().setAccessibleDescription(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_AR_SETTING_ADA"));
        this._jFetchSizeForARLabel.setLabelFor(this._jFetchSizeARValueSpinner);
        this._jFetchSizeForClusteringLabel.setText(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_CLUSTERING_SETTING"));
        this._jFetchSizeForClusteringLabel.setDisplayedMnemonic(StringUtils.getMnemonic(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_CLUSTERING_SETTING_MNEMONIC")));
        this._jFetchSizeForClusteringLabel.getAccessibleContext().setAccessibleName(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_CLUSTERING_SETTING"));
        this._jFetchSizeForClusteringLabel.getAccessibleContext().setAccessibleDescription(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_CLUSTERING_SETTING_ADA"));
        this._jFetchSizeForClusteringLabel.setLabelFor(this._jFetchSizeClusteringValueSpinner);
        this._jFetchSizeForOthersLabel.setText(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_OTHER_MODELS_SETTING"));
        this._jFetchSizeForOthersLabel.setDisplayedMnemonic(StringUtils.getMnemonic(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_OTHER_MODELS_SETTING_MNEMONIC")));
        this._jFetchSizeForOthersLabel.getAccessibleContext().setAccessibleName(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_OTHER_MODELS_SETTING"));
        this._jFetchSizeForOthersLabel.getAccessibleContext().setAccessibleDescription(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_OTHER_MODELS_SETTING_ADA"));
        this._jFetchSizeForOthersLabel.setLabelFor(this._jFetchSizeForOthersValueSpinner);
        this._jFetchSizeARValueSpinner.setModel(new SpinnerNumberModel(this._fetchSizeARModel, 1, Integer.MAX_VALUE, 100));
        this._jFetchSizeClusteringValueSpinner.setModel(new SpinnerNumberModel(this._fetchSizeClusteringModel, 1, Integer.MAX_VALUE, 100));
        this._jFetchSizeForOthersValueSpinner.setModel(new SpinnerNumberModel(this._fetchSizeOtherModels, 1, Integer.MAX_VALUE, 100));
        this.setHelpID("data_miner_prefs");
    }

    public void initUI() {
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    public void onEntry(TraversableContext traversableContext) {
        ModelViewerPreferenceSettings modelViewerPreferenceSettings = ModelViewerPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        this._percentagePrecisionLevel = new Integer(modelViewerPreferenceSettings.getPercentagePrecisionLevel());
        this._jPercentagePrecisionValueSpinner.setValue(this._percentagePrecisionLevel);
        this._numericalPrecisionLevel = new Integer(modelViewerPreferenceSettings.getNumericalPrecisionLevel());
        this._jNumericalPrecisionValueSpinner.setValue(this._numericalPrecisionLevel);
        this._fetchSizeARModel = new Integer(modelViewerPreferenceSettings.getFetchSizeARModel());
        this._jFetchSizeARValueSpinner.setValue(this._fetchSizeARModel);
        this._fetchSizeClusteringModel = new Integer(modelViewerPreferenceSettings.getFetchSizeClusteringModel());
        this._jFetchSizeClusteringValueSpinner.setValue(this._fetchSizeClusteringModel);
        this._fetchSizeOtherModels = new Integer(modelViewerPreferenceSettings.getFetchSizeOtherModels());
        this._jFetchSizeForOthersValueSpinner.setValue(this._fetchSizeOtherModels);
    }

    public void onExit(TraversableContext traversableContext) {
        Number number;
        Number number2;
        Number number3;
        Number number4;
        ModelViewerPreferenceSettings modelViewerPreferenceSettings = ModelViewerPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        Number number5 = this.getNumber(this._jPercentagePrecisionValueSpinner);
        if (number5 != null) {
            modelViewerPreferenceSettings.setPercentagePrecisionLevel(number5.intValue());
        }
        if ((number4 = this.getNumber(this._jNumericalPrecisionValueSpinner)) != null) {
            modelViewerPreferenceSettings.setNumericalPrecisionLevel(number4.intValue());
        }
        if ((number3 = this.getNumber(this._jFetchSizeARValueSpinner)) != null) {
            modelViewerPreferenceSettings.setFetchSizeARModel(number3.intValue());
        }
        if ((number2 = this.getNumber(this._jFetchSizeClusteringValueSpinner)) != null) {
            modelViewerPreferenceSettings.setFetchSizeClusteringModel(number2.intValue());
        }
        if ((number = this.getNumber(this._jFetchSizeForOthersValueSpinner)) != null) {
            modelViewerPreferenceSettings.setFetchSizeOtherModels(number.intValue());
        }
    }

    private static ModelViewerPreferenceSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return ModelViewerPreferenceSettings.getInstance(traversableContext.getPropertyStorage());
    }
}

