/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.legend;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dmt.dataminer.legend.Legend;
import oracle.dmt.dataminer.legend.LegendConsumer;
import oracle.dmt.dataminer.legend.LegendEvent;
import oracle.dmt.dataminer.legend.LegendImplementer;
import oracle.dmt.dataminer.legend.LegendListener;
import oracle.dmt.dataminer.legend.LegendLrb;
import oracle.dmt.dataminer.legend.LegendManager;
import oracle.dmt.dataminer.legend.LegendPageProvider;
import oracle.dmt.dataminer.legend.LegendWindowGUI;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableListener;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.dialogs.MessageDialog;

public class LegendWindow
extends DockableWindow
implements EditorListener,
ViewListener,
Dockable,
DockableListener,
ActiveViewListener {
    private static Icon _icon;
    public static final String VIEW_TYPE = "DATAMININGLEGENDFACTORY";
    public static final String VIEW_NAME = "LEGEND";
    protected HashMap<View, ArrayList<LegendListener>> _legendListenersByType;
    private Object _legendListenerLock = new Object();
    protected ArrayList<Component> _legendWindows;
    LegendGUIEventHandler _guiEventHandler;
    private static final LegendWindow _singleton;
    private JScrollPane _rootContainer;
    private JPanel _emptyPanel;
    private final LegendManager _legendManager = LegendManager.getLegendManager();
    private final Legend _legend = Legend.getInstance();
    private View _currentEditor = null;
    private View _currentView = null;
    private Component _currentGUI = null;
    private static boolean _isView;
    private static boolean _dockableHidden;
    private static boolean editorListenerAdded;
    private Collection<LegendConsumer> _consumers = null;
    public static final String LAYOUT_SHOW_LEGEND = "Layout.ShowLegend";
    public static final String LAYOUT_RAISE_LEGEND = "Layout.RaiseLegend";

    public static String viewId() {
        return "DATAMININGLEGENDFACTORY.LEGEND";
    }

    public LegendWindow() {
        super(LegendWindow.viewId());
        DockStation.getDockStation().addDockableListener((DockableListener)this, (Dockable)this);
        this._legendListenersByType = new HashMap();
        this._guiEventHandler = new LegendGUIEventHandler();
    }

    private void initRootContainer() {
        this._rootContainer = new JScrollPane();
        this._emptyPanel = new JPanel();
        JLabel jLabel = new JLabel();
        jLabel.setText("No Associated Editor");
        this._emptyPanel.add(jLabel);
        this.loadRootContainer(this._emptyPanel);
    }

    private void consumerListeners() {
        this._consumers = this._legendManager.getLegendConsumers();
        if (this._consumers == null) {
            return;
        }
        for (LegendConsumer legendConsumer : this._consumers) {
            legendConsumer.getConsumerView().addViewListener((ViewListener)this);
        }
    }

    public Component getGUI() {
        View view;
        if (this._rootContainer == null) {
            this.initRootContainer();
        }
        if ((view = this.getEditor()) == null) {
            this.loadRootContainer(this._emptyPanel);
            this._currentGUI = null;
            return this.loadRootContainer(this._currentGUI);
        }
        this._currentView = view;
        _isView = true;
        if (this._consumers == null) {
            this.consumerListeners();
        }
        if (this._synchronizeLegend(this.getEditor(), false)) {
            return this._rootContainer;
        }
        this._currentGUI = null;
        return this.loadRootContainer(this._emptyPanel);
    }

    private Component loadRootContainer(Component component) {
        if (component != null) {
            this._rootContainer.setViewportView(component);
        } else {
            this._rootContainer.getViewport().removeAll();
        }
        return this._rootContainer;
    }

    private Component getInternalGUI() {
        Component component = null;
        LegendConsumer legendConsumer = null;
        if (this._currentEditor instanceof LegendConsumer) {
            legendConsumer = (LegendConsumer)this._currentEditor;
        }
        LegendPageProvider legendPageProvider = null;
        if (legendConsumer != null) {
            legendPageProvider = this.findLegendPageProvider(legendConsumer);
            assert (legendPageProvider != null) : "Legend dockable received a request from a consumer, but there is no matching legend provider.";
            if (legendPageProvider != null) {
                component = legendPageProvider.getLegendPage().getGUI();
                if (component instanceof LegendWindowGUI) {
                    this.addInternalGUIToListener(component);
                    this.loadRootContainer(component);
                } else assert (false) : "GUI provided by LegendPageProvider is not an instance of LegendWindowGUI";
            }
        }
        return component;
    }

    private void addInternalGUIToListener(Component component) {
        if (this._legendWindows == null) {
            this._legendWindows = new ArrayList();
        }
        if (!this._legendWindows.contains(component)) {
            ((LegendWindowGUI)component).addLegendListener(this._guiEventHandler);
            this._legendWindows.add(component);
        }
    }

    private LegendPageProvider findLegendPageProvider(LegendConsumer legendConsumer) {
        LegendPageProvider legendPageProvider = null;
        for (LegendPageProvider legendPageProvider2 : this._legend.getLegendPageProviders()) {
            if (!legendPageProvider2.getLegendType().equals(legendConsumer.getLegendType())) continue;
            legendPageProvider = legendPageProvider2;
            break;
        }
        return legendPageProvider;
    }

    public static LegendWindow getInstance() {
        return _singleton;
    }

    public void dockableShown(DockableEvent dockableEvent) {
        _dockableHidden = false;
        super.dockableShown(dockableEvent);
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
        this._synchronizeLegend(this.getEditor(), true);
    }

    public void dockableHidden(DockableEvent dockableEvent) {
        this.unloadUI();
        _dockableHidden = true;
        this._currentEditor = null;
        super.dockableHidden(dockableEvent);
        Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
    }

    public void stateChange(int n) {
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        super.stateChange(n);
    }

    public View getEditor() {
        if (_isView) {
            return this._currentView;
        }
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor == null || editor.getContext() == null || editor.getContext().getNode() == null) {
            editor = null;
        }
        return editor;
    }

    private boolean _synchronizeLegend(View view, boolean bl) {
        if (!editorListenerAdded) {
            EditorManager.getEditorManager().addEditorListener((EditorListener)this);
            editorListenerAdded = true;
        }
        if (view == null) {
            this.loadRootContainer(this._emptyPanel);
            return false;
        }
        if (this._currentEditor == null || view != this._currentEditor) {
            Component component;
            if (!(view instanceof LegendConsumer)) {
                this._currentEditor = view;
                this._currentGUI = null;
                this.loadRootContainer(this._emptyPanel);
                return true;
            }
            if (this._currentGUI != null) {
                this.unloadUI();
            }
            this._currentEditor = view;
            this._currentGUI = component = this.getInternalGUI();
            if (this._currentGUI != null) {
                this.loadRootContainer(this._currentGUI);
                if (bl) {
                    this.initializeUI();
                }
                return true;
            }
            this.loadRootContainer(this._emptyPanel);
            return false;
        }
        this.initializeUI();
        return true;
    }

    private void initializeUI() {
        if (this._currentGUI instanceof LegendImplementer) {
            try {
                LegendImplementer legendImplementer = (LegendImplementer)((Object)this._currentGUI);
                if (!legendImplementer.isLoaded()) {
                    legendImplementer.setupUI(this._currentEditor);
                }
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)LegendLrb.get("LEGEND_PROCESSING_MESG"), (String)LegendLrb.get("LEGEND_PROCESSING_TITLE"), null);
                exception.printStackTrace();
            }
        }
    }

    private void unloadUI() {
        if (this._currentGUI instanceof LegendImplementer) {
            try {
                LegendImplementer legendImplementer = (LegendImplementer)((Object)this._currentGUI);
                if (legendImplementer.isLoaded()) {
                    legendImplementer.unloadUI();
                }
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)LegendLrb.get("LEGEND_PROCESSING_MESG"), (String)LegendLrb.get("LEGEND_PROCESSING_TITLE"), null);
                exception.printStackTrace();
            }
        }
    }

    public void addLegendListener(LegendListener legendListener) {
        this.addLegendListener(legendListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLegendListener(LegendListener legendListener, View view) {
        Object object = this._legendListenerLock;
        synchronized (object) {
            ArrayList<LegendListener> arrayList = null;
            if (this._legendListenersByType == null) {
                this._legendListenersByType = new HashMap();
            }
            if (!this._legendListenersByType.containsKey(view)) {
                this._legendListenersByType.put(view, new ArrayList());
            }
            arrayList = this._legendListenersByType.get(view);
            arrayList.add(legendListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLegendListener(LegendListener legendListener) {
        Object object = this._legendListenerLock;
        synchronized (object) {
            if (this._legendListenersByType == null) {
                return;
            }
            for (ArrayList<LegendListener> arrayList : this._legendListenersByType.values()) {
                arrayList.remove(legendListener);
            }
        }
    }

    private void fireLegendEvent(LegendEvent legendEvent) {
        try {
            this.fireEvent(new LegendListenerHandler(){

                @Override
                public void handle(LegendListener legendListener, LegendEvent legendEvent) {
                    legendListener.addEvent(legendEvent);
                }
            }, legendEvent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fireEvent(LegendListenerHandler legendListenerHandler, LegendEvent legendEvent) {
        HashMap<View, ArrayList<LegendListener>> hashMap = this.cloneToAvoidConcurrentModificationException(this._legendListenersByType);
        ArrayList<LegendListener> arrayList = hashMap.get(legendEvent.getTarget());
        if (arrayList != null) {
            for (LegendListener legendListener : arrayList) {
                legendListenerHandler.handle(legendListener, legendEvent);
            }
        }
        if (legendEvent.getTarget() != null && (arrayList = hashMap.get(null)) != null) {
            for (LegendListener legendListener : arrayList) {
                legendListenerHandler.handle(legendListener, legendEvent);
            }
        }
    }

    private HashMap<View, ArrayList<LegendListener>> cloneToAvoidConcurrentModificationException(HashMap<View, ArrayList<LegendListener>> hashMap) {
        return (HashMap)hashMap.clone();
    }

    public void editorOpened(Editor editor) {
    }

    public void editorActivated(Editor editor) {
        _isView = false;
        if (!_dockableHidden) {
            this._synchronizeLegend((View)editor, true);
        }
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
        if (editor != null && editor == this._currentEditor) {
            this._currentEditor = null;
            this._currentView = null;
            this.unloadUI();
            this._currentGUI = null;
            this.loadRootContainer(this._emptyPanel);
            _isView = false;
        }
    }

    public void viewActivated(ViewEvent viewEvent) {
        _isView = true;
        View view = viewEvent.getView();
        if (!_dockableHidden) {
            this._currentView = view;
            this._synchronizeLegend(view, true);
        }
    }

    public void viewDeactivated(ViewEvent viewEvent) {
    }

    public void viewClosed(ViewEvent viewEvent) {
        View view = viewEvent.getView();
        if (view != null && view == this._currentView) {
            this._currentView = null;
            this._currentEditor = null;
            this.unloadUI();
            this._currentGUI = null;
            this.loadRootContainer(this._emptyPanel);
            _isView = false;
        }
    }

    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        if (activeViewEvent.getNewView() == null) {
            this.loadRootContainer(this._emptyPanel);
            return;
        }
        View view = this.getEditor();
        if (view == null) {
            this.loadRootContainer(this._emptyPanel);
            return;
        }
        if (!_dockableHidden) {
            this._synchronizeLegend(view, true);
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_dataminer_legend_html");
    }

    public int getDefaultVisibility(Layout layout) {
        String string = layout.getProperty(LAYOUT_SHOW_LEGEND, null);
        boolean bl = Boolean.valueOf(string);
        String string2 = layout.getProperty(LAYOUT_RAISE_LEGEND, bl ? "true" : "false");
        boolean bl2 = Boolean.valueOf(string2);
        return (bl ? 1 : 0) | (bl2 ? 4 : 0);
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public Icon getTabIcon() {
        return this.getIcon();
    }

    public String getTitleName() {
        return LegendLrb.get("LEGEND_TAB_NAME");
    }

    public Icon getIcon() {
        if (_icon == null) {
            _icon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), LegendLrb.get("LEGEND_ICON"));
        }
        return _icon;
    }

    public String getUniqueName() {
        return "DATAMININGLEGENDFACTORY.LEGEND";
    }

    static {
        _singleton = new LegendWindow();
        _isView = false;
        _dockableHidden = false;
        editorListenerAdded = false;
    }

    class LegendGUIEventHandler
    implements LegendListener {
        LegendGUIEventHandler() {
        }

        @Override
        public void addEvent(LegendEvent legendEvent) {
            LegendWindow.this.fireLegendEvent(legendEvent);
        }
    }

    private static interface LegendListenerHandler {
        public void handle(LegendListener var1, LegendEvent var2);
    }
}

