/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.generated.server;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;
import oracle.dmt.dataminer.generated.server.OdmrNodeReferenceSet;
import oracle.dmt.dataminer.generated.server.OdmrObjectNames;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.CLOB;
import oracle.sql.ORAData;
import oracle.sql.SimpleXMLType;

public class OdmrWorkflow {
    protected Connection __onn = null;
    protected DataSource __dataSource = null;

    public void setDataSource(DataSource dataSource) throws SQLException {
        this.release();
        this.__dataSource = dataSource;
    }

    public void setDataSourceLocation(String string) throws SQLException {
        try {
            Class<?> clazz = Class.forName("javax.naming.InitialContext");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("lookup", String.class);
            DataSource dataSource = (DataSource)method.invoke(obj, "java:comp/env/" + string);
            this.setDataSource(dataSource);
        }
        catch (Exception exception) {
            throw new SQLException("Error initializing DataSource at " + string + ": " + exception.getMessage());
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.__onn != null) {
            return this.__onn;
        }
        if (this.__dataSource != null) {
            this.__onn = this.__dataSource.getConnection();
        }
        return this.__onn;
    }

    public void release() throws SQLException {
        this.__onn = null;
        this.__dataSource = null;
    }

    public void closeConnection() {
        if (this.__dataSource != null) {
            try {
                if (this.__onn != null) {
                    this.__onn.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.__onn = null;
        }
    }

    public void setConnection(Connection connection) throws SQLException {
        this.__onn = connection;
    }

    public OdmrWorkflow() throws SQLException {
    }

    public OdmrWorkflow(Connection connection) throws SQLException {
        this.__onn = connection;
    }

    public OdmrWorkflow(DataSource dataSource) throws SQLException {
        this.__dataSource = dataSource;
    }

    public CLOB wfLoad(BigDecimal bigDecimal, String[] stringArray, Timestamp[] timestampArray) throws SQLException {
        Connection connection = null;
        CLOB cLOB = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.\"ODMR_WORKFLOW\".WF_LOAD(:2 ,:3 ,:4 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2005);
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            oracleCallableStatement.registerOutParameter(3, 1);
            if (stringArray[0] == null) {
                oracleCallableStatement.setNull(3, 1);
            } else {
                oracleCallableStatement.setString(3, stringArray[0]);
            }
            oracleCallableStatement.registerOutParameter(4, 93);
            if (timestampArray[0] == null) {
                oracleCallableStatement.setNull(4, 93);
            } else {
                oracleCallableStatement.setTimestamp(4, timestampArray[0]);
            }
            oracleCallableStatement.executeUpdate();
            cLOB = oracleCallableStatement.getCLOB(1);
            stringArray[0] = oracleCallableStatement.getString(3);
            timestampArray[0] = oracleCallableStatement.getTimestamp(4);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.\"ODMR_WORKFLOW\".WF_LOAD(:2 ,:3 ,:4 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2005);
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                oracleCallableStatement.registerOutParameter(3, 1);
                if (stringArray[0] == null) {
                    oracleCallableStatement.setNull(3, 1);
                } else {
                    oracleCallableStatement.setString(3, stringArray[0]);
                }
                oracleCallableStatement.registerOutParameter(4, 93);
                if (timestampArray[0] == null) {
                    oracleCallableStatement.setNull(4, 93);
                } else {
                    oracleCallableStatement.setTimestamp(4, timestampArray[0]);
                }
                oracleCallableStatement.executeUpdate();
                cLOB = oracleCallableStatement.getCLOB(1);
                stringArray[0] = oracleCallableStatement.getString(3);
                timestampArray[0] = oracleCallableStatement.getTimestamp(4);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return cLOB;
    }

    public void wfDelete(BigDecimal bigDecimal) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_WORKFLOW\".WF_DELETE(:1 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_WORKFLOW\".WF_DELETE(:1 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void wfRename(BigDecimal bigDecimal, String string, String string2) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_WORKFLOW\".WF_RENAME(:1 ,:2 ,:3 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 12);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            if (string2 == null) {
                oracleCallableStatement.setNull(3, 1);
            } else {
                oracleCallableStatement.setString(3, string2);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_WORKFLOW\".WF_RENAME(:1 ,:2 ,:3 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 12);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                if (string2 == null) {
                    oracleCallableStatement.setNull(3, 1);
                } else {
                    oracleCallableStatement.setString(3, string2);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void wfUnlock(BigDecimal bigDecimal) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_WORKFLOW\".WF_UNLOCK(:1 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_WORKFLOW\".WF_UNLOCK(:1 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void wfGetAllModels(OdmrObjectNames[] odmrObjectNamesArray) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_WORKFLOW\".WF_GET_ALL_MODELS(:1 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
            if (odmrObjectNamesArray[0] == null) {
                oracleCallableStatement.setNull(1, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
            } else {
                oracleCallableStatement.setORAData(1, (ORAData)odmrObjectNamesArray[0]);
            }
            oracleCallableStatement.executeUpdate();
            odmrObjectNamesArray[0] = (OdmrObjectNames)oracleCallableStatement.getORAData(1, OdmrObjectNames.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_WORKFLOW\".WF_GET_ALL_MODELS(:1 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
                if (odmrObjectNamesArray[0] == null) {
                    oracleCallableStatement.setNull(1, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
                } else {
                    oracleCallableStatement.setORAData(1, (ORAData)odmrObjectNamesArray[0]);
                }
                oracleCallableStatement.executeUpdate();
                odmrObjectNamesArray[0] = (OdmrObjectNames)oracleCallableStatement.getORAData(1, OdmrObjectNames.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void wfSave(BigDecimal bigDecimal, SimpleXMLType simpleXMLType, Timestamp[] timestampArray, String string, String string2) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_WORKFLOW\".WF_SAVE(:1 ,:2 ,:3 ,:4 ,:5 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (simpleXMLType == null) {
                oracleCallableStatement.setNull(2, 2007, "SYS.XMLTYPE");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)simpleXMLType);
            }
            oracleCallableStatement.registerOutParameter(3, 93);
            if (timestampArray[0] == null) {
                oracleCallableStatement.setNull(3, 93);
            } else {
                oracleCallableStatement.setTimestamp(3, timestampArray[0]);
            }
            if (string == null) {
                oracleCallableStatement.setNull(4, 1);
            } else {
                oracleCallableStatement.setString(4, string);
            }
            if (string2 == null) {
                oracleCallableStatement.setNull(5, 1);
            } else {
                oracleCallableStatement.setString(5, string2);
            }
            oracleCallableStatement.executeUpdate();
            timestampArray[0] = oracleCallableStatement.getTimestamp(3);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_WORKFLOW\".WF_SAVE(:1 ,:2 ,:3 ,:4 ,:5 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (simpleXMLType == null) {
                    oracleCallableStatement.setNull(2, 2007, "SYS.XMLTYPE");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)simpleXMLType);
                }
                oracleCallableStatement.registerOutParameter(3, 93);
                if (timestampArray[0] == null) {
                    oracleCallableStatement.setNull(3, 93);
                } else {
                    oracleCallableStatement.setTimestamp(3, timestampArray[0]);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(4, 1);
                } else {
                    oracleCallableStatement.setString(4, string);
                }
                if (string2 == null) {
                    oracleCallableStatement.setNull(5, 1);
                } else {
                    oracleCallableStatement.setString(5, string2);
                }
                oracleCallableStatement.executeUpdate();
                timestampArray[0] = oracleCallableStatement.getTimestamp(3);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public CLOB wfGetNodeContent(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) throws SQLException {
        Connection connection = null;
        CLOB cLOB = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.\"ODMR_WORKFLOW\".WF_GET_NODE_CONTENT(:2 ,:3 ,:4 ,:5 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2005);
            if (string == null) {
                oracleCallableStatement.setNull(2, 12);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(3, 2);
            } else {
                oracleCallableStatement.setBigDecimal(3, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(4, 2);
            } else {
                oracleCallableStatement.setBigDecimal(4, bigDecimal2);
            }
            if (bigDecimal3 == null) {
                oracleCallableStatement.setNull(5, 2);
            } else {
                oracleCallableStatement.setBigDecimal(5, bigDecimal3);
            }
            oracleCallableStatement.executeUpdate();
            cLOB = oracleCallableStatement.getCLOB(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.\"ODMR_WORKFLOW\".WF_GET_NODE_CONTENT(:2 ,:3 ,:4 ,:5 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2005);
                if (string == null) {
                    oracleCallableStatement.setNull(2, 12);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(3, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(3, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(4, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(4, bigDecimal2);
                }
                if (bigDecimal3 == null) {
                    oracleCallableStatement.setNull(5, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(5, bigDecimal3);
                }
                oracleCallableStatement.executeUpdate();
                cLOB = oracleCallableStatement.getCLOB(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return cLOB;
    }

    public BigDecimal wfCreate(BigDecimal bigDecimal, String string, String string2, Timestamp[] timestampArray) throws SQLException {
        Connection connection = null;
        BigDecimal bigDecimal2 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.\"ODMR_WORKFLOW\".WF_CREATE(:2 ,:3 ,:4 ,:5 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(3, 12);
            } else {
                oracleCallableStatement.setString(3, string);
            }
            if (string2 == null) {
                oracleCallableStatement.setNull(4, 12);
            } else {
                oracleCallableStatement.setString(4, string2);
            }
            oracleCallableStatement.registerOutParameter(5, 93);
            if (timestampArray[0] == null) {
                oracleCallableStatement.setNull(5, 93);
            } else {
                oracleCallableStatement.setTimestamp(5, timestampArray[0]);
            }
            oracleCallableStatement.executeUpdate();
            bigDecimal2 = oracleCallableStatement.getBigDecimal(1);
            timestampArray[0] = oracleCallableStatement.getTimestamp(5);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.\"ODMR_WORKFLOW\".WF_CREATE(:2 ,:3 ,:4 ,:5 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(3, 12);
                } else {
                    oracleCallableStatement.setString(3, string);
                }
                if (string2 == null) {
                    oracleCallableStatement.setNull(4, 12);
                } else {
                    oracleCallableStatement.setString(4, string2);
                }
                oracleCallableStatement.registerOutParameter(5, 93);
                if (timestampArray[0] == null) {
                    oracleCallableStatement.setNull(5, 93);
                } else {
                    oracleCallableStatement.setTimestamp(5, timestampArray[0]);
                }
                oracleCallableStatement.executeUpdate();
                bigDecimal2 = oracleCallableStatement.getBigDecimal(1);
                timestampArray[0] = oracleCallableStatement.getTimestamp(5);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return bigDecimal2;
    }

    public void wfGetNodesByType(String string, OdmrNodeReferenceSet[] odmrNodeReferenceSetArray) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_WORKFLOW\".WF_GET_NODES_BY_TYPE(:1 ,:2 ); END;");
            if (string == null) {
                oracleCallableStatement.setNull(1, 12);
            } else {
                oracleCallableStatement.setString(1, string);
            }
            oracleCallableStatement.registerOutParameter(2, 2003, "ODMRSYS.ODMR_NODE_REFERENCE_SET");
            if (odmrNodeReferenceSetArray[0] == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_NODE_REFERENCE_SET");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrNodeReferenceSetArray[0]);
            }
            oracleCallableStatement.executeUpdate();
            odmrNodeReferenceSetArray[0] = (OdmrNodeReferenceSet)oracleCallableStatement.getORAData(2, OdmrNodeReferenceSet.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_WORKFLOW\".WF_GET_NODES_BY_TYPE(:1 ,:2 ); END;");
                if (string == null) {
                    oracleCallableStatement.setNull(1, 12);
                } else {
                    oracleCallableStatement.setString(1, string);
                }
                oracleCallableStatement.registerOutParameter(2, 2003, "ODMRSYS.ODMR_NODE_REFERENCE_SET");
                if (odmrNodeReferenceSetArray[0] == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_NODE_REFERENCE_SET");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrNodeReferenceSetArray[0]);
                }
                oracleCallableStatement.executeUpdate();
                odmrNodeReferenceSetArray[0] = (OdmrNodeReferenceSet)oracleCallableStatement.getORAData(2, OdmrNodeReferenceSet.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void wfStop(BigDecimal bigDecimal) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_WORKFLOW\".WF_STOP(:1 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_WORKFLOW\".WF_STOP(:1 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void wfGetAllTables(OdmrObjectNames[] odmrObjectNamesArray) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_WORKFLOW\".WF_GET_ALL_TABLES(:1 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
            if (odmrObjectNamesArray[0] == null) {
                oracleCallableStatement.setNull(1, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
            } else {
                oracleCallableStatement.setORAData(1, (ORAData)odmrObjectNamesArray[0]);
            }
            oracleCallableStatement.executeUpdate();
            odmrObjectNamesArray[0] = (OdmrObjectNames)oracleCallableStatement.getORAData(1, OdmrObjectNames.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.\"ODMR_WORKFLOW\".WF_GET_ALL_TABLES(:1 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
                if (odmrObjectNamesArray[0] == null) {
                    oracleCallableStatement.setNull(1, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
                } else {
                    oracleCallableStatement.setORAData(1, (ORAData)odmrObjectNamesArray[0]);
                }
                oracleCallableStatement.executeUpdate();
                odmrObjectNamesArray[0] = (OdmrObjectNames)oracleCallableStatement.getORAData(1, OdmrObjectNames.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public String wfRun(BigDecimal bigDecimal, String string, String string2, BigDecimal bigDecimal2, String string3, Timestamp timestamp, String string4) throws SQLException {
        Connection connection = null;
        String string5 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.\"ODMR_WORKFLOW\".WF_RUN(:2 ,:3 ,:4 ,:5 ,:6 ,:7 ,:8 ); END;");
            oracleCallableStatement.registerOutParameter(1, 12);
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(3, 12);
            } else {
                oracleCallableStatement.setString(3, string);
            }
            if (string2 == null) {
                oracleCallableStatement.setNull(4, 12);
            } else {
                oracleCallableStatement.setString(4, string2);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(5, 2);
            } else {
                oracleCallableStatement.setBigDecimal(5, bigDecimal2);
            }
            if (string3 == null) {
                oracleCallableStatement.setNull(6, 12);
            } else {
                oracleCallableStatement.setString(6, string3);
            }
            if (timestamp == null) {
                oracleCallableStatement.setNull(7, 93);
            } else {
                oracleCallableStatement.setTimestamp(7, timestamp);
            }
            if (string4 == null) {
                oracleCallableStatement.setNull(8, 12);
            } else {
                oracleCallableStatement.setString(8, string4);
            }
            oracleCallableStatement.executeUpdate();
            string5 = oracleCallableStatement.getString(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.\"ODMR_WORKFLOW\".WF_RUN(:2 ,:3 ,:4 ,:5 ,:6 ,:7 ,:8 ); END;");
                oracleCallableStatement.registerOutParameter(1, 12);
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(3, 12);
                } else {
                    oracleCallableStatement.setString(3, string);
                }
                if (string2 == null) {
                    oracleCallableStatement.setNull(4, 12);
                } else {
                    oracleCallableStatement.setString(4, string2);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(5, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(5, bigDecimal2);
                }
                if (string3 == null) {
                    oracleCallableStatement.setNull(6, 12);
                } else {
                    oracleCallableStatement.setString(6, string3);
                }
                if (timestamp == null) {
                    oracleCallableStatement.setNull(7, 93);
                } else {
                    oracleCallableStatement.setTimestamp(7, timestamp);
                }
                if (string4 == null) {
                    oracleCallableStatement.setNull(8, 12);
                } else {
                    oracleCallableStatement.setString(8, string4);
                }
                oracleCallableStatement.executeUpdate();
                string5 = oracleCallableStatement.getString(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return string5;
    }
}

