/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.dprofiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GenericTableFixedColumns;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.dmt.dataminer.controls.MiniHistogramCellRenderer;
import oracle.dmt.dataminer.dprofiler.DataProfilePanelSettings;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsModel;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsState;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTablePersistentSettings;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class DataProfileViewPanel
extends DataMinerViewGUI {
    private JLabel _jFilterLabel;
    private GenericTableFixedColumns _table;
    private JScrollPane jFilterScrollPane;
    private JPanel jGraphPanel;
    private JLabel jLabelGroupItem;
    private JLabel jLblGroupby;
    private JLabel jLblGroupbyValue;
    private JScrollPane jStatisticsScrollPane;
    private JSplitPane jStatsSplitPane;
    private int FIXED_COLUMNS = 2;
    private GraphPanel _graphPanel;
    private DataProfileStatisticsState _state;
    private SearchField _jFilterCtl = new SearchField();
    public static final int FILTER_SUMMARY_COLUMN_NAME = 0;
    public static final int FILTER_SUMMARY_COLUMN_DATA_TYPE = 1;
    public static final int FILTER_SUMMARY_COLUMN_MODE = 2;
    private int _currentSearchCategory = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_NAME"));
    private int[] _lastSelectedRowsRowsInModel;
    private boolean loadingDetailedGraph = false;
    private boolean _restoringPersistance = false;
    private static Preferences _p = Preferences.getPreferences();
    private DataProfilePanelSettings dataProfilePanelSettings = DataProfilePanelSettings.getInstance((PropertyStorage)_p);
    private GraphicalPreferencesSettings graphPanelSettings = GraphicalPreferencesSettings.getInstance((PropertyStorage)_p);

    public DataProfileViewPanel(Editor editor, Context context) throws Exception {
        super(editor, context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jFilterLabel = new JLabel();
        this.jFilterScrollPane = new JScrollPane();
        this.jLabelGroupItem = new JLabel();
        this.jStatsSplitPane = new JSplitPane();
        this.jStatisticsScrollPane = new JScrollPane();
        this._table = new CustomNiceTable();
        this.jGraphPanel = new JPanel();
        this.jLblGroupby = new JLabel();
        this.jLblGroupbyValue = new JLabel();
        this._jFilterLabel.setText("Filter:");
        this.jFilterScrollPane.setBorder(null);
        this.jLabelGroupItem.setText("jLabel1");
        this.jStatsSplitPane.setDividerLocation(152);
        this.jStatsSplitPane.setOrientation(0);
        this._table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jStatisticsScrollPane.setViewportView((Component)((Object)this._table));
        this.jStatsSplitPane.setTopComponent(this.jStatisticsScrollPane);
        this.jGraphPanel.setMinimumSize(new Dimension(100, 100));
        this.jGraphPanel.setLayout(new BorderLayout());
        this.jStatsSplitPane.setRightComponent(this.jGraphPanel);
        this.jLblGroupby.setText("Group by:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jLabelGroupItem, -1, 85, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLblGroupby, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLblGroupbyValue, -1, 108, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this._jFilterLabel, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFilterScrollPane, -2, 131, -2)).addComponent(this.jStatsSplitPane, -1, 488, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jFilterLabel).addComponent(this.jLabelGroupItem).addComponent(this.jLblGroupby)).addComponent(this.jFilterScrollPane, -2, 26, -2))).addGroup(groupLayout.createSequentialGroup().addGap(23, 23, 23).addComponent(this.jLblGroupbyValue, -2, 14, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jStatsSplitPane, -1, 309, Short.MAX_VALUE).addContainerGap()));
        groupLayout.linkSize(1, this.jLabelGroupItem, this.jLblGroupby);
    }

    @Override
    public void initRes() {
        this._jFilterLabel.setText(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FILTER_LABEL"));
        ResourceUtils.resLabel((JLabel)this._jFilterLabel, (Component)this._jFilterCtl, (String)DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FILTER_LABEL"));
        this._jFilterLabel.getAccessibleContext().setAccessibleName(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FILTER_LABEL"));
        this._jFilterLabel.getAccessibleContext().setAccessibleDescription(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FILTER_LABEL_ADA"));
        this.jLabelGroupItem.setText(DataProfileStatisticsLrb.get("DATA_PROFILE_TITLE"));
    }

    @Override
    public void initUI() {
        this._state = new DataProfileStatisticsState(this._context, this.graphPanelSettings);
        if (this._state.isGroupingBy()) {
            this.jLblGroupby.setText(DataProfileStatisticsLrb.get("GROUP_BY_LABEL"));
            this.jLblGroupbyValue.setText(StringUtils.trimDoubleQuotes(this._state.getGroupingAttributName()));
        }
        this.jLblGroupby.setVisible(this._state.isGroupingBy());
        this.jLblGroupbyValue.setVisible(this._state.isGroupingBy());
        this.jStatsSplitPane.setDividerLocation(600);
        this.setLoading(true);
        this.initializeControls();
        this.addListeners();
        this.graphPanelSettings.addStructureChangeListener(new CustomStructureChangeListener());
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    private void initializeControls() {
        this.setupTable(new DataProfileStatisticsModel(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_LOADING")));
        this._jFilterCtl.setStyle(SearchField.Style.FILTER);
        this._jFilterCtl.addCategory(this._defaultSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_DATA_TYPE")));
        this._jFilterCtl.addCategory(new SearchCategory(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_MODE")));
        this._jFilterCtl.setSelectedCategory(this._defaultSearchCategory);
        this.jFilterScrollPane.setViewportView((Component)this._jFilterCtl);
        this.enableControls(false);
    }

    private void setupTable(DataProfileStatisticsModel dataProfileStatisticsModel) {
        this._table.setFixedColumnCount(this.FIXED_COLUMNS);
        this._table.setModel((TableModel)((Object)dataProfileStatisticsModel));
        this._table.setSelectionMode(2);
        this._table.findOrCreateTableRowHeader(this.jStatisticsScrollPane);
        this._table.setColumnSelectorAvailable(true);
        this._table.setSorted(true);
        this._table.addDynamicCellRenderers();
        this._table.disallowSorting(DataProfileStatisticsModel._colNames.get(1));
        this._table.setCellRenderers();
        this._table.setColumnPreferredWidth(dataProfileStatisticsModel.getColumnName(0), 210);
        this._table.setColumnPreferredWidth(dataProfileStatisticsModel.getColumnName(2), 100);
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        tableColumnModel.getColumn(2 - this.FIXED_COLUMNS).setPreferredWidth(100);
        tableColumnModel.getColumn(3 - this.FIXED_COLUMNS).setPreferredWidth(100);
        tableColumnModel.getColumn(4 - this.FIXED_COLUMNS).setPreferredWidth(100);
        tableColumnModel.getColumn(5 - this.FIXED_COLUMNS).setPreferredWidth(100);
        tableColumnModel.getColumn(6 - this.FIXED_COLUMNS).setPreferredWidth(150);
        tableColumnModel.getColumn(7 - this.FIXED_COLUMNS).setPreferredWidth(90);
        tableColumnModel.getColumn(9 - this.FIXED_COLUMNS).setPreferredWidth(90);
        tableColumnModel.getColumn(10 - this.FIXED_COLUMNS).setPreferredWidth(90);
        tableColumnModel.getColumn(11 - this.FIXED_COLUMNS).setPreferredWidth(115);
        tableColumnModel.getColumn(12 - this.FIXED_COLUMNS).setPreferredWidth(100);
        tableColumnModel.getColumn(13 - this.FIXED_COLUMNS).setPreferredWidth(90);
        tableColumnModel.getColumn(14 - this.FIXED_COLUMNS).setPreferredWidth(90);
        this._table.setAutoResizeMode(0);
        this._table.getTableHeader().setReorderingAllowed(false);
        this._restoringPersistance = true;
        int[] nArray = this.dataProfilePanelSettings.getHiddenColumns();
        if (nArray != null && nArray.length > 0) {
            this._table.setHiddenColumns(nArray);
        }
        this._restoringPersistance = false;
    }

    private void setupMessageOnlyTable(LoadingTableModel loadingTableModel) {
        this._table.setFixedColumnCount(0);
        this._table.setModel((TableModel)((Object)loadingTableModel));
        this._table.findOrCreateTableRowHeader(this.jStatisticsScrollPane);
        this._table.setAutoResizeMode(4);
    }

    private void enableControls(boolean bl) {
    }

    private void addListeners() {
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                DataProfileViewPanel.this.translateSearchCategoryToConstant(DataProfileViewPanel.this._jFilterCtl.getSelectedCategory());
                DataProfileViewPanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                DataProfileViewPanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                DataProfileViewPanel.this.processFilter(string);
            }
        });
    }

    private void handleSelectionChanged(ListSelectionModel listSelectionModel) {
        if (listSelectionModel.getValueIsAdjusting()) {
            return;
        }
        boolean bl = false;
        if (!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
            bl = true;
        }
        if (bl) {
            int[] nArray = this._table.getSelectedRowsInModel();
            if (!this._state.isLoaded()) {
                this._lastSelectedRowsRowsInModel = nArray;
                return;
            }
            if (this.isLoadingDetailedGraph()) {
                return;
            }
            this.setLoadingDetailedGraph(true);
            LoadGraphPanel loadGraphPanel = new LoadGraphPanel(nArray[0]);
            loadGraphPanel.start();
        } else {
            this.jGraphPanel.removeAll();
            String string = DataProfileStatisticsLrb.get("DETAIL_HISTOGRAM_MULTIPLE_SELECT");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 2));
            JLabel jLabel = new JLabel(string);
            Font font = jLabel.getFont();
            Font font2 = font.deriveFont((float)font.getSize() * 2.0f);
            jLabel.setFont(font2);
            int n = this.jGraphPanel.getGraphics().getFontMetrics(font2).stringWidth(string);
            Dimension dimension = this.jGraphPanel.getSize();
            jPanel.add(Box.createHorizontalStrut((dimension.width - n) / 2));
            jPanel.add(jLabel);
            this.jGraphPanel.add(jPanel);
            this.jGraphPanel.updateUI();
        }
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = -1;
        if (searchCategory.getLabel().equals(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_NAME"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_DATA_TYPE"))) {
            this._currentSearchCategory = 1;
        } else if (searchCategory.getLabel().equals(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_MODE"))) {
            this._currentSearchCategory = 2;
        } else assert (false) : "Invalid Search Category Code";
        return n;
    }

    private void processFilter(String string) {
        try {
            DataProfileStatisticsModel dataProfileStatisticsModel = this._state.getFilteredStatistics(string, this._currentSearchCategory);
            this.setupTable(dataProfileStatisticsModel);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_TITLE"), (String)DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_MESG"), null);
        }
    }

    private void updateDetailesGraph() {
        this._graphPanel = new GraphPanel(this._state.getDefaultGraphDataModel());
        this._state.getDefaultGraphDataModel().setDepthRadius(this._state.getDepthRadius());
        this._graphPanel.initGraph();
        this._state.getDefaultGraphDataModel().setStyleSelection(this._state.getStyleSelection());
        this._graphPanel.updateGraphStyle();
        this.jGraphPanel.removeAll();
        this.jGraphPanel.add((Component)this._graphPanel, "Center");
        this.jGraphPanel.updateUI();
    }

    private void setDepthRadius(int n) {
        this._state.setDepthRadius(n);
        this._graphPanel.setDepthRadius();
        this.updateDetailesGraph();
        this.validate();
        this.repaint();
    }

    private void changeStyle(String string) {
        this._state.setStyleSelection(string);
        this._graphPanel.updateGraphStyle();
        this._table.updateUI();
        this.updateDetailesGraph();
        this.validate();
        this.repaint();
    }

    boolean isHistogramVisible() {
        int[] nArray = this._table.getSelectedRowsInModel();
        return nArray != null && nArray.length != 0;
    }

    public void close() {
        this._state.close();
    }

    public void setLoadingDetailedGraph(boolean bl) {
        this.loadingDetailedGraph = bl;
    }

    public boolean isLoadingDetailedGraph() {
        return this.loadingDetailedGraph;
    }

    private String formatCellValue(Object object, FormatType formatType) {
        String string = "";
        if (object == null) {
            string = null;
        } else if (object != null) {
            string = object instanceof Double ? (formatType == FormatType.PERCENTAGE ? NumericFormat.format((Double)object, true, this.dataProfilePanelSettings.getPercentagePrecisionLevel()) + "" : NumericFormat.format((Double)object, true, this.dataProfilePanelSettings.getNumericalPrecisionLevel()) + "") : object.toString();
        }
        return string;
    }

    public class LoadingTableModel
    extends GenericBaseTableModel {
        private Vector<String> _data = new Vector();
        public static final int _COLUMN_NAME = 0;

        public LoadingTableModel(String string) {
            Vector<String> vector = new Vector<String>();
            vector.add(" ");
            this.setColumnIdentifiers(vector);
            String string2 = string;
            this._data.add(string2);
            this.setRowCount(this._data.size());
            this.setColumnCount(vector.size());
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            String string = this._data.get(n);
            String string2 = null;
            switch (n2) {
                case 0: {
                    string2 = string;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds";
                    break;
                }
            }
            return string2 != null ? string2 : "";
        }
    }

    private class LoadGraphPanel
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        GraphDataModel localGraphModel = null;
        int _selectedRowsInModel;

        public LoadGraphPanel(int n) {
            this._selectedRowsInModel = n;
        }

        public Object construct() {
            try {
                DataProfileStatisticsModel dataProfileStatisticsModel = (DataProfileStatisticsModel)((Object)DataProfileViewPanel.this._table.getBaseModel());
                Vector<DataProfileStatisticsData> vector = dataProfileStatisticsModel.getDataVector();
                DataProfileStatisticsData dataProfileStatisticsData = vector.get(this._selectedRowsInModel);
                String string = dataProfileStatisticsData.getName();
                this.localGraphModel = DataProfileViewPanel.this._state.createDetailedGraphModel(string);
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
                exception.printStackTrace();
            }
            return DataProfileViewPanel.this._state;
        }

        public void finished() {
            if (this._success && this._ex == null) {
                DataProfileViewPanel.this._graphPanel = new GraphPanel(this.localGraphModel);
                this.localGraphModel.setDepthRadius(DataProfileViewPanel.this._state.getDepthRadius());
                DataProfileViewPanel.this._graphPanel.initGraph();
                this.localGraphModel.setStyleSelection(DataProfileViewPanel.this._state.getStyleSelection());
                DataProfileViewPanel.this._graphPanel.updateGraphStyle();
                DataProfileViewPanel.this.jGraphPanel.removeAll();
                DataProfileViewPanel.this.jGraphPanel.add((Component)DataProfileViewPanel.this._graphPanel, "Center");
                DataProfileViewPanel.this.jGraphPanel.updateUI();
            }
            DataProfileViewPanel.this.setLoadingDetailedGraph(false);
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        public Object construct() {
            try {
                if (this._reload) {
                    DataProfileViewPanel.this._state.load();
                } else {
                    DataProfileViewPanel.this._state.load();
                }
                this._success = DataProfileViewPanel.this._state.isLoaded();
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return DataProfileViewPanel.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    if (DataProfileViewPanel.this._jFilterCtl.getText().trim().length() > 0) {
                        DataProfileViewPanel.this.setupTable(DataProfileViewPanel.this._state.getFilteredStatistics(DataProfileViewPanel.this._jFilterCtl.getText(), DataProfileViewPanel.this._currentSearchCategory));
                    } else {
                        DataProfileViewPanel.this.setupTable(DataProfileViewPanel.this._state.getTableModel());
                    }
                    DataProfileStatisticsModel dataProfileStatisticsModel = (DataProfileStatisticsModel)((Object)DataProfileViewPanel.this._table.getBaseModel());
                    Vector<DataProfileStatisticsData> vector = dataProfileStatisticsModel.getDataVector();
                    Vector<String> vector2 = new Vector<String>(vector.size());
                    vector2.add(DataProfileStatisticsState._NONE_ATTRIBUTE);
                    for (DataProfileStatisticsData dataProfileStatisticsData : vector) {
                        String string = dataProfileStatisticsData.getName();
                        if (!DataProfileViewPanel.this._state.isValidAttribute(string)) continue;
                        vector2.add(string);
                    }
                    DataProfileViewPanel.this.enableControls(true);
                    if (DataProfileViewPanel.this._table.getRowCount() > 0) {
                        DataProfileViewPanel.this._table.setSelectedRowsInModel(new int[]{0});
                    }
                    if (DataProfileViewPanel.this._state.isGroupingBy()) {
                        DataProfileViewPanel.this.jLblGroupby.setText(DataProfileStatisticsLrb.get("GROUP_BY_LABEL"));
                        DataProfileViewPanel.this.jLblGroupbyValue.setText(StringUtils.trimDoubleQuotes(DataProfileViewPanel.this._state.getGroupingAttributName()));
                    }
                    DataProfileViewPanel.this.jLblGroupby.setVisible(DataProfileViewPanel.this._state.isGroupingBy());
                    DataProfileViewPanel.this.jLblGroupbyValue.setVisible(DataProfileViewPanel.this._state.isGroupingBy());
                    DataProfileViewPanel.this.setLoaded(true);
                } else {
                    DataProfileViewPanel.this.setupMessageOnlyTable(new LoadingTableModel(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_MESG_TRY_RERUN")));
                    if (DataProfileViewPanel.this._state.getTableModel() != null) {
                        DataProfileViewPanel.this._state.getTableModel().setFailedStatus();
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_TITLE"), (String)DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_MESG_TRY_RERUN"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), null, (String)DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_TITLE"), (String)DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_MESG"));
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_TITLE"), (String)DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_MESG"), null);
            }
            finally {
                DataProfileViewPanel.this.setLoading(false);
            }
        }
    }

    private class CustomRenderer
    extends DefaultTableCellRenderer {
        FormatType formatType;

        public CustomRenderer(FormatType formatType) {
            this.formatType = formatType;
        }

        public CustomRenderer() {
            this.formatType = FormatType.NUMERICAL;
        }

        @Override
        public void setValue(Object object) {
            if (object != null) {
                String string = null;
                if (object instanceof Double) {
                    string = this.formatType == FormatType.PERCENTAGE ? NumericFormat.format((Double)object, true, DataProfileViewPanel.this.dataProfilePanelSettings.getPercentagePrecisionLevel()) + "" : NumericFormat.format((Double)object, true, DataProfileViewPanel.this.dataProfilePanelSettings.getNumericalPrecisionLevel()) + "";
                } else if (object instanceof Integer) {
                    string = NumericFormat.format((Integer)object, true, 8) + "";
                } else if (object instanceof String) {
                    String string2 = (String)object;
                    try {
                        Double d = Double.valueOf(string2.trim());
                        string = NumericFormat.format(d, true, DataProfileViewPanel.this.dataProfilePanelSettings.getNumericalPrecisionLevel()) + "";
                    }
                    catch (NumberFormatException numberFormatException) {
                        string = string2;
                    }
                }
                super.setValue(string);
            }
        }
    }

    private static enum FormatType {
        PERCENTAGE,
        NUMERICAL;

    }

    class CustomNiceTable
    extends GenericTableFixedColumns {
        CustomNiceTable() {
            this.adjustRowHeight((int)MiniHistogramCellRenderer._DEFAULT_PREFFERRED_WIDTH.getHeight());
            this.addCellRenderer(DataProfileStatisticsModel._colNames.get(0), new CustomRenderer());
            this.addCellRenderer(DataProfileStatisticsModel._colNames.get(2), new CustomRenderer());
            this.addCellRenderer(DataProfileStatisticsModel._colNames.get(3), new CustomRenderer(FormatType.PERCENTAGE));
            this.addCellRenderer(DataProfileStatisticsModel._colNames.get(4), new CustomRenderer());
            this.addCellRenderer(DataProfileStatisticsModel._colNames.get(5), new CustomRenderer(FormatType.PERCENTAGE));
            this.addCellRenderer(DataProfileStatisticsModel._colNames.get(6), new CustomRenderer());
            this.addCellRenderer(DataProfileStatisticsModel._colNames.get(7), new CustomRenderer());
            this.addCellRenderer(DataProfileStatisticsModel._colNames.get(9), new CustomRenderer());
            this.addCellRenderer(DataProfileStatisticsModel._colNames.get(10), new CustomRenderer());
            this.addCellRenderer(DataProfileStatisticsModel._colNames.get(11), new CustomRenderer());
            this.addCellRenderer(DataProfileStatisticsModel._colNames.get(12), new CustomRenderer());
            this.addCellRenderer(DataProfileStatisticsModel._colNames.get(13), new CustomRenderer());
            this.addCellRenderer(DataProfileStatisticsModel._colNames.get(14), new CustomRenderer());
        }

        protected void setColumnVisible(TableColumn tableColumn, int n, boolean bl) {
            GenericTablePersistentSettings genericTablePersistentSettings;
            super.setColumnVisible(tableColumn, n, bl);
            if (!DataProfileViewPanel.this._restoringPersistance && (genericTablePersistentSettings = this.getPersistentSettings()) != null) {
                DataProfileViewPanel.this.dataProfilePanelSettings.setHiddenColumns(genericTablePersistentSettings.getHiddenColumns());
            }
        }

        @Override
        protected void handleSelectionChanged(ListSelectionModel listSelectionModel) {
            DataProfileViewPanel.this.handleSelectionChanged(listSelectionModel);
        }

        @Override
        public void addDynamicCellRenderers() {
            this.addCellRenderer(DataProfileStatisticsModel._colNames.get(1), new MiniHistogramCellRenderer(DataProfileViewPanel.this._state));
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof DefaultGraphDataModel) {
                String string = ((DefaultGraphDataModel)object).getComment();
                return string;
            }
            if (object instanceof Double) {
                FormatType formatType = null;
                formatType = n2 == 3 || n2 == 5 ? FormatType.PERCENTAGE : FormatType.NUMERICAL;
                return DataProfileViewPanel.this.formatCellValue(object, formatType);
            }
            return super.convertValueToText(object, bl, bl2, n, n2);
        }

        @Override
        protected String customToolTipConverter(Object object, int n, int n2) {
            if (object instanceof Double) {
                FormatType formatType = null;
                formatType = n2 == 3 || n2 == 5 ? FormatType.PERCENTAGE : FormatType.NUMERICAL;
                return DataProfileViewPanel.this.formatCellValue(object, formatType);
            }
            if (object instanceof DefaultGraphDataModel) {
                String string = ((DefaultGraphDataModel)object).getComment();
                return string;
            }
            return object.toString();
        }
    }

    class CustomStructureChangeListener
    extends StructureChangeListener {
        CustomStructureChangeListener() {
        }

        public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
            ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
            if (changeInfoArray == null || changeInfoArray.length == 0) {
                return;
            }
            for (int i = 0; i < changeInfoArray.length; ++i) {
                String string = changeInfoArray[i].getPropertyName();
                if (string.equals("histogram_graph_style")) {
                    DataProfileViewPanel.this.changeStyle(changeInfoArray[i].getNewValueAsString());
                    continue;
                }
                if (!string.equals("radius_depth")) continue;
                DataProfileViewPanel.this.setDepthRadius(changeInfoArray[i].getNewValueAsInt());
            }
        }
    }
}

