/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.dprofiler;

import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsModel;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.DataProfilePhysicalNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ConverterHelper;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.jdbc.OracleResultSet;
import oracle.sql.TIMESTAMPTZ;

public class DataProfileStatisticsState
implements GraphModelProvider {
    private boolean _loaded;
    private Context _context;
    private DataProfilePhysicalNode _profileNode;
    private DataProfileStatisticsModel _tableModel;
    private GraphDataModel _graphDataModel;
    private String styleSelection = DefaultGraphDataModel.DEFAULT_GRAPH_STYLE;
    private int depthRadius = _DEPTH_RADIUS;
    private static int _DEPTH_RADIUS = 50;
    public static final Color _BASE_CHART_COLOR = new Color(255, 255, 153);
    static String _NONE_ATTRIBUTE = DataProfileStatisticsLrb.get("ATTRIBUTE_NONE");
    private static int _LEGEND_SERIES_COUNT = 20;
    private static Color[] _RESERVED_COLORS = new Color[]{Color.yellow, Color.red, Color.green, Color.blue, Color.cyan, Color.magenta, Color.orange, Color.pink, Color.black, Color.gray};
    private static Color[][] _EXTRA_COLORS = new Color[][]{{new Color(255, 226, 122), new Color(255, 122, 122), new Color(122, 255, 122), new Color(122, 122, 255), new Color(122, 255, 255), new Color(255, 122, 255), new Color(255, 226, 122), new Color(255, 51, 51), new Color(51, 26, 0), Color.lightGray}, {new Color(255, 213, 61), new Color(255, 61, 61), new Color(61, 255, 61), new Color(61, 61, 255), new Color(61, 255, 255), new Color(255, 61, 255), new Color(255, 213, 61), new Color(255, 112, 112), new Color(112, 112, 0), Color.darkGray}};
    private String groupingAttributName = _NO_GROUPING;
    private static String ATTR = "ATTR";
    private static String DATA_TYPE = "DATA_TYPE";
    private static String NULL_PERCENT = "NULL_PERCENT";
    private static String DISTINCT_CNT = "DISTINCT_CNT";
    private static String DISTINCT_PERCENT = "DISTINCT_PERCENT";
    private static String MODE_VALUE = "MODE_VALUE";
    private static String AVG = "AVG";
    private static String AVG_DATE = "AVG_DATE";
    private static String AVG_TS_TZ = "AVG_TS_TZ";
    private static String MEDIAN_VAL = "MEDIAN_VAL";
    private static String MEDIAN_DATE = "MEDIAN_DATE";
    private static String MEDIAN_TS_TZ = "MEDIAN_TS_TZ";
    private static String MIN = "MIN";
    private static String MAX = "MAX";
    private static String STD = "STD";
    private static String VAR = "VAR";
    private static String SKEWNESS = "SKEWNESS";
    private static String KURTOSIS = "KURTOSIS";
    private static String ATTRIBUTE_VALUE = "ATTRIBUTE_VALUE";
    private static String GROUPING_ATTRIBUTE_VALUE = "GROUPING_ATTRIBUTE_VALUE";
    private static String ATTRIBUTE_PERCENT = "ATTRIBUTE_PERCENT";
    private static String GROUPING_ATTRIBUTE_NAME = "GROUPING_ATTRIBUTE_NAME";
    private static String _comma = ", ";
    private static String _NO_GROUPING = "_NO_GROUPING";
    private static StringBuffer _listBuffer = new StringBuffer();
    private String _attr_list_token = "<attribute_list>";
    private String _table_name_token = "<table_name>";
    private static String _QUERY;
    private HashMap<String, AttributeHistogramArray> histograms = new HashMap();
    private HashMap<String, DataProfileStatisticsData> dataPoints = new HashMap();

    public String getGroupingAttributName() {
        return this.groupingAttributName;
    }

    public boolean isGroupingBy() {
        return !this.groupingAttributName.equals(_NO_GROUPING);
    }

    public void setStyleSelection(String string) {
        this.styleSelection = string;
    }

    public void setDepthRadius(int n) {
        this.depthRadius = n;
    }

    public DataProfileStatisticsState(Context context, GraphicalPreferencesSettings graphicalPreferencesSettings) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
        this.styleSelection = graphicalPreferencesSettings.getGraphStyle();
        this.depthRadius = graphicalPreferencesSettings.getRadiusDepthValue();
        Node node = this._context.getNode();
        assert (node != null);
        assert (node instanceof DataProfilePhysicalNode);
        this._profileNode = (DataProfilePhysicalNode)node;
        this.initGraphModel();
    }

    private void initGraphModel() {
        this._graphDataModel = new DefaultGraphDataModel(null, 18, null, null, null);
        this._graphDataModel.setX1(DataProfileStatisticsLrb.get("HISTOGRAM_X_AXIS"), null);
        this._graphDataModel.setY1(DataProfileStatisticsLrb.get("HISTOGRAM_Y_AXIS"), 100.0);
    }

    public GraphDataModel getDefaultGraphDataModel() {
        return this._graphDataModel;
    }

    public String getStatisticalTable() {
        return this._profileNode.getStatsTableName();
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void close() {
    }

    public void load() throws Exception {
        String string = this._profileNode.getStatsTableName();
        if (string == null) {
            this._loaded = false;
            return;
        }
        this._tableModel = new DataProfileStatisticsModel(this.loadStatistics(string));
        if (this.groupingAttributName.equals(_NO_GROUPING)) {
            this.createAllGraphDataModelsTotalPopulation();
        } else {
            this.createAllGraphDataModelsGroupBy(this.groupingAttributName);
        }
        this._loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataProfileStatisticsData> loadStatistics(String string) throws Exception {
        List<DataProfileStatisticsData> list = null;
        String string2 = null;
        Connection connection = null;
        Statement statement = null;
        OracleResultSet oracleResultSet = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            string2 = StringUtils.getReplacedString(_QUERY, this._attr_list_token, _listBuffer.toString());
            string2 = StringUtils.getReplacedString(string2, this._table_name_token, string);
            statement = connection.prepareStatement(string2);
            oracleResultSet = (OracleResultSet)statement.executeQuery();
            while (oracleResultSet.next()) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Cloneable cloneable;
                Object object5;
                Timestamp timestamp;
                Object object6;
                String string3 = oracleResultSet.getString(ATTR);
                String string4 = oracleResultSet.getString(DATA_TYPE);
                Object object7 = oracleResultSet.getObject(NULL_PERCENT);
                Object object8 = oracleResultSet.getObject(DISTINCT_CNT);
                Object object9 = oracleResultSet.getObject(DISTINCT_PERCENT);
                String string5 = oracleResultSet.getString(MODE_VALUE);
                Object object10 = oracleResultSet.getObject(AVG);
                Timestamp timestamp2 = oracleResultSet.getTimestamp(AVG_DATE);
                TIMESTAMPTZ tIMESTAMPTZ = oracleResultSet.getTIMESTAMPTZ(AVG_TS_TZ);
                GregorianCalendar gregorianCalendar = null;
                if (tIMESTAMPTZ != null) {
                    object6 = tIMESTAMPTZ.toBytes();
                    timestamp = tIMESTAMPTZ.timestampValue(connection);
                    gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(timestamp);
                    object5 = TimeUtils.GMT + TimeUtils.getRegionName(object6);
                    cloneable = TimeUtils.toTimeZoneFromZoneId((String)object5);
                    gregorianCalendar.setTimeZone((TimeZone)cloneable);
                }
                object6 = oracleResultSet.getObject(MEDIAN_VAL);
                timestamp = oracleResultSet.getTimestamp(MEDIAN_DATE);
                object5 = oracleResultSet.getTIMESTAMPTZ(MEDIAN_TS_TZ);
                cloneable = null;
                if (object5 != null) {
                    object4 = object5.toBytes();
                    object3 = object5.timestampValue(connection);
                    cloneable = new GregorianCalendar();
                    ((Calendar)cloneable).setTime((Date)object3);
                    object2 = TimeUtils.GMT + TimeUtils.getRegionName(object4);
                    object = TimeUtils.toTimeZoneFromZoneId((String)object2);
                    ((GregorianCalendar)cloneable).setTimeZone((TimeZone)object);
                }
                object4 = oracleResultSet.getString(MIN);
                object3 = oracleResultSet.getString(MAX);
                object2 = oracleResultSet.getObject(STD);
                object = oracleResultSet.getObject(VAR);
                Object object11 = oracleResultSet.getObject(SKEWNESS);
                Object object12 = oracleResultSet.getObject(KURTOSIS);
                Object object13 = oracleResultSet.getObject(ATTRIBUTE_VALUE);
                this.groupingAttributName = oracleResultSet.getString(GROUPING_ATTRIBUTE_NAME);
                if (this.groupingAttributName == null) {
                    this.groupingAttributName = _NO_GROUPING;
                }
                String string6 = oracleResultSet.getString(GROUPING_ATTRIBUTE_VALUE);
                Double d = oracleResultSet.getDouble(ATTRIBUTE_PERCENT);
                Double d2 = object7 == null ? null : new Double(((BigDecimal)object7).doubleValue());
                Integer n = object8 == null ? null : new Integer(((BigDecimal)object8).intValue());
                Double d3 = object9 == null ? null : new Double(((BigDecimal)object9).doubleValue());
                Double d4 = object10 == null ? null : new Double(((BigDecimal)object10).doubleValue());
                Date date = null;
                if (timestamp2 != null) {
                    if (DatabaseMetadataUtils.isTimestamp(string4)) {
                        date = new Timestamp(timestamp2.getTime());
                    } else if (string4.equals("DATE")) {
                        date = new Date(timestamp2.getTime());
                    }
                }
                Double d5 = object6 == null ? null : new Double(((BigDecimal)object6).doubleValue());
                Date date2 = null;
                if (timestamp != null) {
                    if (DatabaseMetadataUtils.isTimestamp(string4)) {
                        date2 = new Timestamp(timestamp.getTime());
                    } else if (string4.equals("DATE")) {
                        date2 = new Date(timestamp.getTime());
                    }
                }
                Comparable<Double> comparable = null;
                if (d4 != null) {
                    comparable = d4;
                } else if (date != null) {
                    comparable = date;
                } else if (gregorianCalendar != null) {
                    comparable = gregorianCalendar;
                }
                Object object14 = null;
                if (d5 != null) {
                    object14 = d5;
                } else if (date2 != null) {
                    object14 = date2;
                } else if (cloneable != null) {
                    object14 = cloneable;
                }
                Double d6 = object2 == null ? null : new Double(((BigDecimal)object2).doubleValue());
                Double d7 = object == null ? null : new Double(((BigDecimal)object).doubleValue());
                Double d8 = object11 == null ? null : new Double(((BigDecimal)object11).doubleValue());
                Double d9 = object12 == null ? null : new Double(((BigDecimal)object12).doubleValue());
                this.addPoint(string3, string4, d2, n, d3, string5, comparable, object14, (String)object4, (String)object3, d6, d7, d8, d9, object13, string6, d);
            }
            list = this.getPoints();
        }
        finally {
            try {
                oracleResultSet.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
        return list;
    }

    public DataProfileStatisticsModel getFilteredStatistics(String string, int n) throws Exception {
        return this._tableModel.getFilteredStatistics(string, n);
    }

    public DataProfileStatisticsModel getTableModel() {
        return this._tableModel;
    }

    @Override
    public GraphDataModel getGraphDataModel(int n) {
        if (this._tableModel == null) {
            return null;
        }
        Vector<DataProfileStatisticsData> vector = this._tableModel.getDataVector();
        DataProfileStatisticsData dataProfileStatisticsData = vector.get(n);
        GraphDataModel graphDataModel = dataProfileStatisticsData.getGraphDataModel();
        return graphDataModel;
    }

    @Override
    public String getStyleSelection() {
        return this.styleSelection;
    }

    public boolean isValidAttribute(String string) {
        return true;
    }

    public int getDepthRadius() {
        return this.depthRadius;
    }

    public GraphDataModel createDetailedGraphModel(String string) {
        this._graphDataModel = this.groupingAttributName == null || this.groupingAttributName.equals(_NO_GROUPING) || string.equals(this.groupingAttributName) ? this.createGraphDataModelTotalPopulation(string) : this.createGraphDataModelGroupBy(this.groupingAttributName, string);
        return this._graphDataModel;
    }

    private void createAllGraphDataModelsTotalPopulation() {
        Vector<DataProfileStatisticsData> vector = this._tableModel.getDataVector();
        for (DataProfileStatisticsData dataProfileStatisticsData : vector) {
            String string = dataProfileStatisticsData.getName();
            GraphDataModel graphDataModel = this.createGraphDataModelTotalPopulationGeneric(null, string);
            graphDataModel.setTitle(null);
            graphDataModel.setLegendVisible(false);
            graphDataModel.setDepthRadius(0);
            graphDataModel.setLineDataLineDisplayed(false);
            dataProfileStatisticsData.setGraphDataModel(graphDataModel);
        }
    }

    GraphDataModel createGraphDataModelTotalPopulation(String string) {
        this.createGraphDataModelTotalPopulationGeneric(this._graphDataModel, string);
        return this._graphDataModel;
    }

    GraphDataModel createGraphDataModelGroupBy(String string, String string2) {
        return this.createGraphDataModelGroupByGeneric(this._graphDataModel, string, string2);
    }

    GraphDataModel createGraphDataModelTotalPopulationGeneric(GraphDataModel graphDataModel, String string) {
        boolean bl;
        if (graphDataModel == null) {
            graphDataModel = new DefaultGraphDataModel(null, 18, null, null, null);
            bl = false;
        } else {
            graphDataModel.clear();
            bl = true;
        }
        AttributeHistogramArray attributeHistogramArray = this.getHistogram(string);
        if (attributeHistogramArray == null || attributeHistogramArray.isEmpty()) {
            return graphDataModel;
        }
        ArrayList<String> arrayList = attributeHistogramArray.getBarTitles();
        if (arrayList == null || arrayList.isEmpty()) {
            return graphDataModel;
        }
        int n = arrayList.size();
        int n2 = 1;
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray3[i] = bl ? DataProfileStatisticsLrb.get("HISTOGRAM_Y_AXIS") : "";
            for (int j = 0; j < n; ++j) {
                String string2 = arrayList.get(j);
                ArrayList<NameValuePair> arrayList2 = attributeHistogramArray.getBarArray(string2.toString());
                NameValuePair nameValuePair = arrayList2.get(0);
                Object object = nameValuePair.getValue();
                assert (object instanceof Double) : "Wrong data for this graph";
                objectArray[j][i] = nameValuePair.getValue();
                objectArray2[j] = bl ? string2 : "";
            }
        }
        graphDataModel.addColumnLabels(objectArray2);
        graphDataModel.addRowLabels(objectArray3);
        graphDataModel.addRowColors(new Color[]{_BASE_CHART_COLOR});
        graphDataModel.addGraphData(objectArray);
        if (bl) {
            graphDataModel.setTitle(string);
            graphDataModel.setDepthRadius(this.depthRadius);
        }
        graphDataModel.setLegendVisible(false);
        return graphDataModel;
    }

    private void createAllGraphDataModelsGroupBy(String string) {
        Vector<DataProfileStatisticsData> vector = this._tableModel.getDataVector();
        for (DataProfileStatisticsData dataProfileStatisticsData : vector) {
            String string2 = dataProfileStatisticsData.getName();
            GraphDataModel graphDataModel = string2.equals(string) ? this.createGraphDataModelTotalPopulationGeneric(null, string2) : this.createGraphDataModelGroupByGeneric(null, string, string2);
            graphDataModel.setTitle(null);
            graphDataModel.setLegendVisible(false);
            graphDataModel.setDepthRadius(0);
            graphDataModel.setLineDataLineDisplayed(false);
            dataProfileStatisticsData.setGraphDataModel(graphDataModel);
        }
    }

    GraphDataModel createGraphDataModelGroupByGeneric(GraphDataModel graphDataModel, String string, String string2) {
        int n;
        boolean bl;
        if (graphDataModel == null) {
            graphDataModel = new DefaultGraphDataModel(null, 18, null, null, null);
            bl = false;
        } else {
            graphDataModel.clear();
            bl = true;
        }
        AttributeHistogramArray attributeHistogramArray = this.getHistogram(string2);
        if (attributeHistogramArray == null || attributeHistogramArray.isEmpty()) {
            return graphDataModel;
        }
        ArrayList<String> arrayList = attributeHistogramArray.getBarTitles();
        int n2 = arrayList.size();
        AttributeHistogramArray attributeHistogramArray2 = this.getHistogram(string);
        ArrayList<String> arrayList2 = null;
        arrayList2 = attributeHistogramArray2 == null || attributeHistogramArray2.isEmpty() ? attributeHistogramArray.getGroupingBarTitles() : attributeHistogramArray2.getBarTitles();
        int n3 = arrayList2.size();
        Object[][] objectArray = new Object[n2][n3];
        Object[] objectArray2 = new Object[n2];
        Object[] objectArray3 = new String[n3];
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                objectArray[n][i] = 0.0;
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            String string3 = arrayList.get(n);
            objectArray2[n] = bl ? string3 : "";
            ArrayList<NameValuePair> arrayList3 = attributeHistogramArray.getBarArray(string3.toString());
            for (int i = 0; i < arrayList3.size(); ++i) {
                NameValuePair nameValuePair = arrayList3.get(i);
                int n4 = arrayList2.indexOf("'" + nameValuePair.getName() + "'");
                if (n4 == -1) {
                    n4 = arrayList2.indexOf(nameValuePair.getName());
                }
                if (n4 == -1) continue;
                objectArray[n][n4] = nameValuePair.getValue();
            }
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            objectArray3[n] = bl ? arrayList2.get(n).toString() : "";
        }
        Color[] colorArray = this.generateColors(objectArray3.length);
        graphDataModel.addColumnLabels(objectArray2);
        graphDataModel.addRowLabels(objectArray3);
        graphDataModel.addRowColors(colorArray);
        graphDataModel.addGraphData(objectArray);
        if (bl) {
            graphDataModel.setTitle(StringUtils.trimDoubleQuotes(string2) + " " + DataProfileStatisticsLrb.get("TITLE_HISTOGRAM_BY") + " " + StringUtils.trimDoubleQuotes(string));
            graphDataModel.setLegendVisible(true);
            graphDataModel.setLegendSeriesCount(_LEGEND_SERIES_COUNT);
            graphDataModel.setDepthRadius(this.depthRadius);
        }
        return graphDataModel;
    }

    public void clear() {
        if (this.histograms != null) {
            this.histograms.clear();
        }
        if (this.dataPoints != null) {
            this.dataPoints.clear();
        }
    }

    public DataProfileStatisticsData getDataPoint(String string) {
        if (null == this.dataPoints) {
            return null;
        }
        return this.dataPoints.get(string);
    }

    public List<DataProfileStatisticsData> getPoints() {
        if (null == this.dataPoints) {
            return null;
        }
        ArrayList<DataProfileStatisticsData> arrayList = new ArrayList<DataProfileStatisticsData>();
        arrayList.addAll(this.dataPoints.values());
        return arrayList;
    }

    public void addPoint(String string, String string2, Double d, Integer n, Double d2, String string3, Object object, Object object2, String string4, String string5, Double d3, Double d4, Double d5, Double d6, Object object3, String string6, Double d7) {
        AttributeHistogramArray attributeHistogramArray;
        if (null == this.dataPoints.get(string)) {
            this.dataPoints.put(string, new DataProfileStatisticsData(string, string2, d, n, d2, string3, object, object2, string4, string5, d3, d4, d5, d6));
        }
        if ((attributeHistogramArray = this.histograms.get(string)) == null) {
            attributeHistogramArray = new AttributeHistogramArray();
            this.histograms.put(string, attributeHistogramArray);
        }
        if (string6 == null) {
            string6 = _NO_GROUPING;
        }
        attributeHistogramArray.addPoint(object3, string6, d7);
    }

    AttributeHistogramArray getHistogram(String string) {
        if (this.histograms == null) {
            return null;
        }
        return this.histograms.get(string);
    }

    private Color[] generateColors(int n) {
        int n2 = _RESERVED_COLORS.length + _EXTRA_COLORS[0].length * 2;
        if (n > n2) {
            return this.generateRandomColors(n);
        }
        Color[] colorArray = new Color[n];
        if (n <= _RESERVED_COLORS.length) {
            System.arraycopy(_RESERVED_COLORS, 0, colorArray, 0, n);
            return colorArray;
        }
        System.arraycopy(_RESERVED_COLORS, 0, colorArray, 0, _RESERVED_COLORS.length);
        int n3 = _RESERVED_COLORS.length;
        int n4 = n - n3;
        if (n4 < _EXTRA_COLORS[0].length) {
            System.arraycopy(_EXTRA_COLORS[0], 0, colorArray, n3, n4);
            return colorArray;
        }
        System.arraycopy(_EXTRA_COLORS[0], 0, colorArray, n3, _EXTRA_COLORS[0].length);
        n4 = n - (n3 += _EXTRA_COLORS[0].length);
        System.arraycopy(_EXTRA_COLORS[1], 0, colorArray, n3, n4);
        return colorArray;
    }

    private Color[] generateRandomColors(int n) {
        Color[] colorArray = new Color[n];
        int n2 = 2;
        while (!(Math.pow(++n2, 3.0) >= (double)n)) {
        }
        int n3 = 255 / n2;
        int n4 = 0;
        block1: for (int i = 255; i >= 0; i -= n3) {
            for (int j = 0; j <= 255; j += n3) {
                for (int k = 255; k >= 0; k -= n3) {
                    colorArray[n4++] = new Color(i, j, k);
                    if (n4 == n - 1) break block1;
                }
            }
        }
        return colorArray;
    }

    static {
        _listBuffer.append(ATTR);
        _listBuffer.append(_comma);
        _listBuffer.append(DATA_TYPE);
        _listBuffer.append(_comma);
        _listBuffer.append(NULL_PERCENT);
        _listBuffer.append(_comma);
        _listBuffer.append(DISTINCT_CNT);
        _listBuffer.append(_comma);
        _listBuffer.append(DISTINCT_PERCENT);
        _listBuffer.append(_comma);
        _listBuffer.append(MODE_VALUE);
        _listBuffer.append(_comma);
        _listBuffer.append(AVG);
        _listBuffer.append(_comma);
        _listBuffer.append(AVG_DATE);
        _listBuffer.append(_comma);
        _listBuffer.append(AVG_TS_TZ);
        _listBuffer.append(_comma);
        _listBuffer.append(MEDIAN_VAL);
        _listBuffer.append(_comma);
        _listBuffer.append(MEDIAN_DATE);
        _listBuffer.append(_comma);
        _listBuffer.append(MEDIAN_TS_TZ);
        _listBuffer.append(_comma);
        _listBuffer.append(MIN);
        _listBuffer.append(_comma);
        _listBuffer.append(MAX);
        _listBuffer.append(_comma);
        _listBuffer.append(STD);
        _listBuffer.append(_comma);
        _listBuffer.append(VAR);
        _listBuffer.append(_comma);
        _listBuffer.append(SKEWNESS);
        _listBuffer.append(_comma);
        _listBuffer.append(KURTOSIS);
        _listBuffer.append(_comma);
        _listBuffer.append(ATTRIBUTE_VALUE);
        _listBuffer.append(_comma);
        _listBuffer.append(GROUPING_ATTRIBUTE_NAME);
        _listBuffer.append(_comma);
        _listBuffer.append(GROUPING_ATTRIBUTE_VALUE);
        _listBuffer.append(_comma);
        _listBuffer.append(ATTRIBUTE_PERCENT);
        _QUERY = "SELECT <attribute_list> from <table_name>, table (HISTOGRAMS)";
    }

    private class AttributeHistogramArray {
        ArrayList<NameValuePair> attributeValuesBars = new ArrayList();

        private AttributeHistogramArray() {
        }

        boolean isEmpty() {
            return this.attributeValuesBars.isEmpty();
        }

        ArrayList<String> getGroupingBarTitles() {
            NameValuePair nameValuePair = this.attributeValuesBars.get(0);
            ArrayList<NameValuePair> arrayList = ConverterHelper.objectToNameValuePairList(nameValuePair.getValue());
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (NameValuePair nameValuePair2 : arrayList) {
                arrayList2.add(nameValuePair2.getName());
            }
            return arrayList2;
        }

        ArrayList<String> getBarTitles() {
            ArrayList<String> arrayList = new ArrayList<String>(this.attributeValuesBars.size());
            for (int i = 0; i < this.attributeValuesBars.size(); ++i) {
                NameValuePair nameValuePair = this.attributeValuesBars.get(i);
                arrayList.add(nameValuePair.getName());
            }
            return arrayList;
        }

        ArrayList<NameValuePair> getBarArray(String string) {
            ArrayList<NameValuePair> arrayList = null;
            for (int i = 0; i < this.attributeValuesBars.size(); ++i) {
                NameValuePair nameValuePair = this.attributeValuesBars.get(i);
                if (!string.equals(nameValuePair.getName())) continue;
                arrayList = ConverterHelper.objectToNameValuePairList(nameValuePair.getValue());
            }
            return arrayList;
        }

        void addPoint(Object object, String string, Double d) {
            boolean bl = false;
            for (int i = 0; i < this.attributeValuesBars.size(); ++i) {
                NameValuePair nameValuePair = this.attributeValuesBars.get(i);
                if (object != null && object.toString().equals(nameValuePair.getName())) {
                    ArrayList<NameValuePair> arrayList = ConverterHelper.objectToNameValuePairList(nameValuePair.getValue());
                    arrayList.add(new NameValuePair(string, d));
                    bl = true;
                    continue;
                }
                if (object != null) continue;
                for (NameValuePair nameValuePair2 : this.attributeValuesBars) {
                    if (!nameValuePair2.getName().equals("Null")) continue;
                    ArrayList<NameValuePair> arrayList = ConverterHelper.objectToNameValuePairList(nameValuePair2.getValue());
                    arrayList.add(new NameValuePair(string, d));
                    bl = true;
                }
            }
            if (!bl) {
                ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
                arrayList.add(new NameValuePair(string, d));
                this.attributeValuesBars.add(new NameValuePair(object != null ? object.toString() : "Null", arrayList));
            }
        }
    }
}

