/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.dprofiler;

import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.CustomComparator;
import oracle.dmt.dataminer.utils.NumberComparator;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.javatools.ui.search.SearchMatcher;

public class DataProfileStatisticsModel
extends GenericBaseTableModel {
    private HashMap<String, DataProfileStatisticsData> _dataMap = new HashMap();
    private Vector<DataProfileStatisticsData> _data = new Vector();
    static Vector<String> _colNames = new Vector();
    public static final int _COLUMN_NAME = 0;
    public static final int _COLUMN_HISTOGRAM = 1;
    public static final int _COLUMN_DATA_TYPE = 2;
    public static final int _COLUMN_PERCENT_NULL = 3;
    public static final int _COLUMN_DISTINCT = 4;
    public static final int _PERCENT_DISTINCT = 5;
    public static final int _COLUMN_MODE = 6;
    public static final int _COLUMN_AVG = 7;
    public static final int _COLUMN_MEDIAN = 8;
    public static final int _COLUMN_MIN = 9;
    public static final int _COLUMN_MAX = 10;
    public static final int _COLUMN_STD = 11;
    public static final int _COLUMN_VAR = 12;
    public static final int _COLUMN_SKEWNESS = 13;
    public static final int _COLUMN_KURTOSIS = 14;

    private void addDataItem(DataProfileStatisticsData dataProfileStatisticsData) {
        this._data.add(dataProfileStatisticsData);
        this._dataMap.put(dataProfileStatisticsData.getName(), dataProfileStatisticsData);
    }

    private void clear() {
        this._data.clear();
        this._dataMap.clear();
    }

    private int getDataSize() {
        return this._data.size();
    }

    public DataProfileStatisticsModel(List<DataProfileStatisticsData> list) {
        this.setColumnIdentifiers(_colNames);
        for (DataProfileStatisticsData dataProfileStatisticsData : list) {
            this.addDataItem(dataProfileStatisticsData);
        }
        Collections.sort(this._data);
        this.setRowCount(this.getDataSize());
        this.setColumnCount(_colNames.size());
    }

    public DataProfileStatisticsModel(String string) {
        this.setColumnIdentifiers(_colNames);
        DataProfileStatisticsData dataProfileStatisticsData = new DataProfileStatisticsData(string);
        this.addDataItem(dataProfileStatisticsData);
        this.setRowCount(this.getDataSize());
        this.setColumnCount(_colNames.size());
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        DataProfileStatisticsData dataProfileStatisticsData = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = StringUtils.trimDoubleQuotes(dataProfileStatisticsData.getName());
                break;
            }
            case 2: {
                object = dataProfileStatisticsData.getDataType();
                break;
            }
            case 3: {
                object = dataProfileStatisticsData.getPercentNulls();
                break;
            }
            case 4: {
                object = dataProfileStatisticsData.getNumOfDistincts();
                break;
            }
            case 5: {
                object = dataProfileStatisticsData.getPercentOfDistincts();
                break;
            }
            case 6: {
                object = dataProfileStatisticsData.getMode();
                break;
            }
            case 7: {
                object = dataProfileStatisticsData.getAvg();
                break;
            }
            case 8: {
                object = dataProfileStatisticsData.getMedian();
                break;
            }
            case 9: {
                object = dataProfileStatisticsData.getMin();
                break;
            }
            case 10: {
                object = dataProfileStatisticsData.getMax();
                break;
            }
            case 11: {
                object = dataProfileStatisticsData.getStd();
                break;
            }
            case 12: {
                object = dataProfileStatisticsData.getVar();
                break;
            }
            case 13: {
                object = dataProfileStatisticsData.getSkewness();
                break;
            }
            case 14: {
                object = dataProfileStatisticsData.getKurtosis();
                break;
            }
            case 1: {
                object = dataProfileStatisticsData.getGraphDataModel();
                if (!(object instanceof DefaultGraphDataModel)) break;
                ((DefaultGraphDataModel)object).setComment(MessageFormat.format(DataProfileStatisticsLrb.get("DETAIL_TABLE_TOOL_TIP_HISTOGRAM"), dataProfileStatisticsData.getName()));
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing statistics";
                break;
            }
        }
        if (object instanceof Date || object instanceof Timestamp || object instanceof GregorianCalendar) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = null;
            SimpleDateFormat simpleDateFormat = null;
            if (object instanceof Timestamp) {
                simpleDateFormat = TimeUtils.getExplorerNodeTimestampFormat();
                stringBuffer2 = simpleDateFormat.format((Date)((Timestamp)object), stringBuffer, new FieldPosition(0));
            } else if (object instanceof Date) {
                simpleDateFormat = TimeUtils.getExplorerNodeDateFormat();
                stringBuffer2 = simpleDateFormat.format((Date)object, stringBuffer, new FieldPosition(0));
            } else if (object instanceof GregorianCalendar) {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
                simpleDateFormat = TimeUtils.getExplorerNodeFormatTimestampTimeZone();
                simpleDateFormat.setTimeZone(gregorianCalendar.getTimeZone());
                Date date = gregorianCalendar.getTime();
                simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                stringBuffer2 = new StringBuffer(TimeUtils.removeGMT(stringBuffer.toString()));
            }
            return stringBuffer2.toString().toUpperCase();
        }
        return object != null ? object : "";
    }

    public Comparator getColumnSortComparator(int n) {
        Comparator comparator = null;
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                comparator = NumberComparator.getComparator();
                break;
            }
            case 9: 
            case 10: {
                comparator = CustomComparator.getComparator();
                break;
            }
            default: {
                comparator = super.getColumnSortComparator(n);
            }
        }
        return comparator;
    }

    public void setFailedStatus() {
        DataProfileStatisticsData dataProfileStatisticsData = new DataProfileStatisticsData(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILED_TO_LOAD_TABLE_SUMMARY"));
        this.addDataItem(dataProfileStatisticsData);
        this.clear();
        this.addDataItem(dataProfileStatisticsData);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public DataProfileStatisticsModel getFilteredStatistics(String string, int n) throws Exception {
        Vector<DataProfileStatisticsData> vector = null;
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Vector<DataProfileStatisticsData> vector2 = this.getDataVector();
        vector = new Vector<DataProfileStatisticsData>();
        Iterator<DataProfileStatisticsData> iterator = vector2.iterator();
        DataProfileStatisticsData dataProfileStatisticsData = null;
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            dataProfileStatisticsData = iterator.next();
            if (bl) {
                bl2 = true;
            } else {
                String string2;
                switch (n) {
                    case 0: {
                        string2 = dataProfileStatisticsData.getName();
                        break;
                    }
                    case 1: {
                        string2 = dataProfileStatisticsData.getDataType();
                        break;
                    }
                    case 2: {
                        string2 = dataProfileStatisticsData.getMode();
                        break;
                    }
                    default: {
                        assert (false) : "Invalid table filter category.";
                        string2 = dataProfileStatisticsData.getName();
                    }
                }
                if (string2 == null) {
                    string2 = "";
                }
                bl2 = searchMatcher.matches((CharSequence)string2);
            }
            if (!bl2) continue;
            vector.add(dataProfileStatisticsData);
        }
        return new DataProfileStatisticsModel(vector);
    }

    public Vector<DataProfileStatisticsData> getDataVector() {
        return this._data;
    }

    public HashMap<String, DataProfileStatisticsData> getDataMap() {
        return this._dataMap;
    }

    static {
        _colNames.add(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_NAME"));
        _colNames.add(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_HISTOGRAM"));
        _colNames.add(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_DATA_TYPE"));
        _colNames.add(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_PERCENT_NULL"));
        _colNames.add(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_DISTINCT"));
        _colNames.add(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_PERCENT_DISTINCT"));
        _colNames.add(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_MODE"));
        _colNames.add(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_AVG"));
        _colNames.add(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_MEDIAN"));
        _colNames.add(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_MIN"));
        _colNames.add(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_MAX"));
        _colNames.add(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_STD"));
        _colNames.add(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_VAR"));
        _colNames.add(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_SKEWNESS"));
        _colNames.add(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_KURTOSIS"));
    }
}

