/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.dprofiler;

import java.awt.Container;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.dprofiler.DataProfilePanelSettings;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;

public class DataProfilePreferencesPanel
extends DefaultTraversablePanel {
    private JSpinner _jNumericalPrecisionValueSpinner;
    private JLabel _jNumericalValuesPrecisionLabel;
    private JSpinner _jPercentagePrecisionValueSpinner;
    private JLabel _jPercentageValuesPrecisionLabel;
    private JLabel _jPrecisionGroupDescription;
    private Integer _percentagePrecisionLevel = new Integer(4);
    private Integer _numericalPrecisionLevel = new Integer(4);

    public DataProfilePreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jPercentageValuesPrecisionLabel = new JLabel();
        this._jPercentagePrecisionValueSpinner = new JSpinner();
        this._jNumericalValuesPrecisionLabel = new JLabel();
        this._jPrecisionGroupDescription = new JLabel();
        this._jNumericalPrecisionValueSpinner = new JSpinner();
        this._jPercentageValuesPrecisionLabel.setText("Percentage Based Values:");
        this._jNumericalValuesPrecisionLabel.setText("Numerical Values:");
        this._jPrecisionGroupDescription.setText("Precision Settings:");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addGap(11, 11, 11).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jNumericalValuesPrecisionLabel, -1, 191, Short.MAX_VALUE).addComponent(this._jPercentageValuesPrecisionLabel, -1, 191, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jPercentagePrecisionValueSpinner, -2, 47, -2).addComponent(this._jNumericalPrecisionValueSpinner, GroupLayout.Alignment.TRAILING, -2, 47, -2)).addGap(80, 80, 80)).addComponent(this._jPrecisionGroupDescription, -1, 334, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jPrecisionGroupDescription).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this._jPercentageValuesPrecisionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jNumericalValuesPrecisionLabel)).addGroup(groupLayout.createSequentialGroup().addComponent(this._jPercentagePrecisionValueSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jNumericalPrecisionValueSpinner, -2, -1, -2))).addContainerGap(219, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this._jNumericalPrecisionValueSpinner, this._jNumericalValuesPrecisionLabel, this._jPercentagePrecisionValueSpinner, this._jPercentageValuesPrecisionLabel);
    }

    public void initRes() {
        this._jPercentagePrecisionValueSpinner.setModel(new SpinnerNumberModel(this._percentagePrecisionLevel, 0, 12, 1));
        this._jNumericalPrecisionValueSpinner.setModel(new SpinnerNumberModel(this._numericalPrecisionLevel, 0, 12, 1));
        this.setHelpID("data_miner_prefs");
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DataProfileStatisticsLrb.get("PREFERENCES_PRECISION_SETTINGS"), this._jPrecisionGroupDescription);
        hashMap.put(DataProfileStatisticsLrb.get("PREFERENCES_PERCENTAGE"), this._jPercentageValuesPrecisionLabel);
        hashMap.put(DataProfileStatisticsLrb.get("PREFERENCES_NUMERICAL"), this._jNumericalValuesPrecisionLabel);
        UIResourceHelper.setComponentText(hashMap);
    }

    public void initUI() {
    }

    public void onEntry(TraversableContext traversableContext) {
        DataProfilePanelSettings dataProfilePanelSettings = DataProfilePreferencesPanel.getCoolFeaturePrefs(traversableContext);
        this._percentagePrecisionLevel = new Integer(dataProfilePanelSettings.getPercentagePrecisionLevel());
        this._jPercentagePrecisionValueSpinner.setValue(this._percentagePrecisionLevel);
        this._numericalPrecisionLevel = new Integer(dataProfilePanelSettings.getNumericalPrecisionLevel());
        this._jNumericalPrecisionValueSpinner.setValue(this._numericalPrecisionLevel);
    }

    public void onExit(TraversableContext traversableContext) {
        Number number;
        DataProfilePanelSettings dataProfilePanelSettings = DataProfilePreferencesPanel.getCoolFeaturePrefs(traversableContext);
        Number number2 = this.getNumber(this._jPercentagePrecisionValueSpinner);
        if (number2 != null) {
            dataProfilePanelSettings.setPercentagePrecisionLevel(number2.intValue());
        }
        if ((number = this.getNumber(this._jNumericalPrecisionValueSpinner)) != null) {
            dataProfilePanelSettings.setNumericalPrecisionLevel(number.intValue());
        }
    }

    private static DataProfilePanelSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return DataProfilePanelSettings.getInstance(traversableContext.getPropertyStorage());
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }
}

