/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.JPanel;
import oracle.charts.Chart;
import oracle.charts.axischart.AxisChartInteractive;
import oracle.charts.types.AxisTitleDesc;
import oracle.charts.types.ChartException;
import oracle.charts.types.NumAxisDesc;
import oracle.charts.types.SeriesDesc;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphExporter;
import oracle.javatools.util.DateComparator;

public class TimeSeriesGraphPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    int Chart_height = 200;
    int Chart_width = 300;
    GraphDataModel _dataModel;
    GraphExporter _exporter;
    AxisChartInteractive _graph;

    public TimeSeriesGraphPanel(GraphDataModel graphDataModel) {
        this._dataModel = graphDataModel;
        if (graphDataModel != null) {
            this.initGraph();
        }
    }

    public Chart getGraph() {
        return this._graph;
    }

    public GraphExporter getExporter() {
        return this._exporter;
    }

    public GraphDataModel getGraphDataModel() {
        return this._dataModel;
    }

    public void initGraph(GraphDataModel graphDataModel) {
        this._dataModel = graphDataModel;
        this.initGraph();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        try {
            if (this._graph.getSeriesElementExited(n, n2)) {
                this._graph.setSeriesUnHighlight();
                this._graph.setSeriesAnnotationRemove();
                this.paint(this.getGraphics());
            }
        }
        catch (ChartException chartException) {
            System.out.println(chartException.getMessage());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        try {
            SeriesDesc seriesDesc = this._graph.getSeriesIndexDesc(n, n2);
            int n3 = seriesDesc.getSeriesIndex();
            String string = seriesDesc.getSeriesName();
            this._graph.setSeriesHighlight(string, n3, Color.blue);
            this.paint(this.getGraphics());
        }
        catch (ChartException chartException) {
            System.out.println(chartException.getMessage());
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        try {
            if (this._graph.getSeriesElementExited(n, n2)) {
                this._graph.setSeriesUnHighlight();
                this._graph.setSeriesAnnotationRemove();
                this.paint(this.getGraphics());
            }
            if (this._graph.getSeriesElementEntered(n, n2)) {
                SeriesDesc seriesDesc = this._graph.getSeriesIndexDesc(n, n2);
                int n3 = seriesDesc.getSeriesIndex();
                String string = seriesDesc.getSeriesName();
                this._graph.setSeriesHighlight(string, n3, Color.orange);
                this._graph.setSeriesAnnotation(string, n3);
                this.paint(this.getGraphics());
            }
        }
        catch (ChartException chartException) {
            System.out.println(chartException.getMessage());
        }
    }

    public void initGraph() {
        try {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            AxisChartInteractive axisChartInteractive = this._graph = new AxisChartInteractive();
            axisChartInteractive.setSize(this.getWidth(), this.getHeight());
            if (axisChartInteractive != null) {
                axisChartInteractive.addMouseListener((MouseListener)this);
                axisChartInteractive.addMouseMotionListener((MouseMotionListener)this);
            }
            axisChartInteractive.setPlotBackground(Color.WHITE);
            axisChartInteractive.setBackground(Color.WHITE);
            axisChartInteractive.setLocale(Locale.getDefault());
            String string = this._dataModel.getTitle();
            if (string != null) {
                axisChartInteractive.getTitle().setText(this._dataModel.getTitle());
            } else {
                axisChartInteractive.getTitle().setVisible(false);
            }
            Object[] objectArray = this._dataModel.getRowLabels();
            Date date = (Date)this._dataModel.minX1Value();
            Date date2 = (Date)this._dataModel.maxX1Value();
            double d = (Double)this._dataModel.minY1Value();
            Double d2 = null;
            if (this._dataModel.maxY1Value() != null) {
                d2 = (Double)this._dataModel.maxY1Value();
            }
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMinimumFractionDigits(2);
            axisChartInteractive.setXSeries(date, date2);
            AxisTitleDesc axisTitleDesc = new AxisTitleDesc();
            axisTitleDesc.setTitle(this._dataModel.getX1Title());
            axisChartInteractive.setChartAttributes(1, axisTitleDesc);
            AxisTitleDesc axisTitleDesc2 = new AxisTitleDesc();
            axisTitleDesc2.setTitle(this._dataModel.getY1Title());
            axisChartInteractive.setChartAttributes(2, axisTitleDesc2);
            NumAxisDesc numAxisDesc = new NumAxisDesc();
            numAxisDesc.setExtentMin(d);
            if (d2 != null) {
                numAxisDesc.setExtentMax(d2.doubleValue());
            }
            numAxisDesc.setNumberFormat(numberFormat);
            axisChartInteractive.setChartAttributes(numAxisDesc);
            Object[][] objectArray2 = this._dataModel.getGraphData();
            Date[][] dateArray = this._dataModel.getTimePoints();
            for (int i = 0; i < objectArray2.length; ++i) {
                Date[] dateArray2 = dateArray[i];
                double[] dArray = null;
                TreeMap<Date, Double> treeMap = new TreeMap<Date, Double>((Comparator<Date>)new DateComparator());
                for (int j = 0; j < objectArray2[i].length; ++j) {
                    if ((Double)objectArray2[i][j] == -1.0) continue;
                    treeMap.put(dateArray2[j], (Double)objectArray2[i][j]);
                }
                String string2 = (String)objectArray[i];
                Object[] objectArray3 = treeMap.values().toArray();
                dArray = new double[objectArray3.length];
                for (int j = 0; j < objectArray3.length; ++j) {
                    dArray[j] = (Double)objectArray3[j];
                }
                Date[] dateArray3 = new Date[objectArray3.length];
                axisChartInteractive.setYSeriesSparse(string2, treeMap.keySet().toArray(dateArray3), dArray);
                axisChartInteractive.setSeriesGraphType(string2, 1);
                axisChartInteractive.setSeriesColor(string2, this._dataModel.getRowColors()[i]);
                axisChartInteractive.setSeriesInLegend(string2, false);
            }
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.add((Component)this._graph, "Center");
            axisChartInteractive.invalidate();
        }
        catch (ChartException chartException) {
            System.out.println(chartException.getMessage());
        }
    }
}

