/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.SchemaChooserPane;
import oracle.dmt.dataminer.controls.TableChooserModel;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.workflow.TableChooserPreferenceSettings;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizardModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;

public class TableChooserPane
extends JPanel {
    private TableChooserModel _tblChooserModel = null;
    private RowFilter<TableChooserModel, Integer> _tableFilter;
    private Connection _dbConn;
    private Context _context;
    private TableChooserModel.TableRow _selectedTable;
    private boolean _isInitialized = false;
    public static final int SEARCH_ALL_NAME = 0;
    public static final int SEARCH_TABLE_NAME = 1;
    public static final int SEARCH_SCHEMA_NAME = 2;
    private int _currentSearchCategory = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(ControlsLrb.get("TABLE_CHOOSER_TABLES_SEARCH_CAT_ALL"));
    private SearchField _jFilterCtl = new SearchField();
    private boolean _resultContainsAllSchemas = false;
    private static Preferences _p = Preferences.getPreferences();
    private TableChooserPreferenceSettings _tableChooserPrefenceSettings = TableChooserPreferenceSettings.getInstance((PropertyStorage)_p);
    private boolean _loading = false;
    private String _connectionName;
    JEWTDialog _dlg;
    private GenericTable _tableListTbl = new GenericTable();
    private Component _findPane;
    private AbstractDataNode _node;
    private TableType _existingSelectedTable;
    private boolean _initialTableLoadComplete = false;
    private DataSourceWizardModel _wizModel;
    private JCheckBox _jChkIncludeAllSchemas;
    private JButton _jEditSchemaListButton;
    private ComponentWithTitlebar<JComponent> _tablesComponent;
    private JLabel jLabel1;

    public TableChooserPane(Connection connection) {
        this._dbConn = connection;
        this.initComponents();
        this.initRes();
    }

    public TableChooserPane(Context context) {
        assert (context != null) : "Context can not be null.";
        this._context = context;
        this.initComponents();
        this.initRes();
    }

    public TableChooserPane(Context context, AbstractDataNode abstractDataNode, DataSourceWizardModel dataSourceWizardModel) {
        assert (context != null) : "Context can not be null.";
        this._context = context;
        this._node = abstractDataNode;
        this._dlg = null;
        this._wizModel = dataSourceWizardModel;
        this.initComponents();
        this.initRes();
    }

    public boolean isInitialized() {
        return this._isInitialized;
    }

    public void setExistingSelectedTable(TableType tableType) {
        this._existingSelectedTable = tableType;
    }

    public boolean isDirty() {
        if (this._existingSelectedTable != null) {
            if (this._existingSelectedTable.getSchema() != null && this._existingSelectedTable.getName() != null) {
                return this._selectedTable == null || this._existingSelectedTable.getSchema().compareTo(this._selectedTable.getSchema()) != 0 || this._existingSelectedTable.getName().compareTo(this._selectedTable.getTableName()) != 0;
            }
            return true;
        }
        return true;
    }

    public GenericTable getTableComponent() {
        return this._tableListTbl;
    }

    public TableChooserModel.TableRow getSelectedTable() {
        return this._selectedTable;
    }

    public void setSelectedTable(TableChooserModel.TableRow tableRow) {
        this._selectedTable = tableRow;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this._jChkIncludeAllSchemas = new JCheckBox();
        this._jEditSchemaListButton = new JButton();
        this._tablesComponent = new ComponentWithTitlebar();
        this.jLabel1.setText("jLabel1");
        this._jChkIncludeAllSchemas.setText("Include Tables from Other Schemas");
        this._jChkIncludeAllSchemas.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._jChkIncludeAllSchemas.setMargin(new Insets(0, 0, 0, 0));
        this._jEditSchemaListButton.setText("Add Schemas");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this._jChkIncludeAllSchemas, -2, 298, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jEditSchemaListButton)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this._tablesComponent, -1, 432, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this._tablesComponent, -1, 204, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jChkIncludeAllSchemas, -2, 15, -2).addComponent(this._jEditSchemaListButton)).addContainerGap()));
    }

    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this._jChkIncludeAllSchemas, (String)ControlsLrb.get("TABLE_CHOOSER_INCLUDE_ALL_SCHEMAS"));
        this._jChkIncludeAllSchemas.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("TABLE_CHOOSER_INCLUDE_ALL_SCHEMAS_ADA"));
        ResourceUtils.resButton((AbstractButton)this._jEditSchemaListButton, (String)ControlsLrb.get("TABLE_CHOOSER_ADD_SCHEMAS"));
        this._jEditSchemaListButton.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("TABLE_CHOOSER_ADD_SCHEMAS_ADA"));
        this._jEditSchemaListButton.setToolTipText(ControlsLrb.get("TABLE_CHOOSER_ADD_SCHEMAS_ADA"));
    }

    public void initUI() {
        Object object;
        try {
            Object object2;
            object = null;
            if (this._node instanceof DataSourceNode) {
                object = this._node;
                object2 = (DataSourceNodeType)object.getData();
                this._existingSelectedTable = object2.getSourceTable();
            } else if (this._node instanceof UpdateTableNode) {
                object = this._node;
                object2 = (UpdateTableNodeType)object.getData();
                this._existingSelectedTable = object2.getUpdateTargetTable();
            }
            if (object == null) {
                return;
            }
            this._loading = true;
            this._jChkIncludeAllSchemas.setSelected(this._tableChooserPrefenceSettings.getIncludeAllSchemas(this._connectionName));
            if (this._context != null && this._dbConn == null) {
                this._dbConn = Connections.getSharedConnection(this._context);
            }
            this._connectionName = Connections.getConnectionName(this._context);
            this.setSchemaButtonLabel();
            object2 = Connections.getUserAccountName(this._context);
            object2 = StringUtils.isDoubleQuotedString((String)object2) ? StringUtils.trimDoubleQuotes((String)object2) : ((String)object2).toUpperCase();
            this._tblChooserModel = new TableChooserModel((String)object2, this._context);
            this._tblChooserModel.setOwnerOnly(!this._jChkIncludeAllSchemas.isSelected());
            this._tblChooserModel.setTablesOnly(object instanceof UpdateTableNode);
            this.setupLoadingTable();
            JScrollPane jScrollPane = new JScrollPane((Component)this._tableListTbl);
            this._tablesComponent.setComponent((JComponent)jScrollPane);
            this._tablesComponent.setLabel(new JLabel(ControlsLrb.get("TABLE_CHOOSER_AVAILABLE_TABLES")));
            ControlBar controlBar = new ControlBar();
            this._jEditSchemaListButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableChooserPane.this._jEditSchemaListButton_actionPerformed();
                }
            });
            this._jFilterCtl.setStyle(SearchField.Style.FILTER);
            this._jFilterCtl.addCategory(this._defaultSearchCategory);
            this._jFilterCtl.addCategory(new SearchCategory(ControlsLrb.get("TABLE_CHOOSER_TABLES_SEARCH_CAT_TABLE")));
            this._jFilterCtl.addCategory(new SearchCategory(ControlsLrb.get("TABLE_CHOOSER_TABLES_SEARCH_CAT_SCHEMA")));
            this._jFilterCtl.setSelectedCategory(this._defaultSearchCategory);
            this._findPane = this.createFindPane();
            controlBar.add(this._findPane);
            this._tablesComponent.setControlBar(controlBar);
            this._jFilterCtl.addSearchListener(new SearchListener(){

                public void searchPerformed(SearchEvent searchEvent) {
                    TableChooserPane.this.translateSearchCategoryToConstant(TableChooserPane.this._jFilterCtl.getSelectedCategory());
                    TableChooserPane.this.configureSorting();
                }

                public void searchCategoryChanged(SearchEvent searchEvent) {
                    TableChooserPane.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                    TableChooserPane.this.configureSorting();
                }
            });
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_TITLE"), (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_MESSAGE"), null);
        }
        this._jChkIncludeAllSchemas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TableChooserPane.this._loading) {
                    return;
                }
                TableChooserPane.this._tblChooserModel.setOwnerOnly(!TableChooserPane.this._jChkIncludeAllSchemas.isSelected());
                TableChooserPane.this._tableChooserPrefenceSettings.setIncludeAllSchemas(TableChooserPane.this._connectionName, TableChooserPane.this._jChkIncludeAllSchemas.isSelected());
                TableChooserPane.this._tableListTbl.getSelectionModel().clearSelection();
                TableChooserPane.this._existingSelectedTable = null;
                TableChooserPane.this.reloadUI();
            }
        });
        this.enableControls(false);
        this._tableListTbl.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                TableChooserPane.this.updateTableSelection();
            }
        });
        this._isInitialized = true;
        object = new LoadUI();
        object.start();
    }

    protected Component createFindPane() {
        Box box = new Box(2);
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._jFilterCtl);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 200);
        Dimension dimension3 = this.derive(dimension, 120);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private void reloadUI() {
        if (this._resultContainsAllSchemas) {
            this.configureSorting();
        } else {
            this._loading = true;
            this.enableControls(false);
            TableChooserModel tableChooserModel = new TableChooserModel("DUMMY", this._context);
            tableChooserModel.setLoadingStatus();
            this.setupTable(tableChooserModel);
            LoadUI loadUI = new LoadUI();
            loadUI.start();
        }
    }

    private void _jEditSchemaListButton_actionPerformed() {
        SchemaChooserPane schemaChooserPane = new SchemaChooserPane(this._context);
        if (schemaChooserPane.invokeDialog(null)) {
            this._resultContainsAllSchemas = false;
            this.setSchemaButtonLabel();
            this.reloadUI();
        }
    }

    private void setSchemaButtonLabel() {
        ListStructure listStructure = this._tableChooserPrefenceSettings.getIncludedSchemaList(this._connectionName);
        this._jChkIncludeAllSchemas.setSelected(this._tableChooserPrefenceSettings.getIncludeAllSchemas(this._connectionName));
        if (listStructure.size() > 0) {
            ResourceUtils.resButton((AbstractButton)this._jEditSchemaListButton, (String)ControlsLrb.get("TABLE_CHOOSER_EDIT_SCHEMAS"));
            this._jChkIncludeAllSchemas.setEnabled(true);
        } else {
            ResourceUtils.resButton((AbstractButton)this._jEditSchemaListButton, (String)ControlsLrb.get("TABLE_CHOOSER_ADD_SCHEMAS"));
            this._jChkIncludeAllSchemas.setSelected(false);
            this._jChkIncludeAllSchemas.setEnabled(false);
            this._tableChooserPrefenceSettings.setIncludeAllSchemas(this._connectionName, false);
        }
    }

    private void enableControls(boolean bl) {
        if (bl) {
            this.setSchemaButtonLabel();
        } else {
            this._jChkIncludeAllSchemas.setEnabled(bl);
        }
        this._jFilterCtl.setEnabled(bl);
        this._jEditSchemaListButton.setEnabled(bl);
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = -1;
        if (searchCategory.getLabel().equals(ControlsLrb.get("TABLE_CHOOSER_TABLES_SEARCH_CAT_ALL"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(ControlsLrb.get("TABLE_CHOOSER_TABLES_SEARCH_CAT_TABLE"))) {
            this._currentSearchCategory = 1;
        } else if (searchCategory.getLabel().equals(ControlsLrb.get("TABLE_CHOOSER_TABLES_SEARCH_CAT_SCHEMA"))) {
            this._currentSearchCategory = 2;
        } else assert (false) : "Invalid Search Category Code";
        return n;
    }

    private void setupLoadingTable() {
        TableChooserModel tableChooserModel = new TableChooserModel("DUMMY", this._context);
        tableChooserModel.setLoadingStatus();
        this._tableListTbl.setModel((TableModel)((Object)tableChooserModel));
        TableColumnModel tableColumnModel = this._tableListTbl.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(320);
    }

    private void setupTable(TableChooserModel tableChooserModel) {
        this._tableListTbl.setModel((TableModel)((Object)tableChooserModel));
        this._tableListTbl.setSorted(true);
        this._tableListTbl.setSortColumn(0, true);
        this._tableListTbl.setSelectionMode(0);
        TableColumnModel tableColumnModel = this._tableListTbl.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(320);
        tableColumnModel.getColumn(1).setPreferredWidth(80);
        this._tableFilter = new RowFilter<TableChooserModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends TableChooserModel, ? extends Integer> entry) {
                String string = TableChooserPane.this._jFilterCtl.getText();
                boolean bl = false;
                if (string != null) {
                    bl = true;
                }
                SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
                boolean bl2 = true;
                boolean bl3 = TableChooserPane.this._jChkIncludeAllSchemas.isSelected();
                boolean bl4 = string.length() <= 0;
                boolean bl5 = false;
                boolean bl6 = false;
                Integer n = entry.getIdentifier();
                TableChooserModel tableChooserModel = entry.getModel();
                TableChooserModel.TableRow tableRow = tableChooserModel.getRow(n);
                try {
                    if (bl) {
                        if (bl3) {
                            bl5 = true;
                        } else {
                            boolean bl7 = bl5 = tableRow.getSchema().equals(tableChooserModel.getOwnerSchema());
                        }
                        if (bl4) {
                            bl6 = true;
                        } else {
                            String string2;
                            switch (TableChooserPane.this._currentSearchCategory) {
                                case 0: {
                                    string2 = tableRow.getSchemaTableName();
                                    break;
                                }
                                case 1: {
                                    string2 = tableRow.getTableName();
                                    break;
                                }
                                case 2: {
                                    string2 = tableRow.getSchema();
                                    break;
                                }
                                default: {
                                    string2 = tableRow.getSchemaTableName();
                                }
                            }
                            bl6 = searchMatcher.matches((CharSequence)string2);
                        }
                        bl2 = bl5 && bl6;
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_TITLE"), (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_MESSAGE"), null);
                }
                return bl2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void configureSorting() {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        try {
            ideMainWindow.setCursor(new Cursor(3));
            this.enableControls(false);
            TableRowSorter<TableChooserModel> tableRowSorter = new TableRowSorter<TableChooserModel>(this._tblChooserModel);
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
            arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            tableRowSorter.setSortKeys(arrayList);
            tableRowSorter.setSortsOnUpdates(true);
            tableRowSorter.setRowFilter(this._tableFilter);
            this._tableListTbl.setRowSorter(tableRowSorter);
            this.selectExistingTable(this._tblChooserModel);
            this.enableControls(true);
        }
        finally {
            ideMainWindow.setCursor(new Cursor(0));
        }
    }

    private void selectExistingTable(TableChooserModel tableChooserModel) {
        if (this._existingSelectedTable != null && this._existingSelectedTable.getName() != null && !this._initialTableLoadComplete && this._wizModel.isTableExists()) {
            this._initialTableLoadComplete = true;
            int n = tableChooserModel.selectRow(this._existingSelectedTable.getSchema(), this._existingSelectedTable.getName());
            if (n != -1) {
                this.setSelectedTable(tableChooserModel.getRow(n));
                int n2 = this._tableListTbl.convertRowIndexToView(n);
                if (n2 != -1) {
                    this._tableListTbl.setSelectedRowsInModel(new int[]{n2});
                    this._tableListTbl.scrollToSelection();
                } else {
                    this._initialTableLoadComplete = false;
                }
            } else {
                Object[] objectArray = new Object[]{"\"" + this._existingSelectedTable.getSchema() + "\".\"" + this._existingSelectedTable.getName() + "\""};
                String string = MessageFormat.format(ControlsLrb.get("TABLE_CHOOSER_ERROR_MESG_MISSING_TABLE"), objectArray);
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_TITLE"), null);
            }
        }
    }

    public void refreshSelectedTable() {
        int[] nArray = this._tableListTbl.getSelectedRowsInModel();
        this._selectedTable = nArray != null && nArray.length > 0 ? this._tblChooserModel.getRow(nArray[0]) : null;
    }

    public void updateTableSelection() {
        int[] nArray = this._tableListTbl.getSelectedRowsInModel();
        this._selectedTable = nArray != null && nArray.length == 1 ? this._tblChooserModel.getRow(nArray[0]) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeDialog(Point point) {
        boolean bl = false;
        try {
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            int n = 7;
            this._dlg = new JEWTDialog((Frame)ideMainWindow, ControlsLrb.get("TABLE_CHOOSER_DLG_TITLE"), n);
            if (!this._isInitialized) {
                this.initUI();
            }
            this._dlg.setContent((Component)this);
            this._dlg.setTitle(ControlsLrb.get("TABLE_CHOOSER_DLG_TITLE"));
            this._dlg.setResizable(true);
            this._dlg.setOKButtonEnabled(false);
            this._dlg.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (!string.equals("closed") || Boolean.TRUE.equals(object)) {
                        // empty if block
                    }
                }
            });
            if (this._dlg != null) {
                bl = WizardLauncher.runDialog((JDialog)this._dlg);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_TITLE"), (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_MESSAGE"), null);
        }
        finally {
            if (bl) {
                // empty if block
            }
        }
        return bl;
    }

    public TableChooserModel getModel() {
        return this._tblChooserModel;
    }

    public int getSelectedRow() {
        return this._tableListTbl.getSelectedRowsInModel()[0];
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public Object construct() {
            try {
                TableChooserPane.this._tblChooserModel.load(TableChooserPane.this._dbConn);
            }
            catch (Exception exception) {
                this._ex = exception;
            }
            this._success = true;
            return TableChooserPane.this._tblChooserModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    if (!TableChooserPane.this._resultContainsAllSchemas && TableChooserPane.this._jChkIncludeAllSchemas.isSelected()) {
                        TableChooserPane.this._resultContainsAllSchemas = TableChooserPane.this._jChkIncludeAllSchemas.isSelected();
                    }
                    if (TableChooserPane.this._jFilterCtl.getText().trim().length() > 0) {
                        TableChooserPane.this.setupTable(TableChooserPane.this._tblChooserModel);
                        TableChooserPane.this.configureSorting();
                    } else {
                        TableChooserPane.this._tblChooserModel.setOwnerOnly(!TableChooserPane.this._jChkIncludeAllSchemas.isSelected());
                        TableChooserPane.this.setupTable(TableChooserPane.this._tblChooserModel);
                        TableChooserPane.this.configureSorting();
                    }
                    TableChooserPane.this._loading = false;
                    if (TableChooserPane.this._dlg != null) {
                        TableChooserPane.this._dlg.setOKButtonEnabled(true);
                    }
                } else {
                    TableChooserModel tableChooserModel = new TableChooserModel("DUMMY", TableChooserPane.this._context);
                    tableChooserModel.setFailedStatus();
                    TableChooserPane.this.setupTable(tableChooserModel);
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_TITLE"), (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_MESSAGE"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)ControlsLrb.get("TABLE_CHOOSER_FAILURE_MESSAGE"), (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_TITLE"), null);
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_TITLE"), (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_MESSAGE"), null);
            }
            finally {
                TableChooserPane.this.enableControls(true);
            }
        }
    }
}

