/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.workflow.TableChooserPreferenceSettings;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.search.SearchMatcher;

public class TableChooserModel
extends GenericBaseTableModel {
    private Vector<TableRow> _data = new Vector(1000, 500);
    private String _ownerSchema = null;
    private Context _context;
    private static final int COLUMN_COUNT = 2;
    public static final int SCHEMA_TABLE_NAME = 0;
    public static final int TYPE = 1;
    public static final int SCHEMA = 2;
    public static final int TABLE_NAME = 3;
    private boolean tablesOnly = false;
    private boolean _ownerOnly = true;
    private String _connectionName;
    private static Preferences _p = Preferences.getPreferences();
    private TableChooserPreferenceSettings _tableChooserPrefenceSettings = TableChooserPreferenceSettings.getInstance((PropertyStorage)_p);
    private String[] _columnNames = new String[]{ControlsLrb.get("TABLE_CHOOSER_TABLES_LIST_NAME"), ControlsLrb.get("TABLE_CHOOSER_TABLES_LIST_TYPE")};

    public TableChooserModel(String string, Context context) {
        assert (string != null) : "Can not pass a null ownerSchema in to the constructor";
        assert (context != null) : "Can not pass a null context in to the constructor";
        this._ownerSchema = string;
        this._context = context;
        this._connectionName = Connections.getConnectionName(this._context);
        this.setColumnIdentifiers(this._columnNames);
        this.setRowCount(0);
        this.setColumnCount(2);
    }

    public TableChooserModel(String string, Vector<TableRow> vector, Context context) {
        assert (string != null) : "Can not pass a null ownerSchema in to the constructor";
        assert (context != null) : "Can not pass a null context in to the constructor";
        this._context = context;
        this._ownerSchema = string;
        this._connectionName = Connections.getConnectionName(this._context);
        this.setColumnIdentifiers(this._columnNames);
        this._data = vector;
        this.setRowCount(vector.size());
        this.setColumnCount(2);
    }

    public int selectRow(String string, String string2) {
        int n = -1;
        for (int i = 0; i < this._data.size(); ++i) {
            TableRow tableRow = this._data.get(i);
            if (tableRow.getSchema().compareTo(string) != 0 || tableRow.getTableName().compareTo(string2) != 0) continue;
            n = i;
            break;
        }
        return n;
    }

    public TableRow getRow(int n) {
        return this._data.get(n);
    }

    private void clear() {
        this.fireTableRowsDeleted(0, this.getRowCount());
        this._data.clear();
    }

    private void addDataItem(TableRow tableRow) {
        this._data.add(tableRow);
    }

    public void setFailedStatus() {
        TableRow tableRow = new TableRow(ControlsLrb.get("TABLE_CHOOSER_FAILED_TO_LOAD"), "", "");
        this.clear();
        this.addDataItem(tableRow);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public void setLoadingStatus() {
        TableRow tableRow = new TableRow(ControlsLrb.get("TABLE_CHOOSER_LOADING"), "", "");
        this.clear();
        this.addDataItem(tableRow);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public TableChooserModel getfilteredCopy(String string, int n, boolean bl) throws Exception {
        Vector<TableRow> vector = null;
        assert (string != null) : "name filter must be non null";
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Object object = this.getDataVector();
        vector = new Vector<TableRow>(1000, 500);
        Iterator<TableRow> iterator = ((Vector)object).iterator();
        TableRow tableRow = null;
        boolean bl2 = string.length() <= 0;
        boolean bl3 = false;
        boolean bl4 = false;
        while (iterator.hasNext()) {
            tableRow = iterator.next();
            if (bl) {
                bl3 = true;
            } else {
                boolean bl5 = bl3 = tableRow.getSchema().equals(this._ownerSchema);
            }
            if (bl2) {
                bl4 = true;
            } else {
                String string2;
                switch (n) {
                    case 0: {
                        string2 = tableRow.getSchemaTableName();
                        break;
                    }
                    case 1: {
                        string2 = tableRow.getTableName();
                        break;
                    }
                    case 2: {
                        string2 = tableRow.getSchema();
                        break;
                    }
                    default: {
                        string2 = tableRow.getSchemaTableName();
                    }
                }
                bl4 = searchMatcher.matches((CharSequence)string2);
            }
            if (!bl3 || !bl4) continue;
            vector.add(tableRow);
        }
        object = new TableChooserModel(this._ownerSchema, vector, this._context);
        ((TableChooserModel)((Object)object)).setOwnerOnly(!bl);
        return object;
    }

    public void load(Connection connection) throws Exception {
        this.clear();
        if (this._ownerOnly) {
            this.loadOwnerTablesAndViews(connection);
        } else {
            this.loadAccessableTablesAndViews(connection);
        }
        assert (this._data != null) : "failed to load accessible tables, received a null collection";
        this.setRowCount(this._data.size());
    }

    private void loadAccessableTablesAndViews(Connection connection) throws Exception {
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select OWNER, TABLE_NAME, TYPE from ( select OWNER, TABLE_NAME, 'TABLE' as TYPE from ALL_TABLES where <LIST_OF_SCHEMAS>  TABLE_NAME NOT LIKE 'BIN$%'AND TABLE_NAME NOT LIKE 'DM$%'AND TABLE_NAME NOT LIKE 'DM4J$%'AND TABLE_NAME NOT LIKE 'DR$%'AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@'  ");
            if (!this.tablesOnly) {
                stringBuilder.append("union all select OWNER, VIEW_NAME as TABLE_NAME, 'VIEW' as TYPE from ALL_VIEWS where <LIST_OF_SCHEMAS>   VIEW_NAME NOT LIKE 'DM$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'DR$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND VIEW_NAME NOT LIKE 'DM4J$%'  ESCAPE '@'  ) ");
            } else {
                stringBuilder.append(" ) ");
            }
            stringBuilder.append("order by OWNER, TABLE_NAME ");
            ListStructure listStructure = this._tableChooserPrefenceSettings.getIncludedSchemaList(this._connectionName);
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = listStructure.iterator();
            String string = "";
            boolean bl = false;
            int n = 0;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer.append("'" + StringUtils.escapeSingleQuotesForSQL(string) + "'");
                ++n;
                if (iterator.hasNext()) {
                    stringBuffer.append(",");
                }
                if (string.compareTo(this._ownerSchema) != 0) continue;
                bl = true;
            }
            if (!bl) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("'" + StringUtils.escapeSingleQuotesForSQL(this._ownerSchema) + "'");
                ++n;
            }
            String string2 = " ";
            if (n > 0) {
                string2 = " OWNER IN ( " + stringBuffer.toString() + " ) AND ";
            }
            String string3 = StringUtils.getReplacedString(stringBuilder.toString(), "<LIST_OF_SCHEMAS>", string2);
            statement = connection.prepareStatement(string3);
            statement.setFetchSize(1000);
            resultSet = statement.executeQuery();
            TableRow tableRow = null;
            while (resultSet.next()) {
                tableRow = new TableRow(resultSet.getString("OWNER"), resultSet.getString("TABLE_NAME"), resultSet.getString("TYPE"));
                this._data.add(tableRow);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (statement != null) {
                statement.close();
                statement = null;
            }
        }
    }

    private void loadOwnerTablesAndViews(Connection connection) throws Exception {
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select TABLE_NAME, TYPE from ( select TABLE_NAME, 'TABLE' as TYPE from USER_TABLES where  TABLE_NAME NOT LIKE 'BIN$%'AND TABLE_NAME NOT LIKE 'DM$%'AND TABLE_NAME NOT LIKE 'DM4J$%'AND TABLE_NAME NOT LIKE 'DR$%'AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@'  ");
            if (!this.tablesOnly) {
                stringBuilder.append("union all select VIEW_NAME as TABLE_NAME, 'VIEW' as TYPE from USER_VIEWS where   VIEW_NAME NOT LIKE 'DM$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'DR$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND VIEW_NAME NOT LIKE 'DM4J$%'  ESCAPE '@'  ) ");
            } else {
                stringBuilder.append(" ) ");
            }
            stringBuilder.append("order by TABLE_NAME ");
            statement = connection.prepareStatement(stringBuilder.toString());
            statement.setFetchSize(1000);
            resultSet = statement.executeQuery();
            TableRow tableRow = null;
            while (resultSet.next()) {
                tableRow = new TableRow(this._ownerSchema, resultSet.getString("TABLE_NAME"), resultSet.getString("TYPE"));
                this._data.add(tableRow);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (statement != null) {
                statement.close();
                statement = null;
            }
        }
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        TableRow tableRow = this._data.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                if (this.isOwnerOnly()) {
                    if (this._ownerSchema != null) {
                        if (this._ownerSchema.compareTo(tableRow._schema) == 0) {
                            string = tableRow.getTableName();
                            break;
                        }
                        string = tableRow.getSchemaTableName();
                        break;
                    }
                    string = tableRow.getTableName();
                    break;
                }
                string = tableRow.getSchemaTableName();
                break;
            }
            case 2: {
                string = tableRow.getSchema();
                break;
            }
            case 1: {
                string = tableRow.getType();
                break;
            }
            case 3: {
                string = tableRow.getTableName();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing list of tables";
                break;
            }
        }
        return string;
    }

    public Vector<TableRow> getDataVector() {
        return this._data;
    }

    public void setOwnerOnly(boolean bl) {
        this._ownerOnly = bl;
    }

    public boolean isOwnerOnly() {
        return this._ownerOnly;
    }

    public String getOwnerSchema() {
        return this._ownerSchema;
    }

    public void setTablesOnly(boolean bl) {
        this.tablesOnly = bl;
    }

    public boolean isTablesOnly() {
        return this.tablesOnly;
    }

    public static class TableRow {
        private String _schema;
        private String _tableName;
        private String _type;
        public static String TYPE_TABLE = "TABLE";
        public static String TYPE_VIEW = "VIEW";

        public TableRow(String string, String string2, String string3) {
            this._schema = string;
            this._tableName = string2;
            this._type = string3;
        }

        public void setSchema(String string) {
            this._schema = string;
        }

        public String getSchema() {
            return this._schema.toString();
        }

        public void setTableName(String string) {
            this._tableName = string;
        }

        public String getTableName() {
            return this._tableName.toString();
        }

        public void setType(String string) {
            this._type = string;
        }

        public String getType() {
            return this._type.toString();
        }

        public String getSchemaTableName() {
            return this.getSchema() + "." + this.getTableName();
        }

        public String getMungedSchemaTableName() {
            return this.getSchema() + this.getTableName();
        }

        public boolean equals(Object object) {
            boolean bl = false;
            try {
                if (object == null) {
                    return false;
                }
                TableRow tableRow = (TableRow)object;
                if ((tableRow._schema == null && this._schema == null || tableRow._schema != null && tableRow._schema.equals(this._schema)) && (tableRow._tableName == null && this._tableName == null || tableRow._tableName != null && tableRow._tableName.equals(this._tableName)) && (tableRow._type == null && this._type == null || tableRow._type != null && tableRow._type.equals(this._type))) {
                    bl = true;
                }
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            return bl;
        }
    }
}

