/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.SchemaChooserTableModel;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.workflow.TableChooserPreferenceSettings;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.SwingWorker;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class SchemaChooserPane
extends JPanel
implements DataminerGUIPanel {
    private Connection _dbConn;
    private Context _context;
    private SchemaChooserTableModel _availableSchemaModel;
    private SchemaChooserTableModel _selectedSchemaModel;
    private static Preferences _p = Preferences.getPreferences();
    private TableChooserPreferenceSettings _tableChooserPrefenceSettings = TableChooserPreferenceSettings.getInstance((PropertyStorage)_p);
    private ListStructure _listFromPreferences;
    private JEWTDialog _dlg;
    private String _connectionName;
    private JScrollPane _jAvailSchemasScrollPane;
    private GenericTable _jAvailableSchemas;
    private JLabel _jAvailableSchemasLabel;
    private JButton _jRemoveAllBtn;
    private JButton _jRemoveBtn;
    private JButton _jSelectAllBtn;
    private JButton _jSelectBtn;
    private GenericTable _jSelectedSchemas;
    private JLabel _jSelectedSchemasLabel;
    private JScrollPane _jSelectedSchemasScrollPane;

    public SchemaChooserPane(Context context) {
        assert (context != null) : "Context must not be null";
        this._context = context;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jAvailableSchemasLabel = new JLabel();
        this._jSelectedSchemasLabel = new JLabel();
        this._jAvailSchemasScrollPane = new JScrollPane();
        this._jAvailableSchemas = new GenericTable();
        this._jSelectBtn = new JButton();
        this._jSelectAllBtn = new JButton();
        this._jRemoveBtn = new JButton();
        this._jRemoveAllBtn = new JButton();
        this._jSelectedSchemasScrollPane = new JScrollPane();
        this._jSelectedSchemas = new GenericTable();
        this._jAvailableSchemasLabel.setText("Available Schemas");
        this._jSelectedSchemasLabel.setText("Selected Schemas");
        this._jAvailableSchemas.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this._jAvailSchemasScrollPane.setViewportView((Component)this._jAvailableSchemas);
        this._jSelectBtn.setText(">");
        this._jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchemaChooserPane.this._jSelectBtnActionPerformed(actionEvent);
            }
        });
        this._jSelectAllBtn.setText(">>");
        this._jRemoveBtn.setText("<");
        this._jRemoveAllBtn.setText("<<");
        this._jSelectedSchemas.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this._jSelectedSchemasScrollPane.setViewportView((Component)this._jSelectedSchemas);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jAvailableSchemasLabel, -1, 226, Short.MAX_VALUE).addComponent(this._jAvailSchemasScrollPane, GroupLayout.Alignment.TRAILING, -1, 226, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jSelectBtn, -1, 49, Short.MAX_VALUE).addComponent(this._jSelectAllBtn, -1, 49, Short.MAX_VALUE).addComponent(this._jRemoveBtn, -1, 49, Short.MAX_VALUE).addComponent(this._jRemoveAllBtn, -1, 49, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jSelectedSchemasScrollPane, -1, 237, Short.MAX_VALUE).addComponent(this._jSelectedSchemasLabel, -1, 237, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jSelectedSchemasLabel).addComponent(this._jAvailableSchemasLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jSelectedSchemasScrollPane, -1, 243, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(32, 32, 32).addComponent(this._jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jRemoveAllBtn)).addComponent(this._jAvailSchemasScrollPane, -1, 243, Short.MAX_VALUE)).addContainerGap()));
    }

    private void _jSelectBtnActionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void initRes() {
        this._jAvailableSchemasLabel.setText(ControlsLrb.get("SCHEMA_CHOOSER_AVAILABLE_SCHEMAS"));
        this._jAvailableSchemasLabel.setLabelFor((Component)this._jAvailableSchemas);
        this._jSelectedSchemasLabel.setText(ControlsLrb.get("SCHEMA_CHOOSER_SELECTED_SCHEMAS"));
        this._jSelectedSchemasLabel.setLabelFor((Component)this._jSelectedSchemas);
        this._jSelectBtn.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("SCHEMA_CHOOSER_SELECT_ADA"));
        this._jSelectAllBtn.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("SCHEMA_CHOOSER_SELECT_ALL_ADA"));
        this._jRemoveBtn.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("SCHEMA_CHOOSER_REMOVE_ADA"));
        this._jRemoveAllBtn.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("SCHEMA_CHOOSER_REMOVE_ALL_ADA"));
        this._jSelectBtn.setToolTipText(ControlsLrb.get("SCHEMA_CHOOSER_SELECT_ADA"));
        this._jSelectAllBtn.setToolTipText(ControlsLrb.get("SCHEMA_CHOOSER_SELECT_ALL_ADA"));
        this._jRemoveBtn.setToolTipText(ControlsLrb.get("SCHEMA_CHOOSER_REMOVE_ADA"));
        this._jRemoveAllBtn.setToolTipText(ControlsLrb.get("SCHEMA_CHOOSER_REMOVE_ALL_ADA"));
    }

    @Override
    public void initUI() {
        try {
            this._dbConn = Connections.getSharedConnection(this._context);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_TITLE"), (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_MESSAGE"), null);
            return;
        }
        this._connectionName = Connections.getConnectionName(this._context);
        HelpUtils.setHelpID((JComponent)this, (String)"schema_selection_dialog");
        SchemaChooserTableModel schemaChooserTableModel = new SchemaChooserTableModel();
        schemaChooserTableModel.setLoadingStatus();
        this._jSelectedSchemas.setModel((TableModel)((Object)schemaChooserTableModel));
        SchemaChooserTableModel schemaChooserTableModel2 = new SchemaChooserTableModel();
        schemaChooserTableModel2.setLoadingStatus();
        this._jAvailableSchemas.setModel((TableModel)((Object)schemaChooserTableModel2));
        this.enableControls(false);
        this._jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchemaChooserPane.this.moveItems(SchemaChooserPane.this._jAvailableSchemas, SchemaChooserPane.this._jSelectedSchemas);
            }
        });
        this._jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchemaChooserPane.this._jAvailableSchemas.selectAll();
                SchemaChooserPane.this.moveItems(SchemaChooserPane.this._jAvailableSchemas, SchemaChooserPane.this._jSelectedSchemas);
            }
        });
        this._jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchemaChooserPane.this.moveItems(SchemaChooserPane.this._jSelectedSchemas, SchemaChooserPane.this._jAvailableSchemas);
            }
        });
        this._jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchemaChooserPane.this._jSelectedSchemas.selectAll();
                SchemaChooserPane.this.moveItems(SchemaChooserPane.this._jSelectedSchemas, SchemaChooserPane.this._jAvailableSchemas);
            }
        });
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    private void setupTables(SchemaChooserTableModel schemaChooserTableModel, SchemaChooserTableModel schemaChooserTableModel2) {
        this._jAvailableSchemas.setModel((TableModel)((Object)schemaChooserTableModel));
        this._jSelectedSchemas.setModel((TableModel)((Object)schemaChooserTableModel2));
        this._jAvailableSchemas.setSorted(true);
        this._jAvailableSchemas.setSortColumn(0, true);
        this._jSelectedSchemas.setSorted(true);
        this._jSelectedSchemas.setSortColumn(0, true);
    }

    private void enableControls(boolean bl) {
        this._jRemoveAllBtn.setEnabled(bl);
        this._jRemoveBtn.setEnabled(bl);
        this._jSelectAllBtn.setEnabled(bl);
        this._jSelectBtn.setEnabled(bl);
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2) {
        int n;
        int[] nArray = genericTable.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        Vector<String> vector = ((SchemaChooserTableModel)((Object)genericTable.getModel())).getDataVector();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < nArray.length; ++i) {
            String object2 = vector.get(nArray[i]);
            vector2.add(object2);
        }
        for (String string : vector2) {
            n = vector.indexOf(string);
            if (n == -1) continue;
            vector.remove(n);
        }
        Vector<String> vector3 = ((SchemaChooserTableModel)((Object)genericTable2.getModel())).getDataVector();
        vector3.addAll(vector2);
        ((SchemaChooserTableModel)((Object)genericTable2.getModel())).setRowCount(vector3.size());
        ((SchemaChooserTableModel)((Object)genericTable.getModel())).setRowCount(vector.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        int[] nArray2 = new int[vector2.size()];
        for (n = 0; n < vector2.size(); ++n) {
            int n2 = vector3.indexOf(vector2.get(n));
            assert (n2 != -1) : "Unexpected state - added item should be present and must have an index";
            nArray2[n] = n2;
        }
        genericTable2.setSelectedRowsInModel(nArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeDialog(Point point) {
        boolean bl = false;
        try {
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            int n = 7;
            this._dlg = new JEWTDialog((Frame)ideMainWindow, ControlsLrb.get("SCHEMA_CHOOSER_DLG_TITLE"), n);
            this._dlg.setContent((Component)this);
            this._dlg.setTitle(ControlsLrb.get("SCHEMA_CHOOSER_DLG_TITLE"));
            this._dlg.setResizable(true);
            this._dlg.setOKButtonEnabled(false);
            this._dlg.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object) && !SchemaChooserPane.this.doWork()) {
                        throw new PropertyVetoException("panel", propertyChangeEvent);
                    }
                }
            });
            if (this._dlg != null) {
                bl = WizardLauncher.runDialog((JDialog)this._dlg);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_TITLE"), (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_MESSAGE"), null);
        }
        return bl;
    }

    private boolean doWork() {
        boolean bl = true;
        this._listFromPreferences.clear();
        Vector<String> vector = this._selectedSchemaModel.getDataVector();
        for (String string : vector) {
            this._listFromPreferences.add((Object)string);
        }
        this._tableChooserPrefenceSettings.setIncludedSchemaList(this._connectionName, this._listFromPreferences);
        return bl;
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        public Object construct() {
            try {
                SchemaChooserPane.this._availableSchemaModel = new SchemaChooserTableModel();
                SchemaChooserPane.this._listFromPreferences = SchemaChooserPane.this._tableChooserPrefenceSettings.getIncludedSchemaList(SchemaChooserPane.this._connectionName);
                Iterator iterator = SchemaChooserPane.this._listFromPreferences.iterator();
                Vector<String> vector = new Vector<String>();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    vector.add(string);
                }
                SchemaChooserPane.this._selectedSchemaModel = new SchemaChooserTableModel(vector);
                SchemaChooserPane.this._availableSchemaModel.load(SchemaChooserPane.this._dbConn, Connections.getUserAccountName(SchemaChooserPane.this._context));
                SchemaChooserPane.this._availableSchemaModel.removeDuplicateRows(SchemaChooserPane.this._selectedSchemaModel.getDataVector());
            }
            catch (Exception exception) {
                this._ex = exception;
            }
            this._success = true;
            return this._success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    SchemaChooserPane.this.setupTables(SchemaChooserPane.this._availableSchemaModel, SchemaChooserPane.this._selectedSchemaModel);
                    SchemaChooserPane.this._dlg.setOKButtonEnabled(true);
                } else {
                    SchemaChooserTableModel schemaChooserTableModel = new SchemaChooserTableModel();
                    schemaChooserTableModel.setFailedStatus();
                    SchemaChooserPane.this.setupTables(schemaChooserTableModel, SchemaChooserPane.this._selectedSchemaModel);
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_TITLE"), (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_MESSAGE"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_MESSAGE"), (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_TITLE"), null);
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_TITLE"), (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_MESSAGE"), null);
            }
            finally {
                SchemaChooserPane.this.enableControls(true);
            }
        }
    }
}

