/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;

public class OutputCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private Icon _icon;
    private JButton _btn = new JButton();
    protected static final String EDIT = "edit";
    private static Icon _out_icon;
    private static Icon _ignore_icon;

    public OutputCellEditor() {
        this._btn.setActionCommand(EDIT);
        this._btn.addActionListener(this);
        this._btn.setBorderPainted(false);
        this._btn.setHorizontalAlignment(2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (EDIT.equals(actionEvent.getActionCommand())) {
            this.fireEditingStopped();
        }
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return !(eventObject instanceof MouseEvent) || ((MouseEvent)eventObject).getClickCount() == 1;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        assert (object instanceof Boolean);
        this._icon = (Boolean)object != false ? _out_icon : _ignore_icon;
        this._btn.setIcon(this._icon);
        return this._btn;
    }

    @Override
    public Object getCellEditorValue() {
        if (this._icon == _out_icon) {
            this._icon = _ignore_icon;
        } else if (this._icon == _ignore_icon) {
            this._icon = _out_icon;
        }
        return this._icon == _out_icon;
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    static {
        Class<WorkflowEditor> clazz = WorkflowEditor.class;
        _out_icon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("FILTER_ATTR_OUTPUT_ICON"));
        _ignore_icon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("FILTER_ATTR_IGNORE_ICON"));
    }
}

